/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet;

import com.mathworks.widgets.spreadsheet.IDataBoundsSupplier;
import com.mathworks.widgets.spreadsheet.SpreadsheetTableEvent;
import com.mathworks.widgets.spreadsheet.SpreadsheetTableModelEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public abstract class ResizingTableModelWrapper
extends AbstractTableModel
implements TableModelListener,
IDataBoundsSupplier {
    protected TableModel fModel;
    protected static final int DEFAULT_INITIAL_SIZE = 16;
    protected static final int DEFAULT_INCREMENT_SIZE = 4;
    protected static final int DEFAULT_BUFFER_ZONE_SIZE = 4;
    protected int fCurrentTableWidth;
    protected int fCurrentTableHeight;
    protected int fIncrementSize;
    protected int fBufferZoneSize;
    protected int fMaxWidth;
    protected int fMaxHeight;
    private boolean fAutoGrowthDisabled;

    public ResizingTableModelWrapper(TableModel tableModel) {
        this(tableModel, 4, 4);
    }

    public ResizingTableModelWrapper(TableModel tableModel, boolean bl) {
        this(tableModel, bl ? 4 : 1, bl ? 4 : 0);
    }

    public ResizingTableModelWrapper(TableModel tableModel, int n, int n2) {
        this(tableModel, n, n2, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public ResizingTableModelWrapper(TableModel tableModel, boolean bl, int n, int n2) {
        this(tableModel, bl ? 4 : 1, bl ? 4 : 0, n, n2);
    }

    public ResizingTableModelWrapper(TableModel tableModel, int n, int n2, int n3, int n4) {
        this.fIncrementSize = n;
        this.fBufferZoneSize = n2;
        if (n2 == 0) {
            this.fCurrentTableWidth = 1;
            this.fCurrentTableHeight = 1;
        } else {
            this.fCurrentTableWidth = 16;
            this.fCurrentTableHeight = 16;
        }
        this.fMaxHeight = n3;
        this.fMaxWidth = n4;
        this.fModel = tableModel;
        this.updateTableSizeFromQuery(this.getLastDataRow(), this.getLastDataColumn());
        this.fModel.addTableModelListener(this);
    }

    public void cleanup() {
        this.fModel.removeTableModelListener(this);
    }

    @Override
    public int getRowCount() {
        return this.fCurrentTableHeight;
    }

    @Override
    public int getColumnCount() {
        return this.fCurrentTableWidth;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public abstract String getColumnName(int var1);

    @Override
    public Object getValueAt(int n, int n2) {
        this.updateTableSizeFromQuery(n, n2);
        if (n > this.getLastDataRow() || n2 > this.getLastDataColumn()) {
            return null;
        }
        return this.fModel.getValueAt(n, n2);
    }

    public void setValueAtPreMethod(int n, int n2) {
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.setValueAtPreMethod(n, n2);
        this.fModel.setValueAt(object, n, n2);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent instanceof SpreadsheetTableEvent) {
            ((SpreadsheetTableEvent)tableModelEvent).setSource(this);
            this.fireTableChanged(tableModelEvent);
        } else {
            this.fireTableChanged(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn(), tableModelEvent.getType()));
        }
    }

    @Override
    public int getFirstDataRow() {
        return 0;
    }

    @Override
    public int getLastDataRow() {
        return this.fModel.getRowCount() - 1;
    }

    @Override
    public int getFirstDataColumn() {
        return 0;
    }

    @Override
    public int getLastDataColumn() {
        return this.fModel.getColumnCount() - 1;
    }

    public void removeEmptyRows(int n) {
        if (this.fCurrentTableHeight > (n / this.fIncrementSize + 1) * this.fIncrementSize + this.fBufferZoneSize) {
            int n2 = this.fCurrentTableHeight;
            this.fCurrentTableHeight = (n / this.fIncrementSize + 1) * this.fIncrementSize + this.fBufferZoneSize;
            this.fireTableRowsDeleted(this.fCurrentTableHeight + 1, n2);
        }
    }

    public void removeEmptyColumns(int n) {
        if (this.fCurrentTableWidth > (n / this.fIncrementSize + 1) * this.fIncrementSize + this.fBufferZoneSize) {
            this.fCurrentTableWidth = (n / this.fIncrementSize + 1) * this.fIncrementSize + this.fBufferZoneSize;
            this.fireTableStructureChanged();
        }
    }

    private void updateTableSizeFromQuery(int n, int n2) {
        int n3;
        if (this.fAutoGrowthDisabled) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n4 = this.fCurrentTableHeight;
        if (this.fCurrentTableHeight < this.fMaxHeight && this.fCurrentTableHeight - n < this.fBufferZoneSize | this.fModel.getRowCount() > this.fCurrentTableHeight - this.fBufferZoneSize) {
            n3 = Math.max((this.fCurrentTableHeight / this.fIncrementSize + 1) * this.fIncrementSize, this.fModel.getRowCount()) + this.fBufferZoneSize;
            this.fCurrentTableHeight = n3 = Math.min(n3, this.fMaxHeight);
            bl = true;
        }
        if (this.fCurrentTableWidth < this.fMaxWidth && this.fCurrentTableWidth - n2 < this.fBufferZoneSize | this.fModel.getColumnCount() > this.fCurrentTableWidth - this.fBufferZoneSize) {
            n3 = Math.max((this.fCurrentTableWidth / this.fIncrementSize + 1) * this.fIncrementSize, this.fModel.getColumnCount()) + this.fBufferZoneSize;
            this.fCurrentTableWidth = n3 = Math.min(n3, this.fMaxWidth);
            bl2 = true;
        }
        if (bl) {
            this.fireTableRowsInserted(n4 + 1, this.fCurrentTableHeight);
        }
        if (bl2) {
            this.fireTableColumnsAdded();
        }
    }

    public void fireTableColumnsAdded() {
        this.fireTableChanged(SpreadsheetTableModelEvent.getColumnsAddedInstance(this));
    }

    public void setAutoGrowthTemporarilyDisabled(boolean bl) {
        this.fAutoGrowthDisabled = bl;
    }

    public boolean getAutoGrowthTemporarilyDisabled() {
        return this.fAutoGrowthDisabled;
    }
}

