/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.data;

import com.mathworks.widgets.spreadsheet.data.ComplexIntegralScalar;
import com.mathworks.widgets.spreadsheet.format.FormatUtils;

public final class ComplexScalarByte
extends ComplexIntegralScalar {
    private final byte fR;
    private final byte fI;
    private static final int UNSIGNED_BYTE_MAX = 256;
    private static final ComplexScalarByte ZERO_REAL_SIGNED = new ComplexScalarByte(0, true);
    private static final ComplexScalarByte ONE_REAL_SIGNED = new ComplexScalarByte(1, true);
    private static final ComplexScalarByte ZERO_COMPLEX_SIGNED = new ComplexScalarByte(0, 0, true);
    private static final ComplexScalarByte ONE_COMPLEX_SIGNED = new ComplexScalarByte(1, 0, true);
    private static final ComplexScalarByte I_COMPLEX_SIGNED = new ComplexScalarByte(0, 1, true);
    private static final ComplexScalarByte ZERO_REAL_UNSIGNED = new ComplexScalarByte(0, false);
    private static final ComplexScalarByte ONE_REAL_UNSIGNED = new ComplexScalarByte(1, false);
    private static final ComplexScalarByte ZERO_COMPLEX_UNSIGNED = new ComplexScalarByte(0, 0, false);
    private static final ComplexScalarByte ONE_COMPLEX_UNSIGNED = new ComplexScalarByte(1, 0, false);
    private static final ComplexScalarByte I_COMPLEX_UNSIGNED = new ComplexScalarByte(0, 1, false);

    public static ComplexScalarByte valueOf(byte by) {
        return ComplexScalarByte.valueOf(by, true);
    }

    public static ComplexScalarByte valueOf(byte by, boolean bl) {
        if (by == 0) {
            return bl ? ZERO_REAL_SIGNED : ZERO_REAL_UNSIGNED;
        }
        if (by == 1) {
            return bl ? ONE_REAL_SIGNED : ONE_REAL_UNSIGNED;
        }
        return new ComplexScalarByte(by, bl);
    }

    public static ComplexScalarByte valueOf(byte by, byte by2) {
        return ComplexScalarByte.valueOf(by, by2, true);
    }

    public static ComplexScalarByte valueOf(byte by, byte by2, boolean bl) {
        if (by == 0) {
            if (by2 == 1) {
                return bl ? I_COMPLEX_SIGNED : I_COMPLEX_UNSIGNED;
            }
            if (by2 == 0) {
                return bl ? ZERO_COMPLEX_SIGNED : ZERO_COMPLEX_UNSIGNED;
            }
        }
        if (by == 1 && by2 == 0) {
            return bl ? ONE_COMPLEX_SIGNED : ONE_COMPLEX_UNSIGNED;
        }
        return new ComplexScalarByte(by, by2, bl);
    }

    private ComplexScalarByte(byte by, boolean bl) {
        super(true, bl);
        this.fR = by;
        this.fI = 0;
    }

    private ComplexScalarByte(byte by, byte by2, boolean bl) {
        super(false, bl);
        this.fR = by;
        this.fI = by2;
    }

    @Override
    public long longValueReal() {
        return this.fR;
    }

    @Override
    public long longValueImaginary() {
        return this.fI;
    }

    @Override
    public double doubleValueReal() {
        return this.fR;
    }

    @Override
    public double doubleValueImaginary() {
        return this.fI;
    }

    @Override
    public String formatAsIntegral() {
        byte by = this.byteValueReal();
        byte by2 = this.byteValueImaginary();
        Number number = this.isSigned() || by > -1 ? (Number)by : (Number)(by + 256);
        if (this.isReal()) {
            return FormatUtils.formatAsIntegral(number);
        }
        Number number2 = this.isSigned() || by2 > -1 ? (Number)by2 : (Number)(by2 + 256);
        return FormatUtils.formatAsIntegral(number, number2);
    }
}

