/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.data;

import com.mathworks.widgets.spreadsheet.IReadOnlyData;

public class ValueSummary
implements IReadOnlyData {
    private final long[] fLengths;
    private final boolean fIsSigned;
    private boolean fIsReal = true;
    private boolean fIsSparse = false;
    private boolean fIsGlobal = false;
    private final String fClazz;
    private String fSpecialEmpty;
    private int fNumFields = 0;

    ValueSummary(String string, long[] lArray) {
        this(string, lArray, true);
    }

    ValueSummary(String string, long[] lArray, boolean bl) {
        this(string, lArray, bl, true, null);
    }

    ValueSummary(String string, long[] lArray, String string2) {
        this(string, lArray, true, true, string2);
    }

    ValueSummary(String string, long[] lArray, boolean bl, boolean bl2, String string2) {
        ValueSummary.checkLengths(lArray);
        this.fLengths = lArray;
        this.fIsSigned = bl2;
        this.fIsReal = bl;
        this.fClazz = string;
        this.fSpecialEmpty = string2;
    }

    public boolean isSparse() {
        return this.fIsSparse;
    }

    public void setIsSparse(boolean bl) {
        this.fIsSparse = bl;
    }

    public boolean isGlobal() {
        return this.fIsGlobal;
    }

    public void setIsGlobal(boolean bl) {
        this.fIsGlobal = bl;
    }

    public void setIsReal(boolean bl) {
        this.fIsReal = bl;
    }

    public final boolean isReal() {
        return this.fIsReal;
    }

    public final boolean isSigned() {
        return this.fIsSigned;
    }

    public final long[] getLengths() {
        return this.fLengths;
    }

    public final String toString() {
        return this.toString(true);
    }

    public final String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        long[] lArray = this.getLengths();
        boolean bl2 = false;
        if (bl) {
            for (long l : lArray) {
                if (l != 0L) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2 && this.fSpecialEmpty != null) {
            stringBuilder.append(this.fSpecialEmpty);
        } else {
            if (lArray.length > 3) {
                stringBuilder.append(lArray.length);
                stringBuilder.append("-D");
            } else {
                stringBuilder.append(lArray[0]);
                stringBuilder.append('x');
                stringBuilder.append(lArray[1]);
                if (lArray.length > 2) {
                    stringBuilder.append('x');
                    stringBuilder.append(lArray[2]);
                }
            }
            if (this.fIsGlobal) {
                stringBuilder.append(" global");
            }
            if (this.fIsSparse) {
                stringBuilder.append(" sparse");
            }
            if (!this.fIsReal) {
                stringBuilder.append(" complex");
            }
            String[] stringArray = this.fClazz.split("\\.");
            stringBuilder.append(' ').append(stringArray[stringArray.length - 1]);
        }
        return stringBuilder.toString();
    }

    public final String getMatlabClass() {
        return this.fClazz;
    }

    private static void checkLengths(long[] lArray) {
        if (lArray == null || lArray.length < 2) {
            throw new IllegalArgumentException("Length must be an array with two or more arguments.");
        }
    }

    public void setNumFields(int n) {
        this.fNumFields = n;
    }

    public int getNumFields() {
        return this.fNumFields;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

