/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.format;

import com.mathworks.widgets.spreadsheet.data.ComplexScalar;
import com.mathworks.widgets.spreadsheet.format.ComplexScalarFormatter;
import com.mathworks.widgets.spreadsheet.format.ComplexScalarFormatterFactory;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.FormatUtils;

final class PlusFormatter
implements ComplexScalarFormatter {
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    private static final String ZERO = " ";

    PlusFormatter() {
    }

    @Override
    public String format(ComplexScalar complexScalar) {
        if (FormatUtils.isFloatingPointType(complexScalar)) {
            return PlusFormatter.format(complexScalar.doubleValueReal());
        }
        if (complexScalar.isSigned()) {
            return PlusFormatter.format(complexScalar.longValueReal());
        }
        return complexScalar.longValueReal() == 0L ? ZERO : PLUS;
    }

    @Override
    public String format(Number number) {
        if (FormatUtils.isFloatingPointType(number)) {
            return PlusFormatter.format(number.doubleValue());
        }
        return PlusFormatter.format(number.longValue());
    }

    public String toString() {
        return "PlusFormatter";
    }

    @Override
    public final ComplexScalarFormatter getEditingComplexScalarFormatter() {
        return ComplexScalarFormatterFactory.getInstance(FormatIdentifier.LONG);
    }

    private static String format(double d) {
        if (Double.isNaN(d) || d == 0.0) {
            return ZERO;
        }
        if (d > 0.0) {
            return PLUS;
        }
        return MINUS;
    }

    private static String format(long l) {
        if (l == 0L) {
            return ZERO;
        }
        if (l > 0L) {
            return PLUS;
        }
        return MINUS;
    }

    @Override
    public String getName() {
        return FormatIdentifier.PLUS.getName();
    }
}

