/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.format;

import com.mathworks.widgets.spreadsheet.data.ComplexIntegralScalar;
import com.mathworks.widgets.spreadsheet.data.ComplexScalar;
import com.mathworks.widgets.spreadsheet.format.ComplexScalarFormatter;
import com.mathworks.widgets.spreadsheet.format.ComplexScalarFormatterFactory;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.FormatUtils;

public final class RationalFormatter
implements ComplexScalarFormatter {
    private double fTolerance;
    private static final double DEFAULT_TOLERANCE = 1.0E-6;

    private RationalFormatter(double d) {
        this.fTolerance = d;
    }

    public RationalFormatter() {
        this(1.0E-6);
    }

    @Override
    public final String format(ComplexScalar complexScalar) {
        if (FormatUtils.isFloatingPointType(complexScalar)) {
            if (complexScalar.isReal()) {
                return this.format(complexScalar.doubleValueReal());
            }
            double d = complexScalar.doubleValueImaginary();
            String string = d < 0.0 ? " - " : " + ";
            return this.format(complexScalar.doubleValueReal()) + string + this.format(Math.abs(d)) + 'i';
        }
        return ((ComplexIntegralScalar)complexScalar).formatAsIntegral();
    }

    @Override
    public final String format(Number number) {
        if (FormatUtils.isFloatingPointType(number)) {
            return this.format(number.doubleValue());
        }
        return FormatUtils.formatAsIntegral(number);
    }

    @Override
    public ComplexScalarFormatter getEditingComplexScalarFormatter() {
        return ComplexScalarFormatterFactory.getInstance(FormatIdentifier.LONG);
    }

    private static String makeFraction(long l, long l2) {
        if (l2 == 1L) {
            return Long.toString(l);
        }
        return Long.toString(l) + '/' + Long.toString(l2);
    }

    private String format(double d) {
        if (Double.isInfinite(d)) {
            return d > 0.0 ? RationalFormatter.makeFraction(1L, 0L) : RationalFormatter.makeFraction(-1L, 0L);
        }
        if (Double.isNaN(d)) {
            return RationalFormatter.makeFraction(0L, 0L);
        }
        if (d == 0.0) {
            return RationalFormatter.makeFraction(0L, 1L);
        }
        if (Math.floor(d) == d) {
            if (d < 9.223372036854776E18 && d > -9.223372036854776E18) {
                return FormatUtils.formatAsIntegral((long)d);
            }
            return Double.toString(d).replace("E-", "e-").replace("E", "e+");
        }
        long[] lArray = new long[24];
        long l = 0L;
        long l2 = 1L;
        double d2 = d;
        for (int i = 0; i < 24 && Math.abs((double)l / (double)l2 - d2) > this.fTolerance * Math.abs(d2); ++i) {
            lArray[i] = Math.round(d);
            d -= (double)lArray[i];
            l = lArray[i];
            l2 = 1L;
            int n = i;
            while (n != 0) {
                long l3 = l;
                l = lArray[--n] * l + l2;
                l2 = l3;
            }
            if (d == 0.0) break;
            d = 1.0 / d;
        }
        l = l2 < 0L ? -l : l;
        l2 = Math.abs(l2);
        return RationalFormatter.makeFraction(l, l2);
    }

    @Override
    public String getName() {
        return FormatIdentifier.RATIONAL.getName();
    }
}

