/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.print;

import com.mathworks.widgets.spreadsheet.IAsynchronousContentAccessor;
import com.mathworks.widgets.text.print.GraphicsUtils;
import com.mathworks.widgets.text.print.MultiHeaderUtils;
import com.mathworks.widgets.text.print.PrintSettings;
import com.mathworks.widgets.text.print.PrintUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class ArrayPrintable
implements Printable {
    private JTable fTable;
    private JScrollPane fScrollPane;
    private JTableHeader fHeader;
    private TableColumnModel fColModel;
    private int fTotalColWidth;
    private JTable.PrintMode fPrintMode;
    private MessageFormat fHeaderFormat;
    private MessageFormat fSubHeaderFormat;
    private int fMostRecentPage = -1;
    private int fStartRow;
    private int fRow;
    private int fStartCol;
    private int fCol;
    private final Rectangle fClip = new Rectangle(0, 0, 0, 0);
    private final Rectangle fHclip = new Rectangle(0, 0, 0, 0);
    private final Rectangle fTempRect = new Rectangle(0, 0, 0, 0);
    private int fLastColumnToPrint = -1;
    private int fLastRowToPrint;
    private boolean fPrintBorder = true;

    public ArrayPrintable(JTable jTable, JTable.PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2, Rectangle rectangle) {
        this.fTable = jTable;
        this.fStartRow = rectangle.y;
        int n = this.fStartRow + rectangle.height - 1;
        this.fRow = this.fStartRow;
        this.fStartCol = rectangle.x;
        int n2 = this.fStartCol + rectangle.width - 1;
        this.fCol = this.fStartCol;
        this.fLastColumnToPrint = n2;
        this.fLastRowToPrint = n;
        this.fHeader = jTable.getTableHeader();
        this.fColModel = jTable.getColumnModel();
        this.fTotalColWidth = this.getTotalColWidth();
        if (this.fHeader != null) {
            this.fHclip.height = this.fHeader.getHeight();
        }
        this.fPrintMode = printMode;
        this.fHeaderFormat = messageFormat;
        this.fSubHeaderFormat = messageFormat2;
        this.fScrollPane = this.getScrollPane();
    }

    public void setBorder(boolean bl) {
        this.fPrintBorder = bl;
    }

    private JScrollPane getScrollPane() {
        Container container;
        Container container2 = this.fTable.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            return (JScrollPane)container;
        }
        return null;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (PrintSettings.useMacNativeFixes()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            GraphicsUtils.applyPrintScale(graphics2D);
        }
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        Paper paper = pageFormat2.getPaper();
        pageFormat2.setPaper(paper);
        int n2 = (int)GraphicsUtils.getScaleAdjustedImageableWidth(graphics2D, pageFormat2);
        int n3 = (int)GraphicsUtils.getScaleAdjustedImageableHeight(graphics2D, pageFormat2);
        if (n2 <= 0) {
            throw new PrinterException(PrintUtils.getResource("printing.error.width.too.small"));
        }
        if (n3 <= 0) {
            throw new PrinterException(PrintUtils.getResource("printing.error.height.too.small"));
        }
        MultiHeaderUtils.addHeaderToGraphics(graphics2D, pageFormat, this.fHeaderFormat, this.fSubHeaderFormat, n, false);
        Dimension dimension = this.fScrollPane != null && this.fScrollPane.getRowHeader() != null ? this.fScrollPane.getRowHeader().getView().getSize() : new Dimension(0, 0);
        double d = 1.0;
        if (this.fPrintMode == JTable.PrintMode.FIT_WIDTH && this.fTotalColWidth > n2) {
            assert (n2 > 0);
            assert (this.fTotalColWidth > 1);
            d = (double)n2 / (double)this.fTotalColWidth;
        }
        assert (d > 0.0);
        while (this.fMostRecentPage < n) {
            if (this.fRow >= this.fLastRowToPrint + 1 && this.fCol == this.fStartCol) {
                return 1;
            }
            int n4 = (int)((double)n2 / d);
            int n5 = (int)((double)(n3 - this.fHclip.height - 40) / d);
            this.findNextClip(n4, n5);
            ++this.fMostRecentPage;
        }
        if (this.fScrollPane != null && this.fScrollPane.getRowHeader() != null) {
            AffineTransform affineTransform = graphics2D.getTransform();
            Shape shape = graphics2D.getClip();
            graphics2D.setClip(0, this.fHeader.getHeight() + 40, (int)Math.ceil(dimension.width), (int)Math.ceil(this.fClip.height));
            if (d != 1.0) {
                graphics2D.scale(d, d);
            }
            graphics2D.translate(0, -this.fClip.y + this.fHeader.getHeight() + 40);
            this.fScrollPane.getRowHeader().getView().print(graphics2D);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawRect(0, this.fClip.y, (int)Math.ceil(dimension.width), (int)Math.ceil(this.fClip.height - 1));
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
        }
        this.fTempRect.x = 0;
        this.fTempRect.y = 0;
        this.fTempRect.width = n2;
        this.fTempRect.height = n3;
        graphics2D.clip(this.fTempRect);
        if (d != 1.0) {
            graphics2D.scale(d, d);
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        if (this.fHeader != null) {
            this.fHclip.x = this.fClip.x;
            this.fHclip.width = this.fClip.width;
            graphics2D.translate(-this.fHclip.x + dimension.width - 1, 40);
            graphics2D.clip(this.fHclip);
            this.fHeader.print(graphics2D);
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
            graphics2D.translate(0, this.fHclip.height);
        }
        graphics2D.translate(-this.fClip.x + Math.max(dimension.width - 1, 0), -this.fClip.y + 40);
        graphics2D.clip(this.fClip);
        if (this.fTable.getModel() instanceof IAsynchronousContentAccessor) {
            int n6 = this.fTable.rowAtPoint(new Point((int)this.fClip.getX(), (int)this.fClip.getY()));
            int n7 = this.fTable.rowAtPoint(new Point((int)this.fClip.getX(), (int)(this.fClip.getY() + this.fClip.getHeight())));
            int n8 = this.fTable.columnAtPoint(new Point((int)this.fClip.getX(), (int)this.fClip.getY()));
            int n9 = this.fTable.columnAtPoint(new Point((int)(this.fClip.getX() + this.fClip.getWidth()), (int)this.fClip.getY()));
            ((IAsynchronousContentAccessor)((Object)this.fTable.getModel())).printSetup(n6, n7, n8, n9);
        }
        this.fTable.print(graphics2D);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
        if (this.fPrintBorder) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawRect(Math.max(dimension.width - 1, 0), 39, this.fClip.width, this.fHclip.height + this.fClip.height);
        }
        return 0;
    }

    private void findNextClip(int n, int n2) {
        int n3;
        int n4;
        int n5;
        boolean bl = this.fTable.getComponentOrientation().isLeftToRight();
        if (this.fCol == this.fStartCol) {
            this.fClip.x = bl ? this.fStartCol * this.fColModel.getColumn(this.fCol).getWidth() : this.fLastColumnToPrint + 1;
            if (this.fRow == this.fStartRow) {
                for (n5 = 0; n5 < this.fStartRow; ++n5) {
                    this.fClip.y += this.fTable.getRowHeight(n5);
                }
            }
            this.fClip.y += this.fClip.height;
            this.fClip.width = 0;
            this.fClip.height = 0;
            n5 = this.fLastRowToPrint + 1 - this.fStartRow;
            n4 = this.fTable.getRowHeight(this.fRow);
            n3 = 0;
            do {
                this.fClip.height += n4;
            } while (this.fRow + ++n3 - this.fStartRow < n5 && this.fClip.height + (n4 = this.fTable.getRowHeight(this.fRow + n3)) <= n2);
            this.fRow += n3;
        }
        if (this.fPrintMode == JTable.PrintMode.FIT_WIDTH) {
            this.fClip.x = 0;
            this.fClip.width = this.fTotalColWidth;
            return;
        }
        if (bl) {
            this.fClip.x += this.fClip.width;
        }
        this.fClip.width = 0;
        n5 = this.fLastColumnToPrint + 1 - this.fStartCol;
        n4 = this.fColModel.getColumn(this.fCol).getWidth();
        n3 = 0;
        if (this.fScrollPane != null && this.fScrollPane.getRowHeader() != null) {
            n3 = this.fScrollPane.getRowHeader().getView().getSize().width;
        }
        do {
            this.fClip.width += n4;
            if (!bl) {
                this.fClip.x -= n4;
            }
            if (++this.fCol < n5 + this.fStartCol) continue;
            this.fCol = this.fStartCol;
            break;
        } while (this.fClip.width + (n4 = this.fColModel.getColumn(this.fCol).getWidth()) + n3 <= n);
    }

    private int getTotalColWidth() {
        int n = 0;
        for (int i = this.fStartCol; i <= this.fLastColumnToPrint; ++i) {
            n += this.fColModel.getColumn(i).getWidth();
        }
        return n;
    }
}

