/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.matlab.api.editor.EditorSyntaxHighlighting;
import com.mathworks.matlab.api.editor.SyntaxHighlightingColor;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.widgets.SyntaxHighlightingUtils;
import com.mathworks.widgets.text.EditorLanguageUtils;
import com.mathworks.widgets.text.IndentingStyle;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class EditorPreferences {
    public static final String EXTENSIONS_DELIMITER = ";";
    private static final String EDITOR_LANGUAGE_PREFS_PREFIX = "Editor.Language.";

    private EditorPreferences() {
    }

    public static void setFileExtensions(EditorLanguage editorLanguage, List<String> list) {
        Validate.notNull((Object)editorLanguage, (String)"'language' cannot be null");
        Validate.notNull(list, (String)"'extensions' cannot be null");
        String string = StringUtils.join((Object[])list.toArray(), (String)EXTENSIONS_DELIMITER);
        Prefs.setStringPref((String)EditorPreferences.generateFileExtensionsPrefKey(editorLanguage), (String)string);
    }

    public static List<String> getFileExtensions(EditorLanguage editorLanguage) {
        List<String> list;
        Validate.notNull((Object)editorLanguage, (String)"'language' cannot be null");
        String string = Prefs.getStringPref((String)EditorPreferences.generateFileExtensionsPrefKey(editorLanguage), null);
        List<String> list2 = list = string == null ? editorLanguage.getDefaultExtensions() : Arrays.asList(string.split(EXTENSIONS_DELIMITER));
        assert (list != null);
        return list;
    }

    public static void setIndentingStyle(EditorLanguage editorLanguage, IndentingStyle indentingStyle) {
        Validate.notNull((Object)editorLanguage, (String)"'language' cannot be null");
        Validate.notNull((Object)((Object)indentingStyle), (String)"'indenting' cannot be null");
        Prefs.setStringPref((String)EditorPreferences.generateIndentingPrefKey(editorLanguage), (String)indentingStyle.getInternalName());
    }

    public static IndentingStyle getIndentingStyle(EditorLanguage editorLanguage) {
        return IndentingStyle.lookup(Prefs.getStringPref((String)EditorPreferences.generateIndentingPrefKey(editorLanguage), (String)EditorPreferences.getDefaultIndentingStyle().getInternalName()));
    }

    public static IndentingStyle getDefaultIndentingStyle() {
        return IndentingStyle.SMART;
    }

    public static void listenToIndentingPreferences(PrefListener prefListener) {
        Validate.notNull((Object)prefListener, (String)"'listener' cannot be null");
        for (EditorLanguage editorLanguage : EditorLanguageUtils.getLanguages()) {
            Prefs.addListener((PrefListener)prefListener, (String)EditorPreferences.generateIndentingPrefKey(editorLanguage));
        }
    }

    public static boolean isIndentingPreference(EditorLanguage editorLanguage, String string) {
        Validate.notNull((Object)string, (String)"'key' cannot be null");
        return string.equals(EditorPreferences.generateIndentingPrefKey(editorLanguage));
    }

    public static void setSyntaxHighlightingEnabled(EditorSyntaxHighlighting editorSyntaxHighlighting, boolean bl) {
        Validate.notNull((Object)editorSyntaxHighlighting, (String)"'highlighting' cannot be null");
        Prefs.setBooleanPref((String)EditorPreferences.generateSyntaxHighlightingPrefKey(editorSyntaxHighlighting.getLanguage()), (boolean)bl);
    }

    public static boolean isSyntaxHighlightingEnabled(EditorSyntaxHighlighting editorSyntaxHighlighting) {
        Validate.notNull((Object)editorSyntaxHighlighting, (String)"'highlighting' cannot be null");
        return Prefs.getBooleanPref((String)EditorPreferences.generateSyntaxHighlightingPrefKey(editorSyntaxHighlighting.getLanguage()), (boolean)true);
    }

    public static void listenToSyntaxHighlightingPreferences(PrefListener prefListener) {
        Validate.notNull((Object)prefListener, (String)"'listener' cannot be null");
        for (EditorSyntaxHighlighting editorSyntaxHighlighting : SyntaxHighlightingUtils.getAllSyntaxHighlightings()) {
            Prefs.addListener((PrefListener)prefListener, (String)EditorPreferences.generateSyntaxHighlightingPrefKey(editorSyntaxHighlighting.getLanguage()));
            for (SyntaxHighlightingColor syntaxHighlightingColor : editorSyntaxHighlighting.getColors()) {
                Prefs.addListener((PrefListener)prefListener, (String)syntaxHighlightingColor.getPreferenceKey());
            }
        }
    }

    public static boolean isSyntaxHighlightingPreference(EditorLanguage editorLanguage, String string) {
        Validate.notNull((Object)string, (String)"'key' cannot be null");
        return string.equals(EditorPreferences.generateSyntaxHighlightingPrefKey(editorLanguage));
    }

    public static void setTabChangedToSpaces(boolean bl) {
        Prefs.setBooleanPref((String)"EditorTabToSpaces", (boolean)bl);
    }

    public static void setSpacesPerTab(int n) {
        Prefs.setIntegerPref((String)"EditorSpacesPerTab", (int)n);
    }

    public static String generateFileExtensionsPrefKey(EditorLanguage editorLanguage) {
        return EDITOR_LANGUAGE_PREFS_PREFIX + editorLanguage.getInternalName() + ".Extensions";
    }

    private static String generateSyntaxHighlightingPrefKey(EditorLanguage editorLanguage) {
        return EDITOR_LANGUAGE_PREFS_PREFIX + editorLanguage.getInternalName() + ".SyntaxHighlighting";
    }

    private static String generateIndentingPrefKey(EditorLanguage editorLanguage) {
        return EDITOR_LANGUAGE_PREFS_PREFIX + editorLanguage.getInternalName() + ".Indenting";
    }
}

