/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorLayer;
import com.mathworks.matlab.api.editor.EditorMessage;
import com.mathworks.matlab.api.editor.EditorMessageBarContributor;
import com.mathworks.matlab.api.editor.highlighting.EditorHighlighterProvider;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.GraphicsUtils;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.STPPrefsManager;
import com.mathworks.widgets.editor.highlights.HighlighterManager;
import com.mathworks.widgets.text.MWKit;
import com.mathworks.widgets.text.MWPopupManager;
import com.mathworks.widgets.text.MWStatusBar;
import com.mathworks.widgets.text.MWToolTipSupport;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.STPMessagePanel;
import com.mathworks.widgets.text.STPViewModificationInterface;
import com.mathworks.widgets.text.fold.MWCodeFoldingSideBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.GlyphGutter;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.SettingsAdapter;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ToolTipSupport;

public class MWEditorUI
extends ExtEditorUI {
    private final JPanel fLeftPanel = new MJPanel((LayoutManager)new BorderLayout());
    private final JPanel fRightPanel = new MJPanel((LayoutManager)new BorderLayout());
    private JScrollPane fScrollPane;
    private MWStatusBar fStatusBar;
    private Component fVerticalComp;
    private Component fHorizontalComp;
    private boolean fShowCorners;
    private MWCodeFoldingSideBar fCodeFoldingSideBar;
    private boolean fShowCodeFoldingUI;
    protected final PropertyChangeListener fDocumentChangedListener;
    protected final Map<String, EditorLayer> fLayers = new HashMap<String, EditorLayer>();
    private STPMessagePanel fMessagePanel;
    private HighlighterManager fHighlighterManager;
    private boolean fHideScrollPaneBorder;

    public MWEditorUI() {
        this(false);
    }

    public MWEditorUI(boolean bl) {
        this.fShowCodeFoldingUI = bl;
        this.fDocumentChangedListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("document")) {
                    Document document = (Document)propertyChangeEvent.getOldValue();
                    Document document2 = (Document)propertyChangeEvent.getNewValue();
                    for (EditorLayer editorLayer : MWEditorUI.this.fLayers.values()) {
                        editorLayer.updateDocuments(document, document2);
                    }
                    MWEditorUI.this.getHighlighterManager().setDocument((BaseDocument)document2);
                }
            }
        };
    }

    protected JComponent createExtComponent() {
        JComponent jComponent = super.createExtComponent();
        Component[] componentArray = jComponent.getComponents();
        for (int i = 0; i != componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JScrollPane)) continue;
            JScrollPane jScrollPane = (JScrollPane)componentArray[i];
            Component[] componentArray2 = jScrollPane.getRowHeader().getComponents();
            for (int j = 0; j != componentArray2.length; ++j) {
                if (!(componentArray2[j] instanceof GlyphGutter)) continue;
                GlyphGutter glyphGutter = (GlyphGutter)componentArray2[j];
                glyphGutter.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com.mathworks.widgets.text.resources.RES_text").getString("acc.lineNumberDisplay"));
                glyphGutter.setName("LineNumberPanel");
                jScrollPane.getRowHeader().remove((Component)glyphGutter);
                this.fLeftPanel.add((Component)glyphGutter, "West");
                jScrollPane.setRowHeaderView(this.fLeftPanel);
                break;
            }
            jComponent.remove(jScrollPane);
            this.fScrollPane = new MJScrollPane(jScrollPane.getViewport().getView());
            this.fScrollPane.setVerticalScrollBarPolicy(20);
            this.fScrollPane.setHorizontalScrollBarPolicy(30);
            FancyLayout fancyLayout = new FancyLayout();
            this.fScrollPane.setLayout(fancyLayout);
            fancyLayout.syncWithScrollPane(this.fScrollPane);
            if (this.fVerticalComp != null) {
                this.fScrollPane.add(this.fVerticalComp);
            }
            if (this.fHorizontalComp != null) {
                this.fScrollPane.add(this.fHorizontalComp);
            }
            this.fScrollPane.getViewport().setMinimumSize(jScrollPane.getViewport().getMinimumSize());
            this.fScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.fScrollPane.setRowHeaderView(jScrollPane.getRowHeader().getView());
            if (this.fHideScrollPaneBorder) {
                this.fScrollPane.setBorder(BorderFactory.createEmptyBorder());
            }
            jComponent.add((Component)this.fScrollPane, "Center");
        }
        jComponent.add((Component)this.fRightPanel, "East");
        if (this.fShowCodeFoldingUI) {
            this.createFoldSideBar();
        }
        return jComponent;
    }

    private void createFoldSideBar() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MWEditorUI.this.fCodeFoldingSideBar = new MWCodeFoldingSideBar(MWEditorUI.this.getComponent());
                MWEditorUI.this.fLeftPanel.add((Component)((Object)MWEditorUI.this.fCodeFoldingSideBar), "East");
                MWEditorUI.this.fLeftPanel.revalidate();
                ((STPViewModificationInterface)((Object)MWEditorUI.this.getComponent())).registerViewHierarchyModificationComponent(MWEditorUI.this.fCodeFoldingSideBar);
            }
        });
    }

    public void hideScrollPaneBorder() {
        this.fHideScrollPaneBorder = true;
        this.fRightPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, new Color(204, 204, 204)));
    }

    public MWCodeFoldingSideBar getFoldSideBar() {
        return this.fCodeFoldingSideBar;
    }

    public JPanel getRightPanel() {
        return this.fRightPanel;
    }

    public void setRightPanel(Component component) {
        this.fRightPanel.add(component, "Center");
        this.fRightPanel.revalidate();
    }

    public void removeRightPanel(Component component) {
        this.fRightPanel.remove(component);
        this.fRightPanel.revalidate();
    }

    public void setLeftPanel(JPanel jPanel) {
        this.fLeftPanel.add((Component)jPanel, "Center");
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public HighlighterManager getHighlighterManager() {
        if (this.fHighlighterManager == null) {
            this.fHighlighterManager = new HighlighterManager(null);
        }
        return this.fHighlighterManager;
    }

    public StatusBar getStatusBar() {
        if (this.fStatusBar == null) {
            this.fStatusBar = new MWStatusBar((EditorUI)this);
        }
        return this.fStatusBar;
    }

    public ToolTipSupport getToolTipSupport() {
        if (this.toolTipSupport == null) {
            this.toolTipSupport = new MWToolTipSupport(this);
        }
        return this.toolTipSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PopupManager getPopupManager() {
        if (this.popupManager == null) {
            Object object = this.getComponentLock();
            synchronized (object) {
                if (this.getComponent() != null) {
                    this.popupManager = new MWPopupManager(this.getComponent());
                }
            }
        }
        return this.popupManager;
    }

    public void cleanup() {
        for (EditorLayer editorLayer : this.fLayers.values()) {
            if (editorLayer.supportsMessageBar() && editorLayer.getMessageBarContributor() != null) {
                this.removeFromRightPanel(editorLayer.getMessageBarContributor());
            }
            editorLayer.cleanup();
        }
        this.fLayers.clear();
        this.getComponent().removePropertyChangeListener(this.fDocumentChangedListener);
        if (this.fCodeFoldingSideBar != null) {
            this.fLeftPanel.remove((Component)((Object)this.fCodeFoldingSideBar));
            this.fCodeFoldingSideBar = null;
        }
        this.getToolTipSupport().setEnabled(false);
        ((MWToolTipSupport)this.getToolTipSupport()).unregisterMouseListeners(this.getComponent());
    }

    protected void setExtentPosition(int n, int n2) {
        int n3;
        boolean bl = false;
        JViewport jViewport = this.getParentViewport();
        if (jViewport != null && (double)(n3 = Math.max(n, 0)) > jViewport.getViewPosition().getX()) {
            bl = true;
        }
        super.setExtentPosition(n, n2);
        if (jViewport != null && bl) {
            jViewport.revalidate();
        }
    }

    public void addLayer(EditorLayer editorLayer) {
        String string = editorLayer.getLayerName();
        assert (!this.fLayers.containsKey(string)) : "An EditorLayer should not be added twice.";
        this.fLayers.put(string, editorLayer);
    }

    protected void disableLayers() {
        if (this.getComponent() != null) {
            for (EditorLayer editorLayer : this.fLayers.values()) {
                this.disableLayer(editorLayer);
            }
            this.getComponent().removePropertyChangeListener(this.fDocumentChangedListener);
        }
    }

    public Collection<EditorLayer> getLayers() {
        return this.fLayers.values();
    }

    protected void uninstallUI(JTextComponent jTextComponent) {
        this.disableLayers();
        super.uninstallUI(jTextComponent);
    }

    public void disableLayer(EditorLayer editorLayer) {
        editorLayer.disable();
        if (editorLayer.getMessageBarContributor() != null) {
            this.removeFromRightPanel(editorLayer.getMessageBarContributor());
        }
    }

    public EditorLayer getLayer(String string) {
        return this.fLayers.get(string);
    }

    private void addToRightPanel(EditorMessageBarContributor editorMessageBarContributor) {
        this.createMessagePanelIfNone();
        this.fMessagePanel.addContributor(editorMessageBarContributor);
    }

    private void removeFromRightPanel(EditorMessageBarContributor editorMessageBarContributor) {
        if (this.fMessagePanel != null) {
            this.fMessagePanel.removeContributor(editorMessageBarContributor);
            this.removeMessagePanelIfNoPanelLayers();
        }
    }

    private void createMessagePanelIfNone() {
        MJUtilities.assertIsEventThread();
        if (this.fMessagePanel == null) {
            this.fMessagePanel = this.createMessagePanel((STPBaseInterface)((Object)this.getComponent()));
            this.setRightPanel(this.fMessagePanel.getComponent());
        }
    }

    protected STPMessagePanel createMessagePanel(STPBaseInterface sTPBaseInterface) {
        return new STPMessagePanel(sTPBaseInterface);
    }

    private void removeMessagePanelIfNoPanelLayers() {
        if (this.fMessagePanel.numberOfContributors() == 0) {
            this.fMessagePanel.uninstall();
            this.removeRightPanel(this.fMessagePanel.getComponent());
            this.fMessagePanel = null;
        }
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        super.settingsChange(settingsChangeEvent);
        if (this.getComponent() != null && Utilities.getKit((JTextComponent)this.getComponent()) == null) {
            return;
        }
        String string = settingsChangeEvent != null ? settingsChangeEvent.getSettingName() : null;
        for (EditorLayer editorLayer : this.fLayers.values()) {
            editorLayer.settingsChanged(string, (ExtEditorUI)this);
        }
    }

    public List<? extends EditorMessage> getEditorMessagesAtPosition(int n, int n2) {
        ArrayList arrayList = new ArrayList();
        for (EditorLayer editorLayer : this.fLayers.values()) {
            arrayList.addAll(editorLayer.getMessagesAtPosition(n, n2));
        }
        return arrayList;
    }

    public STPMessagePanel getMessagePanel() {
        return this.fMessagePanel;
    }

    public void installLayer(EditorLayer editorLayer) {
        this.installEditorFeatures(editorLayer, null);
    }

    public void addAndBuildLayerForEditor(EditorLayer editorLayer, Editor editor) {
        Validate.notNull((Object)editorLayer, (String)"EditorLayer should not be null");
        Validate.notNull((Object)editor, (String)"Editor should not be null");
        this.addLayer(editorLayer);
        this.installEditorFeatures(editorLayer, editor);
    }

    private void installEditorFeatures(EditorLayer editorLayer, Editor editor) {
        editorLayer.enable(this.getComponent());
        this.buildAndInstallMessageBarContributor(editorLayer, editor);
        this.installEditorHighlighter(editorLayer, editor);
    }

    private void buildAndInstallMessageBarContributor(EditorLayer editorLayer, Editor editor) {
        if (editorLayer.supportsMessageBar()) {
            EditorMessageBarContributor editorMessageBarContributor = editorLayer.getMessageBarContributor();
            if (editor != null) {
                editorMessageBarContributor.configureModel(editor);
            }
            this.addToRightPanel(editorMessageBarContributor);
        }
    }

    private void installEditorHighlighter(EditorLayer editorLayer, Editor editor) {
        if (editorLayer.supportsHighlighting()) {
            EditorHighlighterProvider editorHighlighterProvider = editorLayer.getEditorHighlighterProvider();
            if (editor != null) {
                editorHighlighterProvider.configureHighlighter(editor);
            }
            this.getHighlighterManager().addHighlighter(editorHighlighterProvider.getHighlighter());
        }
    }

    protected void installUI(final JTextComponent jTextComponent) {
        super.installUI(jTextComponent);
        this.getComponent().setDragEnabled(false);
        if (jTextComponent != null && Utilities.getKit((JTextComponent)jTextComponent) instanceof MWKit) {
            final MWEditorInputMap mWEditorInputMap = new MWEditorInputMap();
            MatlabKeyBindings.getManager().addKeyBindingsWithTag("MATLABEditor", "SyntaxTextPane", (ExtendedInputMap)mWEditorInputMap);
            Runnable object = new Runnable(){

                @Override
                public void run() {
                    InputMap inputMap = jTextComponent.getInputMap(0);
                    InputMap inputMap2 = null;
                    InputMap inputMap3 = inputMap;
                    while (inputMap3 != null && !(inputMap3 instanceof MWEditorInputMap)) {
                        inputMap2 = inputMap3;
                        inputMap3 = inputMap2.getParent();
                    }
                    if (inputMap3 != null) {
                        mWEditorInputMap.setParent(inputMap3.getParent());
                    } else {
                        mWEditorInputMap.setParent(inputMap.getParent());
                        inputMap2 = null;
                    }
                    if (inputMap2 != null) {
                        inputMap2.setParent((InputMap)mWEditorInputMap);
                    } else {
                        jTextComponent.setInputMap(0, (InputMap)mWEditorInputMap);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                object.run();
            } else {
                SwingUtilities.invokeLater(object);
            }
        }
        this.getHighlighterManager().setDocument(this.getDocument());
        for (EditorLayer editorLayer : this.fLayers.values()) {
            this.installLayer(editorLayer);
        }
        this.getComponent().addPropertyChangeListener(this.fDocumentChangedListener);
    }

    public void fireFakePropertyChange(String string, Object object) {
        this.firePropertyChange(string, null, object);
    }

    public void addCorners(Component component, Component component2) {
        if (this.fVerticalComp != null && this.fScrollPane != null) {
            this.fScrollPane.remove(this.fVerticalComp);
        }
        if (this.fHorizontalComp != null && this.fScrollPane != null) {
            this.fScrollPane.remove(this.fHorizontalComp);
        }
        this.fVerticalComp = component;
        this.fHorizontalComp = component2;
        if (this.fScrollPane != null) {
            this.fScrollPane.add(this.fVerticalComp);
            this.fScrollPane.add(this.fHorizontalComp);
            if (this.fShowCorners) {
                this.fScrollPane.revalidate();
            }
        }
    }

    public void setCornerVisibility(boolean bl) {
        this.fShowCorners = bl;
        this.fScrollPane.revalidate();
    }

    static {
        Toolkit.getDefaultToolkit().addPropertyChangeListener("awt.font.desktophints", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SettingsAdapter.setValue((Object)STPPrefsManager.getInstance(), MWKit.class, (String)"rendering-hints", (Object)GraphicsUtils.getAntialiasingRenderingHints());
            }
        });
    }

    private class FancyLayout
    extends ScrollPaneLayout {
        private FancyLayout() {
        }

        @Override
        public void layoutContainer(Container container) {
            Rectangle rectangle;
            super.layoutContainer(container);
            Rectangle rectangle2 = null;
            if (this.rowHead != null && this.hsb != null) {
                Rectangle rectangle3 = this.hsb.getBounds();
                rectangle = this.rowHead.getBounds();
                rectangle2 = new Rectangle(rectangle.x, rectangle3.y, rectangle3.width + rectangle.width, rectangle3.height);
            }
            if (this.hsb != null && MWEditorUI.this.fShowCorners && MWEditorUI.this.fHorizontalComp != null) {
                int n = ((MWEditorUI)MWEditorUI.this).fHorizontalComp.getMinimumSize().width;
                if (rectangle2 == null) {
                    rectangle2 = this.hsb.getBounds();
                }
                rectangle = rectangle2;
                MWEditorUI.this.fHorizontalComp.setBounds(new Rectangle(rectangle.x, rectangle.y, n, rectangle.height));
                rectangle2 = new Rectangle(rectangle.x + n, rectangle.y, rectangle.width - n, rectangle.height);
            }
            if (this.hsb != null && rectangle2 != null) {
                this.hsb.setBounds(rectangle2);
            }
            if (this.vsb != null && MWEditorUI.this.fShowCorners && MWEditorUI.this.fVerticalComp != null) {
                int n = ((MWEditorUI)MWEditorUI.this).fVerticalComp.getMinimumSize().height;
                rectangle = this.vsb.getBounds();
                MWEditorUI.this.fVerticalComp.setBounds(new Rectangle(rectangle.x, rectangle.y, rectangle.width, n));
                this.vsb.setBounds(new Rectangle(rectangle.x, rectangle.y + n, rectangle.width, rectangle.height - n));
            }
        }
    }

    private static class MWEditorInputMap
    extends MInputMap {
        private MWEditorInputMap() {
        }
    }
}

