/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.java;

import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.matlab.api.editor.EditorSyntaxHighlighting;
import com.mathworks.matlab.api.editor.SyntaxHighlightingColor;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.widgets.text.CommonResources;
import com.mathworks.widgets.text.DefaultSyntaxColor;
import com.mathworks.widgets.text.EditorPrefsAccessor;
import com.mathworks.widgets.text.MethodStyle;
import com.mathworks.widgets.text.java.JavaKit;
import com.mathworks.widgets.text.java.JavaLanguage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.text.EditorKit;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.ext.java.JavaLayerTokenContext;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JavaSyntaxHighlighting
implements EditorSyntaxHighlighting {
    public static final EditorSyntaxHighlighting INSTANCE = new JavaSyntaxHighlighting();
    public static final SyntaxHighlightingColor KEYWORD = new DefaultSyntaxColor(CommonResources.KEYWORDS_LABEL, EditorPrefsAccessor.getKeywordsColor(true), JavaTokenContext.KEYWORDS.getName(), JavaLanguage.INSTANCE.getInternalName());
    public static final SyntaxHighlightingColor COMMENT = new DefaultSyntaxColor(CommonResources.COMMENTS_LABEL, EditorPrefsAccessor.getCommentColor(true), JavaTokenContext.LINE_COMMENT.getName(), JavaLanguage.INSTANCE.getInternalName());
    public static final SyntaxHighlightingColor STRING = new DefaultSyntaxColor(CommonResources.STRINGS_LABEL, EditorPrefsAccessor.getStringColor(true), JavaTokenContext.STRING_LITERAL.getName(), JavaLanguage.INSTANCE.getInternalName());
    public static final SyntaxHighlightingColor ERROR = new DefaultSyntaxColor(CommonResources.ERRORS_LABEL, EditorPrefsAccessor.getErrorsColor(true), JavaTokenContext.ERRORS.getName(), JavaLanguage.INSTANCE.getInternalName());
    public static final SyntaxHighlightingColor CHAR = new DefaultSyntaxColor(CommonResources.CHARACTERS_LABEL, ColorPrefs.MatlabColor.STRING.getDefaultColor().brighter().brighter(), JavaTokenContext.CHAR_LITERAL.getName(), JavaLanguage.INSTANCE.getInternalName());
    private static final List<SyntaxHighlightingColor> COLORS = Arrays.asList(KEYWORD, COMMENT, STRING, CHAR);
    private static final String METHOD_STYLE_PREFERENCES_KEY = "Editor.Language." + JavaLanguage.INSTANCE.getInternalName() + "." + JavaLayerTokenContext.METHOD.getName();

    public EditorLanguage getLanguage() {
        return JavaLanguage.INSTANCE;
    }

    public List<SyntaxHighlightingColor> getColors() {
        return Collections.unmodifiableList(COLORS);
    }

    public TokenContext getTokenContext() {
        return JavaTokenContext.context;
    }

    public static MethodStyle getJavaMethodStyle() {
        String string = Prefs.getStringPref((String)METHOD_STYLE_PREFERENCES_KEY, (String)MethodStyle.BOLD.getInternalName());
        return MethodStyle.lookup(string);
    }

    public static void setJavaMethodStylePreference(MethodStyle methodStyle) {
        Validate.notNull((Object)((Object)methodStyle), (String)"'style' cannot be null");
        Prefs.setStringPref((String)METHOD_STYLE_PREFERENCES_KEY, (String)methodStyle.getInternalName());
    }

    public static void listenToJavaMethodTypePreference(PrefListener prefListener) {
        Validate.notNull((Object)prefListener, (String)"'listener' cannot be null");
        Prefs.addListener((PrefListener)prefListener, (String)METHOD_STYLE_PREFERENCES_KEY);
    }

    public static boolean isJavaMethodTypePreference(String string) {
        Validate.notNull((Object)string, (String)"'key' cannot be null");
        return string.equals(METHOD_STYLE_PREFERENCES_KEY);
    }

    public Class<? extends EditorKit> getBaseKitClass() {
        return JavaKit.class;
    }
}

