/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.matlab;

import com.mathworks.util.IntBuffer;
import com.mathworks.widgets.text.matlab.MatlabState;

public final class MatlabTokenInfo {
    private final int[] fTokens;
    private final int[] fTokenOffsets;
    private final int[] fTokenLengths;
    private final MatlabState fState;

    public MatlabTokenInfo(IntBuffer intBuffer, IntBuffer intBuffer2, MatlabState matlabState, int n) {
        assert (intBuffer.length() == intBuffer2.length()) : "Expected tokens.length() " + intBuffer.length() + " to equal tokenLengths.length() " + intBuffer2.length();
        this.fTokens = intBuffer.toArray();
        this.fTokenLengths = intBuffer2.toArray();
        assert (this.fTokens.length == intBuffer.length());
        int n2 = this.fTokens.length;
        this.fTokenOffsets = new int[n2];
        if (n2 > 0) {
            this.fTokenOffsets[0] = n;
            this.fState = matlabState;
        } else {
            this.fState = null;
        }
        for (int i = 1; i < intBuffer2.length(); ++i) {
            int n3 = intBuffer2.getAt(i - 1);
            this.fTokenOffsets[i] = this.fTokenOffsets[i - 1] + n3;
        }
    }

    public int getNumTokens() {
        return this.fTokens.length;
    }

    public MatlabState getNewState() {
        return this.fState;
    }

    public void modifyOffsets(int n) {
        for (int i = 0; i < this.fTokenOffsets.length; ++i) {
            this.fTokenOffsets[i] = this.fTokenOffsets[i] + n;
        }
    }

    public int getOffset(int n) {
        return this.fTokenOffsets[n];
    }

    public int getToken(int n) {
        return this.fTokens[n];
    }

    public int getTokenLength(int n) {
        return this.fTokenLengths[n];
    }
}

