/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.matlab.api.editor.EditorMenuGroupID;
import com.mathworks.matlab.api.editor.EditorMessage;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.util.Log;
import com.mathworks.widgets.TokenizerFactory;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import com.mathworks.widgets.text.MWKit;
import com.mathworks.widgets.text.PrintableDocument;
import com.mathworks.widgets.text.layer.LayerActions;
import com.mathworks.widgets.text.layer.LayerUtils;
import com.mathworks.widgets.text.matlab.MatlabCaret;
import com.mathworks.widgets.text.matlab.MatlabEditorKit;
import com.mathworks.widgets.text.matlab.MatlabSyntaxSupport;
import com.mathworks.widgets.text.mcode.MEditorUI;
import com.mathworks.widgets.text.mcode.MFoldManager;
import com.mathworks.widgets.text.mcode.MFormatter;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.mcode.MLint;
import com.mathworks.widgets.text.mcode.MSettingsInitializer;
import com.mathworks.widgets.text.mcode.MSyntaxFactory;
import com.mathworks.widgets.text.mcode.MTokenManager;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerActions;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerUtils;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightActions;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightPrefs;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightUtils;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;

public abstract class MKit
extends MatlabEditorKit {
    public static final String M_MIME_TYPE = MLanguage.INSTANCE.getMimeType();
    private static final boolean CODE_FOLDING_SUPPORTED = false;

    public static List<Settings.Initializer> getInitializers() {
        return Collections.unmodifiableList(Arrays.asList(new Settings.Initializer[]{new MSettingsInitializer(MKit.class)}));
    }

    public Syntax createSyntax(Document document) {
        return MSyntaxFactory.createEditorSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        return new MatlabSyntaxSupport(baseDocument, MTokenManager.getInstance());
    }

    public Formatter createFormatter() {
        return new MFormatter(((Object)((Object)this)).getClass());
    }

    @Override
    public Caret createCaret() {
        return new MatlabCaret(MTokenManager.getInstance(), TokenizerFactory.getMTokenizer());
    }

    protected boolean isFollowingMLintPreference() {
        return false;
    }

    @Override
    protected EditorUI createEditorUI() {
        MEditorUI mEditorUI = new MEditorUI(this.isCodeFoldingEnabled());
        CodeAnalyzerUtils.getCodeAnalyzerLayer((EditorUI)mEditorUI).setFollowingMLintPreference(this.isFollowingMLintPreference());
        return mEditorUI;
    }

    protected boolean supportsCodeFolding() {
        return false;
    }

    @Override
    public void prepareClone(BaseDocument baseDocument) {
        MFoldManager.putEmptyIgnoreLastValidFoldsProperty(baseDocument);
    }

    @Override
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new MFormatAction(), new MPasteAction(), new MBuildPopupMenuAction(), CodeAnalyzerActions.createAutoFixBindingAction(), CodeAnalyzerActions.createDisableAllBindingAction(), CodeAnalyzerActions.createSuppressThisBindingAction(), CodeAnalyzerActions.createSuppressAllBindingAction(), VariableHighlightActions.createVariableHighlightAction()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    public static class MBuildPopupMenuAction
    extends MWKit.MWBuildPopupMenuAction {
        private static final ResourceBundle BUNDLE = CodeAnalyzerUtils.getBundle();
        private static final String MENU_CONTAINS_CODE_ANALYZER = "codeAnalyzerMenuItems";
        private static final String CODE_ANALYZER_MENU_ITEM = "codeAnalyzerMenuItem";
        private static final String OPEN_MESSAGE_MENU_PROPERTY = "openMessageMenuItem";
        private static final String VAR_HIGHLIGHTING_MENU_PROPERTY = "variableHighlightingMenuItems";
        private int fCount;

        @Override
        protected JPopupMenu buildPopupMenu(JTextComponent jTextComponent) {
            JPopupMenu jPopupMenu = super.buildPopupMenu(jTextComponent);
            MBuildPopupMenuAction.validatePopupMenuActions(jTextComponent);
            this.fCount = 0;
            this.maybeAddOrRemoveCodeAnalyzerItems(jTextComponent, jPopupMenu);
            this.maybeAddOrRemoveOpenMessageItem(jTextComponent, jPopupMenu);
            this.maybeAddVariableHighlighting(jTextComponent, jPopupMenu);
            return jPopupMenu;
        }

        private void maybeAddOrRemoveCodeAnalyzerItems(JTextComponent jTextComponent, JPopupMenu jPopupMenu) {
            MLint.Message message = CodeAnalyzerUtils.getFirstOrFirstAutoFixableMessage(jTextComponent);
            if (message != null) {
                this.addMLintMenuItems(jPopupMenu, message);
            } else if (jPopupMenu.getClientProperty(MENU_CONTAINS_CODE_ANALYZER) != null) {
                MBuildPopupMenuAction.removeMenuItems(jPopupMenu, CODE_ANALYZER_MENU_ITEM, MENU_CONTAINS_CODE_ANALYZER);
            }
        }

        private void maybeAddOrRemoveOpenMessageItem(JTextComponent jTextComponent, JPopupMenu jPopupMenu) {
            List<? extends EditorMessage> list = LayerUtils.getMessagesAtCaret(jTextComponent);
            if (!list.isEmpty()) {
                this.addOpenMessageItem(jPopupMenu);
            } else if (jPopupMenu.getClientProperty(OPEN_MESSAGE_MENU_PROPERTY) != null) {
                MBuildPopupMenuAction.removeMenuItems(jPopupMenu, OPEN_MESSAGE_MENU_PROPERTY, MENU_CONTAINS_CODE_ANALYZER);
            }
        }

        private void maybeAddVariableHighlighting(JTextComponent jTextComponent, JPopupMenu jPopupMenu) {
            MTree.Node node;
            if (jPopupMenu.getClientProperty(VAR_HIGHLIGHTING_MENU_PROPERTY) != null) {
                MBuildPopupMenuAction.removeMenuItems(jPopupMenu, VAR_HIGHLIGHTING_MENU_PROPERTY, VAR_HIGHLIGHTING_MENU_PROPERTY);
            }
            if ((node = VariableHighlightUtils.getVariableUnderCaret(jTextComponent)) != null && !VariableHighlightPrefs.isAutoHighlighting()) {
                MJMenuItem mJMenuItem = new MJMenuItem(VariableHighlightActions.createHighlightVariableMenuAction(node));
                mJMenuItem.putClientProperty((Object)"EditorMenuGroup", (Object)EditorMenuGroupID.CONTEXT_SELECTION_GROUP);
                mJMenuItem.putClientProperty((Object)VAR_HIGHLIGHTING_MENU_PROPERTY, (Object)Boolean.TRUE);
                jPopupMenu.add((Component)mJMenuItem, this.fCount++);
                jPopupMenu.putClientProperty(VAR_HIGHLIGHTING_MENU_PROPERTY, Boolean.TRUE);
            }
        }

        private void addMLintMenuItems(JPopupMenu jPopupMenu, MLint.Message message) {
            CodeAnalyzerActions.CodeAnalyzerMessageMenuAction codeAnalyzerMessageMenuAction = CodeAnalyzerActions.createAutoFixMenuAction(message);
            if (jPopupMenu.getClientProperty(MENU_CONTAINS_CODE_ANALYZER) != null) {
                MBuildPopupMenuAction.removeMenuItems(jPopupMenu, CODE_ANALYZER_MENU_ITEM, MENU_CONTAINS_CODE_ANALYZER);
            }
            MJMenuItem mJMenuItem = new MJMenuItem((Action)((Object)codeAnalyzerMessageMenuAction));
            mJMenuItem.putClientProperty((Object)CODE_ANALYZER_MENU_ITEM, (Object)Boolean.TRUE);
            mJMenuItem.setFont(mJMenuItem.getFont().deriveFont(1));
            mJMenuItem.putClientProperty((Object)"EditorMenuGroup", (Object)EditorMenuGroupID.CONTEXT_CODE_ANALYZER_GROUP);
            jPopupMenu.add((Component)mJMenuItem, this.fCount++);
            if (CodeAnalyzerUtils.isSupressableOrDisableable(message)) {
                String string = new String(MessageFormat.format(BUNDLE.getString("mkit.mlint.suppressSubMenu"), CodeAnalyzerUtils.truncateMessage(message)));
                int n = MJUtilities.indexOfMnemonic((String)string);
                if (n > 0) {
                    string = new StringBuffer(string).insert(n, "&").toString();
                }
                MJMenu mJMenu = new MJMenu(string.toString());
                mJMenu.putClientProperty((Object)"EditorMenuGroup", (Object)EditorMenuGroupID.CONTEXT_CODE_ANALYZER_GROUP);
                mJMenu.putClientProperty((Object)CODE_ANALYZER_MENU_ITEM, (Object)Boolean.TRUE);
                jPopupMenu.add((Component)mJMenu, this.fCount++);
                CodeAnalyzerActions.CodeAnalyzerMessageMenuAction codeAnalyzerMessageMenuAction2 = CodeAnalyzerActions.createSuppressThisMenuAction(message);
                CodeAnalyzerActions.CodeAnalyzerMessageMenuAction codeAnalyzerMessageMenuAction3 = CodeAnalyzerActions.createSuppressAllMenuAction();
                CodeAnalyzerActions.CodeAnalyzerMessageMenuAction codeAnalyzerMessageMenuAction4 = CodeAnalyzerActions.createDisableAllMenuAction();
                MJMenuItem mJMenuItem2 = new MJMenuItem((Action)((Object)codeAnalyzerMessageMenuAction2));
                mJMenuItem2.setText(BUNDLE.getString("mkit.mlint.onThisLine"));
                mJMenuItem2.putClientProperty((Object)CODE_ANALYZER_MENU_ITEM, (Object)Boolean.TRUE);
                mJMenuItem2.putClientProperty((Object)"EditorMenuGroup", (Object)EditorMenuGroupID.CONTEXT_CODE_ANALYZER_GROUP);
                mJMenu.add((JMenuItem)mJMenuItem2);
                MJMenuItem mJMenuItem3 = new MJMenuItem((Action)((Object)codeAnalyzerMessageMenuAction3));
                mJMenuItem3.putClientProperty((Object)CODE_ANALYZER_MENU_ITEM, (Object)Boolean.TRUE);
                mJMenuItem3.setText(BUNDLE.getString("mkit.mlint.inThisFile"));
                mJMenuItem3.putClientProperty((Object)"EditorMenuGroup", (Object)EditorMenuGroupID.CONTEXT_CODE_ANALYZER_GROUP);
                mJMenu.add((JMenuItem)mJMenuItem3);
                codeAnalyzerMessageMenuAction4.setEnabled(CodeAnalyzerActions.isMessageDisableable(message));
                MJMenuItem mJMenuItem4 = new MJMenuItem((Action)((Object)codeAnalyzerMessageMenuAction4));
                mJMenuItem4.putClientProperty((Object)CODE_ANALYZER_MENU_ITEM, (Object)Boolean.TRUE);
                mJMenuItem4.setText(BUNDLE.getString("mkit.mlint.inAllFiles"));
                mJMenuItem4.putClientProperty((Object)"EditorMenuGroup", (Object)EditorMenuGroupID.CONTEXT_CODE_ANALYZER_GROUP);
                mJMenu.add((JMenuItem)mJMenuItem4);
            }
            jPopupMenu.putClientProperty(MENU_CONTAINS_CODE_ANALYZER, Boolean.TRUE);
        }

        private void addOpenMessageItem(JPopupMenu jPopupMenu) {
            if (jPopupMenu.getClientProperty(OPEN_MESSAGE_MENU_PROPERTY) != null) {
                MBuildPopupMenuAction.removeMenuItems(jPopupMenu, OPEN_MESSAGE_MENU_PROPERTY, OPEN_MESSAGE_MENU_PROPERTY);
            }
            Action action = LayerActions.createOpenMessageMenuItemAction();
            MJMenuItem mJMenuItem = new MJMenuItem(action);
            mJMenuItem.putClientProperty((Object)OPEN_MESSAGE_MENU_PROPERTY, (Object)Boolean.TRUE);
            mJMenuItem.putClientProperty((Object)"EditorMenuGroup", (Object)EditorMenuGroupID.CONTEXT_CODE_ANALYZER_GROUP);
            jPopupMenu.add((Component)mJMenuItem, this.fCount++);
            jPopupMenu.putClientProperty(OPEN_MESSAGE_MENU_PROPERTY, Boolean.TRUE);
            JPopupMenu.Separator separator = new JPopupMenu.Separator();
            separator.putClientProperty(OPEN_MESSAGE_MENU_PROPERTY, Boolean.TRUE);
            separator.putClientProperty("EditorMenuGroup", EditorMenuGroupID.CONTEXT_CODE_ANALYZER_GROUP);
            jPopupMenu.add((Component)separator, this.fCount++);
        }

        private static void removeMenuItems(JPopupMenu jPopupMenu, String string, String string2) {
            for (int i = jPopupMenu.getComponentCount() - 1; i >= 0; --i) {
                Component component = jPopupMenu.getComponent(i);
                if (!(component instanceof JComponent) || ((JComponent)component).getClientProperty(string) == null) continue;
                jPopupMenu.remove(component);
            }
            jPopupMenu.putClientProperty(string2, null);
        }

        private static void validatePopupMenuActions(JTextComponent jTextComponent) {
            MEditorUI mEditorUI;
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            if (baseTextUI != null && baseTextUI.getEditorUI() instanceof MEditorUI && (mEditorUI = (MEditorUI)baseTextUI.getEditorUI()).getFoldSideBar() != null) {
                mEditorUI.getFoldSideBar().validateCodeFoldPopupMenuActions(jTextComponent);
            }
        }
    }

    public static class MPasteAction
    extends MWKit.MWPasteAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                try {
                    Transferable transferable = MJClipboard.getMJClipboard().getContents((Object)this);
                    if (transferable.isDataFlavorSupported(MLDataFlavor.simpleVariableListFlavor)) {
                        jTextComponent.replaceSelection(MLDataFlavor.getSimpleVariableStringRepresentation(transferable));
                    } else if (transferable.isDataFlavorSupported(MLDataFlavor.cwPromptlessStringFlavor)) {
                        String string = (String)transferable.getTransferData(MLDataFlavor.cwPromptlessStringFlavor);
                        jTextComponent.replaceSelection(string);
                    } else {
                        super.actionPerformed(actionEvent, jTextComponent);
                    }
                }
                catch (Exception exception) {
                    Log.logException((Exception)exception);
                }
            }
        }
    }

    public static class MFormatAction
    extends MWKit.MWFormatAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null && jTextComponent.getDocument() instanceof BaseDocument) {
                int n = jTextComponent.getSelectionStart();
                int n2 = jTextComponent.getSelectionEnd();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                baseDocument.atomicLock();
                try {
                    if (n == 0 && n2 == baseDocument.getLength()) {
                        if (baseDocument instanceof PrintableDocument) {
                            ((PrintableDocument)baseDocument).startEditGrouping();
                        }
                        try {
                            int n3 = Utilities.getRowCount((BaseDocument)baseDocument);
                            for (int i = 0; i != n3; ++i) {
                                String string;
                                int n4 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)i);
                                int n5 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n4, (int)Utilities.getRowEnd((BaseDocument)baseDocument, (int)n4));
                                if (n5 == -1 || n5 <= n4 || (string = Utilities.getWord((BaseDocument)baseDocument, (int)n5)) == null || !string.equals("function")) continue;
                                baseDocument.remove(n4, n5 - n4);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            Log.logException((Exception)badLocationException);
                        }
                        finally {
                            try {
                                if (baseDocument instanceof PrintableDocument) {
                                    ((PrintableDocument)baseDocument).endEditGrouping();
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                Log.logException((Exception)badLocationException);
                            }
                            jTextComponent.selectAll();
                        }
                    }
                    super.actionPerformed(actionEvent, jTextComponent);
                }
                finally {
                    baseDocument.atomicUnlock();
                }
            }
        }
    }
}

