/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.matlab.api.editor.EditorSyntaxHighlighting;
import com.mathworks.matlab.api.editor.SyntaxHighlightingColor;
import com.mathworks.services.ColorPrefs;
import com.mathworks.widgets.text.CommonResources;
import com.mathworks.widgets.text.DefaultSyntaxColor;
import com.mathworks.widgets.text.mcode.MKit;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.mcode.MTokenContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.text.EditorKit;
import org.netbeans.editor.TokenContext;

public class MSyntaxHighlighting
implements EditorSyntaxHighlighting {
    public static final EditorSyntaxHighlighting INSTANCE = new MSyntaxHighlighting();
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.widgets.text.resources.RES_text");
    public static final SyntaxHighlightingColor KEYWORD = MSyntaxHighlighting.createColor(CommonResources.KEYWORDS_LABEL, ColorPrefs.MatlabColor.KEYWORD, 333);
    public static final SyntaxHighlightingColor COMMENT = MSyntaxHighlighting.createColor(CommonResources.COMMENTS_LABEL, ColorPrefs.MatlabColor.COMMENT, 105, 107, 109, 106, 108, 110);
    public static final SyntaxHighlightingColor STRING = MSyntaxHighlighting.createColor(CommonResources.STRINGS_LABEL, ColorPrefs.MatlabColor.STRING, 44, 45);
    public static final SyntaxHighlightingColor UNTERMINATED_STRING = MSyntaxHighlighting.createColor(BUNDLE.getString("gpcp.unterminated"), ColorPrefs.MatlabColor.UNTERMINATED_STRING, 337);
    public static final SyntaxHighlightingColor SYSTEM = MSyntaxHighlighting.createColor(BUNDLE.getString("gpcp.system"), ColorPrefs.MatlabColor.SYSTEM_COMMAND, 338);
    public static final SyntaxHighlightingColor ERROR = MSyntaxHighlighting.createColor(BUNDLE.getString("gpcp.errors"), ColorPrefs.MatlabColor.ERROR, 122);
    private static final List<SyntaxHighlightingColor> COLORS = Arrays.asList(KEYWORD, COMMENT, STRING, UNTERMINATED_STRING, SYSTEM, ERROR);

    private static SyntaxHighlightingColor createColor(String string, ColorPrefs.MatlabColor matlabColor, Integer ... integerArray) {
        return new DefaultSyntaxColor(string, matlabColor.getDefaultColor(), matlabColor.getKey(), MLanguage.INSTANCE.getInternalName(), matlabColor.getKey(), integerArray);
    }

    public EditorLanguage getLanguage() {
        return MLanguage.INSTANCE;
    }

    public List<SyntaxHighlightingColor> getColors() {
        return Collections.unmodifiableList(COLORS);
    }

    public TokenContext getTokenContext() {
        return MTokenContext.context;
    }

    public Class<? extends EditorKit> getBaseKitClass() {
        return MKit.class;
    }
}

