/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.analyzer;

import com.mathworks.common.icons.DialogIcon;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJRadioButtonMenuItem;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.PrefUtils;
import com.mathworks.util.ArrayUtils;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import com.mathworks.widgets.text.MWEditorUI;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.mcode.CodeAnalyzerUtilities;
import com.mathworks.widgets.text.mcode.MLint;
import com.mathworks.widgets.text.mcode.MLintConfiguration;
import com.mathworks.widgets.text.mcode.MLintPrefsUtils;
import com.mathworks.widgets.text.mcode.MTokenContext;
import com.mathworks.widgets.text.mcode.MTokenUtils;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerLayer;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerMessageModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.BreakIterator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;

public final class CodeAnalyzerUtils {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.widgets.text.mcode.resources.RES_mcode");
    public static final String MLINT_OK = "%#ok";
    public static final String MSG_PROBLEM_READING = "mlint.msg.problemReading";
    public static final String MSG_FILE_DOESNT_EXIST = "mlint.msg.fileNoLongerExists";
    public static final String MSG_PROBLEM_SAVING = "mlint.msg.problemSaving";
    public static final String MSG_FILE_READ_ONLY = "mlint.msg.fileReadOnly";
    private static final int MAX_MESSAGE_LENGTH = 35;

    public static Color getColorForSeverity(int n) {
        return n > 1 ? CodeAnalyzerUtils.getErrorColor() : CodeAnalyzerUtils.getWarningColor();
    }

    public static Color getAutofixBackgroundColor(Class<? extends EditorKit> clazz) {
        return (Color)SettingsUtil.getValue(clazz, (String)"ColorsMLintAutoFixBackground", (Object)ColorPrefs.getColorPref((String)"ColorsMLintAutoFixBackground"));
    }

    public static boolean isError(MLint.Message message) {
        return CodeAnalyzerUtils.isError(message.getSeverity());
    }

    private static boolean isError(int n) {
        return n > 1;
    }

    public static Icon getSeverityIcon(MLint.Message message, int n) {
        return CodeAnalyzerUtils.getSeverityIcon(message.getSeverity(), n);
    }

    public static Icon getSeverityIcon(int n, int n2) {
        if (n2 < 12) {
            return CodeAnalyzerUtils.isWarning(n) ? DialogIcon.WARNING_10x10.getIcon() : DialogIcon.ERROR_10x10.getIcon();
        }
        if (n2 < 16) {
            return CodeAnalyzerUtils.isWarning(n) ? DialogIcon.WARNING_12x12.getIcon() : DialogIcon.ERROR_12x12.getIcon();
        }
        if (n2 < 32) {
            return CodeAnalyzerUtils.isWarning(n) ? DialogIcon.WARNING.getIcon() : DialogIcon.ERROR.getIcon();
        }
        if (n2 < 48) {
            return CodeAnalyzerUtils.isWarning(n) ? DialogIcon.WARNING_32x32.getIcon() : DialogIcon.ERROR_32x32.getIcon();
        }
        return CodeAnalyzerUtils.isWarning(n) ? DialogIcon.WARNING_48x48.getIcon() : DialogIcon.ERROR_48x48.getIcon();
    }

    public static List<JMenuItem> createConfigurationMenuItems() {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        ButtonGroup buttonGroup = new ButtonGroup();
        File file = MLintPrefsUtils.getActiveConfiguration().getFile();
        String string = MLintPrefsUtils.DEFAULT_SETTINGS;
        if (!MLintPrefsUtils.DEFAULT_SETTINGS_FILE.canWrite()) {
            string = MessageFormat.format(BUNDLE.getString("mlint.readOnly"), string);
        }
        MJRadioButtonMenuItem mJRadioButtonMenuItem = new MJRadioButtonMenuItem((Action)new MJAbstractAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                MLintPrefsUtils.useDefaultConfiguration();
            }
        });
        if (MLintPrefsUtils.DEFAULT_SETTINGS_FILE.equals(file)) {
            mJRadioButtonMenuItem.setSelected(true);
        }
        arrayList.add((JMenuItem)mJRadioButtonMenuItem);
        buttonGroup.add((AbstractButton)mJRadioButtonMenuItem);
        List list = PrefUtils.readFileList((String)MLintPrefsUtils.getConfigurationFileListPrefKey(), (boolean)true);
        for (final File file2 : list) {
            if (file2.equals(MLintPrefsUtils.DEFAULT_SETTINGS_FILE)) continue;
            final MJRadioButtonMenuItem mJRadioButtonMenuItem2 = new MJRadioButtonMenuItem();
            String string2 = FileUtils.truncatePathname((String)file2.getAbsolutePath());
            if (!file2.canWrite()) {
                string2 = MessageFormat.format(BUNDLE.getString("mlint.readOnly"), string2);
            }
            mJRadioButtonMenuItem2.setAction((Action)new MJAbstractAction(string2){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        MLintPrefsUtils.useConfiguration(file2);
                    }
                    catch (Exception exception) {
                        CodeAnalyzerUtils.showErrorDialog((Component)mJRadioButtonMenuItem2, "mlint.configProblem", file2, exception);
                    }
                }
            });
            if (file2.equals(file)) {
                mJRadioButtonMenuItem2.setSelected(true);
            }
            arrayList.add((JMenuItem)mJRadioButtonMenuItem2);
            buttonGroup.add((AbstractButton)mJRadioButtonMenuItem2);
        }
        return arrayList;
    }

    public static void showErrorDialog(Component component, String string, File file, Exception exception) {
        MJOptionPane.showMessageDialog((Component)component, (Object)MessageFormat.format(BUNDLE.getString(string), FileUtils.truncatePathname((String)file.getAbsolutePath()), exception == null ? null : exception.getMessage()), (String)BUNDLE.getString("mlint.dialogTitle"), (int)0);
    }

    public static void disableMessage(String string) throws IOException {
        MLintConfiguration mLintConfiguration = MLintPrefsUtils.getActiveConfiguration();
        MLint.MessageDefinition messageDefinition = MLint.getMessageDefinition(string);
        assert (messageDefinition != null) : "No MessageDefinition for " + string;
        mLintConfiguration.disableMessage(string, CodeAnalyzerUtils.defaultSelectionValue(messageDefinition));
        mLintConfiguration.save();
        MLintPrefsUtils.setConfiguration(mLintConfiguration);
    }

    public static void suppressMessage(String string, JTextComponent jTextComponent, int n) {
        CodeAnalyzerUtils.doInsertSuppression(string, jTextComponent, n);
    }

    public static void suppressAllMessages(String string, JTextComponent jTextComponent, int n) {
        if (string == null) {
            throw new IllegalArgumentException("'messageTag' cannot be null");
        }
        CodeAnalyzerUtils.doInsertSuppression('*' + string, jTextComponent, n);
    }

    public static boolean defaultSelectionValue(MLint.MessageDefinition messageDefinition) {
        boolean bl = messageDefinition.isEnabledByDefault();
        if (messageDefinition.getCategoryTag().equals("MCC")) {
            bl = true;
        }
        return bl;
    }

    private static void doInsertSuppression(String string, JTextComponent jTextComponent, int n) {
        Validate.notNull((Object)jTextComponent, (String)"'text' cannot be null");
        Validate.notNull((Object)string, (String)"'messageTag' cannot be null");
        Validate.isTrue((boolean)(jTextComponent.getDocument() instanceof BaseDocument), (String)"must be using a BaseDocument");
        try {
            BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
            int n2 = MTokenUtils.getMLineEnd(baseDocument, n);
            boolean bl = CodeAnalyzerUtils.insertAfterExistingOK(string, jTextComponent, baseDocument, n, n2);
            if (!bl) {
                bl = CodeAnalyzerUtils.insertAfterComment(string, baseDocument, n, n2);
            }
            if (!bl) {
                baseDocument.insertString(n2, " %#ok<" + string + '>', null);
            }
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
    }

    private static boolean insertAfterComment(String string, BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        return CodeAnalyzerUtils.insertMessage(CodeAnalyzerUtils.getCommentLocation(baseDocument, n, n2, false), 0, "%#ok<" + string + "> ", baseDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean insertAfterExistingOK(String string, JTextComponent jTextComponent, BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        boolean bl = false;
        int[] nArray = CodeAnalyzerUtils.getCommentLocation(baseDocument, n, n2, true);
        if (nArray.length > 0) {
            FindSupport findSupport = FindSupport.getFindSupport();
            Map map = findSupport.getDefaultFindProperties();
            try {
                findSupport.putFindProperty("find-what", (Object)"%#ok<");
                findSupport.putFindProperty("find-match-case", (Object)true);
                int[] nArray2 = findSupport.findInBlock(jTextComponent, nArray[0], nArray[0], nArray[1], null, false);
                if (nArray2 != null) {
                    string = string + ",";
                } else {
                    findSupport.putFindProperty("find-what", (Object)MLINT_OK);
                    nArray2 = findSupport.findInBlock(jTextComponent, nArray[0], nArray[0], nArray[1], null, false);
                    string = '<' + string + '>';
                }
                if (nArray2 != null) {
                    bl = CodeAnalyzerUtils.insertMessage(nArray2, 1, string, baseDocument);
                }
            }
            finally {
                findSupport.putFindProperties(map);
            }
        }
        return bl;
    }

    private static int[] getCommentLocation(BaseDocument baseDocument, int n, int n2, boolean bl) throws BadLocationException {
        int[] nArray = baseDocument.getSyntaxSupport().getTokenBlocks(n, n2, new TokenID[]{bl ? MTokenContext.PRAGMA : MTokenContext.LINE_COMMENT});
        assert (nArray != null) : "result from getTokenBlocks should not be null";
        if (nArray.length == 0 && !bl) {
            nArray = baseDocument.getSyntaxSupport().getTokenBlocks(n, n2, new TokenID[]{MTokenContext.PRAGMA});
        }
        if (nArray.length > 1) {
            nArray = new int[]{nArray[nArray.length - 2], nArray[nArray.length - 1]};
        }
        if (nArray.length > 1 && nArray[1] != n2) {
            nArray = ArrayUtils.EmptyPrimitives.INT;
        }
        return nArray;
    }

    private static boolean insertMessage(int[] nArray, int n, String string, BaseDocument baseDocument) throws BadLocationException {
        if (nArray.length > n) {
            baseDocument.insertString(nArray[n], string, null);
        }
        return nArray.length > n;
    }

    public static void setCategoryEnabled(String string, boolean bl) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("'category' cannot be null");
        }
        if (!string.equals("MCC")) {
            throw new IllegalArgumentException("'category' must be MLintPrefsUtils.DEPLOYMENT_CATEGORY");
        }
        MLintConfiguration mLintConfiguration = MLintPrefsUtils.getActiveConfiguration();
        boolean bl2 = false;
        mLintConfiguration.setCategoryEnabled(string, bl, bl2);
        mLintConfiguration.save();
        MLintPrefsUtils.setConfiguration(mLintConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyAutoFixes(STPBaseInterface sTPBaseInterface, List<MLint.AutoFixChange> list) {
        if (sTPBaseInterface == null) {
            throw new IllegalArgumentException("'text' cannot be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("'changes' cannot be null");
        }
        try {
            int n = sTPBaseInterface.getCaretPosition();
            ((BaseDocument)sTPBaseInterface.getDocument()).resetUndoMerge();
            sTPBaseInterface.startBlockEdit();
            for (MLint.AutoFixChange autoFixChange : list) {
                int n2;
                int n3 = CodeAnalyzerUtilities.getStartPosition(sTPBaseInterface.getDocument(), autoFixChange.getStartLine(), autoFixChange.getStartColumn());
                if (n3 >= (n2 = CodeAnalyzerUtilities.getEndPosition(sTPBaseInterface.getDocument(), autoFixChange.getEndLine(), autoFixChange.getEndColumn()))) {
                    sTPBaseInterface.insert(n3 + 1, autoFixChange.getText());
                    continue;
                }
                sTPBaseInterface.replace(n3, n2, autoFixChange.getText());
            }
            sTPBaseInterface.setCaretPosition(Math.min(n, sTPBaseInterface.getLength()));
            CodeAnalyzerUtils.getCodeAnalyzerLayer(sTPBaseInterface.getEditorUI()).refresh();
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        finally {
            sTPBaseInterface.endBlockEdit();
        }
    }

    public static String truncateMessage(MLint.Message message) {
        String string = message.getMessage();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n = breakIterator.preceding(Math.min(35, string.length() - 1));
        if (n != -1) {
            string = string.substring(0, n) + "...";
        }
        return string;
    }

    public static MLint.Message getFirstOrFirstAutoFixableMessage(JTextComponent jTextComponent) {
        MLint.Message message = null;
        if (CodeAnalyzerUtils.selectionWithinWarning(jTextComponent)) {
            List<CodeAnalyzerMessageModel.CodeAnalyzerMessage> list = CodeAnalyzerUtils.getMLintMessagesAtCaret(jTextComponent);
            message = CodeAnalyzerUtils.getFirstOrFirstAutoFixableMessage(list);
        }
        return message;
    }

    public static MLint.Message getFirstOrFirstAutoFixableMessage(List<CodeAnalyzerMessageModel.CodeAnalyzerMessage> list) {
        MLint.Message message = null;
        if (!list.isEmpty()) {
            message = list.get(0).getMLintMessage();
            for (CodeAnalyzerMessageModel.CodeAnalyzerMessage codeAnalyzerMessage : list) {
                MLint.Message message2 = codeAnalyzerMessage.getMLintMessage();
                if (!message2.hasAutoFix()) continue;
                message = message2;
                break;
            }
        }
        return message;
    }

    private static boolean selectionWithinWarning(JTextComponent jTextComponent) {
        return CodeAnalyzerUtils.getCodeAnalyzerLayer(((BaseTextUI)jTextComponent.getUI()).getEditorUI()).messageUnderSelection();
    }

    private CodeAnalyzerUtils() {
    }

    static Color getWarningColor(Class<? extends EditorKit> clazz) {
        return (Color)SettingsUtil.getValue(clazz, (String)ColorPrefs.MatlabColor.WARNING.getKey(), (Object)CodeAnalyzerUtils.getWarningColor());
    }

    public static Color getWarningColor() {
        return ColorPrefs.MatlabColor.WARNING.getPreferredColor();
    }

    static Color getErrorColor() {
        return ColorPrefs.MatlabColor.ERROR.getPreferredColor();
    }

    static Color getErrorColor(Class<? extends EditorKit> clazz) {
        return (Color)SettingsUtil.getValue(clazz, (String)ColorPrefs.MatlabColor.ERROR.getKey(), (Object)CodeAnalyzerUtils.getErrorColor());
    }

    public static boolean isWarning(Integer n) {
        return n <= 1;
    }

    static boolean isAutofixEnabled(Class<? extends EditorKit> clazz) {
        return (Boolean)SettingsUtil.getValue(clazz, (String)"ColorsUseMLintAutoFixBackground", (Object)ColorPrefs.isMLintAutoFixBackgroundEnabled());
    }

    public static List<CodeAnalyzerMessageModel.CodeAnalyzerMessage> getMLintMessagesAtCaret(JTextComponent jTextComponent) {
        int n = jTextComponent.getCaretPosition();
        return CodeAnalyzerUtils.getMLintMessagesAtPosition(jTextComponent, n - 1, n);
    }

    public static List<CodeAnalyzerMessageModel.CodeAnalyzerMessage> getMLintMessagesAtPosition(JTextComponent jTextComponent, int n, int n2) {
        BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
        return CodeAnalyzerUtils.getCodeAnalyzerLayer(baseTextUI.getEditorUI()).getMessagesAtPosition(n, n2);
    }

    public static boolean isSupressableOrDisableable(MLint.Message message) {
        return MLint.getMessageDefinition(message.getTag()) != null;
    }

    public static CodeAnalyzerLayer getCodeAnalyzerLayer(EditorUI editorUI) {
        return (CodeAnalyzerLayer)((MWEditorUI)editorUI).getLayer("Code Analyzer Layer");
    }

    public static ResourceBundle getBundle() {
        return BUNDLE;
    }
}

