/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.variables;

import com.mathworks.mwswing.TextComponentUtils;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.MTreeUtils;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightPrefs;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;

class Variable {
    private static final int MAX_VARIABLE_LENGTH = 64;
    private final MTree.Node fNode;
    private final String fText;
    private final Position fStartPosition;
    private final boolean fIsVariable;
    private final boolean fRenaming;
    private final boolean fHasSelectionBeyondVariable;
    private final int fLineNumber;
    private final List<Position> fOtherInstances;
    private final String fOldVariableName;
    private final Map<Position, String> fOtherVariables;

    Variable(STPBaseInterface sTPBaseInterface, Variable variable, boolean bl) {
        boolean bl2;
        TextComponentUtils.FullIdentifier fullIdentifier = Variable.getIdentifierAtCaret(sTPBaseInterface);
        this.fText = fullIdentifier.getIdentifier();
        Position position = null;
        int n = fullIdentifier.getStartPosition();
        try {
            position = sTPBaseInterface.getDocument().createPosition(n);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.fStartPosition = position;
        this.fRenaming = Variable.isRenaming(variable, n, this.fText);
        this.fOldVariableName = this.fRenaming ? variable.getText() : this.fText;
        this.fNode = VariableHighlightUtils.getVariableUnderCaret((JTextComponent)((Object)sTPBaseInterface));
        this.fIsVariable = this.fRenaming || Variable.isValidIDNode(sTPBaseInterface, this.fNode, this.fText, n);
        this.fHasSelectionBeyondVariable = !Variable.hasSelectionWithinVariable(sTPBaseInterface, this.fText, n);
        this.fLineNumber = Variable.getCurrentLine(sTPBaseInterface, n);
        this.fOtherVariables = this.fNode != null ? Collections.unmodifiableMap(VariableHighlightUtils.getIDNodeNamesAndPositionsNotID((JTextComponent)((Object)sTPBaseInterface), this.fNode)) : null;
        boolean bl3 = bl2 = variable != null && bl && !Variable.isSameVariable(variable.getStartPosition(), n, this.fText);
        this.fOtherInstances = this.fRenaming ? variable.getOtherInstances() : (this.fIsVariable && this.fNode != null && this.fNode.getText().equals(this.fText) && !bl2 ? Variable.createOtherNodesList(sTPBaseInterface, n, VariableHighlightUtils.getNodesAndPositionsForMatchingID((JTextComponent)((Object)sTPBaseInterface), this.fNode)) : Collections.emptyList());
    }

    public boolean hasSelectionBeyondVariable() {
        return this.fHasSelectionBeyondVariable;
    }

    private static int getCurrentLine(STPBaseInterface sTPBaseInterface, int n) {
        if (n == -1) {
            return -1;
        }
        try {
            return sTPBaseInterface.getLineFromPos(n);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private static TextComponentUtils.FullIdentifier getIdentifierAtCaret(STPBaseInterface sTPBaseInterface) {
        int n = sTPBaseInterface.getCaretPosition();
        int n2 = sTPBaseInterface.getDocument().getLength();
        if (n2 <= 0 || n > n2 || n < 0) {
            return new TextComponentUtils.FullIdentifier(null, -1);
        }
        try {
            return TextComponentUtils.getFullIdentifierAt((Document)sTPBaseInterface.getDocument(), (int)n, (boolean)false);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            assert (false) : stringIndexOutOfBoundsException;
            return new TextComponentUtils.FullIdentifier(null, -1);
        }
    }

    private static boolean isRenaming(Variable variable, int n, String string) {
        if (variable == null) {
            return false;
        }
        if (string == null || n == -1) {
            return false;
        }
        boolean bl = !variable.getOtherInstances().isEmpty();
        boolean bl2 = !string.equals(variable.getText());
        boolean bl3 = Variable.isSameVariable(variable.getStartPosition(), n, string);
        boolean bl4 = Variable.isOverLappingOtherVariable(variable, n);
        boolean bl5 = string.length() < 64;
        boolean bl6 = VariableHighlightUtils.isAKeyword(variable.getText());
        return VariableHighlightPrefs.isVariableQuickRename() && bl && bl3 && bl2 && bl5 && Variable.isAssignment(variable.getNode()) && !bl4 && !bl6 && !variable.getNode().isGlobal();
    }

    private static boolean isOverLappingOtherVariable(Variable variable, int n) {
        if (variable == null || variable.getOtherVariables() == null) {
            return false;
        }
        for (Position position : variable.getOtherVariables().keySet()) {
            String string = variable.getOtherVariables().get(position);
            if (!Variable.isSameVariable(n, position.getOffset(), string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSameVariable(int n, int n2, String string) {
        return string != null && n >= n2 && n <= n2 + string.length();
    }

    private static boolean isValidIDNode(STPBaseInterface sTPBaseInterface, MTree.Node node, String string, int n) {
        if (node != null) assert (node.getType() == MTree.NodeType.ID);
        boolean bl = Variable.hasSelectionWithinVariable(sTPBaseInterface, string, n);
        return node != null && node.getText().equals(string) && string != null && bl && string.length() < 64;
    }

    private static boolean hasSelectionWithinVariable(STPBaseInterface sTPBaseInterface, String string, int n) {
        int n2;
        int n3 = sTPBaseInterface.getSelectionStart();
        boolean bl = n3 != (n2 = sTPBaseInterface.getSelectionEnd());
        boolean bl2 = bl && string != null && !string.isEmpty() && n3 >= n && n2 <= n + string.length();
        return !bl || bl2;
    }

    private static boolean isAssignment(MTree.Node node) {
        assert (node.getType() == MTree.NodeType.ID);
        return Variable.isEqualsAssignment(node) || Variable.isEqualsSubscriptAssignment(node) || Variable.isFunctionOrInputOutputVariable(node) || Variable.isForAssignment(node) || Variable.isCatchAssignment(node);
    }

    private static boolean isCatchAssignment(MTree.Node node) {
        assert (node.getType() == MTree.NodeType.ID);
        MTree.Node node2 = node.getParent();
        assert (node2 != null);
        return node2.getType() == MTree.NodeType.CATCH;
    }

    private static boolean isFunctionOrInputOutputVariable(MTree.Node node) {
        MTree.Node node2;
        assert (node.getType() == MTree.NodeType.ID);
        while (true) {
            node2 = node.getParent();
            assert (node2 != null);
            if (node2.getType() != MTree.NodeType.ETC && node2.getType() != MTree.NodeType.ID && node2.getType() != MTree.NodeType.NOT) break;
            node = node2;
        }
        return node2.getType() == MTree.NodeType.FUNCTION;
    }

    private static boolean isForAssignment(MTree.Node node) {
        assert (node.getType() == MTree.NodeType.ID);
        while (true) {
            assert (node.getType() == MTree.NodeType.ETC || node.getType() == MTree.NodeType.ID);
            MTree.Node node2 = node.getParent();
            assert (node2 != null);
            if (node2.getType() == MTree.NodeType.FOR) {
                return true;
            }
            if (node2.getType() != MTree.NodeType.ETC) break;
            node = node2;
        }
        return false;
    }

    private static boolean isEqualsSubscriptAssignment(MTree.Node node) {
        assert (node.getType() == MTree.NodeType.ID);
        MTree.Node node2 = node.getParent();
        assert (node2 != null);
        boolean bl = node2.getType() == MTree.NodeType.SUBSCR;
        boolean bl2 = node.getIndex() == node2.getIndex() + 1;
        return bl && bl2 && Variable.isEqualsAssignment(node2);
    }

    private static boolean isEqualsAssignment(MTree.Node node) {
        assert (node.getType() == MTree.NodeType.ID || node.getType() == MTree.NodeType.SUBSCR);
        while (true) {
            assert (node.getType() == MTree.NodeType.ID || node.getType() == MTree.NodeType.LEFT_BRACKET || node.getType() == MTree.NodeType.SUBSCR || node.getType() == MTree.NodeType.CELL || node.getType() == MTree.NodeType.DOT || node.getType() == MTree.NodeType.NOT);
            MTree.Node node2 = node.getParent();
            assert (node2 != null);
            if (node2.getType() == MTree.NodeType.EQUALS) {
                return node == node2.getLeft();
            }
            if (node2.getType() != MTree.NodeType.ID && node2.getType() != MTree.NodeType.LEFT_BRACKET && node2.getType() != MTree.NodeType.CELL && node2.getType() != MTree.NodeType.DOT && node2.getType() != MTree.NodeType.NOT) break;
            node = node2;
        }
        return false;
    }

    private static List<Position> createOtherNodesList(STPBaseInterface sTPBaseInterface, int n, Map<Integer, MTree.Node> map) {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        for (int n2 : map.keySet()) {
            MTree.Node node = map.get(n2);
            int n3 = MTreeUtils.getPosition(node, (BaseDocument)sTPBaseInterface.getDocument());
            if (n == n3) continue;
            try {
                Position position = sTPBaseInterface.getDocument().createPosition(n3);
                arrayList.add(position);
            }
            catch (BadLocationException badLocationException) {}
        }
        return arrayList;
    }

    List<Position> getOtherInstances() {
        return new ArrayList<Position>(this.fOtherInstances);
    }

    void updatePositions(STPBaseInterface sTPBaseInterface) {
        Iterator<Position> iterator = this.fOtherInstances.iterator();
        while (iterator.hasNext()) {
            Position position = iterator.next();
            if (VariableHighlightUtils.variableExists(sTPBaseInterface, position.getOffset(), this.fText)) continue;
            iterator.remove();
        }
    }

    boolean isVariable() {
        return this.fIsVariable;
    }

    boolean isRenaming() {
        return this.fRenaming;
    }

    MTree.Node getNode() {
        return this.fNode;
    }

    int getLineNumber() {
        return this.fLineNumber;
    }

    String getText() {
        assert (this.fIsVariable || this.fRenaming) : "getText must only be called if this is a variable or renaming";
        return this.fText;
    }

    String getOldName() {
        return this.fOldVariableName;
    }

    int getStartPosition() {
        assert (this.fIsVariable || this.fRenaming) : "getStartPosition must only be called if this is a variable or renaming";
        return this.fStartPosition != null ? this.fStartPosition.getOffset() : -1;
    }

    Map<Position, String> getOtherVariables() {
        assert (this.fNode == null || this.fOtherVariables != null) : "If fNode is valid fOtherVariables should be valid.";
        return Collections.unmodifiableMap(this.fOtherVariables);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Variable)) {
            return false;
        }
        Variable variable = (Variable)object;
        return variable.getStartPosition() == this.getStartPosition() && variable.getText().equals(this.getText());
    }
}

