/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.annot;

import com.mathworks.util.Converter;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class AnnotationUtils {
    private static final Map<Class<?>, Class<?>> WRAPPER_PRIM_MAPPINGS = AnnotationUtils.createPrimitiveWrapperMap();
    private static final Map<Class<?>, Class<?>> PRIM_WRAPPER_MAPPINGS = AnnotationUtils.reverseWrapperMap(WRAPPER_PRIM_MAPPINGS);

    private AnnotationUtils() {
    }

    private static Map<Class<?>, Class<?>> createPrimitiveWrapperMap() {
        HashMap<Class<Character>, Class<Serializable>> hashMap = new HashMap<Class<Character>, Class<Serializable>>();
        hashMap.put(Byte.class, Byte.TYPE);
        hashMap.put(Short.class, Short.TYPE);
        hashMap.put(Integer.class, Integer.TYPE);
        hashMap.put(Double.class, Double.TYPE);
        hashMap.put(Long.class, Long.TYPE);
        hashMap.put(Float.class, Float.TYPE);
        hashMap.put(Double.class, Double.TYPE);
        hashMap.put(Boolean.class, Boolean.TYPE);
        hashMap.put(Character.class, Character.TYPE);
        return Collections.unmodifiableMap(hashMap);
    }

    private static Map<Class<?>, Class<?>> reverseWrapperMap(Map<Class<?>, Class<?>> map) {
        HashMap hashMap = new HashMap();
        for (Map.Entry<Class<?>, Class<?>> entry : map.entrySet()) {
            hashMap.put(entry.getValue(), entry.getKey());
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public static boolean areTypesEqual(Class<?> clazz, Class<?> clazz2) {
        if (clazz.equals(clazz2)) {
            return true;
        }
        if (!clazz.isPrimitive() && !clazz2.isPrimitive()) {
            return false;
        }
        if (!clazz.isPrimitive() && !WRAPPER_PRIM_MAPPINGS.containsKey(clazz)) {
            return false;
        }
        if (!clazz2.isPrimitive() && !WRAPPER_PRIM_MAPPINGS.containsKey(clazz2)) {
            return false;
        }
        String string = clazz.isPrimitive() ? clazz.getName() : WRAPPER_PRIM_MAPPINGS.get(clazz).getName();
        String string2 = clazz2.isPrimitive() ? clazz2.getName() : WRAPPER_PRIM_MAPPINGS.get(clazz2).getName();
        return string.equals(string2);
    }

    public static <T extends Annotation> Set<Method> getAllAnnotatedMethods(Class<?> clazz, Class<T> clazz2) {
        return AnnotationUtils.getAllAnnotatedElementsByType(clazz, clazz2, new Converter<Class<?>, Collection<Method>>(){

            public Collection<Method> convert(Class<?> clazz) {
                return Arrays.asList(clazz.getDeclaredMethods());
            }
        });
    }

    public static <T extends Annotation> Set<Field> getAllAnnotatedFields(Class<?> clazz, Class<T> clazz2) {
        return AnnotationUtils.getAllAnnotatedElementsByType(clazz, clazz2, new Converter<Class<?>, Collection<Field>>(){

            public Collection<Field> convert(Class<?> clazz) {
                return Arrays.asList(clazz.getDeclaredFields());
            }
        });
    }

    public static <T extends Annotation, E extends AnnotatedElement> Set<E> getAllAnnotatedElementsByType(Class<?> clazz, Class<T> clazz2, Converter<Class<?>, Collection<E>> converter) {
        HashSet<AnnotatedElement> hashSet = new HashSet<AnnotatedElement>();
        while (clazz != null) {
            for (AnnotatedElement annotatedElement : (Collection)converter.convert(clazz)) {
                if (annotatedElement.getAnnotation(clazz2) == null) continue;
                hashSet.add(annotatedElement);
            }
            clazz = clazz.getSuperclass();
        }
        return hashSet;
    }

    public static boolean isCompatible(Class[] classArray, Class ... classArray2) {
        boolean bl = false;
        if (classArray.length == classArray2.length) {
            bl = true;
            for (int i = 0; i < classArray.length; ++i) {
                Class clazz = classArray2[i];
                Class clazz2 = classArray[i];
                if (clazz.isAssignableFrom(clazz2) || AnnotationUtils.areTypesEqual(clazz2, clazz) || clazz2.isPrimitive() && clazz.isAssignableFrom(PRIM_WRAPPER_MAPPINGS.get(clazz2))) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }
}

