/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.annot;

import com.mathworks.toolbox.coder.annot.BindingProfile;
import com.mathworks.toolbox.coder.annot.BindingProfileFactory;
import com.mathworks.toolbox.coder.annot.DynamicProxyBindingProfileFactory;
import com.mathworks.toolbox.coder.annot.PropertyBinder;
import com.mathworks.toolbox.coder.annot.PropertyBinderFactory;
import com.mathworks.util.ParameterRunnable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public final class PropertyBindingSupport
extends PropertyChangeSupport {
    private static final BindingProfileFactory DEFAULT_BINDING_PROFILE_FACTORY = new DynamicProxyBindingProfileFactory();
    private final Map<Object, ObjectContext> fContextMap;
    private final BindingProfileFactory fProfileFactory;
    private final ParameterRunnable<Exception> fExceptionHandler;

    public PropertyBindingSupport(BindingProfileFactory bindingProfileFactory, Object object, ParameterRunnable<Exception> parameterRunnable) {
        super(object);
        this.fProfileFactory = bindingProfileFactory;
        this.fContextMap = new HashMap<Object, ObjectContext>();
        this.fExceptionHandler = parameterRunnable != null ? parameterRunnable : this.createDefaultExceptionHandler();
    }

    public PropertyBindingSupport(BindingProfileFactory bindingProfileFactory, Object object) {
        this(bindingProfileFactory, object, null);
    }

    public PropertyBindingSupport(Object object) {
        this(DEFAULT_BINDING_PROFILE_FACTORY, object);
    }

    public PropertyBindingSupport(Object object, ParameterRunnable<Exception> parameterRunnable) {
        this(DEFAULT_BINDING_PROFILE_FACTORY, object, parameterRunnable);
    }

    public boolean bind(Object object) {
        try {
            ObjectContext objectContext = new ObjectContext(object);
            this.fContextMap.put(object, objectContext);
            return true;
        }
        catch (Exception exception) {
            this.fExceptionHandler.run((Object)exception);
            return false;
        }
    }

    public void unbind(Object object) {
        this.fContextMap.remove(object);
    }

    private ParameterRunnable<Exception> createDefaultExceptionHandler() {
        return new ParameterRunnable<Exception>(){

            public void run(Exception exception) {
                exception.printStackTrace();
            }
        };
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.firePropertyChange(propertyChangeEvent);
        for (ObjectContext objectContext : new LinkedList<ObjectContext>(this.fContextMap.values())) {
            PropertyBinder propertyBinder = objectContext.getPropertyBinder(propertyChangeEvent.getPropertyName());
            if (propertyBinder != null) {
                try {
                    propertyBinder.fireBoundPropertyChanged(propertyChangeEvent);
                }
                catch (Exception exception) {
                    this.fExceptionHandler.run((Object)exception);
                }
                continue;
            }
            if (objectContext.getFallbackHandler() == null) continue;
            objectContext.getFallbackHandler().propertyChange(propertyChangeEvent);
        }
    }

    private class ObjectContext {
        private final Map<String, PropertyBinder> fBinderMap;
        private final BindingProfile fBindingProfile;
        private final PropertyChangeListener fFallbackHandler;
        private final Object fTarget;

        ObjectContext(Object object) throws Exception {
            this.fTarget = object;
            this.fBinderMap = new HashMap<String, PropertyBinder>();
            this.fBindingProfile = PropertyBindingSupport.this.fProfileFactory.createBindingProfile(object);
            this.fFallbackHandler = object instanceof PropertyChangeListener ? (PropertyChangeListener)object : null;
        }

        PropertyBinder getPropertyBinder(String string) {
            PropertyBinderFactory propertyBinderFactory;
            PropertyBinder propertyBinder = this.fBinderMap.get(string);
            if (propertyBinder == null && (propertyBinderFactory = this.fBindingProfile.getPropertyBinderFactory(string)) != null) {
                propertyBinder = propertyBinderFactory.createPropertyBinder(this.fTarget);
                this.fBinderMap.put(string, propertyBinder);
            }
            return propertyBinder;
        }

        PropertyChangeListener getFallbackHandler() {
            return this.fFallbackHandler;
        }
    }
}

