/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.toolbox.coder.app.CoderAppModel;
import com.mathworks.toolbox.coder.app.StaleTextMapper;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.CallTree;
import com.mathworks.toolbox.coder.model.CodableEntity;
import com.mathworks.toolbox.coder.model.Expression;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionUtils;
import com.mathworks.toolbox.coder.model.Interval;
import com.mathworks.toolbox.coder.model.UnifiedModel;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.screener.MTreeUtils;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.mcode.MTree;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.editor.BaseDocument;

public final class FunctionScopedEntityLocator {
    private static final Collection<Interval> EMPTY_COLLECTION = Collections.unmodifiableCollection(new LinkedList());
    private static final Comparator<Function> SPECIALIZATION_INDEX_SORTER = new Comparator<Function>(){

        @Override
        public int compare(Function function, Function function2) {
            return Integer.valueOf(function.getSpecializationId()).compareTo(function2.getSpecializationId());
        }
    };
    private final EntityManager<BuildError> fErrorManager;
    private final EntityManager<Variable> fVariableManager;
    private final EntityManager<Function> fFunctionManager;
    private final EntityManager<Function> fSignatureManager;
    private final EntityManager<CallTree.CallSite> fCallSiteManager;
    private final List<EntityManager<? extends CodableEntity>> fEntityManagers;
    private final CoderAppModel fAppModel;
    private final BaseDocument fOriginalCode;
    private final Map<String, MTree.Node> fFunctionNodes;
    private final Map<File, MTree> fParseTreeCache;
    private ReturnRunnable<Collection<BuildError>> fErrorSource;
    private UnifiedModel fModel;
    private EditorView fEditorView;
    private StaleTextMapper fTextMapper;
    private Function fCurrentFunction;
    private MTree fParseTree;

    public FunctionScopedEntityLocator(@Nullable ReturnRunnable<Collection<BuildError>> returnRunnable, @Nullable CoderAppModel coderAppModel, UnifiedModel unifiedModel) {
        this.fAppModel = coderAppModel;
        this.fOriginalCode = new BaseDocument(MLanguage.INSTANCE.createDefaultKit().getClass(), false);
        this.fFunctionNodes = new HashMap<String, MTree.Node>();
        this.fParseTreeCache = new HashMap<File, MTree>();
        this.fErrorSource = returnRunnable;
        this.fModel = unifiedModel;
        this.fVariableManager = new EntityManager<Variable>(new VariableEntityMappingStrategy(), true);
        EntityManager<Expression> entityManager = new EntityManager<Expression>(new ExpressionEntityMappingStrategy(), true);
        this.fErrorManager = new EntityManager<BuildError>(new BuildErrorEntityMappingStrategy(), true);
        this.fFunctionManager = new EntityManager<Function>(new FunctionEntityMappingStrategy(), false);
        this.fSignatureManager = new EntityManager<Function>(new FunctionSignatureEntityMappingStrategy(), false);
        this.fCallSiteManager = new EntityManager<CallTree.CallSite>(new CallSiteEntityMappingStrategy(), true);
        this.fEntityManagers = Arrays.asList(this.fFunctionManager, this.fVariableManager, entityManager, this.fErrorManager, this.fCallSiteManager, this.fSignatureManager);
        this.takeCodeSnapshot(null, "");
    }

    public FunctionScopedEntityLocator(final CoderAppModel coderAppModel, UnifiedModel unifiedModel) {
        this(new ReturnRunnable<Collection<BuildError>>(){

            public Collection<BuildError> run() {
                return coderAppModel.getErrors();
            }
        }, coderAppModel, unifiedModel);
    }

    public FunctionScopedEntityLocator(@Nullable UnifiedModel unifiedModel) {
        this(null, null, unifiedModel);
    }

    private void runOnEntityManagers(ParameterRunnable<EntityManager<?>> parameterRunnable) {
        for (EntityManager<? extends CodableEntity> entityManager : this.fEntityManagers) {
            parameterRunnable.run(entityManager);
        }
    }

    public void setErrorSource(ReturnRunnable<Collection<BuildError>> returnRunnable) {
        ReturnRunnable<Collection<BuildError>> returnRunnable2 = returnRunnable;
        if (returnRunnable2 == null) {
            returnRunnable2 = new ReturnRunnable<Collection<BuildError>>(){

                public Collection<BuildError> run() {
                    return Collections.emptyList();
                }
            };
        }
        this.fErrorSource = returnRunnable2;
        this.reset(false);
    }

    public void setEditorView(EditorView editorView) {
        this.fEditorView = editorView;
        this.fTextMapper = editorView.getTextMapper();
        if (editorView.getCurrentFunction() != null) {
            this.refresh();
        }
    }

    private int mapToOriginal(int n) {
        if (this.fTextMapper != null) {
            return this.fTextMapper.mapToOriginal(n);
        }
        return n;
    }

    public void takeCodeSnapshot(@Nullable Function function, String string) {
        try {
            this.fOriginalCode.remove(0, this.fOriginalCode.getLength());
            this.fOriginalCode.insertString(0, string, null);
            this.fCurrentFunction = function;
            MTree mTree = this.fParseTree = function != null ? this.fParseTreeCache.get(function.getFile()) : null;
            if (this.fParseTree == null) {
                boolean bl = true;
                this.fParseTree = MTree.parse((String)string, (boolean)bl);
                if (function != null) {
                    this.fParseTreeCache.put(function.getFile(), this.fParseTree);
                }
            }
            this.fFunctionNodes.clear();
            this.runOnEntityManagers(new ParameterRunnable<EntityManager<?>>(){

                public void run(EntityManager<?> entityManager) {
                    entityManager.setContextFunction(FunctionScopedEntityLocator.this.fCurrentFunction);
                }
            });
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void refresh() {
        if (this.fEditorView.getTextPane() != null) {
            // empty if block
        }
    }

    public void reset(final File file) {
        this.fParseTreeCache.remove(file);
        this.fFunctionNodes.clear();
        this.runOnEntityManagers(new ParameterRunnable<EntityManager<?>>(){

            public void run(EntityManager<?> entityManager) {
                entityManager.reset(file);
            }
        });
        if (this.fCurrentFunction != null) {
            this.takeCodeSnapshot(this.fCurrentFunction, this.fEditorView.getTextPane().getText());
        }
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean bl) {
        if (bl) {
            this.fFunctionNodes.clear();
            this.fParseTreeCache.clear();
            if (this.fCurrentFunction != null && this.fEditorView.getCurrentFunction() != null && this.fCurrentFunction.getFile().equals(this.fEditorView.getCurrentFunction().getFile())) {
                this.refresh();
            } else {
                try {
                    this.fOriginalCode.remove(0, this.fOriginalCode.getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                this.fCurrentFunction = null;
                if (this.fEditorView.getTextPane() != null && this.fEditorView.getCurrentFunction() != null) {
                    this.takeCodeSnapshot(this.fEditorView.getCurrentFunction(), this.fEditorView.getTextPane().getText());
                }
            }
        }
        this.runOnEntityManagers(new ParameterRunnable<EntityManager<?>>(){

            public void run(EntityManager<?> entityManager) {
                entityManager.reset();
            }
        });
    }

    public Collection<CodableEntity> getEntitiesAtPosition(int n) {
        LinkedList<CodableEntity> linkedList = new LinkedList<CodableEntity>();
        if (n >= this.fOriginalCode.getLength() || n < 0) {
            return linkedList;
        }
        for (EntityManager<? extends CodableEntity> entityManager : this.fEntityManagers) {
            CodableEntity codableEntity = entityManager.getEntityAt(n);
            if (codableEntity == null) continue;
            linkedList.add(codableEntity);
        }
        return linkedList;
    }

    public Variable getVariableAt(int n) {
        return this.fVariableManager.getEntityAt(n);
    }

    public Interval getFunctionInterval(Function function) {
        return this.fFunctionManager.getInterval(function);
    }

    public Interval getFunctionSignatureInterval(Function function) {
        return this.fSignatureManager.getInterval(function);
    }

    public Interval getBuildErrorInterval(BuildError buildError) {
        Interval interval = this.fErrorManager.getInterval(buildError);
        return interval != null ? interval : new Interval(buildError.getPosition(), buildError.getPosition() + buildError.getLength());
    }

    public Collection<Interval> getVariableIntervals(Variable variable) {
        return this.fVariableManager.getIntervals(variable);
    }

    public MTree.Node getFunctionNode(Function function, boolean bl) {
        if (this.fFunctionNodes.isEmpty() || bl) {
            this.fFunctionNodes.clear();
            MTree mTree = this.fParseTree;
            if (this.fEditorView.getLoadContext() != null && !this.fTextMapper.isValid(this.fEditorView.getLoadContext())) {
                mTree = MTree.parse((String)this.fEditorView.getTextPane().getText());
            }
            for (MTree.Node node : mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.FUNCTION})) {
                this.fFunctionNodes.put(node.getFunctionName().getText(), node);
            }
        }
        if (this.fFunctionNodes.containsKey(function.getSpecializationName())) {
            return this.fFunctionNodes.get(function.getSpecializationName());
        }
        return this.fFunctionNodes.get(function.getName());
    }

    public Interval getCallSiteInterval(CallTree.CallSite callSite) {
        return this.fCallSiteManager.getInterval(callSite);
    }

    private Interval getIntervalForNode(MTree.Node node) {
        int n = MTreeUtils.getMinimumPosition(node, this.fOriginalCode);
        int n2 = MTreeUtils.getMaximumPosition(node, this.fOriginalCode);
        return n >= 0 && n2 >= 0 ? new Interval(n, n2) : null;
    }

    private MTree.Node getNodeAtPosition(int n) {
        return MTreeUtils.getNodeAtPosition(this.fParseTree, n, this.fOriginalCode, false);
    }

    private boolean isMTreeRelevant() {
        return this.fCurrentFunction != null && this.fEditorView != null && this.fEditorView.getCurrentFunction() != null && this.fEditorView.getCurrentFunction().getFile().equals(this.fCurrentFunction.getFile());
    }

    private class EntityManager<T extends CodableEntity> {
        private final Map<File, Map<T, Collection<Interval>>> fCachedMaps;
        private final Map<Integer, T> fEntityCache;
        private final EntityMappingStrategy<T> fEntityMappingStrategy;
        private final boolean fRequiresMapping;
        private Map<T, Collection<Interval>> fCachedIntervals;

        EntityManager(EntityMappingStrategy<T> entityMappingStrategy, boolean bl) {
            this.fEntityMappingStrategy = entityMappingStrategy;
            this.fRequiresMapping = bl;
            this.fCachedMaps = new HashMap<File, Map<T, Collection<Interval>>>();
            this.fCachedIntervals = new HashMap<T, Collection<Interval>>();
            this.fEntityCache = new HashMap<Integer, T>();
        }

        void reset() {
            this.fCachedMaps.clear();
            this.fEntityCache.clear();
            this.fCachedIntervals = new HashMap<T, Collection<Interval>>();
        }

        void reset(File file) {
            this.fCachedMaps.remove(file);
        }

        void setContextFunction(Function function) {
            if (function == null) {
                this.fCachedIntervals = new HashMap<T, Collection<Interval>>();
            } else if (this.fCachedMaps.containsKey(function.getFile())) {
                this.fCachedIntervals = this.fCachedMaps.get(function.getFile());
            } else {
                this.fCachedIntervals = new HashMap<T, Collection<Interval>>();
                this.fCachedMaps.put(function.getFile(), this.fCachedIntervals);
            }
        }

        Interval getInterval(T t) {
            Collection<Interval> collection = this.getIntervals(t);
            return !collection.isEmpty() ? collection.iterator().next() : null;
        }

        Collection<Interval> getIntervals(T t) {
            Collection<Interval> collection = this.fCachedIntervals.get(t);
            if (collection == null) {
                collection = this.fEntityMappingStrategy.findIntervals(t);
                this.fCachedIntervals.put(t, collection != null && !collection.isEmpty() ? collection : EMPTY_COLLECTION);
            }
            LinkedList<Interval> linkedList = new LinkedList<Interval>();
            if (collection != null) {
                for (Interval interval : collection) {
                    Interval interval2 = new Interval(FunctionScopedEntityLocator.this.fTextMapper.mapToCurrent(interval.getStart()), FunctionScopedEntityLocator.this.fTextMapper.mapToCurrent(interval.getEnd()));
                    if (interval2.getStart() >= 0) {
                        linkedList.add(interval2);
                        continue;
                    }
                    if (this.fRequiresMapping) continue;
                    linkedList.add(interval);
                }
            }
            return linkedList;
        }

        T getEntityAt(int n) {
            CodableEntity codableEntity = null;
            int n2 = FunctionScopedEntityLocator.this.mapToOriginal(n);
            if (n2 >= 0 && n2 < FunctionScopedEntityLocator.this.fOriginalCode.getLength()) {
                if (this.fEntityCache.containsKey(n2)) {
                    codableEntity = (CodableEntity)this.fEntityCache.get(n2);
                } else {
                    codableEntity = (CodableEntity)this.fEntityMappingStrategy.getEntityAtPosition(n2);
                    if (codableEntity != null) {
                        this.fEntityCache.put(n2, codableEntity);
                    }
                }
            }
            return (T)codableEntity;
        }
    }

    private class CallSiteEntityMappingStrategy
    implements EntityMappingStrategy<CallTree.CallSite> {
        private CallSiteEntityMappingStrategy() {
        }

        @Override
        public Collection<Interval> findIntervals(CallTree.CallSite callSite) {
            Interval interval;
            if (FunctionScopedEntityLocator.this.fCurrentFunction == null) {
                return Collections.emptyList();
            }
            MTree.Node node = MTreeUtils.getNodeAtPosition(FunctionScopedEntityLocator.this.fParseTree, callSite.getPosition(), FunctionScopedEntityLocator.this.fOriginalCode, false);
            if ((node = this.getTrueCallNode(node)) != null && (interval = FunctionScopedEntityLocator.this.getIntervalForNode(node)) != null) {
                return Arrays.asList(interval);
            }
            return Collections.emptyList();
        }

        @Override
        public CallTree.CallSite getEntityAtPosition(int n) {
            Function function;
            if (FunctionScopedEntityLocator.this.fAppModel == null || FunctionScopedEntityLocator.this.fAppModel.getCallTree() == null) {
                return null;
            }
            MTree.Node node = MTreeUtils.getNodeAtPosition(FunctionScopedEntityLocator.this.fParseTree, n, FunctionScopedEntityLocator.this.fOriginalCode, false);
            if ((node = this.getTrueCallNode(node)) != null && (function = (Function)FunctionScopedEntityLocator.this.fFunctionManager.getEntityAt(n)) != null) {
                List<CallTree.CallSite> list = FunctionScopedEntityLocator.this.fAppModel.getCallTree().getCallSites(function);
                Interval interval = FunctionScopedEntityLocator.this.getIntervalForNode(node);
                if (list != null && interval != null) {
                    CallTree.CallSite callSite = null;
                    for (CallTree.CallSite callSite2 : list) {
                        if (!interval.contains(callSite2.getPosition()) || callSite != null && callSite2.getPosition() <= callSite.getPosition()) continue;
                        callSite = callSite2;
                    }
                    return callSite;
                }
            }
            return null;
        }

        private MTree.Node getTrueCallNode(MTree.Node node) {
            for (MTree.Node node2 = node; node2 != null && node2.getType() != MTree.NodeType.JAVA_NULL_NODE; node2 = node2.getTrueParent()) {
                if (node2.getType() != MTree.NodeType.CALL) continue;
                return node2;
            }
            return null;
        }
    }

    private class BuildErrorEntityMappingStrategy
    implements EntityMappingStrategy<BuildError> {
        private BuildErrorEntityMappingStrategy() {
        }

        @Override
        public Collection<Interval> findIntervals(BuildError buildError) {
            return Arrays.asList(new Interval(buildError.getPosition(), buildError.getPosition() + buildError.getLength()));
        }

        @Override
        public BuildError getEntityAtPosition(int n) {
            for (BuildError buildError : (Collection)FunctionScopedEntityLocator.this.fErrorSource.run()) {
                int n2 = buildError.getPosition();
                int n3 = n2 + buildError.getLength();
                if (n < n2 || n >= n3) continue;
                return buildError;
            }
            return null;
        }
    }

    private class FunctionSignatureEntityMappingStrategy
    extends FunctionEntityMappingStrategy {
        private FunctionSignatureEntityMappingStrategy() {
        }

        @Override
        @Nullable
        MTree.Node intervalNodeFromFunctionNode(@NotNull MTree.Node node) {
            return node.getLeft();
        }
    }

    private class FunctionEntityMappingStrategy
    implements EntityMappingStrategy<Function> {
        private FunctionEntityMappingStrategy() {
        }

        @Override
        public Collection<Interval> findIntervals(Function function) {
            MTree.Node node;
            MTree.Node node2;
            LinkedList<Interval> linkedList = new LinkedList<Interval>();
            if (FunctionScopedEntityLocator.this.isMTreeRelevant() && (node2 = FunctionScopedEntityLocator.this.getFunctionNode(function, true)) != null && (node = this.intervalNodeFromFunctionNode(node2)) != null) {
                Interval interval = FunctionScopedEntityLocator.this.getIntervalForNode(node);
                int n = MTreeUtils.getMinimumPosition(node2, FunctionScopedEntityLocator.this.fOriginalCode);
                if (n >= 0 && interval != null) {
                    linkedList.add(new Interval(n, interval.getEnd()));
                }
            }
            return linkedList;
        }

        @Override
        public Function getEntityAtPosition(int n) {
            MTree.Node node;
            if (FunctionScopedEntityLocator.this.fCurrentFunction == null) {
                return null;
            }
            MTree.Node node2 = MTreeUtils.getNodeAtPosition(FunctionScopedEntityLocator.this.fParseTree, n, FunctionScopedEntityLocator.this.fOriginalCode, false);
            if (node2 != null && (node = node2.getType() == MTree.NodeType.FUNCTION ? node2 : FunctionUtils.getParentOfType(node2, MTree.NodeType.FUNCTION)) != null) {
                String string = node.getFunctionName().getText();
                Collection collection = FunctionScopedEntityLocator.this.fModel.getFunctionsByFile().get(FunctionScopedEntityLocator.this.fCurrentFunction.getFile());
                if (collection != null) {
                    for (Object object : collection) {
                        if (!((Function)object).getSpecializationName().equals(string)) continue;
                        return object;
                    }
                    TreeSet treeSet = new TreeSet(SPECIALIZATION_INDEX_SORTER);
                    for (Function function : collection) {
                        if (!function.getName().equals(string)) continue;
                        treeSet.add(function);
                    }
                    if (!treeSet.isEmpty()) {
                        return (Function)treeSet.iterator().next();
                    }
                }
            }
            return null;
        }

        @Nullable
        MTree.Node intervalNodeFromFunctionNode(@NotNull MTree.Node node) {
            return node;
        }
    }

    private class ExpressionEntityMappingStrategy
    implements EntityMappingStrategy<Expression> {
        private ExpressionEntityMappingStrategy() {
        }

        @Override
        public Collection<Interval> findIntervals(Expression expression) {
            return Arrays.asList((Interval)expression.getKey());
        }

        @Override
        public Expression getEntityAtPosition(int n) {
            Function function = (Function)FunctionScopedEntityLocator.this.fFunctionManager.getEntityAt(n);
            Expression expression = null;
            if (function != null && FunctionScopedEntityLocator.this.fModel.hasExpressions(function)) {
                expression = FunctionScopedEntityLocator.this.fModel.getExpressions(function).getNarrowestExpression(n);
            }
            return expression;
        }
    }

    private class VariableEntityMappingStrategy
    implements EntityMappingStrategy<Variable> {
        private VariableEntityMappingStrategy() {
        }

        @Override
        public Collection<Interval> findIntervals(Variable variable) {
            LinkedList<Interval> linkedList;
            block4: {
                MTree.Node node;
                linkedList = new LinkedList<Interval>();
                if (!FunctionScopedEntityLocator.this.isMTreeRelevant() || (node = FunctionScopedEntityLocator.this.getFunctionNode(variable.getFunction(), false)) == null) break block4;
                if (!variable.getName().equals("~")) {
                    for (MTree.Node node2 : node.getSubtree()) {
                        if (node2.getType() != MTree.NodeType.ID || node2.getAttribute() != MTree.Attribute.VARIABLE || !node2.getText().equals(variable.getName())) continue;
                        linkedList.add(FunctionScopedEntityLocator.this.getIntervalForNode(node2));
                    }
                } else {
                    List list = node.getInputArguments();
                    for (MTree.Node node3 : list) {
                        if (node3.getType() != MTree.NodeType.NOT) continue;
                        linkedList.add(FunctionScopedEntityLocator.this.getIntervalForNode(node3));
                        break;
                    }
                }
            }
            return linkedList;
        }

        @Override
        public Variable getEntityAtPosition(int n) {
            MTree.Node node;
            Function function = (Function)FunctionScopedEntityLocator.this.fFunctionManager.getEntityAt(n);
            Variable variable = null;
            if (function != null && (node = FunctionScopedEntityLocator.this.getNodeAtPosition(n)) != null) {
                if (node.getType() == MTree.NodeType.ID && node.getAttribute() == MTree.Attribute.VARIABLE) {
                    variable = new Variable(function, node.getText());
                } else if (node.getType() == MTree.NodeType.NOT) {
                    variable = new Variable(function, "~");
                }
            }
            return variable;
        }
    }

    private static interface EntityMappingStrategy<T> {
        public Collection<Interval> findIntervals(T var1);

        public T getEntityAtPosition(int var1);
    }
}

