/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.TooltipWindow;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.widgets.GuiDefaults;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.Timer;

public final class HintPopupFrame {
    private static final Set<HintPopupFrame> ALL_FRAMES = new HashSet<HintPopupFrame>();
    private final Window fParentWindow;
    private final Component fParent;
    private final ReturnRunnable<Point> fPositioner;
    private final JComponent fContent;
    private final PropertyChangeListener fFocusListener;
    private final ComponentListener fComponentListener;
    private final WindowListener fWindowListener;
    private final HierarchyListener fHierarchyListener;
    private final HyperlinkTextLabel.HyperlinkHandler fHyperlinkDelegate;
    private final Icon fIcon;
    private TooltipWindow fToolTip;
    private HyperlinkTextLabel.HyperlinkHandler fHyperlinkHandler;
    private int fAnchorX;
    private int fAnchorY;
    public static final Color BACKGROUND = new Color(254, 254, 216);
    public static final Color BORDER = PlatformInfo.isMacintosh() ? new Color(120, 115, 40) : new Color(89, 75, 6);

    public HintPopupFrame(Window window, Component component, String string, Icon icon, boolean bl, boolean bl2, ReturnRunnable<Point> returnRunnable) {
        this(window, component, string, icon, bl, bl2, ClosePolicy.AUTO, returnRunnable);
    }

    public HintPopupFrame(Window window, Component component, String string, Icon icon, boolean bl, boolean bl2, ClosePolicy closePolicy, ReturnRunnable<Point> returnRunnable) {
        this(window, component, string, icon, bl, bl2, false, closePolicy, returnRunnable);
    }

    public HintPopupFrame(Window window, Component component, String string, Icon icon, boolean bl, boolean bl2, boolean bl3, final ClosePolicy closePolicy, ReturnRunnable<Point> returnRunnable) {
        this.fParentWindow = window;
        this.fParent = component;
        this.fIcon = icon;
        this.fPositioner = returnRunnable;
        this.fHyperlinkDelegate = new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                if (HintPopupFrame.this.fHyperlinkHandler != null) {
                    HintPopupFrame.this.fHyperlinkHandler.processHyperlink(string);
                }
            }
        };
        MJPanel mJPanel = new MJPanel();
        if (!bl) {
            mJPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(8, 10, 4, 4);
            mJPanel.add(this.createLabel(string), gridBagConstraints);
        } else {
            mJPanel.add(this.createLabel(string));
        }
        mJPanel.setName("wfa.message.popup");
        mJPanel.setOpaque(false);
        this.fToolTip = new TooltipWindow(this.fParentWindow, component, bl, bl2, bl3, 2, BACKGROUND, BORDER);
        this.fContent = closePolicy == ClosePolicy.AUTO ? mJPanel : this.wrapWithCloseable((JComponent)mJPanel);
        this.update();
        if (PlatformInfo.isMacintosh() && !bl2) {
            this.fToolTip.showWithAnimation((Component)this.fContent, this.fAnchorX, this.fAnchorY);
        } else {
            this.fToolTip.setFocusableWindowState(false);
            this.fToolTip.setVisible(true);
            if (closePolicy != ClosePolicy.AUTO) {
                this.fToolTip.setFocusableWindowState(bl3);
            }
        }
        ALL_FRAMES.add(this);
        this.fFocusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!HintPopupFrame.this.fParentWindow.isActive() && !HintPopupFrame.this.fToolTip.isActive() && closePolicy != ClosePolicy.EXPLICIT) {
                    Timer timer = new Timer(100, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            HintPopupFrame.this.close(!PlatformInfo.isLinux());
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            }
        };
        this.fWindowListener = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                HintPopupFrame.this.close();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                HintPopupFrame.this.timerReshow();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                HintPopupFrame.this.timerReshow();
            }
        };
        this.fToolTip.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                HintPopupFrame.this.timerReshow();
            }
        });
        this.fComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                HintPopupFrame.this.update();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                HintPopupFrame.this.update();
            }
        };
        this.fHierarchyListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (!HintPopupFrame.this.fParent.isShowing()) {
                    HintPopupFrame.this.close();
                }
            }
        };
        this.fParent.addComponentListener(this.fComponentListener);
        this.fParent.addHierarchyListener(this.fHierarchyListener);
        this.fParentWindow.addComponentListener(this.fComponentListener);
        this.fParentWindow.addWindowListener(this.fWindowListener);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this.fFocusListener);
    }

    private void timerReshow() {
        Timer timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HintPopupFrame.this.fToolTip != null) {
                    HintPopupFrame.this.fToolTip.setVisible(HintPopupFrame.this.fParentWindow.isActive() || HintPopupFrame.this.fToolTip.isActive());
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public static void closeAllPopups() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (HintPopupFrame hintPopupFrame : new LinkedList(ALL_FRAMES)) {
                    hintPopupFrame.close();
                }
            }
        });
    }

    public void setHyperlinkHandler(HyperlinkTextLabel.HyperlinkHandler hyperlinkHandler) {
        this.fHyperlinkHandler = hyperlinkHandler;
    }

    public void setLocation(int n, int n2) {
        this.fToolTip.setLocation(n, n2);
    }

    private void update() {
        Point point = (Point)this.fPositioner.run();
        if (point.getX() != (double)this.fAnchorX || point.getY() != (double)this.fAnchorY) {
            this.fAnchorX = (int)point.getX();
            this.fAnchorY = (int)point.getY();
            this.fToolTip.update((Component)this.fContent, this.fAnchorX, this.fAnchorY);
        }
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean bl) {
        if (!bl && (this.fToolTip != null && this.fToolTip.isActive() || this.fParentWindow.isActive())) {
            return;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.fFocusListener);
        this.fParentWindow.removeComponentListener(this.fComponentListener);
        this.fParentWindow.removeWindowListener(this.fWindowListener);
        this.fParent.removeComponentListener(this.fComponentListener);
        this.fParent.removeHierarchyListener(this.fHierarchyListener);
        if (this.fToolTip != null) {
            this.fToolTip.dispose();
            this.fToolTip = null;
            ALL_FRAMES.remove(this);
        }
    }

    private Component createLabel(String string) {
        MJLabel mJLabel;
        if (string.contains("<a")) {
            MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("3dlu, fill:d, 1dlu, fill:d:grow", "3dlu, top:d, 3dlu:grow"));
            mJPanel.setOpaque(false);
            CellConstraints cellConstraints = new CellConstraints();
            mJPanel.add((Component)new MJLabel(this.fIcon), (Object)cellConstraints.xy(2, 2));
            mJPanel.add((Component)new HyperlinkTextLabel(string, this.fHyperlinkDelegate).getComponent(), (Object)cellConstraints.xy(4, 2));
            mJLabel = mJPanel;
        } else {
            MJLabel mJLabel2 = new MJLabel(string);
            mJLabel2.setIcon(this.fIcon);
            mJLabel = mJLabel2;
        }
        if (PlatformInfo.isMacintosh()) {
            mJLabel.setForeground(new Color(52, 52, 52));
        }
        return mJLabel;
    }

    private JComponent wrapWithCloseable(JComponent jComponent) {
        MJButton mJButton = new MJButton(GuiDefaults.createCloseIcon(8, new Color(50, 50, 50, 120)));
        mJButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        mJButton.setContentAreaFilled(false);
        mJButton.setToolTipText(CoderResources.getString("wfa.popup.close"));
        mJButton.setCursor(Cursor.getPredefinedCursor(12));
        mJButton.setFocusPainted(false);
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HintPopupFrame.this.close();
            }
        });
        MJPanel mJPanel = new MJPanel((JButton)mJButton, jComponent){
            final /* synthetic */ JButton val$closeButton;
            final /* synthetic */ JComponent val$content;
            {
                this.val$closeButton = jButton;
                this.val$content = jComponent;
            }

            public void doLayout() {
                if (this.getComponentCount() == 2) {
                    Dimension dimension = this.val$closeButton.getPreferredSize();
                    this.val$closeButton.setBounds(this.getWidth() - 8 - 10, 10, dimension.width, dimension.height);
                    dimension = this.val$content.getPreferredSize();
                    this.val$content.setBounds(0, (this.getHeight() - this.val$content.getPreferredSize().height) / 2, dimension.width, dimension.height);
                }
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.val$content.getPreferredSize().width + 8, this.val$content.getPreferredSize().height);
            }
        };
        mJPanel.add(jComponent);
        mJPanel.add((Component)mJButton);
        mJPanel.setOpaque(false);
        return mJPanel;
    }

    public static enum ClosePolicy {
        AUTO,
        EXPLICIT,
        ANY;

    }
}

