/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.engine.DeploymentProcessAdapter;
import com.mathworks.project.impl.logui.BufferedLogSource;
import com.mathworks.project.impl.logui.BuildProgressTextArea;
import com.mathworks.project.impl.logui.LogMessage;
import com.mathworks.project.impl.logui.LogMessageType;
import com.mathworks.project.impl.workflowui.WorkflowDialog;
import com.mathworks.toolbox.coder.app.BuildErrorTable;
import com.mathworks.toolbox.coder.app.PopupBarManager;
import com.mathworks.toolbox.coder.app.TabbedOutputContext;
import com.mathworks.toolbox.coder.app.TabbedPane;
import com.mathworks.toolbox.coder.app.TaskListener;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.BuildErrorSeverity;
import com.mathworks.toolbox.coder.widgets.CoderScrollPane;
import com.mathworks.util.Holder;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.widgets.BusyAffordance;
import com.mathworks.widgets.LightButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public final class OutputPane
implements TabbedOutputContext {
    private final PopupBarManager fPopupBar;
    private final EditorView fEditor;
    private final boolean fUseBorder;
    private final ParameterRunnable<TabbedPane> fInitializer;
    private final ParameterRunnable<ErrorContext> fShowError;
    private final MJPanel fComponent;
    private final MJPanel fTaskProgressPanel;
    private final MJLabel fTaskLabel;
    private final Set<String> fErrorTabs;
    private final Map<String, String> fErrorTabsByTask;
    private final Map<String, List<BuildError>> fErrorsByErrorKey;
    private final Set<String> fSourceCodeErrorKeys;
    private final BusyAffordance fBusyAffordance;
    private final MJButton fCancelButton;
    private final MJButton fRetryButton;
    private final MulticastChangeListener fChangeListeners;
    private final List<TaskListener> fTaskListeners;
    private JComponent fWorkflowHelpButton;
    public static final String BUILD_TASK_KEY = "build";
    public static final String BUILD_ERRORS_KEY = "build-errors";
    public static final String OUTPUT_TAB_KEY = "output";
    private TabbedPane fTabbedPane;
    private Map<String, BuildProgressTextArea> fLogs;
    private Map<String, BufferedLogSource> fLogSources;
    private volatile DeploymentProcess fCurrentProcess;
    private Runnable fCurrentRetry;

    public OutputPane(PopupBarManager popupBarManager, EditorView editorView, boolean bl, ParameterRunnable<TabbedPane> parameterRunnable, ParameterRunnable<ErrorContext> parameterRunnable2) {
        this.fPopupBar = popupBarManager;
        this.fEditor = editorView;
        this.fInitializer = parameterRunnable;
        this.fShowError = parameterRunnable2;
        this.fErrorTabs = new HashSet<String>();
        this.fErrorTabsByTask = new HashMap<String, String>();
        this.fErrorsByErrorKey = new HashMap<String, List<BuildError>>();
        this.fUseBorder = bl;
        this.fSourceCodeErrorKeys = new HashSet<String>();
        this.fChangeListeners = new MulticastChangeListener();
        this.fTaskListeners = new ArrayList<TaskListener>();
        this.fComponent = new MJPanel(){

            public void doLayout() {
                super.doLayout();
                if (OutputPane.this.fTabbedPane != null && OutputPane.this.fTabbedPane.getComponent().getParent() == this) {
                    int n = 0;
                    if (this.getBorder() != null) {
                        n = this.getBorder().getBorderInsets((Component)((Object)this)).left;
                    }
                    OutputPane.this.fTabbedPane.getComponent().setBounds(n, 0, this.getWidth(), this.getHeight());
                } else if (this.getComponents().length == 1) {
                    this.getComponents()[0].setBounds(0, 0, this.getWidth(), this.getHeight());
                }
            }
        };
        if (bl) {
            this.fComponent.setBorder(new Border(){

                @Override
                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    graphics.setColor(new Color(160, 160, 160));
                    graphics.drawLine(0, 0, 0, component.getHeight());
                }

                @Override
                public Insets getBorderInsets(Component component) {
                    return new Insets(0, 1, 0, 0);
                }

                @Override
                public boolean isBorderOpaque() {
                    return true;
                }
            });
        }
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        this.fTaskLabel = new MJLabel();
        this.fTaskProgressPanel = new MJPanel(){
            private static final int SPACING = 6;

            public void doLayout() {
                Dimension dimension;
                Dimension dimension2;
                super.doLayout();
                int n = this.getWidth() - 3;
                if (OutputPane.this.fWorkflowHelpButton != null) {
                    dimension2 = OutputPane.this.fWorkflowHelpButton.getPreferredSize();
                    OutputPane.this.fWorkflowHelpButton.setBounds(n - dimension2.width, this.getHeight() / 2 - dimension2.height / 2, dimension2.width, Math.min(this.getHeight() - 1, dimension2.height));
                    n -= dimension2.width + 6;
                }
                dimension2 = null;
                if (OutputPane.this.fCancelButton.getParent() == this) {
                    dimension2 = OutputPane.this.fCancelButton;
                } else if (OutputPane.this.fRetryButton.getParent() == this) {
                    dimension2 = OutputPane.this.fRetryButton;
                }
                if (dimension2 != null) {
                    dimension = ((JComponent)((Object)dimension2)).getPreferredSize();
                    ((Component)((Object)dimension2)).setBounds(n -= dimension.width, this.getHeight() / 2 - dimension.height / 2 - 1, dimension.width, dimension.height);
                    n -= 6;
                }
                if (OutputPane.this.fTaskLabel.getParent() == this) {
                    dimension = OutputPane.this.fTaskLabel.getPreferredSize();
                    OutputPane.this.fTaskLabel.setBounds(n -= dimension.width, this.getHeight() / 2 - dimension.height / 2 - 1, dimension.width, dimension.height);
                    n -= 6;
                }
                if (OutputPane.this.fBusyAffordance.getComponent().getParent() == this) {
                    dimension = OutputPane.this.fBusyAffordance.getComponent().getPreferredSize();
                    OutputPane.this.fBusyAffordance.getComponent().setBounds(n -= dimension.width, this.getHeight() / 2 - dimension.height / 2 - 1, dimension.width, dimension.height);
                    n -= 6;
                }
            }

            public Dimension getPreferredSize() {
                Dimension dimension = new Dimension();
                dimension.width = 6;
                for (Component component : this.getComponents()) {
                    Dimension dimension2 = component.getPreferredSize();
                    dimension.width += dimension2.width + 6;
                }
                dimension.height = OutputPane.this.fTabbedPane.getTabHeight();
                return dimension;
            }
        };
        this.fTaskProgressPanel.setLayout(null);
        if (PlatformInfo.isMacintosh()) {
            this.fCancelButton = new MJButton(BuiltInResources.getString((String)"button.cancel"));
            this.fCancelButton.putClientProperty((Object)"JButton.buttonType", (Object)"roundRect");
        } else {
            this.fCancelButton = new LightButton(BuiltInResources.getString((String)"button.cancel")){

                public Dimension getPreferredSize() {
                    return new Dimension((int)super.getPreferredSize().getWidth(), (int)super.getPreferredSize().getHeight() + 3);
                }
            };
        }
        this.fCancelButton.setName("f2f.button.cancel");
        this.fCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeploymentProcess deploymentProcess = OutputPane.this.fCurrentProcess;
                if (deploymentProcess != null) {
                    deploymentProcess.cancel();
                }
            }
        });
        if (PlatformInfo.isMacintosh()) {
            final LightButton lightButton = new LightButton(BuiltInResources.getString((String)"button.cancel"));
            this.fRetryButton = new MJButton(){

                public Dimension getPreferredSize() {
                    return new Dimension((int)super.getPreferredSize().getWidth(), (int)lightButton.getPreferredSize().getHeight() + 3);
                }
            };
            this.fRetryButton.putClientProperty((Object)"JButton.buttonType", (Object)"roundRect");
        } else {
            this.fRetryButton = new LightButton(){

                public Dimension getPreferredSize() {
                    return new Dimension((int)super.getPreferredSize().getWidth(), (int)super.getPreferredSize().getHeight() + 3);
                }
            };
        }
        this.fRetryButton.setName("f2f.button.retry");
        this.fRetryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (OutputPane.this.fCurrentRetry != null) {
                    OutputPane.this.fCurrentRetry.run();
                }
            }
        });
    }

    public TabbedPane getTabbedPane() {
        return this.fTabbedPane;
    }

    public boolean hasBuildErrors() {
        return this.hasBuildErrors(BuildErrorSeverity.ERROR);
    }

    public boolean hasBuildErrors(@Nullable BuildErrorSeverity buildErrorSeverity) {
        List<BuildError> list;
        if (buildErrorSeverity == null) {
            buildErrorSeverity = BuildErrorSeverity.INFO;
        }
        if ((list = this.fErrorsByErrorKey.get(BUILD_ERRORS_KEY)) != null) {
            list = new LinkedList<BuildError>(list);
            Iterator<BuildError> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (buildErrorSeverity.compareTo(iterator.next().getSeverity()) <= 0) continue;
                iterator.remove();
            }
        }
        return list != null && !list.isEmpty();
    }

    public DeploymentProcess getCurrentProcess() {
        return this.fCurrentProcess;
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public void addTaskListener(TaskListener taskListener) {
        this.fTaskListeners.add(taskListener);
    }

    public void removeTaskListener(TaskListener taskListener) {
        this.fTaskListeners.remove(taskListener);
    }

    public void setWorkflowHelpButtonVisible(boolean bl) {
        if (bl && this.fWorkflowHelpButton == null) {
            this.fWorkflowHelpButton = WorkflowDialog.createHelpButton();
            this.fTaskProgressPanel.add((Component)this.fWorkflowHelpButton);
        } else if (!bl && this.fWorkflowHelpButton != null) {
            this.fTaskProgressPanel.remove((Component)this.fWorkflowHelpButton);
            this.fWorkflowHelpButton = null;
        }
        this.fTaskProgressPanel.revalidate();
        this.fTaskProgressPanel.repaint();
    }

    public void dispose() {
        if (this.fLogs != null) {
            for (BuildProgressTextArea object : this.fLogs.values()) {
                object.dispose();
            }
            this.fLogs.clear();
        }
        for (String string : this.fErrorTabsByTask.values()) {
            Component component = this.fTabbedPane.removeSubElement(OUTPUT_TAB_KEY, string);
            if (component == null) continue;
            BuildErrorTable buildErrorTable = (BuildErrorTable)((JComponent)component).getClientProperty(BuildErrorTable.class.getName());
            buildErrorTable.dispose();
        }
    }

    public void reset() {
        this.fCurrentRetry = null;
        if (this.fCurrentProcess != null) {
            this.fCurrentProcess.cancel();
        }
        this.fCurrentProcess = null;
        this.fTabbedPane.removeSubElements(OUTPUT_TAB_KEY);
        this.fTabbedPane.setVisible(OUTPUT_TAB_KEY, false);
        String string = this.fTabbedPane.getFirstVisibleTabKey();
        if (string != null) {
            this.fTabbedPane.select(string);
        }
        this.clearTaskProgressPanel();
        this.fTaskProgressPanel.revalidate();
        this.fTaskProgressPanel.repaint();
        for (BuildProgressTextArea buildProgressTextArea : this.fLogs.values()) {
            buildProgressTextArea.dispose();
        }
        this.fLogs.clear();
        this.fLogSources.clear();
    }

    @Override
    public void runWithoutLog(DeploymentProcess deploymentProcess) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                OutputPane.this.showTask(false);
            }
        });
        deploymentProcess.addMonitor((DeploymentProcessMonitor)new DeploymentProcessAdapter(){

            public void finished() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (OutputPane.this.fCurrentProcess == null) {
                            OutputPane.this.fBusyAffordance.stop();
                            OutputPane.this.clearTaskProgressPanel();
                            OutputPane.this.fTaskProgressPanel.revalidate();
                            OutputPane.this.fTaskProgressPanel.repaint();
                            OutputPane.this.fChangeListeners.stateChanged(new ChangeEvent(OutputPane.this));
                        }
                    }
                });
            }

            public void failed() {
                this.finished();
            }

            public void canceled() {
                this.finished();
            }

            public void commandStarted(final String string) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OutputPane.this.fTaskLabel.setText(string);
                    }
                });
            }
        });
        deploymentProcess.start();
    }

    @Override
    public void runWithLog(String string, String string2, DeploymentProcess deploymentProcess) {
        this.runWithLog(string, string2, deploymentProcess, null);
    }

    public void runWithLog(String string, String string2, DeploymentProcess deploymentProcess, @Nullable Predicate<BufferedLogSource> predicate) {
        this.runWithLog(string, string2, deploymentProcess, null, null, predicate);
    }

    @Override
    public void runWithLog(String string, String string2, DeploymentProcess deploymentProcess, @Nullable Runnable runnable, @Nullable String string3, final Predicate<BufferedLogSource> predicate) {
        BuildErrorTable buildErrorTable;
        Object object;
        String string4;
        this.fCurrentRetry = null;
        if (this.fLogs == null || !this.fLogs.containsKey(string)) {
            this.initializeTabbedPane();
            this.initializeLog(string);
            this.fTabbedPane.addSubElement(OUTPUT_TAB_KEY, string, string2, (Component)this.createScrollPane(this.fLogs.get(string).getComponent()));
        }
        if ((string4 = this.fErrorTabsByTask.get(string)) != null) {
            object = this.fTabbedPane.removeSubElement(OUTPUT_TAB_KEY, string4);
            if (object != null) {
                buildErrorTable = (BuildErrorTable)((JComponent)object).getClientProperty(BuildErrorTable.class.getName());
                buildErrorTable.dispose();
            }
            this.fEditor.setBuildErrors(new LinkedList<BuildError>(), false);
            this.fErrorTabs.remove(string4);
            this.fErrorTabsByTask.remove(string);
            this.fErrorsByErrorKey.remove(string4);
            this.fSourceCodeErrorKeys.remove(string4);
        } else {
            this.fEditor.setBuildErrors(new LinkedList<BuildError>(), false);
        }
        object = this.fPopupBar.block();
        buildErrorTable = this.fLogSources.get(string);
        buildErrorTable.setProcess(deploymentProcess);
        this.fTabbedPane.select(OUTPUT_TAB_KEY, string);
        this.showTask(true);
        this.fCurrentProcess = deploymentProcess;
        deploymentProcess.addMonitor((DeploymentProcessMonitor)new DeploymentProcessAdapter((BufferedLogSource)buildErrorTable, string, runnable, string3, (PopupBarManager.Block)object, deploymentProcess){
            final /* synthetic */ BufferedLogSource val$log;
            final /* synthetic */ String val$key;
            final /* synthetic */ Runnable val$retry;
            final /* synthetic */ String val$retryLabel;
            final /* synthetic */ PopupBarManager.Block val$popupBlock;
            final /* synthetic */ DeploymentProcess val$process;
            {
                this.val$log = bufferedLogSource;
                this.val$key = string;
                this.val$retry = runnable;
                this.val$retryLabel = string2;
                this.val$popupBlock = block;
                this.val$process = deploymentProcess;
            }

            public void finished() {
                this.cleanup();
                if (predicate != null && predicate.accept((Object)this.val$log)) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            OutputPane.this.fLogs.remove(val$key);
                            OutputPane.this.fLogSources.remove(val$key);
                            OutputPane.this.fTabbedPane.removeSubElement(OutputPane.OUTPUT_TAB_KEY, val$key);
                            OutputPane.this.fTabbedPane.selectPrevious();
                        }
                    });
                }
                OutputPane.this.fireTaskSucceeded(this.val$key);
            }

            public void commandStarted(final String string) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OutputPane.this.fChangeListeners.stateChanged(new ChangeEvent(this));
                        OutputPane.this.fTaskLabel.setText(string);
                    }
                });
            }

            public void failed() {
                this.cleanup();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OutputPane.this.fChangeListeners.stateChanged(new ChangeEvent(this));
                        if (val$retry != null) {
                            OutputPane.this.showRetry(val$retry, val$retryLabel);
                        }
                        OutputPane.this.fireTaskFailed(val$key);
                    }
                });
            }

            public void canceled() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        val$popupBlock.dispose();
                        BuildProgressTextArea buildProgressTextArea = (BuildProgressTextArea)OutputPane.this.fLogs.get(val$key);
                        if (buildProgressTextArea != null) {
                            buildProgressTextArea.clear();
                        }
                        this.cleanup();
                        if (val$retry != null) {
                            OutputPane.this.showRetry(val$retry, val$retryLabel);
                        }
                        OutputPane.this.fireTaskCanceled(val$key);
                    }
                });
            }

            private void cleanup() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (OutputPane.this.fCurrentProcess == val$process) {
                            val$popupBlock.dispose();
                            OutputPane.this.fCurrentProcess = null;
                            OutputPane.this.fBusyAffordance.stop();
                            OutputPane.this.clearTaskProgressPanel();
                            OutputPane.this.fTaskProgressPanel.revalidate();
                            OutputPane.this.fTaskProgressPanel.repaint();
                            OutputPane.this.fChangeListeners.stateChanged(new ChangeEvent(OutputPane.this));
                        }
                    }
                });
            }
        });
        this.fireTaskStarted(string);
        deploymentProcess.start();
    }

    public boolean isRetryShowing() {
        return this.fCurrentRetry != null && this.fRetryButton.getParent() != null;
    }

    public boolean isRunningTask() {
        return this.fCurrentProcess != null;
    }

    public void setTabVisible(String string, boolean bl) {
        this.initializeTabbedPane();
        this.fTabbedPane.setVisible(string, bl);
    }

    @Override
    public void activateTab(String string) {
        this.fTabbedPane.select(string);
    }

    public void showBanner(Component component) {
        this.fComponent.removeAll();
        this.fComponent.add(component);
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    public void clearBanner() {
        this.fComponent.removeAll();
        if (this.fTabbedPane != null) {
            this.fComponent.add(this.fTabbedPane.getComponent());
        }
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    public void showErrorMessage(String string) {
        if (this.fCurrentProcess != null || this.fCurrentRetry != null) {
            return;
        }
        if (string == null) {
            this.fTaskLabel.setText("");
            this.fTaskLabel.setForeground(Color.BLACK);
            this.clearTaskProgressPanel();
            this.fTaskProgressPanel.revalidate();
            this.fTaskProgressPanel.repaint();
        } else {
            this.fTaskLabel.setText(string);
            this.fTaskLabel.setForeground(new Color(170, 0, 0));
            this.clearTaskProgressPanel();
            this.fTaskProgressPanel.add((Component)this.fTaskLabel);
            this.fTaskProgressPanel.revalidate();
            this.fTaskProgressPanel.repaint();
        }
    }

    @Override
    public void showErrors(String string, String string2, String string3, boolean bl, boolean bl2, Component component, List<BuildError> list) {
        this.initializeTabbedPane();
        final Holder holder = new Holder();
        BuildErrorTable buildErrorTable = new BuildErrorTable(list, new ParameterRunnable<BuildError>(){

            public void run(final BuildError buildError) {
                OutputPane.this.fShowError.run((Object)new ErrorContext(){

                    @Override
                    public BuildError getError() {
                        return buildError;
                    }

                    @Override
                    public BuildErrorTable getErrorTable() {
                        return (BuildErrorTable)holder.get();
                    }
                });
            }
        });
        holder.set((Object)buildErrorTable);
        JComponent jComponent = buildErrorTable.getComponent();
        if (component != null) {
            jComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
            jComponent.add(component, "North");
            jComponent.add((Component)buildErrorTable.getComponent(), "Center");
            jComponent.putClientProperty(BuildErrorTable.class.getName(), buildErrorTable.getComponent().getClientProperty(BuildErrorTable.class.getName()));
        }
        this.fTabbedPane.removeSubElement(OUTPUT_TAB_KEY, string2);
        this.fTabbedPane.addSubElement(OUTPUT_TAB_KEY, string2, string3, jComponent);
        this.fErrorsByErrorKey.put(string2, list);
        if (bl) {
            this.fSourceCodeErrorKeys.add(string2);
        }
        this.fEditor.setBuildErrors(list, bl);
        this.fTabbedPane.select(OUTPUT_TAB_KEY, string2);
        this.fErrorTabsByTask.put(string, string2);
        this.fErrorTabs.add(string2);
        buildErrorTable.showFirstError(bl2);
    }

    public void setVisibleTaskKeys(Set<String> set) {
        boolean bl = false;
        for (Map.Entry<String, String> entry : this.fErrorTabsByTask.entrySet()) {
            boolean bl2 = set.contains(entry.getKey());
            this.fTabbedPane.setVisible(OUTPUT_TAB_KEY, entry.getValue(), bl2);
            if (bl) continue;
            bl = bl2;
        }
        if (!bl) {
            this.fEditor.setBuildErrors(new ArrayList<BuildError>(), true);
        }
    }

    public void initializeTabbedPane() {
        if (this.fTabbedPane == null) {
            this.fTabbedPane = new TabbedPane((Component)this.fTaskProgressPanel);
            this.fInitializer.run((Object)this.fTabbedPane);
            this.fTabbedPane.hideAll();
            this.fComponent.removeAll();
            this.fComponent.setLayout(null);
            this.fComponent.add(this.fTabbedPane.getComponent());
            this.fComponent.revalidate();
            this.fComponent.repaint();
            this.fLogs = new HashMap<String, BuildProgressTextArea>();
            this.fLogSources = new HashMap<String, BufferedLogSource>();
            this.fTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    String string = OutputPane.this.fTabbedPane.getSelectedSubElementKey();
                    if (string != null && OutputPane.this.fErrorTabs.contains(string)) {
                        OutputPane.this.fEditor.setBuildErrors((List)OutputPane.this.fErrorsByErrorKey.get(string), OutputPane.this.fSourceCodeErrorKeys.contains(string));
                    }
                }
            });
        }
    }

    public void showCustomAction(Runnable runnable, String string, @Nullable String string2) {
        if (!this.isRetryShowing() && !this.isRunningTask()) {
            this.fTaskProgressPanel.removeAll();
            if (string2 != null) {
                this.fTaskLabel.setText(string2);
                this.fTaskProgressPanel.add((Component)this.fTaskLabel);
            }
            this.showRetry(runnable, string);
        }
    }

    public void hideCustomAction() {
        this.fTaskProgressPanel.removeAll();
    }

    private void showRetry(Runnable runnable, String string) {
        this.fCurrentRetry = runnable;
        this.fRetryButton.setText(string);
        this.fTaskProgressPanel.add((Component)this.fRetryButton);
        this.fTaskProgressPanel.revalidate();
        this.fTaskProgressPanel.repaint();
    }

    private void fireTaskStarted(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (TaskListener taskListener : new ArrayList(OutputPane.this.fTaskListeners)) {
                    taskListener.taskStarted(string);
                }
            }
        });
    }

    private void fireTaskCanceled(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (TaskListener taskListener : new ArrayList(OutputPane.this.fTaskListeners)) {
                    taskListener.taskCanceled(string);
                }
            }
        });
    }

    private void fireTaskSucceeded(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (TaskListener taskListener : new ArrayList(OutputPane.this.fTaskListeners)) {
                    taskListener.taskSucceeded(string);
                }
            }
        });
    }

    private void fireTaskFailed(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (TaskListener taskListener : new ArrayList(OutputPane.this.fTaskListeners)) {
                    taskListener.taskFailed(string);
                }
            }
        });
    }

    private void clearTaskProgressPanel() {
        this.fTaskProgressPanel.removeAll();
        if (this.fWorkflowHelpButton != null) {
            this.fTaskProgressPanel.add((Component)this.fWorkflowHelpButton);
        }
    }

    private void showTask(boolean bl) {
        this.fTaskLabel.setForeground(Color.BLACK);
        this.fTaskLabel.setText("");
        this.fBusyAffordance.start();
        this.clearTaskProgressPanel();
        this.fTaskProgressPanel.add((Component)this.fBusyAffordance.getComponent());
        this.fTaskProgressPanel.add((Component)this.fTaskLabel);
        if (bl) {
            this.fTaskProgressPanel.add((Component)this.fCancelButton);
        }
        this.fTaskProgressPanel.revalidate();
        this.fTaskProgressPanel.repaint();
    }

    private void initializeLog(String string) {
        if (!this.fLogs.containsKey(string)) {
            BuildProgressTextArea buildProgressTextArea = new BuildProgressTextArea();
            buildProgressTextArea.setEcho(false);
            this.fLogs.put(string, buildProgressTextArea);
            this.fLogSources.put(string, new BufferedLogSource((Predicate)new StepHeadingFilter()));
            this.fLogSources.get(string).bind(this.fLogs.get(string).getDisplay());
        }
    }

    private MJScrollPane createScrollPane(Component component) {
        CoderScrollPane coderScrollPane = new CoderScrollPane(component);
        if (this.fUseBorder) {
            coderScrollPane.setBorder(new Border(){

                @Override
                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    graphics.setColor(new Color(160, 160, 160));
                    graphics.drawLine(0, 0, component.getWidth(), 0);
                    graphics.drawLine(component.getWidth() - 1, 0, component.getWidth() - 1, component.getHeight());
                    graphics.drawLine(0, component.getHeight() - 1, component.getWidth(), component.getHeight() - 1);
                }

                @Override
                public Insets getBorderInsets(Component component) {
                    return new Insets(1, 0, 1, 1);
                }

                @Override
                public boolean isBorderOpaque() {
                    return true;
                }
            });
        } else {
            coderScrollPane.setBorder(new Border(){

                @Override
                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    graphics.setColor(new Color(220, 220, 220));
                    graphics.drawLine(0, 0, component.getWidth(), 0);
                    graphics.drawLine(0, 0, 0, component.getHeight());
                }

                @Override
                public Insets getBorderInsets(Component component) {
                    return new Insets(1, 1, 0, 0);
                }

                @Override
                public boolean isBorderOpaque() {
                    return true;
                }
            });
        }
        return coderScrollPane;
    }

    public static interface ErrorContext {
        public BuildError getError();

        public BuildErrorTable getErrorTable();
    }

    private static class StepHeadingFilter
    implements Predicate<LogMessage> {
        private StepHeadingFilter() {
        }

        public boolean accept(LogMessage logMessage) {
            return logMessage.getType() != LogMessageType.OUTPUT || !logMessage.getLine().trim().startsWith("============= Step");
        }
    }
}

