/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app;

import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.impl.logui.LogDisplay;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.toolbox.coder.app.CoderAppModel;
import com.mathworks.toolbox.coder.app.OutputPane;
import com.mathworks.toolbox.coder.app.TaskListener;
import com.mathworks.toolbox.coder.app.TestHarnessAdapter;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.TestBenchConfig;
import com.mathworks.toolbox.coder.plugin.TestBenchResult;
import com.mathworks.toolbox.coder.plugin.TestBenchRunMode;
import com.mathworks.toolbox.coder.plugin.TestBenchUtils;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public class TestHarness {
    private final CoderAppModel fModel;
    private final TestHarnessAdapter fAdapter;
    private final MulticastChangeListener fChangeListeners;
    private boolean fCanceled;
    private boolean fCancelPending;
    private boolean fSuccessful;

    public TestHarness(CoderAppModel coderAppModel, TestHarnessAdapter testHarnessAdapter) {
        this.fModel = coderAppModel;
        this.fAdapter = testHarnessAdapter;
        this.fChangeListeners = new MulticastChangeListener();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public boolean isSuccessful() {
        return this.fSuccessful;
    }

    public void run(String string, TestBenchRunMode testBenchRunMode) {
        this.run(string, null, testBenchRunMode, null);
    }

    public void run(String string, final @Nullable LogDisplay logDisplay, TestBenchRunMode testBenchRunMode, final @Nullable Runnable runnable) {
        this.notifyRunning();
        this.createContext(string, testBenchRunMode, new ParameterRunnable<TestBenchContext>(){

            public void run(final TestBenchContext testBenchContext) {
                if (testBenchContext == null) {
                    if (runnable != null) {
                        runnable.run();
                    }
                    return;
                }
                TestBenchUtils.runTestBench(testBenchContext.getConfig(), logDisplay, new ParameterRunnable<TestBenchResult>(){

                    public void run(TestBenchResult testBenchResult) {
                        TestHarness.this.processResult(testBenchContext, testBenchResult);
                        if (runnable != null) {
                            runnable.run();
                        }
                        testBenchContext.dispose();
                    }
                });
            }
        });
    }

    public void cancel() {
        this.fCancelPending = true;
        TestBenchUtils.interruptTestBench();
    }

    private void reset(final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TestHarness.this.fCanceled = false;
                TestHarness.this.fCancelPending = false;
                TestHarness.this.fSuccessful = false;
                if (bl) {
                    TestHarness.this.fChangeListeners.stateChanged(new ChangeEvent(this));
                }
            }
        });
    }

    private void notifyRunning() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TestHarness.this.reset(false);
                TestHarness.this.fChangeListeners.stateChanged(new ChangeEvent(this));
            }
        });
    }

    private void notifyCanceled() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TestHarness.this.fCancelPending = false;
                TestHarness.this.fCanceled = true;
                TestHarness.this.fChangeListeners.stateChanged(new ChangeEvent(this));
            }
        });
    }

    private void notifySuccessful() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TestHarness.this.reset(false);
                TestHarness.this.fSuccessful = true;
                TestHarness.this.fChangeListeners.stateChanged(new ChangeEvent(this));
            }
        });
    }

    private void notifyError(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TestHarness.this.reset(false);
                TestHarness.this.fAdapter.testFailed(string);
                TestHarness.this.fChangeListeners.stateChanged(new ChangeEvent(this));
            }
        });
    }

    public void createContext(String string, TestBenchRunMode testBenchRunMode, ParameterRunnable<TestBenchContext> parameterRunnable) {
        this.createContext(string, testBenchRunMode, parameterRunnable, null);
    }

    public void createContext(final String string, final TestBenchRunMode testBenchRunMode, final ParameterRunnable<TestBenchContext> parameterRunnable, final @Nullable OutputPane outputPane) {
        final Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File file = new File(TestHarness.this.fModel.getProjectWorkingFolder(), "a" + UUID.randomUUID().toString().replaceAll("-", "_") + ".m");
                try (PrintWriter printWriter = null;){
                    printWriter = new PrintWriter(new FileWriter(file));
                    printWriter.print(string);
                    printWriter.flush();
                    printWriter.close();
                    printWriter = null;
                    parameterRunnable.run((Object)new TestBenchContext(TestHarness.this.fModel, file, true, testBenchRunMode, outputPane));
                }
            }
        };
        if (TestHarness.isPlainInvocation(string)) {
            Utilities.which(string, new ParameterRunnable<File>(){

                public void run(File file) {
                    if (file != null) {
                        parameterRunnable.run((Object)new TestBenchContext(TestHarness.this.fModel, file, false, testBenchRunMode, outputPane));
                    } else {
                        new Thread(runnable).start();
                    }
                }
            });
        } else {
            new Thread(runnable).start();
        }
    }

    private static boolean isPlainInvocation(String string) {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (i == 0 && !Character.isJavaIdentifierStart(c) || i > 0 && !Character.isJavaIdentifierPart(c) || bl && c != ')' && c != ';') {
                return false;
            }
            if (c != '(') continue;
            bl = true;
        }
        return true;
    }

    private void processResult(final TestBenchContext testBenchContext, final TestBenchResult testBenchResult) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (TestHarness.this.fCancelPending) {
                    TestHarness.this.notifyCanceled();
                    return;
                }
                if (testBenchResult.getMessage().isEmpty()) {
                    if (TestHarness.foundAnyTypes(testBenchResult)) {
                        TestHarness.this.applyResult(testBenchResult);
                        TestHarness.this.notifySuccessful();
                    } else {
                        TestHarness.this.reset(true);
                        if (testBenchContext.getConfig().getRunMode() == TestBenchRunMode.RUN_FORTYPES) {
                            TestHarness.this.fAdapter.noTypesFound();
                        }
                    }
                } else {
                    String string = new FileLocation(testBenchContext.getConfig().getTestBenchFile()).getName();
                    String string2 = MessageFormat.format(CoderResources.getString("wfa.test.error.prefix"), string);
                    String string3 = testBenchResult.getMessage().startsWith(string2) ? testBenchResult.getMessage().substring(string2.length()) : testBenchResult.getMessage();
                    StringBuilder stringBuilder = new StringBuilder(string3.replaceAll("\n +", "\n "));
                    for (int i = 0; i < stringBuilder.length() - 1; ++i) {
                        if (stringBuilder.charAt(i) != ':' || !Character.isLetter(stringBuilder.charAt(i + 1))) continue;
                        stringBuilder.insert(i + 1, ' ');
                        ++i;
                    }
                    TestHarness.this.notifyError(stringBuilder.toString());
                }
            }
        });
    }

    private static boolean foundAnyTypes(TestBenchResult testBenchResult) {
        for (String string : testBenchResult.getEntryPointTypes().values()) {
            if (!string.contains("</Input>")) continue;
            return true;
        }
        return false;
    }

    private void applyResult(final TestBenchResult testBenchResult) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Map<String, String> map = testBenchResult.getEntryPointTypes();
                FileSetInstance fileSetInstance = TestHarness.this.fModel.getEntryPointFileSet();
                Set set = fileSetInstance.getFiles();
                for (File file : set) {
                    String string = new FileLocation(file).getNameBeforeDot();
                    String string2 = map.get(string);
                    if (string2 == null) continue;
                    fileSetInstance.setCustomData(file, string2);
                    try {
                        TestHarness.this.fAdapter.updateTypesWidget(file, XmlApi.getInstance().read(string2));
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException(iOException);
                    }
                }
            }
        });
    }

    private static class CleanupTaskListener
    implements TaskListener {
        private final OutputPane fOutputPane;
        private final File fSyntheticFile;
        private final FileLocation fWorkingDir;

        CleanupTaskListener(OutputPane outputPane, File file) {
            this.fOutputPane = outputPane;
            this.fSyntheticFile = file;
            this.fWorkingDir = MatlabPathModel.getInstance().getCurrentFolder();
            this.fOutputPane.addTaskListener(this);
        }

        @Override
        public void taskStarted(String string) {
        }

        @Override
        public void taskSucceeded(String string) {
            this.fOutputPane.removeTaskListener(this);
        }

        @Override
        public void taskFailed(String string) {
            this.fOutputPane.removeTaskListener(this);
        }

        @Override
        public void taskCanceled(String string) {
            this.fOutputPane.removeTaskListener(this);
            try {
                this.fSyntheticFile.delete();
                if (!MatlabPathModel.getInstance().getCurrentFolder().equals((Object)this.fWorkingDir)) {
                    new Matlab();
                    Matlab.whenAtPrompt((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MvmContext.get().feval("cd", new Object[]{CleanupTaskListener.this.fWorkingDir.toString()});
                        }
                    });
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public static class TestBenchContext {
        private final TestBenchConfig fConfig;
        private final boolean fSynthetic;

        private TestBenchContext(CoderAppModel coderAppModel, File file, boolean bl, TestBenchRunMode testBenchRunMode, OutputPane outputPane) {
            this.fSynthetic = bl;
            this.fConfig = new TestBenchConfig(testBenchRunMode);
            this.fConfig.setTestBenchFile(file);
            this.fConfig.setSynthetic(bl);
            this.fConfig.setEntryPointFiles(coderAppModel.getEntryPointFileSet().getFiles());
            if (testBenchRunMode == TestBenchRunMode.RUN_COMPILED) {
                this.fConfig.setMexFunctionName(coderAppModel.getCompiledArtifactName());
                this.fConfig.setWorkingFolder(coderAppModel.getProjectWorkingFolder());
            }
            if (outputPane != null && bl) {
                new CleanupTaskListener(outputPane, file);
            }
        }

        public boolean isSynthetic() {
            return this.fSynthetic;
        }

        public TestBenchConfig getConfig() {
            return this.fConfig;
        }

        public void dispose() {
            if (this.fSynthetic) {
                this.fConfig.getTestBenchFile().delete();
            }
        }
    }
}

