/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.app.ide.IDEFileSidebar;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.UnifiedModel;
import com.mathworks.toolbox.coder.wfa.files.FileSetIntegrationContext;
import com.mathworks.toolbox.coder.wfa.files.FileSetSidebarWidget;
import com.mathworks.toolbox.coder.wfa.files.FileSetView;
import com.mathworks.toolbox.coder.wfa.files.FileSetViewGroup;
import com.mathworks.toolbox.coder.wfa.files.MultiFileSetView;
import com.mathworks.toolbox.coder.wfa.files.SidebarDecorationContext;
import com.mathworks.util.Converter;
import com.mathworks.util.MulticastChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeListener;

abstract class AbstractIDEFileSidebar
implements IDEFileSidebar {
    private final Map<String, FileSetEntry> fSetEntries;
    private final Map<FileSetView, FileSetEntry> fLookups;
    private final MulticastChangeListener fGlobalChangeListener;
    private final Set<String> fVisibleKeys;
    private final FileSetViewGroup fFileSets;
    private final FileSetSidebarWidget fSidebar;
    private final EditorView fEditorView;
    private final CoderApp fApp;
    private UnifiedModel fUnifiedModel;

    AbstractIDEFileSidebar(CoderApp coderApp, EditorView editorView, FileSetSidebarWidget fileSetSidebarWidget) {
        this.fApp = coderApp;
        this.fSidebar = fileSetSidebarWidget;
        this.fEditorView = editorView;
        this.fGlobalChangeListener = new MulticastChangeListener();
        this.fLookups = new HashMap<FileSetView, FileSetEntry>();
        this.fSetEntries = new HashMap<String, FileSetEntry>();
        this.fVisibleKeys = new HashSet<String>();
        this.fFileSets = new FileSetViewGroup();
        this.useDefaultSidebarConfiguration();
    }

    abstract void buildDefaultSidebar();

    void addFileSet(String string, String string2, boolean bl) {
        assert (MJUtilities.isEventDispatchThread());
        FileSetEntry fileSetEntry = new FileSetEntry(string, string2, bl);
        this.fSetEntries.put(string, fileSetEntry);
        this.fLookups.put(fileSetEntry.getView(), fileSetEntry);
    }

    void removeFileSet(String string) {
        assert (MJUtilities.isEventDispatchThread());
        FileSetEntry fileSetEntry = this.fSetEntries.remove(string);
        fileSetEntry.getView().removeAll();
        this.fSidebar.removeFileSetPanel(string);
        this.fFileSets.remove(fileSetEntry.getView());
        this.fLookups.remove(fileSetEntry.getView());
        fileSetEntry.setVisible(false);
    }

    CoderApp getApp() {
        return this.fApp;
    }

    EditorView getEditorView() {
        return this.fEditorView;
    }

    FileSetViewGroup getFileSets() {
        return this.fFileSets;
    }

    void setFileSetVisible(String string, boolean bl) {
        this.fSetEntries.get(string).setVisible(bl);
    }

    MultiFileSetView getRootFileSetView(String string) {
        return this.fSetEntries.containsKey(string) ? this.fSetEntries.get(string).getView() : null;
    }

    @Override
    public void updateAll() {
        for (FileSetEntry fileSetEntry : new LinkedList<FileSetEntry>(this.fSetEntries.values())) {
            fileSetEntry.getView().update();
        }
    }

    @Override
    public void setCurrentUnifiedModel(UnifiedModel unifiedModel) {
        this.fUnifiedModel = unifiedModel;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.fGlobalChangeListener.addChangeListener(changeListener);
        } else {
            for (String string : stringArray) {
                if (!this.fSetEntries.containsKey(string)) continue;
                this.fSetEntries.get(string).addChangeListener(changeListener);
            }
        }
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.fGlobalChangeListener.removeChangeListener(changeListener);
        for (FileSetEntry fileSetEntry : new LinkedList<FileSetEntry>(this.fSetEntries.values())) {
            fileSetEntry.removeChangeListener(changeListener);
        }
    }

    @Override
    public void setFiles(String string, Collection<File> collection) {
        if (this.fSetEntries.containsKey(string)) {
            this.fSetEntries.get(string).setFiles(collection);
        }
    }

    @Override
    public void setVisibleFileSetView(String string, FileSetView fileSetView) {
        if (this.fSetEntries.containsKey(string)) {
            this.fSetEntries.get(string).getView().setActiveView(fileSetView);
        }
    }

    @Override
    public boolean installFileSetView(FileSetView fileSetView, String string) {
        if (this.fLookups.containsKey(fileSetView) || !this.fSetEntries.containsKey(string)) {
            return false;
        }
        FileSetEntry fileSetEntry = this.fSetEntries.get(string);
        fileSetEntry.getView().addSubView(fileSetView);
        this.fLookups.put(fileSetView, fileSetEntry);
        return true;
    }

    @Override
    public boolean installFileSetView(Converter<FileSetIntegrationContext, FileSetView> converter, String string) {
        FileSetView fileSetView;
        if (this.fSetEntries.containsKey(string) && (fileSetView = (FileSetView)converter.convert((Object)this.fSetEntries.get(string))) != null) {
            return this.installFileSetView(fileSetView, string);
        }
        return false;
    }

    @Override
    public void uninstallFileSetView(FileSetView fileSetView, String string) {
        if (this.fSetEntries.containsKey(string)) {
            this.fSetEntries.get(string).getView().removeSubView(fileSetView);
            this.fLookups.remove(fileSetView);
        }
    }

    @Override
    public <T> T getFileSetViewByType(Class<T> clazz) {
        Collection<T> collection = this.getFileSetViewsByType(clazz);
        return !collection.isEmpty() ? (T)collection.iterator().next() : null;
    }

    @Override
    public <T> Collection<T> getFileSetViewsByType(Class<T> clazz) {
        LinkedList<T> linkedList = new LinkedList<T>();
        for (FileSetView fileSetView : new LinkedList<FileSetView>(this.fLookups.keySet())) {
            if (!clazz.isInstance(fileSetView)) continue;
            linkedList.add(clazz.cast(fileSetView));
        }
        return linkedList;
    }

    @Override
    public void setSupportedFileSetKeys(Set<String> set) {
        Set<String> set2 = set;
        if (set2 == null) {
            set2 = new HashSet<String>(this.fSetEntries.keySet());
        }
        this.fVisibleKeys.clear();
        this.fVisibleKeys.addAll(set2);
        for (Map.Entry<String, FileSetEntry> entry : this.fSetEntries.entrySet()) {
            entry.getValue().setVisible(this.fVisibleKeys.contains(entry.getKey()));
        }
    }

    @Override
    public void useDefaultSidebarConfiguration() {
        for (String string : new LinkedList<String>(this.fSetEntries.keySet())) {
            this.removeFileSet(string);
        }
        this.buildDefaultSidebar();
    }

    @Override
    public File getSelectedFile(String string) {
        return this.fSetEntries.get(string).getView().getSelectedFile();
    }

    @Override
    public Function getSelectedFunction(String string) {
        return this.fSetEntries.get(string).getView().getSelectedFunction();
    }

    @Override
    public FileSetIntegrationContext getFileSetIntegrationContext(String string) {
        return this.fSetEntries.containsKey(string) ? this.fSetEntries.get(string) : null;
    }

    private class FileSetEntry
    implements FileSetIntegrationContext {
        private final MultiFileSetView fView;
        private final MulticastChangeListener fChangeListener;
        private final Set<File> fFiles;
        private final String fKey;
        private final String fLabel;
        private boolean fVisible = false;

        private FileSetEntry(String string, String string2, boolean bl) {
            this.fKey = string;
            this.fLabel = string2;
            this.fChangeListener = new MulticastChangeListener();
            this.fFiles = new LinkedHashSet<File>();
            this.fView = new MultiFileSetView((FileSetIntegrationContext)this, new FileSetView[0]);
            AbstractIDEFileSidebar.this.fSidebar.addFileSetPanel(this.fKey, this.fLabel, this.getView().getComponent());
            this.setVisible(bl);
        }

        private void addChangeListener(ChangeListener changeListener) {
            this.fChangeListener.addChangeListener(changeListener);
        }

        private void removeChangeListener(ChangeListener changeListener) {
            this.fChangeListener.removeChangeListener(changeListener);
        }

        private MultiFileSetView getView() {
            return this.fView;
        }

        private void setFiles(Collection<File> collection) {
            this.fFiles.clear();
            this.fFiles.addAll(collection);
            this.fView.update();
        }

        private void setVisible(boolean bl) {
            if (bl && !this.fVisible) {
                AbstractIDEFileSidebar.this.fVisibleKeys.add(this.fKey);
                AbstractIDEFileSidebar.this.fFileSets.add(this.getView());
            } else if (!bl && this.fVisible) {
                AbstractIDEFileSidebar.this.fFileSets.remove(this.getView());
                AbstractIDEFileSidebar.this.fVisibleKeys.remove(this.fKey);
            }
            this.fVisible = bl;
            AbstractIDEFileSidebar.this.fSidebar.setVisibleFileSets(new HashSet<String>(AbstractIDEFileSidebar.this.fVisibleKeys));
        }

        @Override
        public CoderApp getApp() {
            return AbstractIDEFileSidebar.this.fApp;
        }

        @Override
        public UnifiedModel getSourceModel() {
            return AbstractIDEFileSidebar.this.fUnifiedModel != null ? AbstractIDEFileSidebar.this.fUnifiedModel : this.getApp().getModel().getInferenceModel();
        }

        @Override
        public Set<File> getFiles() {
            return new LinkedHashSet<File>(this.fFiles);
        }

        @Override
        public SidebarDecorationContext getSidebarIntegrationContext() {
            return AbstractIDEFileSidebar.this.fSidebar.getSidebarDecorationContext(this.fKey);
        }

        @Override
        public EditorView getEditorView() {
            return AbstractIDEFileSidebar.this.fEditorView;
        }
    }
}

