/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.matlab.api.editor.EditorLayer;
import com.mathworks.matlab.api.editor.EditorLayerProvider;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.services.FontPrefs;
import com.mathworks.toolbox.coder.app.ide.CodeCoverageBar;
import com.mathworks.toolbox.coder.app.ide.EditorContextActionProvider;
import com.mathworks.toolbox.coder.app.ide.EditorSupport;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.app.ide.EditorViewRegistry;
import com.mathworks.toolbox.coder.app.ide.LineNumberPane;
import com.mathworks.widgets.text.MWKit;
import com.mathworks.widgets.text.ViewHierarchyChangeEvent;
import com.mathworks.widgets.text.ViewHierarchyChangeListener;
import com.mathworks.widgets.text.fold.MWCodeFoldingSideBar;
import com.mathworks.widgets.text.mcode.MEditorUI;
import com.mathworks.widgets.text.mcode.MKit;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerEditorLayerProvider;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightingEditorLayerProvider;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightingLayer;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.EditorUI;

final class CoderMKit
extends MKit {
    private static final String KEY_CODER_CONTEXT_MENU_ITEM = "coder-context-menu-flag";
    private final Action fContextMenuAction;
    private final EditorView fEditor;
    private VariableHighlightingLayer fLayer;

    CoderMKit(EditorView editorView) {
        this.fEditor = editorView;
        this.fContextMenuAction = new CoderContextMenuAction();
    }

    void setHighlightingEnabled(JTextComponent jTextComponent, boolean bl) {
        if (this.fLayer != null) {
            if (bl) {
                this.fLayer.enable(jTextComponent);
            } else {
                this.fLayer.disable();
            }
        }
    }

    public String getContentType() {
        return MLanguage.INSTANCE.getMimeType();
    }

    protected EditorUI createEditorUI() {
        return new CoderMEditorUI();
    }

    protected boolean supportsCodeFolding() {
        return true;
    }

    protected Action[] createActions() {
        Action[] actionArray = super.createActions();
        Action[] actionArray2 = new Action[actionArray.length + 1];
        System.arraycopy(actionArray, 0, actionArray2, 0, actionArray.length);
        actionArray2[actionArray2.length - 1] = this.fContextMenuAction;
        return actionArray2;
    }

    private void removeExistingItems(JPopupMenu jPopupMenu) {
        for (Component component : Arrays.asList(jPopupMenu.getComponents())) {
            Object object;
            if (!(component instanceof JComponent) || (object = ((JComponent)component).getClientProperty(KEY_CODER_CONTEXT_MENU_ITEM)) == null || !object.equals(Boolean.TRUE)) continue;
            jPopupMenu.remove(component);
        }
    }

    class CoderMEditorUI
    extends MEditorUI
    implements EditorSupport.CoderEditorUI {
        private JScrollPane fScrollPane;
        private VariableHighlightingLayer fLayer;
        private MWCodeFoldingSideBar fSidebar;
        private LineNumberPane fLineNumberPane;
        private CodeCoverageBar fCoverageBar;
        private JComponent fWrapper;

        CoderMEditorUI() {
            super(false, (MEditorUI.EditorLayerProviderContributor)new CoderMLayerProvider());
        }

        @Override
        public JComponent createExtComponent() {
            if (this.fSidebar == null) {
                this.fSidebar = new MWCodeFoldingSideBar(this.getComponent()){

                    protected Color getBackColor() {
                        Color color = super.getBackColor();
                        if (CoderMKit.this.fEditor.getTextPane() != null) {
                            color = CoderMKit.this.fEditor.getTextPane().getBackground();
                        }
                        return color;
                    }
                };
                this.fSidebar.addViewHierarchyChangeListener(new ViewHierarchyChangeListener(){

                    public void viewHierarchyChanged(ViewHierarchyChangeEvent viewHierarchyChangeEvent) {
                        CoderMEditorUI.this.refresh();
                    }
                });
            }
            if (this.fLineNumberPane == null) {
                this.fLineNumberPane = new LineNumberPane(FontPrefs.getCodeFont(), CoderMKit.this.fEditor);
                this.getComponent().getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        CoderMEditorUI.this.fLineNumberPane.update();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        CoderMEditorUI.this.fLineNumberPane.update();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        CoderMEditorUI.this.fLineNumberPane.update();
                    }
                });
            }
            if (this.fCoverageBar == null) {
                this.fCoverageBar = new CodeCoverageBar(CoderMKit.this.fEditor, FontPrefs.getCodeFont(), new Runnable(){

                    @Override
                    public void run() {
                        CoderMEditorUI.this.refresh();
                    }
                });
            }
            boolean bl = this.fScrollPane == null;
            this.fScrollPane = EditorSupport.wrapIntoScrollPane((Component)((Object)this.fLineNumberPane), (Component)((Object)this.fCoverageBar), (Component)this.fSidebar, this.getComponent(), this.fScrollPane);
            if (bl) {
                this.fScrollPane.getViewport().addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        if (CoderMKit.this.fEditor.getPopupController() != null) {
                            CoderMKit.this.fEditor.getPopupController().updatePopup();
                        }
                    }
                });
            }
            return this.fScrollPane;
        }

        public MWCodeFoldingSideBar getFoldSideBar() {
            return this.fSidebar;
        }

        CodeCoverageBar getCoverageBar() {
            return this.fCoverageBar;
        }

        private void refresh() {
            if (this.fCoverageBar != null) {
                this.fCoverageBar.setVisible(this.fCoverageBar.hasModel());
            }
            JComponent jComponent = this.getExtComponent();
            ((Component)jComponent).revalidate();
            jComponent.repaint();
        }
    }

    private class CoderMLayerProvider
    implements MEditorUI.EditorLayerProviderContributor {
        private CoderMLayerProvider() {
        }

        public Collection<EditorLayerProvider> getContributors() {
            return Arrays.asList(new CodeAnalyzerEditorLayerProvider(), new VariableHighlightingEditorLayerProvider(){

                public EditorLayer createEditorLayer() {
                    CoderMKit.this.fLayer = (VariableHighlightingLayer)super.createEditorLayer();
                    return CoderMKit.this.fLayer;
                }
            });
        }
    }

    private class CoderContextMenuAction
    extends MWKit.MWBuildPopupMenuAction {
        private CoderContextMenuAction() {
        }

        protected JPopupMenu buildPopupMenu(JTextComponent jTextComponent) {
            JPopupMenu jPopupMenu = super.buildPopupMenu(jTextComponent);
            CoderMKit.this.removeExistingItems(jPopupMenu);
            EditorView editorView = EditorViewRegistry.getEditorView(jTextComponent);
            if (editorView == null) {
                return jPopupMenu;
            }
            int n = -1;
            if (editorView.getMousePoint() != null) {
                try {
                    n = editorView.getTextPane().getPosFromPoint(editorView.getMousePoint());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            for (EditorContextActionProvider editorContextActionProvider : new LinkedList<EditorContextActionProvider>(editorView.getContextActionProviders())) {
                List<? extends Action> list;
                if (editorView.getCurrentFunction() == null || (list = editorContextActionProvider.contributeContextMenuActions(editorView, editorView.getCurrentFunction(), n)) == null) continue;
                if (!list.isEmpty()) {
                    JPopupMenu.Separator separator = new JPopupMenu.Separator();
                    separator.putClientProperty(CoderMKit.KEY_CODER_CONTEXT_MENU_ITEM, Boolean.TRUE);
                    jPopupMenu.add(separator);
                }
                for (Action action : list) {
                    MJMenuItem mJMenuItem = new MJMenuItem(action);
                    mJMenuItem.putClientProperty(CoderMKit.KEY_CODER_CONTEXT_MENU_ITEM, Boolean.TRUE);
                    jPopupMenu.add((Component)mJMenuItem);
                }
            }
            return jPopupMenu;
        }
    }
}

