/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.toolbox.coder.app.ide.EditorLoadContext;
import com.mathworks.toolbox.coder.app.ide.EditorSupport;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.plugin.Utilities;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultEditorLoadContext
implements EditorLoadContext {
    private final Function fFunction;
    private final File fFile;
    private final String fContentType;
    private final long fOriginallyModified;
    private final long fOriginalSize;

    public DefaultEditorLoadContext(Function function) {
        this(function, function.getFile(), EditorSupport.getContentType(function.getFile()));
    }

    public DefaultEditorLoadContext(File file) {
        this(null, file, EditorSupport.getContentType(file));
    }

    private DefaultEditorLoadContext(@Nullable Function function, @NotNull File file, String string) {
        this.fContentType = string;
        this.fFunction = function;
        this.fFile = file;
        this.fOriginallyModified = this.fFile != null ? this.fFile.lastModified() : 0L;
        this.fOriginalSize = this.fFile != null ? this.fFile.length() : 0L;
    }

    @Override
    public String getContentType() {
        return this.fContentType;
    }

    @Override
    public long getOriginallyModified() {
        return this.fOriginallyModified;
    }

    @Override
    public boolean hasFunction() {
        return this.fFunction != null;
    }

    @Override
    public boolean hasFile() {
        return this.getFile() != null;
    }

    @Override
    public Function getFunction() {
        return this.fFunction;
    }

    @Override
    public File getFile() {
        return this.fFile;
    }

    @Override
    public boolean isSameFile(File file) {
        return !Utilities.areValuesDifferent(file, this.getFile());
    }

    @Override
    @Nullable
    public String loadText() throws IOException {
        return this.getFile() != null ? CoderFileSupport.readMatlabSource(this.getFile()) : null;
    }

    @Override
    public void saveText(String string) throws IOException {
        if (this.getFile() != null) {
            CoderFileSupport.writeMatlabSource(string, this.getFile());
        }
    }

    @Override
    public boolean hasChanged() {
        return this.getFile() != null && (this.getFile().lastModified() != this.fOriginallyModified || this.getFile().length() != this.fOriginalSize);
    }

    @Override
    public boolean exists() {
        return this.getFile() != null && this.getFile().exists();
    }

    @Override
    public DefaultEditorLoadContext derive() {
        if (this.getFunction() != null) {
            return new DefaultEditorLoadContext(this.getFunction());
        }
        return new DefaultEditorLoadContext(this.getFile());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !EditorLoadContext.class.isAssignableFrom(this.getClass())) {
            return false;
        }
        EditorLoadContext editorLoadContext = (EditorLoadContext)object;
        if (this.fOriginallyModified != editorLoadContext.getOriginallyModified()) {
            return false;
        }
        if (this.fContentType != null ? !this.fContentType.equals(editorLoadContext.getContentType()) : editorLoadContext.getContentType() != null) {
            return false;
        }
        if (this.fFile != null ? !this.fFile.equals(editorLoadContext.getFile()) : editorLoadContext.getFile() != null) {
            return false;
        }
        return !(this.fFunction != null ? !this.fFunction.equals(editorLoadContext.getFunction()) : editorLoadContext.getFunction() != null);
    }

    public int hashCode() {
        int n = this.fFunction != null ? this.fFunction.hashCode() : 0;
        n = 31 * n + (this.fFile != null ? this.fFile.hashCode() : 0);
        n = 31 * n + (this.fContentType != null ? this.fContentType.hashCode() : 0);
        n = 31 * n + (int)(this.fOriginallyModified ^ this.fOriginallyModified >>> 32);
        return n;
    }
}

