/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorApplication;
import com.mathworks.matlab.api.editor.EditorApplicationListener;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.netbeans.editor.BaseDocument;

final class DesktopDocumentBinder {
    private static final DesktopDocumentBinder SINGLETON = new DesktopDocumentBinder();
    private final Map<File, BindingContext> fBindings = new HashMap<File, BindingContext>();
    private final Map<Object, EditorContext> fEditors = new HashMap<Object, EditorContext>();
    private final EditorApplicationListener fMatlabListener = new EditorApplicationListener(){

        public void editorOpened(Editor editor) {
            DesktopDocumentBinder.this.registerMatlabEditor(editor);
        }

        public void editorClosed(Editor editor) {
            DesktopDocumentBinder.this.unregisterMatlabEditor(editor);
        }
    };
    private boolean fMonitoringMatlab;

    private DesktopDocumentBinder() {
    }

    static DesktopDocumentBinder getInstance() {
        return SINGLETON;
    }

    void registerCoderEditor(EditorView editorView) {
        boolean bl = this.hasNonMatlabEditors();
        this.registerEditor(editorView, new CoderEditorBridge(editorView));
        if (!bl) {
            this.startMonitoringMatlabEditors();
        }
    }

    private void registerMatlabEditor(Editor editor) {
        this.registerEditor(editor, new MatlabEditorBridge(editor));
    }

    private void registerEditor(Object object, EditorBridge<?> editorBridge) {
        if (!this.fEditors.containsKey(object)) {
            this.fEditors.put(object, new EditorContext(editorBridge));
        }
    }

    void unregisterCoderEditor(EditorView editorView) {
        this.unregisterEditor(editorView);
        if (!this.hasNonMatlabEditors()) {
            this.stopMonitoringMatlabEditors();
        }
    }

    private void unregisterMatlabEditor(Editor editor) {
        this.unregisterEditor(editor);
    }

    private void unregisterEditor(Object object) {
        EditorContext editorContext = this.fEditors.remove(object);
        if (editorContext != null) {
            editorContext.update(null);
        }
    }

    private void startMonitoringMatlabEditors() {
        if (this.fMonitoringMatlab) {
            return;
        }
        EditorApplication editorApplication = MLEditorServices.getEditorApplication();
        for (Editor editor : editorApplication.getOpenEditors()) {
            this.registerMatlabEditor(editor);
        }
        editorApplication.addEditorApplicationListener(this.fMatlabListener);
        this.fMonitoringMatlab = true;
    }

    private void stopMonitoringMatlabEditors() {
        if (!this.fMonitoringMatlab) {
            return;
        }
        MLEditorServices.getEditorApplication().removeEditorApplicationListener(this.fMatlabListener);
        for (Object e : new LinkedList<Object>(this.fEditors.keySet())) {
            if (!(e instanceof Editor)) continue;
            this.unregisterMatlabEditor((Editor)e);
        }
        this.fMonitoringMatlab = false;
    }

    private boolean hasNonMatlabEditors() {
        for (Object object : this.fEditors.keySet()) {
            if (object instanceof Editor) continue;
            return true;
        }
        return false;
    }

    private static void replaceText(Document document, Document document2) throws BadLocationException {
        DesktopDocumentBinder.replaceText(document2, document.getText(0, document.getLength()));
    }

    private static void replaceText(Document document, String string) throws BadLocationException {
        if (!document.getText(0, document.getLength()).equals(string)) {
            if (document instanceof BaseDocument) {
                ((BaseDocument)document).replace(0, document.getLength(), string, null);
            } else {
                document.remove(0, document.getLength());
                document.insertString(0, string, null);
            }
        }
    }

    private static class RemovalChangeApplier
    implements ParameterRunnable<Document> {
        private final int fStart;
        private final int fLen;

        private RemovalChangeApplier(DocumentEvent documentEvent) {
            this.fStart = documentEvent.getOffset();
            this.fLen = documentEvent.getLength();
        }

        public void run(Document document) {
            try {
                document.remove(this.fStart, this.fLen);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private static class ReplacementChangeApplier
    implements ParameterRunnable<Document> {
        private final String fText;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ReplacementChangeApplier(DocumentEvent documentEvent) {
            String string = null;
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                this.fText = string;
            }
        }

        public void run(Document document) {
            if (this.fText != null) {
                try {
                    DesktopDocumentBinder.replaceText(document, this.fText);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    private static class InsertionChangeApplier
    implements ParameterRunnable<Document> {
        private final String fText;
        private final int fOffset;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InsertionChangeApplier(DocumentEvent documentEvent) {
            this.fOffset = documentEvent.getOffset();
            String string = null;
            try {
                string = documentEvent.getDocument().getText(this.fOffset, documentEvent.getLength());
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                this.fText = string;
            }
        }

        public void run(Document document) {
            if (this.fText != null) {
                try {
                    document.insertString(this.fOffset, this.fText, null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    static abstract class EditorBridge<T> {
        private final T fEditor;

        EditorBridge(@NotNull T t) {
            this.fEditor = t;
        }

        public boolean equals(Object object) {
            return object != null && object instanceof EditorBridge && this.getEditor().equals(((EditorBridge)object).getEditor());
        }

        public int hashCode() {
            return this.fEditor.hashCode();
        }

        Document getDocument() {
            JTextComponent jTextComponent = this.getTextComponent();
            if (jTextComponent != null) {
                return jTextComponent.getDocument();
            }
            return null;
        }

        T getEditor() {
            return this.fEditor;
        }

        abstract void attachFileListener(ParameterRunnable<File> var1);

        abstract void detachFileListener(ParameterRunnable<File> var1);

        abstract File getCurrentFile();

        abstract JTextComponent getTextComponent();
    }

    private static class MatlabEditorBridge
    extends EditorBridge<Editor> {
        private MatlabEditorBridge(@NotNull Editor editor) {
            super(editor);
        }

        @Override
        void attachFileListener(ParameterRunnable<File> parameterRunnable) {
        }

        @Override
        void detachFileListener(ParameterRunnable<File> parameterRunnable) {
        }

        @Override
        File getCurrentFile() {
            StorageLocation storageLocation = ((Editor)this.getEditor()).getStorageLocation();
            return storageLocation != null && storageLocation instanceof FileStorageLocation ? ((FileStorageLocation)storageLocation).getFile() : null;
        }

        @Override
        JTextComponent getTextComponent() {
            return ((Editor)this.getEditor()).getTextComponent();
        }
    }

    private static class CoderEditorBridge
    extends EditorBridge<EditorView>
    implements ParameterRunnable<EditorView> {
        private ParameterRunnable<File> fChangeCallback;

        CoderEditorBridge(EditorView editorView) {
            super(editorView);
        }

        @Override
        void attachFileListener(ParameterRunnable<File> parameterRunnable) {
            this.fChangeCallback = parameterRunnable;
            ((EditorView)this.getEditor()).addFileLoadedCallback(this, false);
        }

        @Override
        void detachFileListener(ParameterRunnable<File> parameterRunnable) {
            this.fChangeCallback = null;
            ((EditorView)this.getEditor()).removeFileLoadedCallback(this);
        }

        @Override
        JTextComponent getTextComponent() {
            return ((EditorView)this.getEditor()).getTextPane();
        }

        @Override
        File getCurrentFile() {
            return ((EditorView)this.getEditor()).getCurrentFile();
        }

        public void run(EditorView editorView) {
            if (this.fChangeCallback != null) {
                this.fChangeCallback.run((Object)editorView.getCurrentFile());
            }
        }
    }

    private static class BindingContext {
        private final Map<EditorBridge<?>, MultiListener> fListeners = new HashMap();
        private boolean fSuppressed;

        BindingContext() {
        }

        void addBoundClient(EditorBridge<?> editorBridge) {
            Object object;
            JTextComponent jTextComponent = editorBridge.getTextComponent();
            if (jTextComponent == null || jTextComponent.getDocument() == null) {
                return;
            }
            Document document = jTextComponent.getDocument();
            if (!this.fListeners.isEmpty()) {
                object = this.fListeners.keySet().iterator().next();
                if (!jTextComponent.getText().equals(((EditorBridge)object).getTextComponent().getText())) {
                    try {
                        DesktopDocumentBinder.replaceText(((EditorBridge)object).getDocument(), document);
                    }
                    catch (BadLocationException badLocationException) {
                        return;
                    }
                }
            }
            object = new MultiListener(editorBridge, document);
            this.fListeners.put(editorBridge, (MultiListener)object);
            document.addDocumentListener((DocumentListener)object);
            jTextComponent.addPropertyChangeListener((PropertyChangeListener)object);
        }

        void removeBoundClient(EditorBridge<?> editorBridge) {
            JTextComponent jTextComponent;
            MultiListener multiListener = this.fListeners.remove(editorBridge);
            if (multiListener != null && (jTextComponent = editorBridge.getTextComponent()) != null) {
                jTextComponent.removePropertyChangeListener(multiListener);
                Document document = jTextComponent.getDocument();
                if (document != null) {
                    document.removeDocumentListener(multiListener);
                }
            }
        }

        boolean isEmpty() {
            return this.fListeners.isEmpty();
        }

        private void updateAllDocuments(DocumentEvent documentEvent, EditorBridge<?> editorBridge, DocumentEvent.EventType eventType) {
            Document document = editorBridge.getDocument();
            if (document == null) {
                return;
            }
            Object object = eventType == DocumentEvent.EventType.INSERT ? new InsertionChangeApplier(documentEvent) : (eventType == DocumentEvent.EventType.REMOVE ? new RemovalChangeApplier(documentEvent) : new ReplacementChangeApplier(documentEvent));
            this.fSuppressed = true;
            for (EditorBridge editorBridge2 : new LinkedList(this.fListeners.keySet())) {
                Document document2;
                if (editorBridge2.equals(editorBridge) || (document2 = editorBridge2.getDocument()) == null) continue;
                object.run((Object)document2);
            }
            this.fSuppressed = false;
        }

        private class MultiListener
        implements DocumentListener,
        PropertyChangeListener {
            private final EditorBridge<?> fEditorBridge;
            private Document fDocument;

            MultiListener(@NotNull EditorBridge<?> editorBridge, Document document) {
                this.fEditorBridge = editorBridge;
                this.fDocument = document;
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (!BindingContext.this.fSuppressed) {
                    BindingContext.this.updateAllDocuments(documentEvent, this.fEditorBridge, DocumentEvent.EventType.INSERT);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (!BindingContext.this.fSuppressed) {
                    BindingContext.this.updateAllDocuments(documentEvent, this.fEditorBridge, DocumentEvent.EventType.REMOVE);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                if (!BindingContext.this.fSuppressed) {
                    BindingContext.this.updateAllDocuments(documentEvent, this.fEditorBridge, DocumentEvent.EventType.CHANGE);
                }
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("document")) {
                    this.fDocument.removeDocumentListener(this);
                    this.fDocument = (Document)propertyChangeEvent.getNewValue();
                    if (this.fDocument != null) {
                        this.fDocument.addDocumentListener(this);
                    }
                }
            }
        }
    }

    private class EditorContext
    implements ParameterRunnable<File> {
        private final EditorBridge<?> fEditorBridge;
        private File fCurrentFile;

        EditorContext(EditorBridge<?> editorBridge) {
            this.fEditorBridge = editorBridge;
            this.fEditorBridge.attachFileListener(this);
            this.update(this.fEditorBridge.getCurrentFile());
        }

        public void run(File file) {
            this.update(file);
        }

        void update(File file) {
            BindingContext bindingContext;
            if (this.fCurrentFile != null && DesktopDocumentBinder.this.fBindings.containsKey(this.fCurrentFile)) {
                bindingContext = (BindingContext)DesktopDocumentBinder.this.fBindings.get(this.fCurrentFile);
                bindingContext.removeBoundClient(this.fEditorBridge);
                if (bindingContext.isEmpty()) {
                    DesktopDocumentBinder.this.fBindings.remove(bindingContext);
                }
            }
            this.fCurrentFile = file;
            if (file != null) {
                bindingContext = (BindingContext)DesktopDocumentBinder.this.fBindings.get(file);
                if (bindingContext == null) {
                    bindingContext = new BindingContext();
                    DesktopDocumentBinder.this.fBindings.put(file, bindingContext);
                }
                bindingContext.addBoundClient(this.fEditorBridge);
            }
        }
    }
}

