/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.util.CoderLogger;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nullable;

final class EditorViewRegistry {
    private static final CoderLogger LOGGER = new CoderLogger(EditorViewRegistry.class);
    private static final Map<JTextComponent, EditorView> TEXTPANES_TO_EDITORS = new HashMap<JTextComponent, EditorView>();

    private EditorViewRegistry() {
    }

    @Nullable
    static EditorView getEditorView(JTextComponent jTextComponent) {
        return TEXTPANES_TO_EDITORS.get(jTextComponent);
    }

    static void registerEditorView(EditorView editorView) {
        assert (editorView.getTextPane() != null);
        TEXTPANES_TO_EDITORS.put((JTextComponent)editorView.getTextPane(), editorView);
        LOGGER.debug("EditorView registered: %s", editorView);
    }

    static void unregisterEditorView(EditorView editorView) {
        TEXTPANES_TO_EDITORS.remove(editorView.getTextPane());
        LOGGER.debug("EditorView unregistered: %s", editorView);
    }
}

