/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.util.CoderLogger;
import com.mathworks.util.event.GlobalEventListener;
import com.mathworks.util.event.GlobalEventManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

public class FileMonitor {
    private static final Watcher SINGLETON = new Watcher();
    private final Executor fDispatchThread;
    private final Collection<FileChangeObserver> fChangeObservers;
    private final Set<File> fFiles;
    private final Object fMutex;

    public FileMonitor() {
        this(new Executor(){

            @Override
            public void execute(final @NotNull Runnable runnable) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        runnable.run();
                    }
                });
            }
        });
    }

    public FileMonitor(Executor executor) {
        this.fDispatchThread = executor;
        this.fFiles = new HashSet<File>();
        this.fMutex = new Object();
        this.fChangeObservers = new LinkedList<FileChangeObserver>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean watchFile(File file) {
        Object object = this.fMutex;
        synchronized (object) {
            try {
                if (this.fFiles.add(file)) {
                    SINGLETON.addFile(this, file);
                }
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(File file) {
        Object object = this.fMutex;
        synchronized (object) {
            if (this.fFiles.remove(file)) {
                SINGLETON.removeFile(this, file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.fMutex;
        synchronized (object) {
            for (File file : this.fFiles) {
                SINGLETON.removeFile(this, file);
            }
            this.fFiles.clear();
        }
    }

    public void dispose() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileChangeObserver(FileChangeObserver fileChangeObserver) {
        Object object = this.fMutex;
        synchronized (object) {
            this.fChangeObservers.add(fileChangeObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileChangeObserver(FileChangeObserver fileChangeObserver) {
        Object object = this.fMutex;
        synchronized (object) {
            this.fChangeObservers.remove(fileChangeObserver);
        }
    }

    private void notifyObservers(final File file) {
        this.fDispatchThread.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LinkedList linkedList;
                Iterator iterator = FileMonitor.this.fMutex;
                synchronized (iterator) {
                    linkedList = new LinkedList(FileMonitor.this.fChangeObservers);
                }
                for (FileChangeObserver fileChangeObserver : linkedList) {
                    fileChangeObserver.fileChanged(file);
                }
            }
        });
    }

    public static interface FileChangeObserver {
        public void fileChanged(File var1);
    }

    private static class PathContext {
        private final FileTime fLastModified;
        private final long fSize;

        PathContext(FileTime fileTime, long l) {
            this.fLastModified = fileTime;
            this.fSize = l;
        }

        PathContext(Path path) throws IOException {
            this(Files.getLastModifiedTime(path, new LinkOption[0]), Files.size(path));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PathContext)) {
                return false;
            }
            PathContext pathContext = (PathContext)object;
            return this.fSize == pathContext.fSize && this.fLastModified.equals(pathContext.fLastModified);
        }

        public int hashCode() {
            return 31 * this.fLastModified.hashCode() + (int)(this.fSize ^ this.fSize >>> 32);
        }
    }

    private static class Watcher {
        private static final String SHUTDOWN_KEY = "shutdown";
        private final Map<Path, DirectoryContext> fDirContexts = new HashMap<Path, DirectoryContext>();
        private final Map<Path, PathContext> fPathContexts = new HashMap<Path, PathContext>();
        private final GlobalEventListener fGlobalEventListener;
        private final CoderLogger fLogger = new CoderLogger(this);
        private ExecutorService fThread;
        private WatchContext fWatchContext;

        Watcher() {
            this.fGlobalEventListener = new GlobalEventListener(){

                public void actionPerformed(String string) {
                    if (string.equals(Watcher.SHUTDOWN_KEY)) {
                        Watcher.this.stopMonitoring();
                    }
                }
            };
        }

        synchronized void addFile(FileMonitor fileMonitor, File file) throws IOException {
            Path path = Watcher.keyablePath(file.isDirectory() ? file.toPath() : file.getParentFile().toPath());
            DirectoryContext directoryContext = this.fDirContexts.get(path);
            if (directoryContext == null) {
                directoryContext = new DirectoryContext();
                this.fDirContexts.put(path, directoryContext);
                if (!this.isMonitoring()) {
                    this.startMonitoring();
                }
            }
            directoryContext.addFile(file, fileMonitor);
            try {
                file.getParentFile().toPath().register(this.fWatchContext.getWatchService(), StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            catch (ClosedWatchServiceException closedWatchServiceException) {
                this.fLogger.error("Error registering watch: {}", closedWatchServiceException);
            }
        }

        synchronized void removeFile(FileMonitor fileMonitor, File file) {
            Path path = Watcher.keyablePath(file.isDirectory() ? file.toPath() : file.getParentFile().toPath());
            DirectoryContext directoryContext = this.fDirContexts.get(path);
            if (directoryContext != null) {
                directoryContext.removeFile(file, fileMonitor);
                if (directoryContext.isEmpty()) {
                    this.fDirContexts.remove(path);
                }
            }
            if (this.fDirContexts.isEmpty() && this.isMonitoring()) {
                this.stopMonitoring();
            }
        }

        private synchronized boolean isMonitoring() {
            return this.fWatchContext != null;
        }

        private synchronized void startMonitoring() throws IOException {
            if (!this.isMonitoring()) {
                this.fThread = Executors.newSingleThreadExecutor();
                this.fWatchContext = new WatchContext(FileSystems.getDefault().newWatchService());
                this.fThread.execute(this.fWatchContext);
                GlobalEventManager.addListener((String)SHUTDOWN_KEY, (GlobalEventListener)this.fGlobalEventListener);
            }
        }

        private synchronized void stopMonitoring() {
            if (this.isMonitoring()) {
                this.fWatchContext.stop();
                this.fWatchContext = null;
                this.fThread.shutdown();
                this.fThread = null;
                GlobalEventManager.removeListener((String)SHUTDOWN_KEY, (GlobalEventListener)this.fGlobalEventListener);
            }
        }

        private static Path keyablePath(Path path) {
            return path.toAbsolutePath();
        }

        private class WatchContext
        implements Runnable {
            private final WatchService fWatchService;
            private final Timer fPoller;
            private volatile boolean fKeepGoing;

            WatchContext(WatchService watchService) {
                this.fWatchService = watchService;
                this.fKeepGoing = true;
                this.fPoller = new Timer(true);
            }

            WatchService getWatchService() {
                return this.fWatchService;
            }

            synchronized void stop() {
                this.fKeepGoing = false;
                this.fPoller.cancel();
                try {
                    this.fWatchService.close();
                }
                catch (IOException iOException) {
                    Watcher.this.fLogger.error("Error closing watch service: {}", iOException);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.fPoller.schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        HashSet hashSet = new HashSet();
                        Watcher watcher = Watcher.this;
                        synchronized (watcher) {
                            for (Map.Entry object2 : new HashMap(Watcher.this.fPathContexts).entrySet()) {
                                try {
                                    if (new PathContext((Path)object2.getKey()).equals(object2.getValue())) continue;
                                    hashSet.add(object2.getKey());
                                    Watcher.this.fPathContexts.put(object2.getKey(), new PathContext((Path)object2.getKey()));
                                }
                                catch (IOException iOException) {
                                    Watcher.this.fLogger.error("Error during polling for file changes: %s", iOException);
                                }
                            }
                        }
                        for (Object object : hashSet) {
                            Watcher watcher2 = Watcher.this;
                            synchronized (watcher2) {
                                Path path = Watcher.keyablePath(object.getParent());
                                if (Watcher.this.fDirContexts.containsKey(path)) {
                                    ((DirectoryContext)Watcher.this.fDirContexts.get(path)).fileChanged((Path)object);
                                }
                            }
                        }
                    }
                }, 0L, 2500L);
                try {
                    while (this.fKeepGoing) {
                        WatchKey watchKey = this.fWatchService.take();
                        Path path = (Path)watchKey.watchable();
                        for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                            WatchEvent.Kind<?> kind = watchEvent.kind();
                            if (kind.equals(StandardWatchEventKinds.OVERFLOW)) continue;
                            Path path2 = Watcher.keyablePath(path.resolve((Path)watchEvent.context()));
                            Watcher watcher = Watcher.this;
                            synchronized (watcher) {
                                if (this.fKeepGoing) {
                                    PathContext pathContext;
                                    PathContext pathContext2 = (PathContext)Watcher.this.fPathContexts.get(path2);
                                    try {
                                        pathContext = new PathContext(path2);
                                    }
                                    catch (IOException iOException) {
                                        pathContext = null;
                                    }
                                    if (!(pathContext2 == null || pathContext != null && pathContext.equals(pathContext2))) {
                                        ((DirectoryContext)Watcher.this.fDirContexts.get(Watcher.keyablePath(path2.getParent()))).fileChanged(path2);
                                        if (kind.equals(StandardWatchEventKinds.ENTRY_DELETE)) {
                                            Watcher.this.removeFile(null, path2.toFile());
                                        } else if (pathContext != null) {
                                            Watcher.this.fPathContexts.put(path2, pathContext);
                                        }
                                    }
                                }
                            }
                        }
                        watchKey.reset();
                    }
                }
                catch (InterruptedException | ClosedWatchServiceException exception) {
                    Watcher.this.fLogger.error("Exception while watching files: {}", exception);
                }
                finally {
                    Watcher.this.stopMonitoring();
                }
            }
        }

        private class DirectoryContext {
            private final Map<Path, Set<FileMonitor>> fDirClients = new HashMap<Path, Set<FileMonitor>>();

            DirectoryContext() {
            }

            boolean isEmpty() {
                return this.fDirClients.isEmpty();
            }

            void addFile(File file, FileMonitor fileMonitor) throws IOException {
                Path path = Watcher.keyablePath(file.toPath());
                Watcher.this.fPathContexts.put(path, new PathContext(path));
                Set<FileMonitor> set = this.fDirClients.get(path);
                if (set == null) {
                    set = new HashSet<FileMonitor>();
                    this.fDirClients.put(path, set);
                }
                set.add(fileMonitor);
            }

            void removeFile(File file, FileMonitor fileMonitor) {
                Path path = Watcher.keyablePath(file.toPath());
                Collection collection = this.fDirClients.get(path);
                if (collection != null) {
                    if (fileMonitor != null) {
                        collection.remove(fileMonitor);
                    } else {
                        collection.clear();
                    }
                    if (collection.isEmpty()) {
                        this.fDirClients.remove(path);
                        Watcher.this.fPathContexts.remove(path);
                    }
                }
            }

            void fileChanged(Path path) {
                Collection collection = this.fDirClients.get(path);
                if (collection != null) {
                    File file = path.toFile();
                    for (FileMonitor fileMonitor : new LinkedList(collection)) {
                        fileMonitor.notifyObservers(file);
                    }
                }
            }
        }
    }
}

