/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.app.ide;

import com.mathworks.toolbox.coder.annot.BoundToProperty;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.CoderAppModel;
import com.mathworks.toolbox.coder.app.SourceSet;
import com.mathworks.toolbox.coder.app.ide.DefaultIDEFileSidebar;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.app.ide.IDEView;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.CallTree;
import com.mathworks.toolbox.coder.wfa.files.CallTreeFileSetView;
import com.mathworks.util.ParameterRunnable;
import java.io.File;
import java.util.Collection;

final class IDEPropertyBinder {
    private final CoderApp fApp;
    private final EditorView fEditorView;
    private final DefaultIDEFileSidebar fSidebarContext;
    private final IDEView fIDEView;

    IDEPropertyBinder(CoderApp coderApp, EditorView editorView, DefaultIDEFileSidebar defaultIDEFileSidebar, IDEView iDEView) {
        this.fApp = coderApp;
        this.fEditorView = editorView;
        this.fIDEView = iDEView;
        this.fSidebarContext = defaultIDEFileSidebar;
        coderApp.getModel().getPrimarySourceSet().addSourceSetObserver(new ParameterRunnable<SourceSet>(){

            public void run(SourceSet sourceSet) {
                IDEPropertyBinder.this.handleInputFilesProperty(sourceSet.getFiles());
            }
        });
    }

    void initToModel() {
        CoderAppModel coderAppModel = this.fApp.getModel();
        this.handleBuiltProperty(coderAppModel.isBuilt());
        this.handleCallTreeProperty(coderAppModel.getCallTree());
        this.handleErrorsProperty(coderAppModel.getErrors());
        this.handleInputFilesProperty(coderAppModel.getPrimarySourceSet().getFiles());
        this.handleOutputFilesProperty(coderAppModel.getOutputFiles());
    }

    @BoundToProperty(value="built")
    void handleBuiltProperty(boolean bl) {
        if (this.fEditorView.getPopupController() != null) {
            this.fEditorView.getEntityLocator().reset();
        }
        if (this.fEditorView.getEntityLocator() != null) {
            this.fEditorView.getEntityLocator().refresh();
        }
        if (this.fSidebarContext.getCallTreeView() != null) {
            this.fSidebarContext.getCallTreeView().expandAll(null);
        }
        if (this.fSidebarContext.getFunctionTreeView() != null) {
            this.fSidebarContext.getFunctionTreeView().setFunctions(this.fSidebarContext.getFileSetIntegrationContext("input-files").getSourceModel().getFunctionsByFile());
        }
        this.fSidebarContext.toggleInputFlatViewState(!this.fSidebarContext.getFileSetIntegrationContext("input-files").getSourceModel().getFunctions().isEmpty());
    }

    @BoundToProperty(value="output-files")
    void handleOutputFilesProperty(Collection<File> collection) {
        this.fSidebarContext.setFiles("output-files", collection);
        this.fSidebarContext.setFileSetVisible("output-files", !this.fApp.getModel().getOutputFiles().isEmpty());
        if (collection != null && !collection.isEmpty()) {
            this.fIDEView.selectFile(false, true);
        }
    }

    @BoundToProperty(value="input-files")
    void handleInputFilesProperty(Collection<File> collection) {
        this.fSidebarContext.setFiles("input-files", collection);
        this.fSidebarContext.toggleInputFlatViewState(false);
        if (this.fSidebarContext.getRootFileSetView("input-files").getSelectedFunction() == null) {
            this.fIDEView.selectFile(true, true);
        }
    }

    @BoundToProperty(value="errors")
    void handleErrorsProperty(Collection<BuildError> collection) {
        if (this.fSidebarContext.getCallTreeView() != null) {
            this.fSidebarContext.getCallTreeView().setErrors(collection);
        }
        if (this.fSidebarContext.getFunctionTreeView() != null) {
            this.fSidebarContext.getFunctionTreeView().setErrors(collection);
        }
        if (!collection.isEmpty()) {
            this.fSidebarContext.toggleInputFlatViewState(false);
        }
    }

    @BoundToProperty(value="call-tree")
    void handleCallTreeProperty(final CallTree callTree) {
        this.fSidebarContext.runOnCallTreeView(new ParameterRunnable<CallTreeFileSetView>(){

            public void run(CallTreeFileSetView callTreeFileSetView) {
                callTreeFileSetView.setCallTree(callTree);
                callTreeFileSetView.update();
            }
        });
        this.fSidebarContext.toggleCallTreeViewEnabled(callTree != null);
    }
}

