/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.table.AbstractComboBoxCellEditor;
import com.mathworks.project.impl.table.AbstractMacPopupCellEditor;
import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.AbstractSimpleCellEditor;
import com.mathworks.project.impl.table.Cell;
import com.mathworks.project.impl.table.CellPaintContext;
import com.mathworks.project.impl.table.CellPredicate;
import com.mathworks.project.impl.table.ClickSensitiveCellEditor;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTableColumn;
import com.mathworks.project.impl.table.PropertyTableContextMenuCustomizer;
import com.mathworks.project.impl.table.PropertyTableDecorator;
import com.mathworks.project.impl.table.PropertyTableHighlighter;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.project.impl.table.PropertyTableSearchPredicate;
import com.mathworks.project.impl.table.VirtualComponentManager;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.HintPopupFrame;
import com.mathworks.toolbox.coder.app.PopupBarManager;
import com.mathworks.toolbox.coder.app.ide.FunctionSelectionEvent;
import com.mathworks.toolbox.coder.app.ide.SelectionEvent;
import com.mathworks.toolbox.coder.app.ide.SelectionListener;
import com.mathworks.toolbox.coder.app.ide.Selector;
import com.mathworks.toolbox.coder.app.ide.VariableSelectionEvent;
import com.mathworks.toolbox.coder.fixedpoint.AnalysisTableContextMenu;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.ConversionStatusManager;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.FunctionSelector;
import com.mathworks.toolbox.coder.fixedpoint.NumericTypeTextField;
import com.mathworks.toolbox.coder.fixedpoint.ProposedTypeColumn;
import com.mathworks.toolbox.coder.fixedpoint.RangeColumn;
import com.mathworks.toolbox.coder.mi.ConversionUtils;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import com.mathworks.toolbox.coder.model.MatlabType;
import com.mathworks.toolbox.coder.model.MetadataTree;
import com.mathworks.toolbox.coder.model.NumericType;
import com.mathworks.toolbox.coder.model.Range;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.model.VariableKind;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.util.RequestFilter;
import com.mathworks.util.ReturnRunnable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public final class AnalysisTable
implements Selector {
    private final FixedPointDataAdapter fData;
    private final MJPanel fComponent;
    private final File fEntryPoint;
    private final ConversionModel fConversionModel;
    private final ConversionStatusManager fStatus;
    private final FunctionSelector fSelector;
    private final PopupBarManager fPopupBar;
    private final Runnable fReset;
    private final PropertyChangeListener fStatusListener;
    private final PropertyChangeListener fModelListener;
    private final List<SelectionListener> fSelectionListeners;
    private final MulticastChangeListener fSelectionChangeListeners;
    private final CoderApp fApp;
    private RequestFilter fProposedTypeUpdater;
    private HintPopupFrame fMissingDesignRangeHint;
    private static final int STATIC_MIN_INDEX = 4;
    private static final int STATIC_MAX_INDEX = 5;
    private static final int INTEGER_FLAG_INDEX = 6;
    private static final int PROPOSED_TYPE_INDEX = 7;
    private static final int ORIGINAL_TYPE_INDEX = 1;
    private PropertyTable<Variable> fTable;
    private ProposedTypeColumn fProposedTypeColumn;
    private PropertyTableModel<Variable> fModel;
    private PropertyTableHighlighter<Variable> fHighlighter;
    private Function fSelectedFunction;
    private boolean fCallOutMissingDesignRanges;
    private boolean fShortSyntax;
    private boolean fSuppressChange;
    private String fSearchText;

    public AnalysisTable(FixedPointDataAdapter fixedPointDataAdapter, ConversionStatusManager conversionStatusManager, ConversionModel conversionModel, FunctionSelector functionSelector, PopupBarManager popupBarManager, File file, Runnable runnable) {
        this(fixedPointDataAdapter, conversionStatusManager, conversionModel, functionSelector, popupBarManager, file, null, runnable);
    }

    public AnalysisTable(FixedPointDataAdapter fixedPointDataAdapter, ConversionStatusManager conversionStatusManager, ConversionModel conversionModel, FunctionSelector functionSelector, PopupBarManager popupBarManager, File file, CoderApp coderApp, Runnable runnable) {
        this.fApp = coderApp;
        this.fData = fixedPointDataAdapter;
        this.fStatus = conversionStatusManager;
        this.fSelector = functionSelector;
        this.fPopupBar = popupBarManager;
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fConversionModel = conversionModel;
        this.fReset = runnable;
        this.fEntryPoint = file;
        this.fSelectionChangeListeners = new MulticastChangeListener();
        this.fSelectionListeners = new LinkedList<SelectionListener>();
        this.fModelListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("VariableKinds") || propertyChangeEvent.getPropertyName().equals("DerivedRanges") || propertyChangeEvent.getPropertyName().equals("SimulationRanges")) {
                    AnalysisTable.this.dataChanged();
                } else if (propertyChangeEvent.getPropertyName().startsWith("ProposedType:") || propertyChangeEvent.getPropertyName().startsWith("RoundingMethod:") || propertyChangeEvent.getPropertyName().startsWith("OverflowAction:")) {
                    AnalysisTable.this.dataChanged();
                } else if (propertyChangeEvent.getPropertyName().equals("ComputedProposedTypes") || propertyChangeEvent.getPropertyName().equals("FunctionReplacements") || propertyChangeEvent.getPropertyName().startsWith("DesignRange:")) {
                    AnalysisTable.this.dataChanged();
                }
                if (propertyChangeEvent.getPropertyName().equals("ComputedProposedTypes") || propertyChangeEvent.getPropertyName().startsWith("ProposedType:") || propertyChangeEvent.getPropertyName().equals("SimulationRanges") || propertyChangeEvent.getPropertyName().equals("DerivedRanges")) {
                    AnalysisTable.this.fStatus.typesChanged(!propertyChangeEvent.getPropertyName().startsWith("ProposedType:"));
                    AnalysisTable.this.dataChanged();
                }
            }
        };
        this.fStatusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (AnalysisTable.this.fTable != null) {
                    AnalysisTable.this.fSuppressChange = true;
                    AnalysisTable.this.fTable.getModel().fireChange();
                    AnalysisTable.this.fSuppressChange = false;
                }
            }
        };
        this.fConversionModel.addPropertyChangeListener(this.fModelListener);
        this.fStatus.addPropertyChangeListener(this.fStatusListener);
    }

    @Override
    public void select(SelectionEvent selectionEvent) {
        if (selectionEvent.getVariable() != null) {
            this.setSelectedVariable(selectionEvent.getVariable());
        } else if (selectionEvent.getFunction() != null) {
            this.setSelectedFunction(selectionEvent.getFunction());
        }
    }

    private void fireSelectionEvent(ChangeEvent changeEvent) {
        SelectionEvent selectionEvent;
        this.fSelectionChangeListeners.stateChanged(changeEvent);
        if (this.getSelectedVariable() != null) {
            selectionEvent = new VariableSelectionEvent(this, this.getSelectedVariable());
        } else if (this.getSelectedFunction() != null) {
            selectionEvent = new FunctionSelectionEvent(this, this.getSelectedFunction());
        } else {
            return;
        }
        for (SelectionListener selectionListener : new LinkedList<SelectionListener>(this.fSelectionListeners)) {
            selectionListener.selectionChanged(selectionEvent);
        }
    }

    @Override
    public void addSelectionListener(SelectionListener selectionListener) {
        this.fSelectionListeners.add(selectionListener);
    }

    @Override
    public void removeSelectionListener(SelectionListener selectionListener) {
        this.fSelectionListeners.remove(selectionListener);
    }

    public void dispose() {
        if (this.fTable != null) {
            this.fTable.dispose();
        }
        if (this.fMissingDesignRangeHint != null) {
            this.fMissingDesignRangeHint.close();
        }
        this.fConversionModel.removeChangeListener(this.fModelListener);
        this.fStatus.removePropertyChangeListener(this.fStatusListener);
    }

    public void setUseShortTypeSyntax(boolean bl) {
        this.fProposedTypeColumn.setUseShortSyntax(bl);
        this.fShortSyntax = true;
    }

    public void addSelectionChangeListener(ChangeListener changeListener) {
        this.fSelectionChangeListeners.addChangeListener(changeListener);
    }

    public void removeSelectionChangeListener(ChangeListener changeListener) {
        this.fSelectionChangeListeners.removeChangeListener(changeListener);
    }

    public Variable getSelectedVariable() {
        return this.fTable == null || this.fTable.getSelectionModel().getSelectedRowCount() != 1 ? null : (Variable)this.fTable.getModel().getValue(this.fTable.getSelectionModel().getSelectedRow(), 0);
    }

    public ConversionModel getConversionModel() {
        return this.fConversionModel;
    }

    public void setProposedTypeUpdater(RequestFilter requestFilter) {
        this.fProposedTypeUpdater = requestFilter;
    }

    public void setSelectedFunction(Function function) {
        this.setSelectedContext(function, null);
    }

    public void setSelectedVariable(@NotNull Variable variable) {
        this.setSelectedContext(variable.getFunction(), variable);
    }

    public void setSelectedContext(Function function, Variable variable) {
        this.fSelectedFunction = function;
        this.rebuildTable();
        if (this.fTable != null && variable != null) {
            for (int i = 0; i < this.fTable.getModel().getRowCount(); ++i) {
                Variable variable2 = (Variable)this.fTable.getModel().getValue(i, 0);
                if (Utilities.areValuesDifferent(variable, variable2)) continue;
                this.fTable.getSelectionModel().select(i);
                break;
            }
        }
    }

    public Function getSelectedFunction() {
        return this.fSelectedFunction;
    }

    public void stopEditing() {
        if (this.fTable != null) {
            this.fTable.stopEditing(false);
        }
    }

    public void setProposedTypes(final MetadataTree<String> metadataTree, final MetadataTree<Boolean> metadataTree2) {
        final MetadataTree<String> metadataTree3 = this.fConversionModel.getComputedProposedTypes();
        final MetadataTree<Boolean> metadataTree4 = this.fConversionModel.getComputedIntegerFlags();
        this.fTable.animateDataChange(new Runnable(){

            @Override
            public void run() {
                AnalysisTable.this.fConversionModel.setComputedProposedTypes(metadataTree);
                AnalysisTable.this.fConversionModel.setComputedIntegerFlags(metadataTree2);
            }
        }, new Runnable(){

            @Override
            public void run() {
                AnalysisTable.this.fConversionModel.setComputedProposedTypes(metadataTree3);
                AnalysisTable.this.fConversionModel.setComputedIntegerFlags(metadataTree4);
            }
        });
    }

    public void find(String string) {
        this.fSearchText = string;
        if (this.fTable != null) {
            this.fTable.setSearchText(string);
        }
    }

    public void clearSearch() {
        this.fSearchText = "";
        if (this.fTable != null) {
            this.fTable.setSearchText("");
        }
    }

    public boolean isTableInitialized() {
        return this.fTable != null;
    }

    private void rebuildTable() {
        this.fSuppressChange = true;
        ArrayList<PropertyTableNode> arrayList = new ArrayList<PropertyTableNode>();
        if (!this.fConversionModel.hasVariableKinds()) {
            return;
        }
        for (VariableKind variableKind : VariableKind.values()) {
            PropertyTableNode propertyTableNode = new PropertyTableNode(null, true, variableKind.getLabel());
            for (Variable variable : this.fConversionModel.getVariables(this.fSelectedFunction)) {
                VariableKind variableKind2 = this.fConversionModel.getVariableKind(variable);
                if (variableKind2 != variableKind && (variableKind != VariableKind.LOCAL || variableKind2 != null)) continue;
                new PropertyTableNode(propertyTableNode, false, Arrays.asList(variable));
            }
            if (propertyTableNode.getChildren().isEmpty()) continue;
            arrayList.add(propertyTableNode);
        }
        if (this.fTable == null) {
            this.fComponent.removeAll();
            this.fProposedTypeColumn = new ProposedTypeColumn(this.fConversionModel, 4, 5);
            ArrayList arrayList2 = new ArrayList();
            arrayList2.add(new VariableNameColumn());
            arrayList2.add(new MatlabTypeColumn());
            arrayList2.add(new RangeColumn(true, false, CoderResources.getString("f2f.column.simMin"), this.fConversionModel.getLazySimulationRanges()));
            arrayList2.add(new RangeColumn(false, false, CoderResources.getString("f2f.column.simMax"), this.fConversionModel.getLazySimulationRanges()));
            arrayList2.add(new RangeColumn(true, true, CoderResources.getString("f2f.column.staticMin"), this.fConversionModel.getLazyDesignRanges(), this.fConversionModel.getLazyAutoDesignRanges(), this.fConversionModel.getLazyDerivedRanges()));
            arrayList2.add(new RangeColumn(false, true, CoderResources.getString("f2f.column.staticMax"), this.fConversionModel.getLazyDesignRanges(), this.fConversionModel.getLazyAutoDesignRanges(), this.fConversionModel.getLazyDerivedRanges()));
            arrayList2.add(new IntegerColumn());
            arrayList2.add(this.fProposedTypeColumn);
            this.fModel = new PropertyTableModel<Variable>((List)arrayList2, (PropertyTableSearchPredicate)new PropertyTableSearchPredicate<Variable>(){

                public boolean accept(Variable variable, String string) {
                    return variable.getName().toUpperCase(Locale.ENGLISH).contains(string.toUpperCase(Locale.ENGLISH));
                }
            }, arrayList){

                public boolean isEnabled(int n, int n2) {
                    Variable variable;
                    boolean bl = super.isEnabled(n, n2);
                    if (bl && (n2 == 1 || n2 == 7) && (variable = (Variable)this.getValue(n, 0)) != null) {
                        MatlabType matlabType;
                        bl = n2 == 1 ? (matlabType = AnalysisTable.this.fConversionModel.getMatlabType(variable)) != null && !matlabType.isSystemObject() : AnalysisTable.this.isNumericTypeEnabled(variable);
                    }
                    return bl;
                }
            };
            this.fTable = new PropertyTable(this.fModel, (PropertyTableCellEditorFactory)new EditorFactory());
            this.fTable.getSelectionModel().setAllowMultiselect(true);
            this.fTable.getSelectionModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (!AnalysisTable.this.fSuppressChange) {
                        AnalysisTable.this.fireSelectionEvent(changeEvent);
                    }
                }
            });
            this.fTable.setName("FixedPointAnalysisTable");
            this.fTable.setColumnWeights(new double[]{0.16, 0.16, 0.1, 0.1, 0.1, 0.1, 0.1, 0.18});
            this.fProposedTypeColumn.setTable(this.fTable);
            this.fTable.setContextMenuCustomizer((PropertyTableContextMenuCustomizer)new AnalysisTableContextMenu(this.fTable, this.fConversionModel, 4, 5, 6, 7, new Predicate<Function>(){

                public boolean accept(Function function) {
                    return AnalysisTable.this.isEntryPoint(function);
                }
            }, this.fReset, new Runnable(){

                @Override
                public void run() {
                    AnalysisTable.this.closeMissingDesignRangeHintIfUnneeded();
                    AnalysisTable.this.dataChanged();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    AnalysisTable.this.closeMissingDesignRangeHintIfUnneeded();
                    AnalysisTable.this.fStatus.refreshStaticAnalysisStatus();
                }
            }));
            this.fTable.setDefaultPredicate((CellPredicate)new DefaultPredicate());
            this.fTable.setSortable(true);
            this.fTable.setAutoSelectEditableCell(false);
            this.fTable.addHighlighter(this.createBadTypeHighlighter());
            for (int i = 0; i < this.fModel.getColumnCount(); ++i) {
                PropertyTableColumn propertyTableColumn = this.fModel.getColumn(i);
                if (!(propertyTableColumn instanceof RangeColumn)) continue;
                ((RangeColumn)propertyTableColumn).setTable(this.fTable);
            }
            if (this.fSearchText != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AnalysisTable.this.fTable.setSearchText(AnalysisTable.this.fSearchText);
                    }
                });
            }
            this.fComponent.add((Component)this.fTable.getComponent());
        }
        this.fModel.setRootLevelRows(arrayList);
        this.fModel.expandAll();
        this.updateMissingDesignRangeHighlight();
        this.fComponent.revalidate();
        this.fComponent.repaint();
        this.fSuppressChange = false;
    }

    public void showMissingDesignRanges() {
        Function function = new Function(this.fEntryPoint, new FileLocation(this.fEntryPoint).getNameBeforeDot());
        this.fSelector.select(function);
        this.setSelectedFunction(function);
        this.fCallOutMissingDesignRanges = true;
        this.updateMissingDesignRangeHighlight();
    }

    public void showMissingDesignRangeHint() {
        Timer timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalysisTable.this.fMissingDesignRangeHint = new HintPopupFrame(SwingUtilities.windowForComponent((Component)AnalysisTable.this.fComponent), (Component)AnalysisTable.this.fComponent, CoderResources.getString("f2f.warning.designRanges"), null, true, false, new ReturnRunnable<Point>(){

                    public Point run() {
                        Point point = new Point((int)(AnalysisTable.this.fTable.getCellRect(0, 4).getX() + (AnalysisTable.this.fTable.getCellRect(0, 4).getWidth() + AnalysisTable.this.fTable.getCellRect(0, 5).getWidth()) / 2.0), ((AnalysisTable)AnalysisTable.this).fTable.getVisibleRect().y);
                        AnalysisTable.this.fTable.convertPointToScreen(point);
                        return point;
                    }
                });
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public void hideMissingDesignRangeHint() {
        if (this.fMissingDesignRangeHint != null) {
            this.fMissingDesignRangeHint.close();
            this.fMissingDesignRangeHint = null;
        }
        this.fCallOutMissingDesignRanges = false;
        this.updateMissingDesignRangeHighlight();
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void dataChanged() {
        this.rebuildTable();
        this.fConversionModel.serialize(this.fData);
    }

    public boolean autoDefineInputRanges(final Runnable runnable) {
        Object object;
        final List<Variable> list = this.getVariablesWithOldAutoDefinedDesignRanges();
        list.addAll(this.fConversionModel.getVariablesWithUnspecifiedDesignRanges(this.fData, true));
        Iterator<Variable> iterator = list.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            String string = this.fConversionModel.getUserProposedTypes().get((FunctionScopedKey<?>)object);
            if (string == null) {
                if (this.fConversionModel.getVariableKind((Variable)object) == VariableKind.INPUT) {
                    return false;
                }
                iterator.remove();
                continue;
            }
            try {
                new NumericType(string).getSupportedRange();
            }
            catch (Exception exception) {
                if (this.fConversionModel.getVariableKind((Variable)object).isInput()) {
                    return false;
                }
                iterator.remove();
            }
        }
        if (list.isEmpty()) {
            return false;
        }
        object = this.fPopupBar.block();
        for (Variable variable : list) {
            this.fConversionModel.clearDesignRange(variable);
        }
        this.fProposedTypeColumn.showDesignRangeDerivation(list, new Runnable((PopupBarManager.Block)object){
            final /* synthetic */ PopupBarManager.Block val$block;
            {
                this.val$block = block;
            }

            @Override
            public void run() {
                for (Variable variable : list) {
                    String string = AnalysisTable.this.fConversionModel.getUserProposedTypes().get(variable);
                    if (string == null) continue;
                    try {
                        Range range = new NumericType(string).getSupportedRange();
                        AnalysisTable.this.fConversionModel.setAutoDesignRange(variable, range);
                    }
                    catch (Exception exception) {}
                }
                runnable.run();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        val$block.dispose();
                    }
                });
            }
        });
        return true;
    }

    public List<Variable> getVariablesWithOldAutoDefinedDesignRanges() {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        for (Variable variable : this.fConversionModel.getVariablesWithRequiredDesignRanges(this.fData, true)) {
            if (!this.fConversionModel.hasAutoDesignRange(variable)) continue;
            Range range = this.fConversionModel.getDesignRange(variable);
            try {
                Range range2 = new NumericType(this.fConversionModel.getProposedType(variable)).getSupportedRange();
                if (range.equals(range2)) continue;
                arrayList.add(variable);
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    private void updateMissingDesignRangeHighlight() {
        List<Variable> list;
        PropertyTableHighlighter<Variable> propertyTableHighlighter = this.fHighlighter;
        if (this.fHighlighter != null) {
            this.fHighlighter = null;
        }
        if (this.fConversionModel.hasVariableKinds() && this.fCallOutMissingDesignRanges && !(list = this.fConversionModel.getVariablesWithUnavailableDesignRanges(this.fData)).isEmpty()) {
            this.fHighlighter = new PropertyTableHighlighter(new Color(251, 155, 155), Color.BLACK, list, (Predicate)new Predicate<Cell<Variable>>(){

                public boolean accept(Cell<Variable> cell) {
                    VariableKind variableKind = AnalysisTable.this.fConversionModel.getVariableKind((Variable)cell.getValue());
                    if (variableKind == null || !variableKind.isInput() && variableKind != VariableKind.PERSISTENT) {
                        return false;
                    }
                    Range range = AnalysisTable.this.fConversionModel.getDesignRange((FunctionScopedKey)cell.getValue());
                    if (range == null) {
                        return cell.getColumnIndex() == 4 || cell.getColumnIndex() == 5;
                    }
                    return cell.getColumnIndex() == 4 && range.getMin() == null || cell.getColumnIndex() == 5 && range.getMax() == null;
                }
            });
            if (this.fTable != null) {
                this.fTable.swapHighlighter(propertyTableHighlighter, this.fHighlighter);
            }
        }
        if (this.fHighlighter == null && this.fTable != null) {
            this.fTable.removeHighlighter(propertyTableHighlighter);
        }
    }

    private void closeMissingDesignRangeHintIfUnneeded() {
        if (this.fMissingDesignRangeHint != null && this.fConversionModel.getVariablesWithUnavailableDesignRanges(this.fData).isEmpty()) {
            this.fMissingDesignRangeHint.close();
            this.fMissingDesignRangeHint = null;
        }
    }

    private boolean isEntryPoint(Function function) {
        return function.isEntryPointFunction();
    }

    private boolean isNumericTypeEnabled(Variable variable) {
        String string;
        if (variable == null) {
            return false;
        }
        MatlabType matlabType = this.fConversionModel.getMatlabType(variable);
        return matlabType == null || !matlabType.isSystemObject() || (string = this.fConversionModel.getProposedType(variable)) == null || NumericType.parse(string) != null;
    }

    private PropertyTableHighlighter<Variable> createBadTypeHighlighter() {
        return new PropertyTableHighlighter(null, new Color(170, 0, 0), (Predicate)new Predicate<Variable>(){

            public boolean accept(Variable variable) {
                return AnalysisTable.this.isNumericTypeEnabled(variable) && variable != null && (AnalysisTable.this.fConversionModel.hasSimulationOverflow(variable) || AnalysisTable.this.isSupportedRangeBad(variable));
            }
        }, (Predicate)new Predicate<Cell<Variable>>(){

            public boolean accept(Cell<Variable> cell) {
                return AnalysisTable.this.fConversionModel.hasSimulationOverflow((Variable)cell.getValue()) && cell.getColumnIndex() == 1 || AnalysisTable.this.isSupportedRangeBad((Variable)cell.getValue()) && cell.getColumnIndex() == 7;
            }
        });
    }

    private boolean isSupportedRangeBad(Variable variable) {
        Range range;
        Object object;
        String string = this.fConversionModel.getProposedType(variable);
        if (string != null) {
            try {
                object = new NumericType(string);
                if (((NumericType)object).getWordLength() > 128 || ((NumericType)object).getWordLength() < 1) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return true;
            }
        }
        if (this.fConversionModel.hasAutoDesignRange(variable)) {
            return false;
        }
        if (this.fConversionModel.hasSimulationRanges()) {
            object = this.fConversionModel.getDesignRange(variable);
            if (object == null || ((Range)object).getMin() == null || ((Range)object).getMax() == null) {
                object = this.fConversionModel.getSimulationRange(variable);
            }
            range = this.fConversionModel.getSupportedRange(variable);
            if (object != null && range != null) {
                return !range.contains((Range)object);
            }
        }
        if (this.fConversionModel.hasDerivedRanges()) {
            object = this.fConversionModel.getDerivedRange(variable);
            range = this.fConversionModel.getSupportedRange(variable);
            if (object != null && ((Range)object).getMin() != null && ((Range)object).getMax() != null && range != null) {
                return !range.contains((Range)object);
            }
        }
        return false;
    }

    private class DefaultPredicate
    implements CellPredicate {
        private DefaultPredicate() {
        }

        public boolean accept(int n, int n2) {
            AnalysisTable.this.fTable.getModel().getValue(n, n2);
            Variable variable = (Variable)AnalysisTable.this.fTable.getModel().getValue(n, n2);
            if (variable == null) {
                return true;
            }
            if (n2 == 4 || n2 == 5) {
                return AnalysisTable.this.fConversionModel.getDesignRange(variable) == null || AnalysisTable.this.fConversionModel.hasAutoDesignRange(variable);
            }
            if (n2 == 6) {
                return AnalysisTable.this.fConversionModel.getUserIntegerFlags().get(variable) == null;
            }
            if (n2 == 7) {
                return AnalysisTable.this.fConversionModel.getUserProposedTypes().get(variable) == null && !this.hasNonDefaultFimathProperties(variable);
            }
            return true;
        }

        private boolean hasNonDefaultFimathProperties(Variable variable) {
            return AnalysisTable.this.fConversionModel.hasVariableNames() && (AnalysisTable.this.fConversionModel.getDefaultRoundingMethod(variable) != AnalysisTable.this.fConversionModel.getRoundingMethod(variable) || AnalysisTable.this.fConversionModel.getDefaultOverflowAction(variable) != AnalysisTable.this.fConversionModel.getOverflowAction(variable));
        }
    }

    private class TypeEditor
    implements ClickSensitiveCellEditor<Variable> {
        private final NumericTypeTextField fTextField;
        private final Variable fVariable;
        private Point fInitialClickPoint;
        private String fDisplayedText;

        TypeEditor(Variable variable) {
            this.fVariable = variable;
            this.fTextField = new NumericTypeTextField(AnalysisTable.this.fData, AnalysisTable.this.fConversionModel, variable, (PropertyTable<Variable>)AnalysisTable.this.fTable, AnalysisTable.this.fApp);
            this.fTextField.lockFormatTip();
        }

        public void setInitialClickPoint(Point point) {
            this.fInitialClickPoint = point;
        }

        public void loadData(Object object, String string) {
            this.fDisplayedText = string;
            this.fTextField.setText(string);
        }

        public void commitData() {
            try {
                String string = ConversionUtils.contractFixedPointType(this.fTextField.getText());
                if (string.trim().isEmpty()) {
                    string = null;
                }
                if (AnalysisTable.this.fConversionModel.setProposedTypeIfNotAcceptingDefault(this.fVariable, string)) {
                    AnalysisTable.this.fConversionModel.serialize(AnalysisTable.this.fData);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public JComponent getComponent() {
            return this.fTextField.getComponent();
        }

        public void activate() {
            AnalysisTable.this.hideMissingDesignRangeHint();
            this.fTextField.requestFocus();
            if (this.fInitialClickPoint != null) {
                SwingUtilities.convertPointFromScreen(this.fInitialClickPoint, this.fTextField.getComponent());
                Font font = AnalysisTable.this.fTable.getFont();
                if (AnalysisTable.this.fConversionModel.getUserProposedTypes().get(this.fVariable) != null) {
                    font = font.deriveFont(1);
                }
                this.fTextField.clickFromRendererIntoEditor(this.fDisplayedText, font, this.fInitialClickPoint);
            }
            this.fTextField.unlockFormatTip();
        }

        public void dispose() {
            this.fTextField.dispose();
        }
    }

    private class EditorFactory
    implements PropertyTableCellEditorFactory<Variable> {
        private EditorFactory() {
        }

        public PropertyTableCellEditor<Variable> createWidget(final PropertyTable<Variable> propertyTable, final int n, final int n2, final Variable variable) {
            if (n2 == 4 || n2 == 5) {
                AbstractSimpleCellEditor<Variable> abstractSimpleCellEditor = new AbstractSimpleCellEditor<Variable>(propertyTable){

                    public void loadData(Object object, String string) {
                        if (string.equals(CoderResources.getString("f2f.range.unknown"))) {
                            this.setData(null, "");
                        } else {
                            Variable variable2 = (Variable)object;
                            String string2 = ((RangeColumn)propertyTable.getModel().getColumn(n2)).getFullText(variable2);
                            this.setData(object, string2);
                        }
                        if (n2 == 4 && (AnalysisTable.this.fConversionModel.getDesignRange(variable) == null || AnalysisTable.this.fConversionModel.getDesignRange(variable).getMax() == null)) {
                            this.getTextField().addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            AnalysisTable.this.fTable.startEditing(n, n2 + 1, false);
                                        }
                                    });
                                }
                            });
                        }
                    }

                    public void commitData() {
                        Object object;
                        String string;
                        Double d;
                        Double d2;
                        Range range;
                        block11: {
                            range = AnalysisTable.this.fConversionModel.getDesignRange(variable);
                            d2 = null;
                            d = null;
                            if (range != null) {
                                d2 = range.getMin();
                                d = range.getMax();
                            }
                            string = (String)this.getData();
                            try {
                                Object object2 = object = string.trim().isEmpty() ? null : Double.valueOf(Double.parseDouble(string));
                                if (n2 == 5) {
                                    d = object;
                                } else {
                                    d2 = object;
                                }
                            }
                            catch (Exception exception) {
                                if (string == null) break block11;
                                if (string.equalsIgnoreCase("Inf")) {
                                    if (n2 == 5) {
                                        d = Double.POSITIVE_INFINITY;
                                    } else {
                                        d2 = Double.POSITIVE_INFINITY;
                                    }
                                }
                                if (!string.equalsIgnoreCase("-Inf")) break block11;
                                if (n2 == 5) {
                                    d = Double.NEGATIVE_INFINITY;
                                }
                                d2 = Double.NEGATIVE_INFINITY;
                            }
                        }
                        object = AnalysisTable.this.fConversionModel.getDerivedRange(variable);
                        if (object != null && (n2 == 4 && ((Range)object).getMin() != null && ((Range)object).getMin().equals(d2) || n2 == 5 && ((Range)object).getMax() != null && ((Range)object).getMax().equals(d)) && range == null) {
                            return;
                        }
                        AnalysisTable.this.fConversionModel.setDesignRange(variable, new Range(d2, d));
                        if (object != null && string.trim().isEmpty()) {
                            object = new Range(n2 == 4 ? null : ((Range)object).getMin(), n2 == 5 ? null : ((Range)object).getMax());
                            AnalysisTable.this.fConversionModel.setDerivedRange(variable, (Range)object);
                            AnalysisTable.this.fStatus.refreshStaticAnalysisStatus();
                            AnalysisTable.this.fModel.fireChange();
                        }
                        AnalysisTable.this.updateMissingDesignRangeHighlight();
                        AnalysisTable.this.fConversionModel.serialize(AnalysisTable.this.fData);
                        AnalysisTable.this.closeMissingDesignRangeHintIfUnneeded();
                    }
                };
                abstractSimpleCellEditor.setAlignment(4);
                return abstractSimpleCellEditor;
            }
            if (n2 == 6) {
                if (PlatformInfo.isMacintosh()) {
                    return new AbstractMacPopupCellEditor<Variable>(propertyTable, n, n2){

                        protected boolean loadBooleanValue() {
                            Boolean bl = AnalysisTable.this.fConversionModel.getIntegerFlag(variable);
                            return bl != null && bl != false;
                        }

                        protected void commitBooleanValue(boolean bl) {
                            EditorFactory.this.commitIntegerFlag(variable, bl);
                        }
                    };
                }
                return new AbstractComboBoxCellEditor<Variable>(propertyTable){
                    private Object fCurrentValue;
                    {
                        super(propertyTable);
                        this.fCurrentValue = null;
                    }

                    public void loadData(Object object, String string) {
                        if (!string.isEmpty()) {
                            if (string.equals(BuiltInResources.getString((String)"param.boolean.true"))) {
                                this.setData(true);
                            } else {
                                this.setData(false);
                            }
                        }
                    }

                    public void setData(Object object) {
                        this.fCurrentValue = object;
                        super.setData(object);
                    }

                    public void commitData() {
                        if (Utilities.areValuesDifferent(this.fCurrentValue, this.getData())) {
                            EditorFactory.this.commitIntegerFlag(variable, (Boolean)this.getData());
                        }
                    }
                };
            }
            return new TypeEditor(variable);
        }

        private void commitIntegerFlag(Variable variable, Boolean bl) {
            Boolean bl2 = AnalysisTable.this.fConversionModel.getIntegerFlag(variable);
            if (bl2 != null && bl2.equals(bl)) {
                return;
            }
            if (AnalysisTable.this.fConversionModel.setIntegerFlagIfNotAcceptingDefault(variable, bl)) {
                AnalysisTable.this.fConversionModel.serialize(AnalysisTable.this.fData);
                if (AnalysisTable.this.fProposedTypeUpdater != null) {
                    AnalysisTable.this.fProposedTypeUpdater.request();
                }
            }
        }
    }

    private final class IntegerColumn
    extends AbstractPropertyTableColumn<Variable> {
        IntegerColumn() {
            super(CoderResources.getString("f2f.column.integer"));
        }

        public String getText(Variable variable) {
            Boolean bl = AnalysisTable.this.fConversionModel.getIntegerFlag(variable);
            return bl != null && bl != false ? BuiltInResources.getString((String)"param.boolean.true") : BuiltInResources.getString((String)"param.boolean.false");
        }

        public boolean isFinite() {
            return true;
        }

        public boolean isEditable() {
            return true;
        }
    }

    private final class MatlabTypeColumn
    extends AbstractPropertyTableColumn<Variable> {
        MatlabTypeColumn() {
            super(CoderResources.getString("f2f.column.matlabType"));
        }

        public String getText(Variable variable) {
            MatlabType matlabType = AnalysisTable.this.fConversionModel.getMatlabType(variable);
            if (matlabType == null) {
                return "";
            }
            return matlabType.toUniqueString(AnalysisTable.this.fShortSyntax);
        }

        public PropertyTableDecorator<Variable> getDecorator() {
            return new PropertyTableDecorator<Variable>(){

                public boolean shouldPaintText(Variable variable) {
                    if (variable == null) {
                        return true;
                    }
                    MatlabType matlabType = AnalysisTable.this.fConversionModel.getMatlabType(variable);
                    return matlabType != null && !matlabType.isSystemObject() || matlabType == null;
                }

                public void paintDecoration(CellPaintContext<Variable> cellPaintContext, Graphics2D graphics2D, VirtualComponentManager virtualComponentManager, Color color, Color color2) {
                    MatlabType matlabType;
                    if (cellPaintContext.getValue() != null && (matlabType = AnalysisTable.this.fConversionModel.getMatlabType((FunctionScopedKey)cellPaintContext.getValue())) != null && matlabType.isSystemObject() && (matlabType.getClassName() == null || matlabType.getClassName().isEmpty()) && !PlatformInfo.isMacintosh()) {
                        graphics2D.setColor(new Color(252, 252, 252));
                        Rectangle rectangle = cellPaintContext.getCellRect().getBounds();
                        rectangle.setLocation(rectangle.x - 2, rectangle.y);
                        graphics2D.fill(rectangle);
                    }
                }
            };
        }
    }

    private static final class VariableNameColumn
    extends AbstractPropertyTableColumn<Variable> {
        VariableNameColumn() {
            super(CoderResources.getString("f2f.column.variable"));
        }

        public String getText(Variable variable) {
            return variable.getName();
        }
    }
}

