/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.plaf.MWindowsComboBoxUI;
import com.mathworks.project.impl.TooltipWindow;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CodePopupFrame {
    public static final Color BACKGROUND = PlatformInfo.isMacintosh() ? new Color(243, 243, 243) : new Color(221, 234, 248);
    public static final Color BORDER = PlatformInfo.isMacintosh() ? new Color(130, 130, 130) : new Color(20, 85, 148);
    private static final int ATTENTION_LOST_DELAY = 1000;
    private final CodePopupContentView fContentView;
    private final Window fParentWindow;
    private final AWTEventListener fAwtListener;
    private final Collection<CodePopupFrameListener> fListeners;
    private TooltipWindow fToolTip;
    private Timer fOutTimer;
    private CodePopupContext fPopupContext;
    private boolean fContainsMouse;

    public CodePopupFrame(Window window, CodePopupContentView codePopupContentView) {
        this.fParentWindow = window;
        this.fContentView = codePopupContentView;
        this.fListeners = new LinkedList<CodePopupFrameListener>();
        this.fAwtListener = this.createAWTEventListener();
        this.fParentWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                if (!(CodePopupFrame.this.fParentWindow.hasFocus() || CodePopupFrame.this.hasFocus() || CodePopupFrame.this.fToolTip == null || CodePopupFrame.this.fToolTip.isVisible() || CodePopupFrame.this.fToolTip.isActive())) {
                    CodePopupFrame.this.close(false);
                }
            }
        });
        this.fContentView.setParentCodePopupFrame(this);
    }

    private AWTEventListener createAWTEventListener() {
        return new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                if (CodePopupFrame.this.fToolTip == null || aWTEvent.getSource() == null || !(aWTEvent instanceof MouseEvent)) {
                    return;
                }
                CodePopupFrame.this.fContainsMouse = CodePopupFrame.this.fToolTip.equals(aWTEvent.getSource()) || SwingUtilities.isDescendingFrom((Component)aWTEvent.getSource(), (Component)CodePopupFrame.this.fToolTip);
                boolean bl = false;
                if (CodePopupFrame.this.fPopupContext != null && CodePopupFrame.this.fPopupContext.getPositionPredicate() != null) {
                    Point point = new Point(((MouseEvent)aWTEvent).getPoint());
                    SwingUtilities.convertPoint((Component)aWTEvent.getSource(), point, CodePopupFrame.this.fPopupContext.getParent());
                    bl = CodePopupFrame.this.fPopupContext.getPositionPredicate().accept((Object)point);
                }
                if ((CodePopupFrame.this.hasFocus() || bl) && CodePopupFrame.this.fOutTimer != null) {
                    CodePopupFrame.this.fOutTimer.stop();
                    CodePopupFrame.this.fOutTimer = null;
                }
                if (!(CodePopupFrame.this.hasFocus() || bl || CodePopupFrame.this.fOutTimer != null && CodePopupFrame.this.fOutTimer.isRunning())) {
                    CodePopupFrame.this.fOutTimer = new Timer(1000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (!CodePopupFrame.this.hasFocus()) {
                                CodePopupFrame.this.close(false);
                            }
                        }
                    });
                    CodePopupFrame.this.fOutTimer.setRepeats(false);
                    CodePopupFrame.this.fOutTimer.start();
                }
            }
        };
    }

    private void fireVisibilityChanged(boolean bl, boolean bl2) {
        for (CodePopupFrameListener codePopupFrameListener : new LinkedList<CodePopupFrameListener>(this.fListeners)) {
            codePopupFrameListener.popupVisibilityChanged(bl, bl2);
        }
    }

    public void addCodePopupFrameListener(CodePopupFrameListener codePopupFrameListener) {
        this.fListeners.add(codePopupFrameListener);
    }

    public void removeCodePopupFrameListener(CodePopupFrameListener codePopupFrameListener) {
        this.fListeners.remove(codePopupFrameListener);
    }

    public CodePopupContentView getContentView() {
        return this.fContentView;
    }

    public void close() {
        this.close(true);
    }

    private void close(boolean bl) {
        boolean bl2 = false;
        if (this.fToolTip != null) {
            this.fToolTip.close();
            this.fToolTip = null;
            bl2 = true;
        }
        if (this.fOutTimer != null) {
            this.fOutTimer.stop();
            this.fOutTimer = null;
        }
        if (bl2) {
            this.fContainsMouse = false;
            this.fPopupContext = null;
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.fAwtListener);
            this.fireVisibilityChanged(false, bl);
        }
    }

    public Rectangle getBounds() {
        return this.fToolTip == null ? null : this.fToolTip.getBounds();
    }

    public boolean hasFocus() {
        if (!(this.fToolTip != null && this.fToolTip.hasFocus() || this.getContentView().isContentViewFocused() || this.fContainsMouse)) {
            return false;
        }
        return this.fToolTip != null && this.fContainsMouse;
    }

    public void update(CodePopupContext codePopupContext) {
        if (!this.focusedWindowIsRelevant()) {
            this.close();
        } else if (this.fPopupContext != null && this.fPopupContext.equals(codePopupContext)) {
            return;
        }
        this.fPopupContext = codePopupContext;
        JComponent jComponent = codePopupContext.getKey() != null ? this.getContentView().updateContentView(codePopupContext.getKey()) : this.getContentView().updateContentView(codePopupContext.getFunction());
        if (jComponent == null) {
            return;
        }
        jComponent.setOpaque(false);
        if (this.fToolTip == null) {
            this.fToolTip = new TooltipWindow(this.fParentWindow, (Component)this.fParentWindow, false, false, true, 2, BACKGROUND, BORDER);
            this.fToolTip.setName("f2f.code.popup");
        }
        if (PlatformInfo.isMacintosh() && !this.fToolTip.isVisible()) {
            this.fToolTip.showWithAnimation((Component)jComponent, codePopupContext.getPoint().x, codePopupContext.getPoint().y);
        } else {
            this.fToolTip.update((Component)jComponent, codePopupContext.getPoint().x, codePopupContext.getPoint().y);
            this.fToolTip.setFocusableWindowState(false);
            this.fToolTip.setVisible(true);
            this.fToolTip.setFocusableWindowState(true);
            Toolkit.getDefaultToolkit().addAWTEventListener(this.fAwtListener, 52L);
            this.fireVisibilityChanged(true, true);
        }
    }

    public FunctionScopedKey<?> getFunctionScopedKey() {
        return this.fPopupContext != null ? this.fPopupContext.getKey() : null;
    }

    public Function getFunction() {
        return this.fPopupContext != null ? this.fPopupContext.getFunction() : null;
    }

    public JComboBox<?> createTransparencySafeComboBox() {
        return new TransparencySafeComboBox();
    }

    public Point getAnchorPoint() {
        return new Point(this.fToolTip.getScreenAnchorPoint());
    }

    private boolean focusedWindowIsRelevant() {
        return this.fParentWindow != null && this.fParentWindow.isFocused() || this.fToolTip != null && this.fToolTip.isFocused() || this.hasFocus();
    }

    public static final class CodePopupContext {
        private final Predicate<Point> fPositionPredicate;
        private final FunctionScopedKey<?> fKey;
        private final Function fFunction;
        private final Point fPoint;
        private final Component fParent;

        public CodePopupContext(FunctionScopedKey<?> functionScopedKey, Component component, Point point, @Nullable Predicate<Point> predicate) {
            this(functionScopedKey, null, component, point, predicate);
        }

        public CodePopupContext(Function function, Component component, Point point, @Nullable Predicate<Point> predicate) {
            this(null, function, component, point, predicate);
        }

        private CodePopupContext(FunctionScopedKey<?> functionScopedKey, Function function, Component component, Point point, Predicate<Point> predicate) {
            if (functionScopedKey == null && function == null) {
                throw new IllegalArgumentException("Either a key or function must be non-null");
            }
            this.fKey = functionScopedKey;
            this.fFunction = function;
            this.fPoint = point;
            this.fParent = component;
            this.fPositionPredicate = predicate;
        }

        @NotNull
        public Object getTrigger() {
            return this.fKey != null ? this.fKey : this.fFunction;
        }

        @Nullable
        public FunctionScopedKey<?> getKey() {
            return this.fKey;
        }

        @Nullable
        public Function getFunction() {
            return this.fFunction;
        }

        @NotNull
        public Point getPoint() {
            return this.fPoint;
        }

        @Nullable
        public Predicate<Point> getPositionPredicate() {
            return this.fPositionPredicate;
        }

        @NotNull
        public Component getParent() {
            return this.fParent;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CodePopupContext codePopupContext = (CodePopupContext)object;
            if (this.fFunction != null ? !this.fFunction.equals(codePopupContext.fFunction) : codePopupContext.fFunction != null) {
                return false;
            }
            if (this.fKey != null ? !this.fKey.equals(codePopupContext.fKey) : codePopupContext.fKey != null) {
                return false;
            }
            return this.fParent.equals(codePopupContext.fParent) && this.fPoint.equals(codePopupContext.fPoint);
        }

        public int hashCode() {
            int n = this.fKey != null ? this.fKey.hashCode() : 0;
            n = 31 * n + (this.fFunction != null ? this.fFunction.hashCode() : 0);
            n = 31 * n + this.fPoint.hashCode();
            n = 31 * n + this.fParent.hashCode();
            return n;
        }
    }

    public static interface CodePopupFrameListener {
        public void popupVisibilityChanged(boolean var1, boolean var2);
    }

    public static interface CodePopupContentView {
        public void setParentCodePopupFrame(CodePopupFrame var1);

        public JComponent updateContentView(FunctionScopedKey<?> var1);

        public JComponent updateContentView(Function var1);

        public boolean isContentViewFocused();
    }

    private class TransparencySafePopup
    extends MWindowsComboBoxUI.WindowsMBasicComboPopup {
        TransparencySafePopup(JComboBox<?> jComboBox) {
            super(jComboBox);
            this.setLightWeightPopupEnabled(true);
        }

        public void show() {
            Point point = new Point(0, this.comboBox.getHeight());
            SwingUtilities.convertPointToScreen(point, this.comboBox);
            Dimension dimension = this.getPreferredSize();
            Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
            CodePopupFrame.this.fToolTip.setPopupRect((Component)((Object)this), rectangle);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TransparencySafePopup.super.show();
                }
            });
        }

        public void hide() {
            boolean bl = this.isShowing();
            super.hide();
            if (bl) {
                CodePopupFrame.this.fToolTip.setPopupRect((Component)((Object)this), null);
            }
        }
    }

    private class TransparencySafeComboBox
    extends MJComboBox {
        TransparencySafeComboBox() {
            if (PlatformInfo.isWindows()) {
                this.setUI((ComboBoxUI)new MWindowsComboBoxUI(){

                    public ComboPopup createPopup() {
                        return new TransparencySafePopup(this.comboBox);
                    }
                });
            }
        }
    }
}

