/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.toolbox.coder.app.AbstractMexBuildManager;
import com.mathworks.toolbox.coder.app.TabbedOutputContext;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.mi.ConversionUtils;
import com.mathworks.toolbox.coder.model.MetadataTree;
import com.mathworks.toolbox.coder.model.VariableKind;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import java.io.File;

public final class FixedPointBuildManager
extends AbstractMexBuildManager {
    private final FixedPointDataAdapter fData;
    private final File fEntryPoint;
    private final ConversionModel fConversionModel;
    private final Runnable fNotifyOnResultsHandled;

    public FixedPointBuildManager(FixedPointDataAdapter fixedPointDataAdapter, File file) {
        this(fixedPointDataAdapter, file, null, null, new Runnable(){

            @Override
            public void run() {
            }
        }, new Runnable(){

            @Override
            public void run() {
            }
        }, new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public FixedPointBuildManager(FixedPointDataAdapter fixedPointDataAdapter, File file, TabbedOutputContext tabbedOutputContext, ConversionModel conversionModel, Runnable runnable, Runnable runnable2, Runnable runnable3) {
        super(fixedPointDataAdapter.getConfiguration(), tabbedOutputContext, "emlcprivate", 6, 3, 2, 5, CoderResources.getString("f2f.status.building"), CoderResources.getString("f2f.status.buildingUpdate"), runnable, runnable2);
        this.fData = fixedPointDataAdapter;
        this.fEntryPoint = file;
        this.fConversionModel = conversionModel;
        this.fNotifyOnResultsHandled = runnable3;
    }

    public File getEntryPoint() {
        return this.fEntryPoint;
    }

    @Override
    protected Object[] getBuildArguments() {
        return new Object[]{"fpBuildFloatingPointCode", this.fData, this.fEntryPoint.getAbsolutePath()};
    }

    @Override
    protected boolean shouldForceInitialBuild() {
        return !this.fConversionModel.hasSimulationRanges() && !this.fConversionModel.hasDerivedRanges();
    }

    @Override
    public File getMexFile() {
        return this.fData.getInstrumentedMexFile();
    }

    @Override
    protected String getLastMexInputChecksum() {
        return this.fData.getMexInputChecksum();
    }

    @Override
    protected String generateMexInputChecksum() {
        return this.fData.generateMexInputChecksum();
    }

    @Override
    protected void updateMexInputChecksum() {
        this.fData.setMexInputChecksum(this.fData.generateMexInputChecksum());
    }

    @Override
    protected void handleBuildOutput(Object[] objectArray) {
        Object object = objectArray[0];
        MetadataTree<VariableKind> metadataTree = ConversionUtils.convertPlainVariableList(object);
        this.fConversionModel.setVariableNames(metadataTree, ConversionUtils.convertMatlabTypes(object));
        this.fConversionModel.setCallTree(ConversionUtils.convertCallTree(objectArray[4], metadataTree.getFunctions()));
        File file = new File((String)objectArray[1]);
        this.fData.setInstrumentedMexFile(file);
        ConversionUtils.loadAllVariableKinds(this.fConversionModel, new Runnable(){

            @Override
            public void run() {
                FixedPointBuildManager.this.fNotifyOnResultsHandled.run();
            }
        });
    }

    @Override
    protected boolean isUseStrictMexValidation() {
        return !this.fConversionModel.isDependencyModifyingTestBenchFlag();
    }
}

