/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.client.Client;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.desktop.ToolstripUtils;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.workflowui.WorkflowDialog;
import com.mathworks.services.Prefs;
import com.mathworks.toolbox.coder.app.BuildManager;
import com.mathworks.toolbox.coder.app.FindAdapter;
import com.mathworks.toolbox.coder.app.FunctionScopedEntityLocator;
import com.mathworks.toolbox.coder.app.GlassPaneManager;
import com.mathworks.toolbox.coder.app.OutputPane;
import com.mathworks.toolbox.coder.app.PopupBarManager;
import com.mathworks.toolbox.coder.app.PopupHintProvider;
import com.mathworks.toolbox.coder.app.TabbedPane;
import com.mathworks.toolbox.coder.app.ide.AbstractCodeInfoView;
import com.mathworks.toolbox.coder.app.ide.EditorLoadContext;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.fixedpoint.ActionWithPopupMenu;
import com.mathworks.toolbox.coder.fixedpoint.AdvancedSettingsTable;
import com.mathworks.toolbox.coder.fixedpoint.AnalysisTable;
import com.mathworks.toolbox.coder.fixedpoint.CallTreeComboBox;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupController;
import com.mathworks.toolbox.coder.fixedpoint.ConversionModel;
import com.mathworks.toolbox.coder.fixedpoint.ConversionStatusManager;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointBuildManager;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointCodePopupContentView;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointController;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointHintProvider;
import com.mathworks.toolbox.coder.fixedpoint.GlobalFixedPointRegistry;
import com.mathworks.toolbox.coder.fixedpoint.HelpAction;
import com.mathworks.toolbox.coder.fixedpoint.OpenInEditorAction;
import com.mathworks.toolbox.coder.fixedpoint.RunSimulationAction;
import com.mathworks.toolbox.coder.fixedpoint.RunStaticAnalysisAction;
import com.mathworks.toolbox.coder.fixedpoint.ValidateTypesAction;
import com.mathworks.toolbox.coder.fixedpoint.VerifyAction;
import com.mathworks.toolbox.coder.fixedpoint.replace.ExpandedReplacementsTable;
import com.mathworks.toolbox.coder.model.CodeCoverageModel;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionUtils;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.core.Animator;
import com.mathworks.toolstrip.DefaultToolstrip;
import com.mathworks.toolstrip.DefaultToolstripTab;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.components.ButtonOrientation;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSButton;
import com.mathworks.toolstrip.components.TSDropDownButton;
import com.mathworks.toolstrip.components.TSLabel;
import com.mathworks.toolstrip.components.TSPanel;
import com.mathworks.toolstrip.components.TSRadioButton;
import com.mathworks.toolstrip.components.TSSplitButton;
import com.mathworks.toolstrip.components.TSTextField;
import com.mathworks.toolstrip.sections.ToolstripSections;
import com.mathworks.util.Converter;
import com.mathworks.util.Holder;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.RequestFilter;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.SyntaxTextPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class FixedPointToolPanel {
    private final MJPanel fComponent;
    private final FixedPointController fController;
    private final boolean fIsHdl;
    private final CodeInfoView fCodeInfoView;
    private final Toolstrip fToolstrip;
    private final ToolstripTab fTab;
    private final FixedPointDataAdapter fData;
    private final ConversionStatusManager fStatus;
    private final CallTreeComboBox fComboBox;
    private final ConversionModel fConversionModel;
    private final AnalysisTable fAnalysisTable;
    private final ExpandedReplacementsTable fReplacementsWidget;
    private final CodeCoverageModel fCoverageModel;
    private final PropertyChangeListener fDataListener;
    private final PropertyChangeListener fStatusListener;
    private final RequestFilter fHdlReset;
    private boolean fSimmedOrDerived;
    private boolean fDisposed;
    private RunSimulationAction fRunSimulationAction;
    private RunStaticAnalysisAction fRunStaticAnalysisAction;
    private VerifyAction fVerifyAction;
    private ValidateTypesAction fValidateAction;
    private TSSplitButton fRunSimulationButton;
    private TSSplitButton fRunStaticAnalysisButton;
    private static final String TAB_NAME = "TAB";
    public static final String PANEL_PROPERTY = "Panel";
    public static final String TABLE_TAB_KEY = "table";
    public static final String FUNCTION_REPLACEMENTS_TAB_KEY = "functionReplacements";

    public FixedPointToolPanel(Window window, GlassPaneManager glassPaneManager, FixedPointDataAdapter fixedPointDataAdapter, ConversionStatusManager conversionStatusManager, ConversionModel conversionModel, File file) {
        this.fData = fixedPointDataAdapter;
        this.fStatus = conversionStatusManager;
        this.fConversionModel = conversionModel;
        this.fCodeInfoView = new CodeInfoView(window, fixedPointDataAdapter.getConfiguration(), file, glassPaneManager);
        this.fComboBox = new CallTreeComboBox(file, this.fConversionModel, this.fCodeInfoView.getGlassPaneManager());
        this.fHdlReset = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                WorkflowDialog.getInstance().resetStep("category.workflow.targetinterface");
                WorkflowDialog.getInstance().resetStep("category.workflow.generate");
            }
        });
        this.fAnalysisTable = new AnalysisTable(this.fData, conversionStatusManager, this.fConversionModel, this.fComboBox, this.fCodeInfoView.getPopupBarManager(), file, new Runnable(){

            @Override
            public void run() {
                FixedPointToolPanel.this.reset(true);
            }
        });
        this.fToolstrip = new DefaultToolstrip();
        this.fToolstrip.setAttribute((Attribute)Toolstrip.NO_TABS, (Object)true);
        this.fReplacementsWidget = new ExpandedReplacementsTable(this.fConversionModel.getFunctionReplacementsModel(), this.fConversionModel, window, glassPaneManager);
        this.fConversionModel.getFunctionReplacementsModel().setScreener(this.fData);
        this.fConversionModel.getFunctionReplacementsModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FixedPointToolPanel.this.fConversionModel.serialize(FixedPointToolPanel.this.fData);
            }
        });
        this.fAnalysisTable.setSelectedFunction(this.fComboBox.getSelectedFunction());
        this.fCoverageModel = new CodeCoverageModel(this.fData);
        GlobalFixedPointRegistry.getInstance().registerInstance(this.fData);
        this.fController = new FixedPointController(this.fData, this.fConversionModel, this.fStatus, (FixedPointBuildManager)this.fCodeInfoView.getBuildManager(), this.fCoverageModel, this.fAnalysisTable, this.fCodeInfoView.getOutputPane(), this.fCodeInfoView.getPopupBarManager(), this.fCodeInfoView.getNotificationManager(), TABLE_TAB_KEY, new Runnable(){

            @Override
            public void run() {
                FixedPointToolPanel.this.preRunAction();
            }
        }, this.createPostDeriveRunnable(), null);
        this.fAnalysisTable.setProposedTypeUpdater(this.fController.getProposedTypesUpdater());
        if (fixedPointDataAdapter.isCoverageEnabled()) {
            this.fCodeInfoView.getEditorView().setCoverageModel(this.fCoverageModel);
        }
        this.fCodeInfoView.getEditorView().setCloseFunctionConverter(new Converter<EditorLoadContext, Function>(){

            public Function convert(EditorLoadContext editorLoadContext) {
                Collection<Function> collection = FixedPointToolPanel.this.fConversionModel.getEntryPointFunctions();
                if (editorLoadContext.hasFunction() && collection.contains(editorLoadContext.getFunction())) {
                    return editorLoadContext.getFunction();
                }
                return !collection.isEmpty() ? collection.iterator().next() : null;
            }
        });
        this.fTab = new DefaultToolstripTab(TAB_NAME, BuiltInResources.getString((String)"toolstrip.home"));
        this.rebuildToolstrip();
        this.fToolstrip.getModel().add((Client)this.fTab);
        this.fToolstrip.setCurrentTab(TAB_NAME);
        this.fToolstrip.setAttribute((Attribute)Toolstrip.COLLAPSABLE, (Object)false);
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fComponent.setName("f2f.panel");
        this.fComponent.putClientProperty((Object)PANEL_PROPERTY, (Object)this);
        this.fComponent.add((Component)this.fToolstrip.getComponent(), (Object)"North");
        this.fComponent.add((Component)this.fCodeInfoView.getComponent(), (Object)"Center");
        this.fIsHdl = fixedPointDataAdapter.getConfiguration().getTarget().getKey().contains("hdl");
        if (this.fIsHdl && !PlatformInfo.isMacintosh()) {
            this.fToolstrip.getComponent().setBorder(new Border(){

                @Override
                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    graphics.setColor(new Color(160, 160, 160));
                    graphics.drawLine(0, 0, component.getWidth(), 0);
                    graphics.drawLine(0, 0, 0, component.getHeight());
                }

                @Override
                public Insets getBorderInsets(Component component) {
                    return new Insets(1, 1, 0, 0);
                }

                @Override
                public boolean isBorderOpaque() {
                    return true;
                }
            });
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.fComponent.add((Component)this.fToolstrip.getComponent(), (Object)"North");
        this.fConversionModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("VariableKinds") || propertyChangeEvent.getPropertyName().equals("SimulationRanges") || propertyChangeEvent.getPropertyName().equals("DerivedRanges")) {
                    FixedPointToolPanel.this.fCodeInfoView.fireChange();
                    FixedPointToolPanel.this.fComboBox.refreshFunctionList();
                }
            }
        });
        this.fComboBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FixedPointToolPanel.this.fAnalysisTable.setSelectedFunction(FixedPointToolPanel.this.fComboBox.getSelectedFunction());
                FixedPointToolPanel.this.fCodeInfoView.getEditorView().displayFunction(FixedPointToolPanel.this.fComboBox.getSelectedFunction());
            }
        });
        this.fDataListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (FixedPointToolPanel.this.fData.isAdvancedTypeProposalSetting(propertyChangeEvent)) {
                    FixedPointToolPanel.this.fController.updateProposedTypes();
                } else if (FixedPointToolPanel.this.fData.isConversionModeChange(propertyChangeEvent)) {
                    FixedPointToolPanel.this.rebuildToolstrip();
                } else if (FixedPointToolPanel.this.fData.isFimathChange(propertyChangeEvent)) {
                    FixedPointToolPanel.this.fConversionModel.updateDefaultsFromFimath(FixedPointToolPanel.this.fData.getFimath());
                } else if (propertyChangeEvent.getPropertyName().contains("Coverage")) {
                    if (FixedPointToolPanel.this.fData.isCoverageEnabled()) {
                        FixedPointToolPanel.this.fCodeInfoView.getEditorView().setCoverageModel(FixedPointToolPanel.this.fCoverageModel);
                    } else {
                        FixedPointToolPanel.this.fCodeInfoView.getEditorView().setCoverageModel(null);
                    }
                } else if (FixedPointToolPanel.this.fIsHdl && (propertyChangeEvent.getPropertyName().equals("param.transformedVariables") || propertyChangeEvent.getPropertyName().equals("param.computedVariables")) || FixedPointToolPanel.this.fData.isAdvancedTypeProposalSetting(propertyChangeEvent)) {
                    FixedPointToolPanel.this.fHdlReset.request();
                }
            }
        };
        this.fStatusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FixedPointToolPanel.this.fCodeInfoView.fireChange();
            }
        };
        this.fCodeInfoView.fireChange();
        this.fData.addPropertyChangeListener(this.fDataListener);
        this.fStatus.addPropertyChangeListener(this.fStatusListener);
        this.fAnalysisTable.addSelectionChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Variable variable = FixedPointToolPanel.this.fAnalysisTable.getSelectedVariable();
                if (variable != null) {
                    FixedPointToolPanel.this.fCodeInfoView.getEditorView().displayVariable(variable);
                }
            }
        });
        if (this.fConversionModel.hasVariableNames()) {
            this.fComboBox.refreshFunctionList();
        }
    }

    private ParameterRunnable<Boolean> createPostDeriveRunnable() {
        return new ParameterRunnable<Boolean>(){

            public void run(Boolean bl) {
                FixedPointToolPanel.this.fSimmedOrDerived = FixedPointToolPanel.this.fSimmedOrDerived || bl != false;
            }
        };
    }

    FixedPointController getController() {
        return this.fController;
    }

    public AnalysisTable getAnalysisTable() {
        return this.fAnalysisTable;
    }

    public boolean runStaticAnalysis(ParameterRunnable<Boolean> parameterRunnable) {
        if (this.fRunStaticAnalysisAction.isEnabled()) {
            return this.fController.runStaticAnalysis(parameterRunnable);
        }
        return false;
    }

    public boolean runSimulation() {
        if (!this.fRunSimulationAction.isEnabled()) {
            return false;
        }
        return this.fRunSimulationAction.tryToRun();
    }

    public boolean validateTypes() {
        return FixedPointToolPanel.runIfEnabled(this.fValidateAction);
    }

    public boolean verifyNumerics() {
        return FixedPointToolPanel.runIfEnabled(this.fVerifyAction);
    }

    public void reset(boolean bl) {
        if (this.fCodeInfoView.isActivated()) {
            this.fConversionModel.reset(bl);
            this.fAnalysisTable.dataChanged();
            this.fData.setSourceCodeChecksum(Double.toString(Math.random()));
            this.fData.setValidationChecksum(Double.toString(Math.random()));
            this.fData.setStaticAnalysisChecksum("");
            this.fComboBox.refreshFunctionList();
            this.fCodeInfoView.getOutputPane().reset();
            new Matlab().evalConsoleOutput("coderprivate.Float2FixedManager.instance.resetEntireTable()");
            if (!bl) {
                this.fCodeInfoView.resetActivation();
            }
        }
    }

    public boolean isTableInitialized() {
        return this.fAnalysisTable.isTableInitialized();
    }

    private static boolean runIfEnabled(MJAbstractAction mJAbstractAction) {
        if (mJAbstractAction.isEnabled()) {
            mJAbstractAction.actionPerformed(null);
            return true;
        }
        return false;
    }

    private void rebuildToolstrip() {
        while (this.fTab.getModel().size() > 0) {
            this.fTab.getModel().remove(0);
        }
        this.fTab.getModel().add((Client)ToolstripSections.newSectionBuilder((String)"analysis", (String)CoderResources.getString("f2f.dataCollection")).add((JComponent)this.createRangePanel()).build());
        this.fTab.getModel().add((Client)ToolstripSections.newSectionBuilder((String)"rangePanel", (String)CoderResources.getString("f2f.navigation")).add((JComponent)this.createNavigationPanel()).build());
        this.fTab.getModel().add((Client)ToolstripSections.newSectionBuilder((String)"typeProposal", (String)CoderResources.getString("f2f.typeProposal")).add((JComponent)this.createSettingsPanel()).build());
        if (this.fData.isModeAutomatic()) {
            this.fTab.getModel().add((Client)ToolstripSections.newSectionBuilder((String)"verification", (String)CoderResources.getString("f2f.verification")).add((JComponent)this.createConversionPanel()).build());
        }
        this.fTab.getModel().add((Client)ToolstripSections.newSectionBuilder((String)"help", (String)BuiltInResources.getString((String)"button.help")).add((JComponent)this.createHelpPanel()).build());
    }

    public void activate() {
        this.fCodeInfoView.activate();
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public OutputPane getOutputPane() {
        return this.fCodeInfoView.getOutputPane();
    }

    public DeploymentProcess getCurrentProcess() {
        return this.fCodeInfoView.getCurrentProcess();
    }

    public void dispose() {
        if (!this.fDisposed) {
            this.fDisposed = true;
            this.fCodeInfoView.dispose();
            this.fCoverageModel.dispose();
            this.fAnalysisTable.dispose();
            this.fReplacementsWidget.dispose();
            this.fData.removePropertyChangeListener(this.fDataListener);
            this.fStatus.removePropertyChangeListener(this.fStatusListener);
            GlobalFixedPointRegistry.getInstance().removeInstance(this.fData);
        }
    }

    private void preRunAction() {
        this.fAnalysisTable.stopEditing();
        this.fAnalysisTable.hideMissingDesignRangeHint();
        this.fCodeInfoView.getPopupBarManager().closePopup();
    }

    private TSPanel createRangePanel() {
        MJAbstractAction mJAbstractAction;
        boolean bl = Prefs.getBooleanPref((String)"EnableF2FExplicitBuild");
        TSPanel tSPanel = new TSPanel(bl ? new FlowLayout(0, 3, 0) : new GridLayout(1, 2, 0, 0));
        this.fRunSimulationAction = new RunSimulationAction(this.fCodeInfoView.getParent(), this.fController, this.fCodeInfoView.getOutputPane(), new Runnable(){

            @Override
            public void run() {
                FixedPointToolPanel.this.fSimmedOrDerived = true;
            }
        });
        this.fRunStaticAnalysisAction = new RunStaticAnalysisAction(this.fController, new ParameterRunnable<Boolean>(){

            public void run(Boolean bl) {
                FixedPointToolPanel.this.fSimmedOrDerived = FixedPointToolPanel.this.fSimmedOrDerived || bl != false;
            }
        });
        this.fRunSimulationButton = this.createSplitButton(this.fRunSimulationAction);
        this.fRunStaticAnalysisButton = this.createSplitButton(this.fRunStaticAnalysisAction);
        this.fRunSimulationAction.setButton(this.fRunSimulationButton);
        if (bl) {
            mJAbstractAction = new MJAbstractAction(BuiltInResources.getString((String)"tab.build"), CoderResources.getIcon("Build_24.png")){

                public void actionPerformed(ActionEvent actionEvent) {
                    FixedPointToolPanel.this.fCodeInfoView.getBuildManager().forceBuild();
                }
            };
            tSPanel.add((Component)ToolstripUtils.createVerticalButton((MJAbstractAction)mJAbstractAction));
        } else {
            mJAbstractAction = null;
        }
        tSPanel.add((Component)this.fRunSimulationButton);
        tSPanel.add((Component)this.fRunStaticAnalysisButton);
        this.fCodeInfoView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = FixedPointToolPanel.this.fConversionModel.hasVariableNames() && !FixedPointToolPanel.this.fCodeInfoView.getOutputPane().isRunningTask();
                FixedPointToolPanel.this.fRunSimulationAction.setEnabled(bl);
                FixedPointToolPanel.this.fRunStaticAnalysisAction.setEnabled(bl);
                if (mJAbstractAction != null) {
                    mJAbstractAction.setEnabled(!FixedPointToolPanel.this.fCodeInfoView.getOutputPane().isRunningTask());
                }
                FixedPointToolPanel.this.fCodeInfoView.getPopupBarManager().updateHint();
            }
        });
        this.fCodeInfoView.incrementPreferredWidth(tSPanel.getPreferredSize().getWidth());
        return tSPanel;
    }

    private TSPanel createNavigationPanel() {
        TSPanel tSPanel = new TSPanel((LayoutManager)new FlowLayout(0, 0, 0));
        tSPanel.add((Component)this.fComboBox.getComponent());
        TSButton tSButton = new TSButton((Action)((Object)new OpenInEditorAction(this.fCodeInfoView.getEditorView())));
        tSButton.setText(null);
        tSPanel.add((Component)tSButton);
        this.fCodeInfoView.incrementPreferredWidth(tSPanel.getPreferredSize().getWidth());
        return tSPanel;
    }

    private TSPanel createSettingsPanel() {
        MJTextField mJTextField;
        TSPanel tSPanel = new TSPanel((LayoutManager)new FlowLayout(0, 0, 0));
        TSPanel tSPanel2 = new TSPanel((LayoutManager)new GridBagLayout());
        TSPanel tSPanel3 = new TSPanel((LayoutManager)new GridLayout(1, 1, 0, 0));
        tSPanel.add((Component)tSPanel2);
        tSPanel.add((Component)tSPanel3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        final TSRadioButton tSRadioButton = new TSRadioButton(CoderResources.getString("f2f.radio.proposeFraction"));
        tSRadioButton.setToolTipText(CoderResources.getString("f2f.radio.proposeFraction.tooltip"));
        tSRadioButton.setName("f2f.radio.proposeFractionLengths");
        final TSRadioButton tSRadioButton2 = new TSRadioButton(CoderResources.getString("f2f.radio.proposeWord"));
        tSRadioButton2.setToolTipText(CoderResources.getString("f2f.radio.proposeWord.tooltip"));
        tSRadioButton2.setName("f2f.radio.proposeWordLengths");
        if (PlatformInfo.isMacintosh()) {
            tSRadioButton.setFont(FontUtils.getSystemUIFont().deriveFont(11.0f));
            tSRadioButton2.setFont(FontUtils.getSystemUIFont().deriveFont(11.0f));
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)tSRadioButton);
        buttonGroup.add((AbstractButton)tSRadioButton2);
        tSPanel2.add((Component)tSRadioButton, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        tSPanel2.add((Component)tSRadioButton2, (Object)gridBagConstraints);
        TSPanel tSPanel4 = new TSPanel((LayoutManager)new GridBagLayout());
        final TSLabel tSLabel = new TSLabel();
        tSLabel.setText(CoderResources.getString("f2f.label.defaultFractionLength"));
        tSLabel.setFont(tSRadioButton.getFont());
        if (PlatformInfo.isMacintosh()) {
            tSLabel.setFont(FontUtils.getSystemUIFont().deriveFont(11.0f));
        }
        tSPanel4.add((Component)tSLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        if (PlatformInfo.isMacintosh()) {
            mJTextField = new MJTextField();
            mJTextField.putClientProperty((Object)"JComponent.sizeVariant", (Object)"mini");
        } else {
            mJTextField = new TSTextField();
        }
        if (this.fData.isProposingFractionLengths()) {
            mJTextField.setText(Integer.toString(this.fData.getDefaultWordLength()));
        } else {
            mJTextField.setText(Integer.toString(this.fData.getDefaultFractionLength()));
        }
        mJTextField.setColumns(3);
        mJTextField.setName("f2f.textfield.defaultLength");
        tSPanel4.add((Component)mJTextField, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        MJPanel mJPanel = new MJPanel();
        mJPanel.setOpaque(false);
        tSPanel4.add((Component)mJPanel, (Object)new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        tSPanel4.setPreferredSize(tSPanel4.getPreferredSize());
        if (this.fData.isProposingFractionLengths()) {
            tSLabel.setText(CoderResources.getString("f2f.label.defaultWordLength"));
        }
        ++gridBagConstraints.gridy;
        tSPanel2.add((Component)tSPanel4, (Object)gridBagConstraints);
        final TSDropDownButton tSDropDownButton = new TSDropDownButton(CoderResources.getString("f2f.action.settings"), CoderResources.getIcon("settings.png"));
        tSDropDownButton.setPopupListener(new PopupListener(){

            public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                AdvancedSettingsTable advancedSettingsTable = new AdvancedSettingsTable(FixedPointToolPanel.this.fData);
                MJPanel mJPanel = new MJPanel(new BorderLayout(0, 0)){

                    public Dimension getPreferredSize() {
                        return new Dimension(425, (int)super.getPreferredSize().getHeight() + 2);
                    }
                };
                mJPanel.setBorder((Border)new EmptyBorder(3, 3, 3, 3));
                mJPanel.add((Component)advancedSettingsTable.getComponent());
                popupCallback.show((JComponent)mJPanel);
            }
        });
        tSDropDownButton.setOrientation(ButtonOrientation.VERTICAL);
        tSDropDownButton.setToolTipText(CoderResources.getString("f2f.action.settings.tooltip"));
        tSDropDownButton.setName("f2f.action.moreSettings");
        tSPanel.add((Component)tSDropDownButton);
        if (PlatformInfo.isMacintosh()) {
            tSDropDownButton.setFont(FontUtils.getSystemUIFont().deriveFont(11.0f));
        }
        final Holder holder = new Holder((Object)false);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                holder.set((Object)true);
                if (tSRadioButton2.isSelected()) {
                    tSLabel.setText(CoderResources.getString("f2f.label.defaultFractionLength"));
                    mJTextField.setText(Integer.toString(FixedPointToolPanel.this.fData.getDefaultFractionLength()));
                    FixedPointToolPanel.this.fData.setProposeFractionLengths(false);
                    FixedPointToolPanel.this.fController.updateProposedTypes();
                } else {
                    tSLabel.setText(CoderResources.getString("f2f.label.defaultWordLength"));
                    mJTextField.setText(Integer.toString(FixedPointToolPanel.this.fData.getDefaultWordLength()));
                    FixedPointToolPanel.this.fData.setProposeFractionLengths(true);
                    FixedPointToolPanel.this.fController.updateProposedTypes();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        holder.set((Object)false);
                    }
                });
            }
        };
        if (this.fData.isProposingFractionLengths()) {
            tSRadioButton.setSelected(true);
        } else {
            tSRadioButton2.setSelected(true);
        }
        tSRadioButton2.addItemListener(itemListener);
        tSRadioButton.addItemListener(itemListener);
        this.fCodeInfoView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = FixedPointToolPanel.this.fConversionModel.hasVariableNames() && !FixedPointToolPanel.this.fCodeInfoView.getOutputPane().isRunningTask() && !FixedPointToolPanel.this.fCodeInfoView.getOutputPane().hasBuildErrors();
                mJTextField.setEnabled(bl);
                tSLabel.setEnabled(bl);
                tSRadioButton2.setEnabled(bl);
                tSRadioButton.setEnabled(bl);
                tSDropDownButton.setEnabled(bl);
            }
        });
        mJTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (((Boolean)holder.get()).booleanValue()) {
                    return;
                }
                try {
                    int n = Integer.parseInt(mJTextField.getText());
                    if (tSRadioButton2.isSelected()) {
                        FixedPointToolPanel.this.fData.setDefaultFractionLength(n);
                    } else {
                        FixedPointToolPanel.this.fData.setDefaultWordLength(n);
                    }
                    FixedPointToolPanel.this.fController.updateProposedTypes();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        });
        this.fCodeInfoView.incrementPreferredWidth(tSPanel.getPreferredSize().getWidth());
        return tSPanel;
    }

    private TSPanel createConversionPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        TSPanel tSPanel = new TSPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.fValidateAction = new ValidateTypesAction(this.fController);
        this.fVerifyAction = new VerifyAction(this.fCodeInfoView.getParent(), this.fData, this.fController, this.fAnalysisTable);
        TSButton tSButton = ToolstripUtils.createVerticalButton((MJAbstractAction)this.fValidateAction);
        TSSplitButton tSSplitButton = this.createSplitButton(this.fVerifyAction);
        this.fVerifyAction.setButton(tSSplitButton);
        this.fCodeInfoView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = FixedPointToolPanel.this.fSimmedOrDerived && FixedPointToolPanel.this.fConversionModel.hasVariableNames() && !FixedPointToolPanel.this.fCodeInfoView.getOutputPane().isRunningTask() && FixedPointToolPanel.this.fConversionModel.hasAllProposedTypes() && !FixedPointToolPanel.this.fCodeInfoView.getOutputPane().hasBuildErrors();
                FixedPointToolPanel.this.fValidateAction.setEnabled(bl);
                FixedPointToolPanel.this.fValidateAction.putValue("SmallIcon", CoderResources.getIcon(!FixedPointToolPanel.this.fStatus.needsValidation() ? "validate_types_completed.png" : "validate_types.png"));
                FixedPointToolPanel.this.fVerifyAction.setEnabled(bl && !FixedPointToolPanel.this.fStatus.needsValidation());
            }
        });
        tSPanel.add((Component)tSButton, (Object)gridBagConstraints);
        ++gridBagConstraints.gridx;
        tSPanel.add((Component)tSSplitButton, (Object)gridBagConstraints);
        this.fCodeInfoView.incrementPreferredWidth(tSPanel.getPreferredSize().getWidth());
        return tSPanel;
    }

    private TSPanel createHelpPanel() {
        TSPanel tSPanel = new TSPanel((LayoutManager)new GridLayout(1, 1, 0, 0));
        tSPanel.add((Component)ToolstripUtils.createVerticalButton((MJAbstractAction)new HelpAction(this.fCodeInfoView.getParent(), this.fData.getConfiguration())));
        return tSPanel;
    }

    private TSSplitButton createSplitButton(final ActionWithPopupMenu actionWithPopupMenu) {
        TSSplitButton tSSplitButton = new TSSplitButton((Action)actionWithPopupMenu);
        tSSplitButton.setOrientation(ButtonOrientation.VERTICAL);
        tSSplitButton.setPopupListener(new PopupListener(){

            public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                FixedPointToolPanel.this.fCodeInfoView.getPopupBarManager().closePopup();
                actionWithPopupMenu.showPopup(popupCallback);
            }
        });
        if (PlatformInfo.isMacintosh()) {
            tSSplitButton.setFont(FontUtils.getSystemUIFont().deriveFont(11.0f));
        }
        return tSSplitButton;
    }

    private void enterReadyState() {
        this.fStatus.refresh();
        this.fCodeInfoView.getOutputPane().setTabVisible(TABLE_TAB_KEY, true);
        if (this.fData.isModeAutomatic()) {
            this.fCodeInfoView.getOutputPane().setTabVisible(FUNCTION_REPLACEMENTS_TAB_KEY, true);
        }
        this.fCodeInfoView.getOutputPane().activateTab(TABLE_TAB_KEY);
        this.fCodeInfoView.getPopupBarManager().enterReadyState();
    }

    private ReturnRunnable<Point> createDataCollectionPositioner() {
        return new ReturnRunnable<Point>(){

            public Point run() {
                Point point = new Point((FixedPointToolPanel.this.fRunStaticAnalysisButton.getX() + FixedPointToolPanel.this.fRunStaticAnalysisButton.getWidth() - FixedPointToolPanel.this.fRunSimulationButton.getX()) / 2 + FixedPointToolPanel.this.fRunSimulationButton.getX(), FixedPointToolPanel.this.fToolstrip.getComponent().getHeight());
                SwingUtilities.convertPointToScreen(point, FixedPointToolPanel.this.fToolstrip.getComponent().getParent());
                return point;
            }
        };
    }

    public static CodePopupController createFixedPointPopupController(Window window, EditorView editorView, AnalysisTable analysisTable) {
        return new CodePopupController(window, editorView, analysisTable.getConversionModel(), new FixedPointCodePopupContentView(analysisTable));
    }

    static {
        MJUtilities.initJIDE();
    }

    private class CodeInfoView
    extends AbstractCodeInfoView {
        public CodeInfoView(Window window, Configuration configuration, File file, GlassPaneManager glassPaneManager) {
            super(window, glassPaneManager, new Animator(), !PlatformInfo.isMacintosh() && configuration.getTargetKey().contains("hdl"));
            this.getEditorView().displayFunction(new Function(file, FunctionUtils.getFunctionName(file)));
        }

        @Override
        protected PopupHintProvider createHintProvider(PopupBarManager popupBarManager, FindAdapter findAdapter) {
            return new FixedPointHintProvider(popupBarManager, FixedPointToolPanel.this.fConversionModel, FixedPointToolPanel.this.fStatus, this.getParent(), this.getComponent(), findAdapter, (ReturnRunnable<Point>)FixedPointToolPanel.this.createDataCollectionPositioner());
        }

        @Override
        protected boolean isFunctionInTargetCodeBase(Function function) {
            return false;
        }

        @Override
        protected void filterInfo(String string) {
            FixedPointToolPanel.this.fAnalysisTable.find(string);
        }

        @Override
        protected void clearInfoFilter() {
            FixedPointToolPanel.this.fAnalysisTable.clearSearch();
        }

        @Override
        protected void preShowCodeContextMenu() {
            FixedPointToolPanel.this.fAnalysisTable.stopEditing();
        }

        @Override
        protected void forceFunctionSelection(Function function) {
            FixedPointToolPanel.this.fComboBox.selectSilently(function, true);
        }

        @Override
        protected void handleFunctionSelectionFromCode(Function function) {
            FixedPointToolPanel.this.fComboBox.selectSilently(function, false);
            FixedPointToolPanel.this.fAnalysisTable.setSelectedFunction(FixedPointToolPanel.this.fComboBox.getSelectedFunction());
        }

        @Override
        protected BuildManager createBuildManager(OutputPane outputPane) {
            return new FixedPointBuildManager(FixedPointToolPanel.this.fData, FixedPointToolPanel.this.fData.getEntryPoints().iterator().next(), outputPane, FixedPointToolPanel.this.fConversionModel, new Runnable(){

                @Override
                public void run() {
                    FixedPointToolPanel.this.fStatus.refresh();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    FixedPointToolPanel.this.enterReadyState();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    CodeInfoView.this.getOutputPane().setTabVisible(FixedPointToolPanel.TABLE_TAB_KEY, true);
                }
            });
        }

        @Override
        protected CodePopupController createCodePopupController(Window window, EditorView editorView, SyntaxTextPane syntaxTextPane, Function function) {
            return FixedPointToolPanel.createFixedPointPopupController(window, editorView, FixedPointToolPanel.this.fAnalysisTable);
        }

        @Override
        protected FunctionScopedEntityLocator createEntityLocator() {
            return new FunctionScopedEntityLocator(FixedPointToolPanel.this.fConversionModel);
        }

        @Override
        protected void initializeTabbedPane(TabbedPane tabbedPane) {
            tabbedPane.addTab(FixedPointToolPanel.TABLE_TAB_KEY, CoderResources.getString("f2f.tab.table"), FixedPointToolPanel.this.fAnalysisTable.getComponent());
            tabbedPane.addTab(FixedPointToolPanel.FUNCTION_REPLACEMENTS_TAB_KEY, CoderResources.getString("f2f.tab.functionReplacements"), FixedPointToolPanel.this.fReplacementsWidget.getComponent());
            tabbedPane.addTab("output", CoderResources.getString("f2f.tab.output"));
            tabbedPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    FixedPointToolPanel.this.fAnalysisTable.stopEditing();
                }
            });
        }

        @Override
        protected boolean isEntryPoint(File file) {
            return FixedPointToolPanel.this.fData.getEntryPoints().contains(file);
        }
    }
}

