/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.CellPaintContext;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableDecorator;
import com.mathworks.project.impl.table.VirtualComponent;
import com.mathworks.project.impl.table.VirtualComponentManager;
import com.mathworks.toolbox.coder.fixedpoint.CellExpansionPopup;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import com.mathworks.toolbox.coder.model.MetadataTree;
import com.mathworks.toolbox.coder.model.MetadataTreeUtils;
import com.mathworks.toolbox.coder.model.Range;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.ReturnRunnable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.SwingUtilities;

public final class RangeColumn
extends AbstractPropertyTableColumn<Variable> {
    private final ReturnRunnable<MetadataTree<Range>>[] fChain;
    private final boolean fMin;
    private final boolean fEditable;
    private PropertyTable<Variable> fTable;
    private static final DecimalFormat FORMAT = new DecimalFormat("##########################0.##");
    private static final DecimalFormat FULL_FORMAT = new DecimalFormat("##########################0.#################################################");

    RangeColumn(boolean bl, boolean bl2, String string, ReturnRunnable<MetadataTree<Range>> ... returnRunnableArray) {
        super(string);
        this.fChain = (ReturnRunnable[])returnRunnableArray.clone();
        this.fMin = bl;
        this.fEditable = bl2;
    }

    public void setTable(PropertyTable<Variable> propertyTable) {
        this.fTable = propertyTable;
    }

    public PropertyTableDecorator<Variable> getDecorator() {
        return new PropertyTableDecorator<Variable>(){

            public boolean shouldPaintText(Variable variable) {
                return true;
            }

            public void paintDecoration(CellPaintContext<Variable> cellPaintContext, Graphics2D graphics2D, VirtualComponentManager virtualComponentManager, Color color, Color color2) {
                Variable variable = (Variable)cellPaintContext.getValue();
                Rectangle2D rectangle2D = cellPaintContext.getCellRect();
                if (variable == null) {
                    return;
                }
                Double d = RangeColumn.this.getValue(variable);
                if (d == null) {
                    return;
                }
                String string = RangeColumn.this.getText(variable);
                String string2 = RangeColumn.this.getFullText(variable);
                int n = cellPaintContext.getRowIndex();
                int n2 = cellPaintContext.getColumnIndex();
                double d2 = graphics2D.getFontMetrics().getStringBounds(string, graphics2D).getWidth();
                if (RangeColumn.isAbbreviated(string2, string) || d2 > rectangle2D.getWidth() - 4.0) {
                    CellExpansionPopup cellExpansionPopup;
                    List list = virtualComponentManager.getComponents(n, n2);
                    if (list.isEmpty()) {
                        double d3 = cellPaintContext.getCellRect().getX() + cellPaintContext.getCellRect().getWidth() - 14.0 - 5.0;
                        cellExpansionPopup = new CellExpansionPopup((PropertyTable<Variable>)RangeColumn.this.fTable, cellPaintContext, d3, true, string2);
                        virtualComponentManager.defineCellComponents(n, n2, new VirtualComponent[]{cellExpansionPopup});
                    } else {
                        cellExpansionPopup = (CellExpansionPopup)((Object)list.get(0));
                    }
                    cellExpansionPopup.paint(graphics2D);
                } else {
                    virtualComponentManager.defineCellComponents(n, n2, new VirtualComponent[0]);
                }
            }
        };
    }

    private static boolean isAbbreviated(String string, String string2) {
        try {
            Double.parseDouble(string);
            Double.parseDouble(string2);
            return !string.equals(string2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getFullText(Variable variable) {
        Double d = this.getValue(variable);
        return d != null ? FULL_FORMAT.format(d) : "";
    }

    public String getText(Variable variable) {
        Double d = this.getValue(variable);
        if (d == null) {
            return "";
        }
        return RangeColumn.format(d);
    }

    public Double getValue(Variable variable) {
        return MetadataTreeUtils.get(this.fMin, (FunctionScopedKey)variable, this.fChain);
    }

    public boolean isNumericallyAligned() {
        return true;
    }

    public boolean hasHiddenDigits(Variable variable, String string, Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (variable == null) {
            return false;
        }
        Double d = this.getValue(variable);
        String string2 = this.getFullText(variable);
        double d2 = graphics2D.getFontMetrics().getStringBounds(string, graphics2D).getWidth();
        return d != null && (RangeColumn.isAbbreviated(string, string2) || d2 > rectangle2D.getWidth() - 4.0);
    }

    public int getRightMargin(boolean bl, boolean bl2, Graphics2D graphics2D) {
        return bl2 ? 21 : 5;
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public int compareForAscendingSort(Variable variable, Variable variable2) {
        Double d;
        Double d2 = this.getValue(variable);
        if (d2 == null ^ (d = this.getValue(variable2)) == null) {
            return d2 == null ? -1 : 1;
        }
        if (d2 == null) {
            return 0;
        }
        if (d2 < d) {
            return -1;
        }
        if (d2 > d) {
            return 1;
        }
        return 0;
    }

    public static String format(double d) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Inf";
        }
        if (Double.isNaN(d)) {
            return CoderResources.getString("f2f.range.unknown");
        }
        String string = FORMAT.format(d);
        if (string.equals("-0")) {
            string = "0";
        }
        return string;
    }
}

