/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.toolbox.coder.fixedpoint.ActionWithPopupMenu;
import com.mathworks.toolbox.coder.fixedpoint.AnalysisTable;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointController;
import com.mathworks.toolbox.coder.fixedpoint.FixedPointDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.ToolstripPopupUtils;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.TestFileSelectorPanel;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSSplitButton;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.util.ParameterRunnable;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;

public class VerifyAction
extends MJAbstractAction
implements ActionWithPopupMenu {
    private final FixedPointDataAdapter fData;
    private final FixedPointController fController;
    private final Window fParent;
    private final AnalysisTable fTable;
    private TSSplitButton fButton;
    private PopupList fList;

    public VerifyAction(Window window, FixedPointDataAdapter fixedPointDataAdapter, FixedPointController fixedPointController, AnalysisTable analysisTable) {
        super(VerifyAction.expand(fixedPointDataAdapter.getConfiguration(), CoderResources.getString("f2f.action.verify")), CoderResources.getIcon("run_ts_24.png"));
        this.fController = fixedPointController;
        this.fParent = window;
        this.fData = fixedPointDataAdapter;
        this.fTable = analysisTable;
        this.setTip(CoderResources.getString("f2f.action.verify.tooltip"));
        this.setComponentName("f2f.action.verifyNumerics");
    }

    public void setButton(TSSplitButton tSSplitButton) {
        this.fButton = tSSplitButton;
    }

    private static String expand(Configuration configuration, String string) {
        if (configuration.getTarget().getKey().contains("hdl")) {
            return string;
        }
        return string.replaceAll("\n", " ");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ToolstripPopupUtils.closePopup(this.fList);
        this.fList = null;
        this.fTable.hideMissingDesignRangeHint();
        Set<File> set = this.fData.getVerificationTestFiles().getFiles();
        Set<File> set2 = this.fData.getVerificationTestFiles().getExcludedFiles();
        if (set.isEmpty()) {
            this.chooseFileAndRun();
        } else if (set2.containsAll(set)) {
            this.fButton.doDropDownClick();
        } else {
            this.fController.testNumerics(new ArrayList<File>(set), false, null);
        }
    }

    @Override
    public void showPopup(PopupListener.PopupCallback popupCallback) {
        final HashMap<ListItem, Runnable> hashMap = new HashMap<ListItem, Runnable>();
        DefaultListModel<ListItem> defaultListModel = new DefaultListModel<ListItem>();
        this.fList = new PopupList();
        this.fList.setName("f2f.verifyNumerics.popup");
        this.fList.setListStyle(ListStyle.ICON_TEXT);
        this.fList.setModel(defaultListModel);
        this.fList.addListActionListener(new ListActionListener(){

            public void listItemSelected(ListActionEvent listActionEvent) {
                ((Runnable)hashMap.get(listActionEvent.getListItem())).run();
            }
        });
        ToolstripPopupUtils.addMultiSelectTestFileList(this.fList, this.fParent, defaultListModel, this.fData, this.fData.getVerificationTestFiles(), hashMap);
        ListItem listItem = new ListItem("OPTIONS");
        listItem.setAttribute((Attribute)ListItem.TITLE, (Object)CoderResources.getString("f2f.options"));
        listItem.setAttribute((Attribute)ListItem.HEADER, (Object)true);
        defaultListModel.addElement(listItem);
        ListItem listItem2 = new ListItem("logAllValues");
        listItem2.setAttribute((Attribute)ListItem.TITLE, (Object)CoderResources.getString("f2f.logIO"));
        listItem2.setAttribute((Attribute)ListItem.HAS_CHECKBOX, (Object)true);
        listItem2.setAttribute((Attribute)ListItem.CHECKVALUE_STATE, (Object)this.fData.isVerificationLoggingEnabled());
        defaultListModel.addElement(listItem2);
        hashMap.put(listItem2, new Runnable(){

            @Override
            public void run() {
                VerifyAction.this.fData.setVerificationLoggingEnabled(!VerifyAction.this.fData.isVerificationLoggingEnabled());
                OverlayManager overlayManager = OverlayManagers.get((Component)VerifyAction.this.fList);
                if (overlayManager != null) {
                    overlayManager.packOverlay((Component)VerifyAction.this.fList);
                }
            }
        });
        ListItem listItem3 = new ListItem("detectOverflows");
        listItem3.setAttribute((Attribute)ListItem.TITLE, (Object)CoderResources.getString("f2f.detectOverflows"));
        listItem3.setAttribute((Attribute)ListItem.HAS_CHECKBOX, (Object)true);
        listItem3.setAttribute((Attribute)ListItem.CHECKVALUE_STATE, (Object)this.fData.isOverflowDetectionEnabled());
        defaultListModel.addElement(listItem3);
        hashMap.put(listItem3, new Runnable(){

            @Override
            public void run() {
                VerifyAction.this.fData.setOverflowDetectionEnabled(!VerifyAction.this.fData.isOverflowDetectionEnabled());
                OverlayManager overlayManager = OverlayManagers.get((Component)VerifyAction.this.fList);
                if (overlayManager != null) {
                    overlayManager.packOverlay((Component)VerifyAction.this.fList);
                }
            }
        });
        popupCallback.show((JComponent)this.fList);
        OverlayManager overlayManager = OverlayManagers.get((Component)this.fList);
        if (overlayManager != null) {
            overlayManager.setAllowMultiSelect((Component)this.fList, true);
        }
    }

    private void chooseFileAndRun() {
        TestFileSelectorPanel.browseForTestFile(this.fParent, this.fData.getConfiguration(), new ParameterRunnable<File>(){

            public void run(File file) {
                VerifyAction.this.fData.setDefaultTestFile(file);
                VerifyAction.this.actionPerformed(null);
            }
        });
    }
}

