/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.fixedpoint.replace;

import com.mathworks.mwswing.MJTextField;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import com.mathworks.project.impl.textfield.AutoCompleter;
import com.mathworks.project.impl.textfield.CharacterFilter;
import com.mathworks.project.impl.textfield.FormatTokenizer;
import com.mathworks.project.impl.textfield.FormattedTextField;
import com.mathworks.project.impl.textfield.Token;
import com.mathworks.toolbox.coder.fixedpoint.replace.FunctionReplacementStrategy;
import com.mathworks.toolbox.coder.fixedpoint.replace.ReplacementKey;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.util.ParameterRunnable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;

class DesignMinMaxCellEditor
implements PropertyTableCellEditor<ReplacementKey> {
    private static final String AUTO_TEXT = CoderResources.getString("f2f.functionReplacement.property.autoValue");
    private static final String AUTO_TEXT_LOWERED = AUTO_TEXT.toLowerCase();
    private static final Set<Character> AUTO_CHARS = DesignMinMaxCellEditor.initAutoChars();
    private static final CharacterFilter MIN_MAX_CHARACTER_FILTER = DesignMinMaxCellEditor.createCharacterFilter();
    private static final int TOKEN_TYPE_AUTO = 1;
    private static final int TOKEN_TYPE_DEFAULT = 0;
    private final PropertyTable<ReplacementKey> fTable;
    private final CustomTextField fTextField;
    private final ParameterRunnable<Object> fChangeCallback;
    private final FunctionReplacementStrategy.Property fProperty;
    private final PropertyChangeListener fChangeListener;
    private final Object fAutoValue;
    private boolean fAllowAuto;

    DesignMinMaxCellEditor(PropertyTable<ReplacementKey> propertyTable, Object object, FunctionReplacementStrategy.Property property, ParameterRunnable<Object> parameterRunnable) {
        this.fTable = propertyTable;
        this.fChangeCallback = parameterRunnable;
        this.fProperty = property;
        this.fAutoValue = object;
        this.fTextField = new CustomTextField();
        this.fTextField.getComponent().setBorder(new MJTextField().getBorder());
        this.fChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!DesignMinMaxCellEditor.this.fTextField.getText().equals(DesignMinMaxCellEditor.this.fProperty.getStringValue())) {
                    DesignMinMaxCellEditor.this.loadData(DesignMinMaxCellEditor.this.fProperty.getValue(), DesignMinMaxCellEditor.this.fProperty.getStringValue());
                }
            }
        };
        this.fProperty.addPropertyChangeListener(this.fChangeListener);
    }

    void setAllowAuto(boolean bl) {
        this.fAllowAuto = bl;
    }

    boolean isAllowAuto() {
        return this.fAllowAuto;
    }

    public void loadData(Object object, String string) {
        if (Utilities.areValuesDifferent(this.fProperty.getValue(), this.fAutoValue)) {
            this.fTextField.setText(this.fProperty.getStringValue() != null ? this.fProperty.getStringValue() : "");
        } else {
            this.fTextField.setText(AUTO_TEXT);
        }
    }

    public void commitData() {
        String string = this.fTextField.getText().trim();
        if (!string.equals(AUTO_TEXT)) {
            try {
                Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        this.fChangeCallback.run((Object)string);
    }

    public JComponent getComponent() {
        return this.fTextField.getComponent();
    }

    public void activate() {
        this.fTextField.requestFocus();
        this.fTextField.selectAll();
    }

    public void dispose() {
        this.fProperty.removePropertyChangeListener(this.fChangeListener);
        this.fTextField.dispose();
    }

    private static Set<Character> initAutoChars() {
        HashSet<Character> hashSet = new HashSet<Character>();
        for (int i = 0; i < AUTO_TEXT.length(); ++i) {
            char c = AUTO_TEXT.charAt(i);
            hashSet.add(Character.valueOf(Character.toLowerCase(c)));
            hashSet.add(Character.valueOf(Character.toUpperCase(c)));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static CharacterFilter createCharacterFilter() {
        return new CharacterFilter(){

            public boolean accept(FormattedTextField formattedTextField, char c) {
                return Character.isDigit(c) || c == '-' || AUTO_CHARS.contains(Character.valueOf(c)) || c == '.';
            }
        };
    }

    private class CustomTextField
    extends FormattedTextField {
        CustomTextField() {
            this.setFilter(MIN_MAX_CHARACTER_FILTER);
            this.setTokenizer(new FormatTokenizer(){

                public List<Token> tokenize(String string) {
                    return Arrays.asList(new Token(string.equals(AUTO_TEXT) ? 1 : 0, string));
                }
            });
            this.setCompleter(new AutoCompleter(){

                public void getSuggestedCompletion(List<Token> list, ParameterRunnable<List<Token>> parameterRunnable) {
                    String string;
                    String string2 = string = !list.isEmpty() ? list.get(0).getText() : "";
                    if (AUTO_TEXT_LOWERED.startsWith(string.toLowerCase())) {
                        parameterRunnable.run(Arrays.asList(new Token(1, AUTO_TEXT.substring(string.length()))));
                    } else {
                        parameterRunnable.run(new LinkedList());
                    }
                }
            });
        }

        private boolean containsOnlyAutoChars(String string) {
            for (int i = 0; i < string.length(); ++i) {
                if (AUTO_CHARS.contains(Character.valueOf(string.charAt(i)))) continue;
                return false;
            }
            return true;
        }

        private boolean willStillBeNumber(String string) {
            try {
                Integer.parseInt(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        protected boolean isField(Token token) {
            return true;
        }

        protected boolean isPrompt(Token token) {
            return true;
        }

        public void doEnter() {
            if (AUTO_TEXT_LOWERED.startsWith(this.getText().toLowerCase())) {
                this.setText(AUTO_TEXT);
            }
            DesignMinMaxCellEditor.this.fTable.stopEditing(false);
        }

        public void doEscape() {
            DesignMinMaxCellEditor.this.fTable.stopEditing(true);
        }
    }
}

