/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.mi;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Array;

public final class MatlabInterfaceLogger {
    private static PrintWriter sLog;

    private MatlabInterfaceLogger() {
    }

    private static boolean attachLogFileFromEnv(String string) {
        try {
            if (System.getenv(string) != null) {
                sLog = new PrintWriter(new FileWriter(System.getenv(string)));
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logReturn(String string, int n, Object[] objectArray, Object object) {
        if (sLog != null) {
            PrintWriter printWriter = sLog;
            synchronized (printWriter) {
                sLog.println(MatlabInterfaceLogger.createLogHeader(string, n, objectArray));
                MatlabInterfaceLogger.logData(0, object);
                sLog.println();
                sLog.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logCancellation(String string, int n, Object[] objectArray) {
        if (sLog != null) {
            PrintWriter printWriter = sLog;
            synchronized (printWriter) {
                sLog.println(MatlabInterfaceLogger.createLogHeader(string, n, objectArray) + " canceled");
                sLog.println();
                sLog.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logError(String string, int n, Object[] objectArray, Exception exception) {
        if (sLog != null) {
            PrintWriter printWriter = sLog;
            synchronized (printWriter) {
                sLog.println(MatlabInterfaceLogger.createLogHeader(string, n, objectArray) + " failed:");
                exception.printStackTrace(sLog);
                sLog.println();
                sLog.flush();
            }
        }
    }

    private static String createLogHeader(String string, int n, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[" + n + "] = " + string + "(");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuilder.append(objectArray[i]);
            if (i >= objectArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static void logData(int n, Object object) {
        for (int i = 0; i < n; ++i) {
            sLog.print("   ");
        }
        if (object == null) {
            sLog.println("null");
        } else {
            String string = object.getClass().getName();
            if (string.startsWith("java.lang.")) {
                string = string.substring("java.lang.".length());
            } else if (string.startsWith("[Ljava.lang.")) {
                string = "[" + string.substring("[Ljava.lang.".length());
            }
            sLog.print(string);
            if (object.getClass().isArray()) {
                if (Array.getLength(object) == 0) {
                    sLog.println(" empty");
                } else {
                    sLog.println();
                    for (int i = 0; i < Array.getLength(object); ++i) {
                        MatlabInterfaceLogger.logData(n + 1, Array.get(object, i));
                    }
                }
            } else if (object instanceof String) {
                sLog.println(" \"" + object + "\"");
            } else {
                sLog.println(" " + object);
            }
        }
    }

    static {
        if (!MatlabInterfaceLogger.attachLogFileFromEnv("__MATLAB_CODER_F2F_LOG_FILE")) {
            MatlabInterfaceLogger.attachLogFileFromEnv("__MATLAB_CODER_GUI_LOG_FILE");
        }
    }
}

