/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.model;

import com.mathworks.toolbox.coder.model.CodableEntity;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.util.LRUMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public final class CallTree {
    private final Map<Function, List<CallSite>> fCallSites;
    private final Map<Function, CallTree> fHierarchyCache;
    private final boolean fInverted;

    public CallTree() {
        this(false);
    }

    private CallTree(boolean bl) {
        this.fInverted = bl;
        this.fCallSites = new HashMap<Function, List<CallSite>>();
        this.fHierarchyCache = !bl ? new LRUMap<Function, CallTree>(new LRUMap.LRUPredicate<Function, CallTree>(){

            @Override
            public boolean evictEldestEntry(Map.Entry<Function, CallTree> entry, Map<Function, CallTree> map) {
                return map.size() > 1;
            }
        }) : new TreeMap();
    }

    public void add(@NotNull CallSite callSite) {
        this.add(callSite, true);
    }

    private void add(@NotNull CallSite callSite, boolean bl) {
        Function function = bl ? callSite.getEnclosingFunction() : callSite.getTarget();
        List<CallSite> list = this.fCallSites.get(function);
        if (list == null) {
            list = new LinkedList<CallSite>();
            this.fCallSites.put(function, list);
        }
        list.add(callSite);
        this.fHierarchyCache.clear();
    }

    @NotNull
    public List<CallSite> getCallSites(@NotNull Function function) {
        ArrayList arrayList = this.fCallSites.get(function);
        return arrayList == null ? new ArrayList(0) : arrayList;
    }

    @NotNull
    public Set<Function> getFunctionsInvoked(@NotNull Function function) {
        TreeSet<Function> treeSet = new TreeSet<Function>();
        for (CallSite callSite : this.getCallSites(function)) {
            treeSet.add(callSite.getTarget());
        }
        return treeSet;
    }

    @NotNull
    public Set<CallSite> getAllCallSites() {
        LinkedHashSet<CallSite> linkedHashSet = new LinkedHashSet<CallSite>();
        for (Collection collection : this.fCallSites.values()) {
            linkedHashSet.addAll(collection);
        }
        return linkedHashSet;
    }

    public boolean isInverted() {
        return this.fInverted;
    }

    @NotNull
    public CallTree getCallHierarchy(@NotNull Function function) {
        if (!this.isInverted()) {
            CallTree callTree = this.fHierarchyCache.get(function);
            if (callTree == null) {
                callTree = this.buildCallHierarchy(function);
                this.fHierarchyCache.put(function, callTree);
            }
            return callTree;
        }
        return this;
    }

    private CallTree buildCallHierarchy(Function function) {
        CallTree callTree = new CallTree(true);
        Set<CallSite> set = this.getAllCallSites();
        LinkedList<Function> linkedList = new LinkedList<Function>();
        HashSet<Function> hashSet = new HashSet<Function>();
        linkedList.add(function);
        while (!linkedList.isEmpty()) {
            hashSet.addAll(linkedList);
            linkedList.clear();
            Iterator<CallSite> iterator = set.iterator();
            while (iterator.hasNext()) {
                CallSite callSite = iterator.next();
                if (!hashSet.contains(callSite.getTarget())) continue;
                callTree.add(callSite, false);
                linkedList.add(callSite.getEnclosingFunction());
                iterator.remove();
            }
            hashSet.clear();
        }
        return callTree;
    }

    public static final class CallSite
    implements CodableEntity {
        private final int fPosition;
        private final Function fEnclosingFunction;
        private final Function fTarget;

        public CallSite(int n, @NotNull Function function, @NotNull Function function2) {
            this.fPosition = n;
            this.fEnclosingFunction = function;
            this.fTarget = function2;
        }

        public int getPosition() {
            return this.fPosition;
        }

        @NotNull
        public Function getEnclosingFunction() {
            return this.fEnclosingFunction;
        }

        @NotNull
        public Function getTarget() {
            return this.fTarget;
        }

        @Override
        public CodableEntity.Type getEntityType() {
            return CodableEntity.Type.CALL_SITE;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CallSite)) {
                return false;
            }
            CallSite callSite = (CallSite)object;
            return this.fPosition == callSite.getPosition() && this.fTarget.equals(callSite.getTarget()) && this.fEnclosingFunction.equals(callSite.getEnclosingFunction());
        }

        public int hashCode() {
            int n = this.fPosition;
            n = 31 * n + this.fEnclosingFunction.hashCode();
            n = 31 * n + this.fTarget.hashCode();
            return n;
        }
    }
}

