/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.model;

import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.impl.model.DefaultProjectVersionSupport;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.ProjectVersionSupport;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.model.TargetFactory;
import com.mathworks.project.impl.plugin.JavaAttribute;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.util.Matlab;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.UnifiedTargetFactory;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class CoderTargetFactory
implements TargetFactory {
    private static final String RESOURCE_PATH = "/com/mathworks/toolbox/coder/resources";
    private static final String C_TARGET_KEY = "target.matlab.coder";
    private static final String OLD_ECODER_TARGET_KEY = "target.matlab.ecoder";
    private static final String SAXON_NINE_TRANSFORMER_FACTORY = "net.sf.saxon.TransformerFactoryImpl";
    private static final File TOOLBOX_ROOT = new File(Matlab.matlabRoot(), "toolbox/coder");

    public List<Target> defineTargets() {
        UnifiedTargetFactory.registerToolboxes();
        LinkedList<Target> linkedList = new LinkedList<Target>();
        DefaultProjectVersionSupport defaultProjectVersionSupport = new DefaultProjectVersionSupport();
        CoderTargetFactory.addTranslation(defaultProjectVersionSupport, "1.0", "R2012a");
        CoderTargetFactory.addTranslation(defaultProjectVersionSupport, "R2012a", "R2013a");
        CoderTargetFactory.addTranslation(defaultProjectVersionSupport, "R2013a", "R2014a_nu");
        defaultProjectVersionSupport.addTranslationResource("target.coder", "R2014b", C_TARGET_KEY, "R2014a_nu", RESOURCE_PATH, "unified_R2014b_to_R2014a_nu.xsl");
        defaultProjectVersionSupport.markTranslationAsPrivate("target.coder", "R2014b");
        linkedList.addAll(PluginManager.readXmlPluginFromResource((File)TOOLBOX_ROOT, (String)RESOURCE_PATH, (String)"coder_plugin", (ProjectVersionSupport)defaultProjectVersionSupport));
        for (Target target : linkedList) {
            target.setSettingsDialogWidth((DynamicTargetAttribute)new SettingsWidthCalculator());
            target.setSettingsDialogHeight((DynamicTargetAttribute)new SettingsHeightCalculator());
        }
        if (CoderApp.isUsingUnifiedUIForC()) {
            linkedList.clear();
        }
        if (!CoderApp.isUsingUnifiedUIForHDL()) {
            defaultProjectVersionSupport = new DefaultProjectVersionSupport(SAXON_NINE_TRANSFORMER_FACTORY);
            defaultProjectVersionSupport.addTranslationResource("target.coder", "R2014b", "target.matlab.hdlcoder", "R2013a", RESOURCE_PATH, "unified_R2014b_to_R2013a_hdl.xsl");
            defaultProjectVersionSupport.markTranslationAsPrivate("target.coder", "R014b");
            linkedList.addAll(PluginManager.readXmlPluginFromResource((File)TOOLBOX_ROOT, (String)RESOURCE_PATH, (String)"hdlcoder_plugin", (ProjectVersionSupport)defaultProjectVersionSupport));
        }
        return linkedList;
    }

    private static void addTranslation(DefaultProjectVersionSupport defaultProjectVersionSupport, String string, String string2) {
        CoderTargetFactory.addTranslation(defaultProjectVersionSupport, string, string2, "coder_plugin_" + string + "_to_" + string2 + ".xsl");
    }

    private static void addTranslation(DefaultProjectVersionSupport defaultProjectVersionSupport, String string, String string2, String string3) {
        defaultProjectVersionSupport.addTranslationResource(C_TARGET_KEY, string, string2, RESOURCE_PATH, "coder_plugin_" + string + "_to_" + string2 + ".xsl");
        if (!string2.equals("R2013a")) {
            defaultProjectVersionSupport.addTranslationResource(OLD_ECODER_TARGET_KEY, string, string2, RESOURCE_PATH, string3);
        } else {
            defaultProjectVersionSupport.addTranslationResource(OLD_ECODER_TARGET_KEY, string, C_TARGET_KEY, string2, RESOURCE_PATH, string3);
        }
    }

    private static class SettingsHeightCalculator
    extends JavaAttribute<Integer> {
        private SettingsHeightCalculator() {
        }

        protected Integer evaluate(ReadableConfiguration readableConfiguration) {
            boolean bl = readableConfiguration.getParamAsBoolean("var.mex");
            boolean bl2 = readableConfiguration.getParamAsBoolean("param.UseECoderFeatures");
            if (PlatformInfo.isMacintosh()) {
                if (bl) {
                    return 654;
                }
                if (bl2) {
                    return 710;
                }
                return 693;
            }
            if (PlatformInfo.isLinux()) {
                return bl ? 592 : 675;
            }
            if (bl) {
                return 610;
            }
            if (bl2) {
                return 742;
            }
            return 698;
        }

        public boolean hasReference(String string) {
            return string.equals("param.UseECoderFeatures") || string.equals("var.mex");
        }
    }

    private static class SettingsWidthCalculator
    extends JavaAttribute<Integer> {
        private SettingsWidthCalculator() {
        }

        protected Integer evaluate(ReadableConfiguration readableConfiguration) {
            boolean bl = readableConfiguration.getParamAsBoolean("var.mex");
            if (PlatformInfo.isMacintosh()) {
                return bl ? 880 : 976;
            }
            if (PlatformInfo.isLinux()) {
                return bl ? 760 : 890;
            }
            return bl ? 760 : 844;
        }

        public boolean hasReference(String string) {
            return string.equals("var.mex");
        }
    }
}

