/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ParamWidget;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.EnumWidget;
import com.mathworks.project.impl.settingsui.EnumWidgetStyle;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.widgets.BusyAffordance;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.event.ChangeListener;

public class SimulationToolWidget
implements ParamWidget<String> {
    private MJPanel fComponent = new MJPanel((LayoutManager)new FormLayout("fill:d:grow, 3dlu, fill:d, 3dlu, fill:d", "center:d"));
    private EnumWidget fSimulationTool;
    private final BusyAffordance fBusyAffordance;
    private final HyperlinkTextLabel fRefreshLink;

    public SimulationToolWidget(Param param, final Project project) {
        this.fSimulationTool = new EnumWidget(EnumWidgetStyle.COMBO_BOX, param, false, project);
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        this.fRefreshLink = Utilities.createLink(CoderResources.getString("link.refreshList"), "link.refreshToolList", new Runnable(){

            @Override
            public void run() {
                SimulationToolWidget.this.fRefreshLink.setEnabled(false);
                SimulationToolWidget.this.fBusyAffordance.getComponent().setVisible(true);
                SimulationToolWidget.this.fBusyAffordance.start();
                new Matlab().evalConsoleOutput("getHDLToolInfo('refreshSimToolList');", new CompletionObserver(){

                    public void completed(int n, Object object) {
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                SimulationToolWidget.this.fSimulationTool.setEnabled(false);
                                SimulationToolWidget.this.fBusyAffordance.getComponent().setVisible(false);
                                SimulationToolWidget.this.fBusyAffordance.stop();
                                SimulationToolWidget.this.fSimulationTool.setEnabled(true);
                                SimulationToolWidget.this.fRefreshLink.setEnabled(true);
                                project.getConfiguration().refreshParamOptions("param.hdl.SimulationTool");
                            }
                        });
                    }
                });
            }
        });
        CellConstraints cellConstraints = new CellConstraints();
        this.fComponent.add(this.fSimulationTool.getComponent(), (Object)cellConstraints.xy(1, 1));
        this.fComponent.add((Component)this.fRefreshLink.getComponent(), (Object)cellConstraints.xy(3, 1));
        this.fComponent.add((Component)this.fBusyAffordance.getComponent(), (Object)cellConstraints.xy(5, 1));
        this.fComponent.setOpaque(false);
    }

    public void setEnabled(boolean bl) {
        this.fComponent.setEnabled(bl);
        this.fSimulationTool.setEnabled(bl);
    }

    public boolean isExternalLabelRequired() {
        return this.fSimulationTool.isExternalLabelRequired();
    }

    public void setData(String string) {
        this.fSimulationTool.setData(string);
    }

    public String getData() {
        return this.fSimulationTool.getData();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fSimulationTool.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fSimulationTool.removeChangeListener(changeListener);
    }

    public boolean showValidationMessage(ValidationMessage validationMessage) {
        return false;
    }

    public void clearValidationMessage() {
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        this.fSimulationTool.dispose();
    }
}

