/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.Support;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.Command;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.api.InvalidProjectException;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.SectionComponentWithPropertySupport;
import com.mathworks.project.api.SubProcessType;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.desktop.BasicProjectClient;
import com.mathworks.project.impl.desktop.BuildAction;
import com.mathworks.project.impl.engine.DeploymentEngine;
import com.mathworks.project.impl.engine.DeploymentProcessAdapter;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.DynamicFileReference;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.ParamWidgetBinder;
import com.mathworks.toolbox.coder.plugin.CodeGenWrapper;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.InstrumentationUtils;
import com.mathworks.toolbox.coder.plugin.TestBenchConfig;
import com.mathworks.toolbox.coder.plugin.TestBenchResult;
import com.mathworks.toolbox.coder.plugin.TestBenchRunMode;
import com.mathworks.toolbox.coder.plugin.TestBenchUtils;
import com.mathworks.toolbox.coder.plugin.TestFileSelectorPanel;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.RequestFilter;
import com.mathworks.util.tree.TreeUtils;
import com.mathworks.widgets.BusyAffordance;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.CRC32;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class VerificationSection
implements SectionComponentWithPropertySupport {
    private final Configuration fConfiguration;
    private final BasicProjectClient fClient;
    private final BuildAction fBuildAction;
    private final PropertyChangeListener fConfigurationListener;
    private final PropertyChangeListener fBuildActionListener;
    private final PropertyChangeListener fCurrentFolderChangeListener;
    private final PropertyChangeSupport fPropertySupport;
    private final MJPanel fComponent;
    private final TestFileSelectorPanel fTestFileSelector;
    private final MJPanel fButtonPanel;
    private final Component fMergeInstrumentationResultsCheckBox;
    private final Component fRedirectToGeneratedCodeCheckBox;
    private final MJLabel fWarningLabel;
    private final MJButton fRunButton;
    private final MJButton fClearInstrumentationResultsButton;
    private final MJButton fTerminateXILExecutionButton;
    private final ParamWidgetBinder fBinder;
    private final BusyAffordance fLoadingAffordance;
    private final BusyAffordance fBusyAffordance;
    private final RequestFilter fClearTermUpdater;
    private String fHeaderText;
    private boolean fReloadedDefaultFile;
    private boolean fRunning;
    private boolean fCanceled;
    private boolean fOriginalGenCodeOnlyValue;
    private boolean fUsingSil;
    private static PrintWriter sLogWriter = null;

    public VerificationSection(WritableConfiguration writableConfiguration) {
        this.fConfiguration = (Configuration)writableConfiguration;
        this.fPropertySupport = new PropertyChangeSupport(this);
        this.fComponent = new MJPanel();
        this.fComponent.setOpaque(false);
        this.fClient = (BasicProjectClient)ProjectGUI.getInstance().getCurrentClient();
        this.fBuildAction = (BuildAction)this.fClient.getAction("BUILD");
        this.fTestFileSelector = new TestFileSelectorPanel((WritableConfiguration)this.fConfiguration, true);
        this.fBinder = new ParamWidgetBinder(this.fConfiguration.getProject(), true);
        this.fClearTermUpdater = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                VerificationSection.this.updateClearButton();
            }
        }, 100);
        this.fTestFileSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                File file = VerificationSection.this.fTestFileSelector.getSelectedFile();
                if (VerificationSection.this.fReloadedDefaultFile && file != null) {
                    VerificationSection.this.fConfiguration.setParamAsFile("param.DefaultTestFile", file);
                }
            }
        });
        this.fTestFileSelector.setQeNamePrefix("verification");
        FileSetInstance fileSetInstance = Utilities.getTestFileSet((ReadableConfiguration)this.fConfiguration);
        this.fMergeInstrumentationResultsCheckBox = this.fBinder.createAndRegister(this.fConfiguration.getTarget().getParam("param.MergeInstrumentationResults"));
        this.fRedirectToGeneratedCodeCheckBox = this.fBinder.createAndRegister(this.fConfiguration.getTarget().getParam("param.CallGeneratedCodeFromTest"));
        this.fWarningLabel = new MJLabel(CoderResources.getString("verification.redirection.warning"));
        this.fWarningLabel.setIcon((Icon)DialogIcon.ERROR.getIcon());
        this.fRunButton = new MJButton();
        this.fRunButton.setName("testfile.button.runOrStop");
        this.configureRunButton();
        this.fClearInstrumentationResultsButton = new MJButton(CoderResources.getString("verification.clear.instrumentation"));
        this.fClearInstrumentationResultsButton.setName("testfile.button.clear.instrumentation");
        this.fTerminateXILExecutionButton = new MJButton(CoderResources.getString("verification.terminate.pil.sil"));
        this.fTerminateXILExecutionButton.setName("testfile.button.terminate.pil.sil");
        this.updateClearButton();
        this.fClearInstrumentationResultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VerificationSection.this.runClearInstrumentationResults();
            }
        });
        this.fTerminateXILExecutionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InstrumentationUtils.terminateVerification(VerificationSection.this.determineLibraryWrapperMexFile().getAbsolutePath(), new Runnable(){

                    @Override
                    public void run() {
                        VerificationSection.this.requestClearButtonUpdate();
                    }
                });
                VerificationSection.this.fConfiguration.setParamAsBoolean("param.RanPilSilVerification", false);
            }
        });
        this.fLoadingAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        this.fButtonPanel = new MJPanel((LayoutManager)new FormLayout("0dlu:grow, fill:d, 3dlu, fill:d", "fill:d"));
        this.fButtonPanel.setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        this.fBusyAffordance.getComponent().setVisible(false);
        this.fButtonPanel.add((Component)this.fBusyAffordance.getComponent(), (Object)cellConstraints.xy(2, 1));
        this.fButtonPanel.add((Component)this.fRunButton, (Object)cellConstraints.xy(4, 1));
        this.fConfigurationListener = this.createConfigurationListener();
        writableConfiguration.addPropertyChangeListener(this.fConfigurationListener);
        this.updateWarning();
        this.configureRunButton();
        this.fRunButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (VerificationSection.this.fRunning) {
                    VerificationSection.this.fCanceled = true;
                    TestBenchUtils.interruptTestBench();
                } else {
                    VerificationSection.this.buildIfRequestedAndRun();
                }
            }
        });
        this.fBuildActionListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!VerificationSection.this.fRunning && propertyChangeEvent.getPropertyName().equals("enabled")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VerificationSection.this.configureRunButton();
                        }
                    });
                }
            }
        };
        this.fCurrentFolderChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                VerificationSection.this.configureRunButton();
                VerificationSection.this.updateWarning();
            }
        };
        MatlabPathModel.getInstance().addPropertyChangeListener(this.fCurrentFolderChangeListener);
        this.fClient.getAction("BUILD").addPropertyChangeListener(this.fBuildActionListener);
        this.configureRunButton();
        this.rebuild();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VerificationSection.this.fPropertySupport.firePropertyChange("header-text", null, VerificationSection.this.getHeaderText());
            }
        });
        File file = this.fConfiguration.getParamAsFile("param.DefaultTestFile");
        if (file != null && fileSetInstance.getFiles().contains(file)) {
            this.fTestFileSelector.setSelectedFile(file);
        }
        this.fTestFileSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                VerificationSection.this.configureRunButton();
            }
        });
        this.fReloadedDefaultFile = true;
    }

    public static void enableLogging(File file) throws IOException {
        VerificationSection.disableLogging();
        sLogWriter = new PrintWriter(new FileWriter(file));
    }

    public static void disableLogging() throws IOException {
        if (sLogWriter != null) {
            sLogWriter.close();
        }
        sLogWriter = null;
    }

    private PropertyChangeListener createConfigurationListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                switch (propertyChangeEvent.getPropertyName()) {
                    case "pending-defaults": {
                        VerificationSection.this.rebuild();
                        break;
                    }
                    case "param.FixedPointMode": {
                        VerificationSection.this.rebuild();
                        break;
                    }
                    case "files": {
                        VerificationSection.this.updateWarning();
                        VerificationSection.this.configureRunButton();
                        break;
                    }
                    case "param.artifact": 
                    case "param.UseECoderFeatures": {
                        VerificationSection.this.requestClearButtonUpdate();
                        VerificationSection.this.rebuild();
                        break;
                    }
                    case "param.WorkingFolder": 
                    case "param.SpecifiedWorkingFolder": {
                        VerificationSection.this.configureRunButton();
                        VerificationSection.this.updateWarning();
                        break;
                    }
                    case "param.BuiltInstrumentedMex": 
                    case "param.RanInstrumentedMex": 
                    case "param.RanPilSilVerification": {
                        VerificationSection.this.requestClearButtonUpdate();
                        break;
                    }
                    case "param.CallGeneratedCodeFromTest": {
                        VerificationSection.this.configureRunButton();
                        VerificationSection.this.updateWarning();
                        break;
                    }
                    case "param.MergeInstrumentationResults": {
                        VerificationSection.this.requestClearButtonUpdate();
                        break;
                    }
                    case "param.SameHardware": 
                    case "param.HardwareVendor.Production": {
                        VerificationSection.this.requestClearButtonUpdate();
                    }
                    case "param.HardwareVendor.Target": {
                        VerificationSection.this.rebuild();
                        VerificationSection.this.requestClearButtonUpdate();
                        break;
                    }
                    case "build-time": {
                        VerificationSection.this.generateAnnotationChecksum(true);
                    }
                }
                if (Utilities.isPilBuildStatusParam(propertyChangeEvent.getPropertyName())) {
                    VerificationSection.this.requestClearButtonUpdate();
                }
            }
        };
    }

    private String generateAnnotationChecksum(boolean bl) {
        Object object2;
        CRC32 cRC32 = new CRC32();
        FileSetInstance fileSetInstance = this.fConfiguration.getFileSet("fileset.entrypoints");
        for (Object object2 : fileSetInstance.getFiles()) {
            XmlReader xmlReader = fileSetInstance.getCustomData((File)object2);
            if (xmlReader == null) continue;
            cRC32.update(xmlReader.getXML().getBytes());
        }
        String string = this.fConfiguration.getParamAsString("param.globals");
        if (string != null) {
            cRC32.update(string.getBytes());
        }
        object2 = String.valueOf(cRC32.getValue());
        if (bl) {
            this.fConfiguration.setParamAsString("param.AnnotationChecksum", (String)object2);
        }
        return object2;
    }

    private boolean isAnnotationChecksumOutdated() {
        String string = this.fConfiguration.getParamAsString("param.AnnotationChecksum");
        String string2 = this.generateAnnotationChecksum(true);
        return string == null || !string.equals(string2);
    }

    private void requestClearButtonUpdate() {
        this.fClearTermUpdater.request();
    }

    private void updateClearButton() {
        String string = this.fConfiguration.getParamAsString("param.artifact");
        boolean bl = string.equals("option.target.artifact.mex.instrumented");
        boolean bl2 = this.fConfiguration.getParamAsBoolean("param.RanInstrumentedMex");
        boolean bl3 = Utilities.isPilSilBuild(this.fConfiguration);
        boolean bl4 = this.fConfiguration.getParamAsBoolean("param.RanPilSilVerification");
        final boolean bl5 = bl3 && bl4;
        final boolean bl6 = bl && bl2;
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                VerificationSection.this.fClearInstrumentationResultsButton.setVisible(bl6);
                VerificationSection.this.fTerminateXILExecutionButton.setVisible(bl5);
            }
        });
        if (bl5) {
            InstrumentationUtils.isSilPilWrapperLoaded(this.determineLibraryWrapperMexFile().getAbsolutePath(), new ParameterRunnable<Boolean>(){

                public void run(Boolean bl) {
                    VerificationSection.this.fTerminateXILExecutionButton.setEnabled(bl != false && !VerificationSection.this.fRunning);
                }
            });
        }
        if (bl6) {
            InstrumentationUtils.hasInstrumentationResults(this.fConfiguration, new ParameterRunnable<Boolean>(){

                public void run(Boolean bl) {
                    VerificationSection.this.fClearInstrumentationResultsButton.setEnabled(bl != false && !VerificationSection.this.fRunning);
                }
            });
        }
    }

    private void runClearInstrumentationResults() {
        InstrumentationUtils.clearResults(this.fConfiguration, new Runnable(){

            @Override
            public void run() {
                VerificationSection.this.requestClearButtonUpdate();
            }
        });
    }

    private void rebuild() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Object object;
                VerificationSection.this.fComponent.removeAll();
                VerificationSection.this.fComponent.setLayout((LayoutManager)new GridBagLayout());
                VerificationSection.this.fLoadingAffordance.stop();
                String string = VerificationSection.this.fConfiguration.getParamAsString("param.artifact");
                boolean bl = string.equals("option.target.artifact.mex");
                boolean bl2 = string.equals("option.target.artifact.dll");
                boolean bl3 = string.equals("option.target.artifact.lib");
                boolean bl4 = string.equals("option.target.artifact.mex.instrumented");
                boolean bl5 = VerificationSection.this.fConfiguration.getParamAsBoolean("param.UseECoderFeatures");
                String string2 = VerificationSection.this.fConfiguration.getParamAsString("param.FixedPointMode");
                boolean bl6 = string2 != null && string2.equals("option.FixedPointMode.Automatic");
                JCheckBox jCheckBox = (JCheckBox)TreeUtils.findComponent((Component)VerificationSection.this.fRedirectToGeneratedCodeCheckBox, JCheckBox.class);
                if (!VerificationSection.this.isDirectMexBuild()) {
                    jCheckBox.setText(CoderResources.getString(bl3 ? "verification.redirectToLibrary" : "verification.redirectToDynamicLibrary"));
                } else {
                    jCheckBox.setText(CoderResources.getString("verification.redirectToMex"));
                }
                VerificationSection.this.fUsingSil = (bl3 || bl2) && bl5;
                if (VerificationSection.this.fUsingSil) {
                    boolean bl7 = Utilities.isPilBuild((ReadableConfiguration)VerificationSection.this.fConfiguration);
                    object = bl3 ? (bl7 ? "verification.redirectToLibrary.pil.desc" : "verification.redirectToLibrary.sil.desc") : (bl7 ? "verification.redirectToDynamicLibrary.pil.desc" : "verification.redirectToDynamicLibrary.sil.desc");
                    jCheckBox.setToolTipText(CoderResources.getString((String)object));
                    String string3 = bl7 ? "verification.terminate.pil.desc" : "verification.terminate.sil.desc";
                    VerificationSection.this.fTerminateXILExecutionButton.setToolTipText(CoderResources.getString(string3));
                } else if (bl) {
                    jCheckBox.setToolTipText(CoderResources.getString("verification.redirectToMex.desc"));
                } else {
                    jCheckBox.setToolTipText(CoderResources.getString("verification.redirectToMexInstrumented.desc"));
                }
                if (bl6) {
                    VerificationSection.this.fComponent.setLayout((LayoutManager)new BorderLayout());
                    VerificationSection.this.fComponent.add((Component)Utilities.createDescriptionComponent("verification.unavailable.fxpauto"), (Object)"Center");
                } else if ((bl3 || bl2) && !bl5 && VerificationSection.this.fConfiguration.hasPendingMatlabDefault("param.HasECoderFeatures")) {
                    object = new GridBagConstraints();
                    ((GridBagConstraints)object).gridx = 0;
                    ((GridBagConstraints)object).gridy = 0;
                    ((GridBagConstraints)object).insets = new Insets(10, 10, 10, 10);
                    ((GridBagConstraints)object).ipadx = 10;
                    ((GridBagConstraints)object).ipady = 10;
                    VerificationSection.this.fComponent.add((Component)VerificationSection.this.fLoadingAffordance.getComponent(), object);
                    VerificationSection.this.fLoadingAffordance.start();
                } else if (bl || bl4 || VerificationSection.this.fUsingSil) {
                    object = new GridBagConstraints();
                    ((GridBagConstraints)object).gridx = 0;
                    ((GridBagConstraints)object).gridy = 0;
                    ((GridBagConstraints)object).anchor = 17;
                    ((GridBagConstraints)object).insets = new Insets(6, 0, 3, 5);
                    if (bl4 || VerificationSection.this.fUsingSil) {
                        ((GridBagConstraints)object).weightx = 1.0;
                        ((GridBagConstraints)object).fill = 2;
                        ((GridBagConstraints)object).gridwidth = 2;
                        String string4 = VerificationSection.this.fUsingSil ? (Utilities.isPilBuild((ReadableConfiguration)VerificationSection.this.fConfiguration) ? "verification.pil.desc" : "verification.sil.desc") : "verification.instrumented.desc";
                        VerificationSection.this.fComponent.add((Component)Utilities.createDescriptionComponent(string4), object);
                        ++((GridBagConstraints)object).gridy;
                        ((GridBagConstraints)object).gridwidth = 1;
                        ((GridBagConstraints)object).weightx = 0.0;
                        ((GridBagConstraints)object).fill = 0;
                    }
                    VerificationSection.this.fComponent.add((Component)new MJLabel(CoderResources.getString("verification.testfile.name")), object);
                    ((GridBagConstraints)object).insets.right = 2;
                    ++((GridBagConstraints)object).gridx;
                    ((GridBagConstraints)object).fill = 2;
                    ((GridBagConstraints)object).weightx = 1.0;
                    VerificationSection.this.fComponent.add((Component)VerificationSection.this.fTestFileSelector.getComponent(), object);
                    ((GridBagConstraints)object).insets.top = 3;
                    ++((GridBagConstraints)object).gridy;
                    ((GridBagConstraints)object).gridx = 0;
                    ((GridBagConstraints)object).gridwidth = 2;
                    if (bl4) {
                        VerificationSection.this.fComponent.add(VerificationSection.this.fMergeInstrumentationResultsCheckBox, object);
                        ++((GridBagConstraints)object).gridy;
                    }
                    VerificationSection.this.fComponent.add(VerificationSection.this.fRedirectToGeneratedCodeCheckBox, object);
                    ++((GridBagConstraints)object).gridy;
                    VerificationSection.this.fComponent.add((Component)VerificationSection.this.fWarningLabel, object);
                    ++((GridBagConstraints)object).gridy;
                    ((GridBagConstraints)object).weightx = 0.0;
                    ((GridBagConstraints)object).fill = 0;
                    if (bl4) {
                        VerificationSection.this.fComponent.add((Component)VerificationSection.this.fClearInstrumentationResultsButton, object);
                        ++((GridBagConstraints)object).gridy;
                    }
                    if (VerificationSection.this.fUsingSil) {
                        VerificationSection.this.fComponent.add((Component)VerificationSection.this.fTerminateXILExecutionButton, object);
                        ++((GridBagConstraints)object).gridy;
                    }
                    ((GridBagConstraints)object).weightx = 1.0;
                    ((GridBagConstraints)object).fill = 2;
                    ++((GridBagConstraints)object).gridy;
                    ((GridBagConstraints)object).gridwidth = 1;
                    ((GridBagConstraints)object).gridx = 1;
                    ((GridBagConstraints)object).anchor = 13;
                    ((GridBagConstraints)object).insets.right = 6;
                    ((GridBagConstraints)object).insets.bottom = 12;
                    VerificationSection.this.fComponent.add((Component)VerificationSection.this.fButtonPanel, object);
                } else {
                    VerificationSection.this.fComponent.setLayout((LayoutManager)new BorderLayout());
                    VerificationSection.this.fComponent.add((Component)Utilities.createDescriptionComponent("verification.unavailable" + (bl5 ? ".ecoder" : "")), (Object)"Center");
                }
                object = VerificationSection.this.getHeaderText();
                if (bl4) {
                    VerificationSection.this.setHeaderText(CoderResources.getString("verification.header.instrumented"));
                } else if (bl5 && (bl3 || bl2)) {
                    if (Utilities.isPilBuild((ReadableConfiguration)VerificationSection.this.fConfiguration)) {
                        VerificationSection.this.setHeaderText(CoderResources.getString("verification.header.pil"));
                    } else {
                        VerificationSection.this.setHeaderText(CoderResources.getString("verification.header.sil"));
                    }
                } else {
                    VerificationSection.this.setHeaderText(CoderResources.getString("verification.header.normal"));
                }
                if (!VerificationSection.this.getHeaderText().equals(object)) {
                    SwingUtilities.invokeLater(new Runnable((String)object){
                        final /* synthetic */ String val$oldHeaderText;
                        {
                            this.val$oldHeaderText = string;
                        }

                        @Override
                        public void run() {
                            VerificationSection.this.fPropertySupport.firePropertyChange("header-text", this.val$oldHeaderText, VerificationSection.this.getHeaderText());
                        }
                    });
                }
                VerificationSection.this.configureRunButton();
                VerificationSection.this.fComponent.revalidate();
                VerificationSection.this.fComponent.repaint();
            }
        });
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        this.fConfiguration.removePropertyChangeListener(this.fConfigurationListener);
        this.fBuildAction.removePropertyChangeListener(this.fBuildActionListener);
        this.fTestFileSelector.dispose();
        this.fClearTermUpdater.cancelPendingRequests();
        this.fBinder.dispose();
        MatlabPathModel.getInstance().removePropertyChangeListener(this.fCurrentFolderChangeListener);
    }

    private void updateWarning() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (VerificationSection.this.hasRedirectionProblem()) {
                    VerificationSection.this.fWarningLabel.setVisible(true);
                } else {
                    VerificationSection.this.fWarningLabel.setVisible(false);
                }
            }
        });
    }

    private boolean hasFile() {
        return this.fTestFileSelector.getSelectedFile() != null;
    }

    private boolean hasRedirectionProblem() {
        return this.fConfiguration.getParamAsBoolean("param.CallGeneratedCodeFromTest") && this.hasEntryPointOutsideWorkingFolder();
    }

    private boolean hasEntryPointOutsideWorkingFolder() {
        FileSetInstance fileSetInstance = this.fConfiguration.getFileSet("fileset.entrypoints");
        File file = this.getAbsoluteWorkingFolder();
        if (file == null) {
            return false;
        }
        for (File file2 : fileSetInstance.getFiles()) {
            File file3 = file2.getParentFile();
            if (file3 != null && file3.equals(file)) continue;
            return true;
        }
        return false;
    }

    private void configureRunButton() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String string = VerificationSection.this.getRunButtonTooltip(VerificationSection.this.fRunning);
                VerificationSection.this.fRunButton.setToolTipText(string != null ? CoderResources.getString(string) : null);
                if (VerificationSection.this.fRunning) {
                    VerificationSection.this.fRunButton.setEnabled(true);
                    VerificationSection.this.fRunButton.setIcon((Icon)MiscellaneousIcon.CANCEL_15x15.getIcon());
                    VerificationSection.this.fRunButton.setText(CoderResources.getString("verification.stop"));
                } else {
                    VerificationSection.this.fRunButton.setEnabled(VerificationSection.this.hasFile() && !VerificationSection.this.hasRedirectionProblem() && ProjectGUI.getInstance().getCurrentProcess() == null);
                    VerificationSection.this.fRunButton.setText(BuiltInResources.getString((String)"button.build"));
                    VerificationSection.this.fRunButton.setIcon(CoderResources.getIcon("run.png"));
                    int n = (int)VerificationSection.this.fRunButton.getPreferredSize().getWidth();
                    VerificationSection.this.fRunButton.setText(CoderResources.getString("verification.run"));
                    n = Math.max((int)VerificationSection.this.fRunButton.getPreferredSize().getWidth(), n);
                    VerificationSection.this.fRunButton.setPreferredSize(new Dimension(n, (int)VerificationSection.this.fRunButton.getPreferredSize().getHeight()));
                    if (VerificationSection.this.fUsingSil) {
                        VerificationSection.this.fRunButton.setEnabled(VerificationSection.this.hasFile() && VerificationSection.this.getEntryPointCount() > 0);
                    }
                }
            }
        });
    }

    private int getEntryPointCount() {
        return this.fConfiguration.getFileSet("fileset.entrypoints").getCurrentCount();
    }

    private String getRunButtonTooltip(boolean bl) {
        String string;
        if (bl) {
            return "verification.stop.tooltip";
        }
        switch (string = this.fConfiguration.getParamAsString("param.artifact")) {
            case "option.target.artifact.dll": 
            case "option.target.artifact.lib": {
                if (Utilities.isPilBuild((ReadableConfiguration)this.fConfiguration)) {
                    return "verification.run.tooltip.pil";
                }
                return "verification.run.tooltip.sil";
            }
            case "option.target.artifact.mex": {
                return "verification.run.tooltip.mex";
            }
            case "option.target.artifact.mex.instrumented": {
                return "verification.run.tooltip.instrumentedMex";
            }
        }
        return "verification.run.tooltip.mex";
    }

    private void buildIfRequestedAndRun() {
        final TestBenchConfig testBenchConfig = new TestBenchConfig(this.fConfiguration.getParamAsBoolean("param.CallGeneratedCodeFromTest") ? TestBenchRunMode.RUN_COMPILED : TestBenchRunMode.RUN_ORIGINAL);
        testBenchConfig.setTestBenchFile(this.fTestFileSelector.getSelectedFile());
        FileSetInstance fileSetInstance = this.fConfiguration.getFileSet("fileset.entrypoints");
        testBenchConfig.setEntryPointFiles(fileSetInstance.getFiles());
        testBenchConfig.setMexFunctionName(this.isDirectMexBuild() ? this.fConfiguration.getParamAsString("param.mex.outputfile") : new FileLocation(this.determineLibraryWrapperMexFile()).getNameBeforeDot());
        testBenchConfig.setWorkingFolder(this.getProjectWorkingFolder());
        this.fRunning = true;
        this.fCanceled = false;
        this.fBuildAction.setEnabled(false);
        this.fTestFileSelector.setEnabled(false);
        this.fRedirectToGeneratedCodeCheckBox.setEnabled(false);
        this.fRedirectToGeneratedCodeCheckBox.setName("param.CallGeneratedCodeFromTest.check");
        this.fRunButton.setEnabled(false);
        this.fClearInstrumentationResultsButton.setEnabled(false);
        this.fTerminateXILExecutionButton.setEnabled(false);
        this.fBusyAffordance.getComponent().setVisible(true);
        this.fBusyAffordance.start();
        this.fConfiguration.setForcedDisabled("param.mex.outputfile", true);
        this.fConfiguration.setForcedDisabled("param.artifact", true);
        this.fConfiguration.setForcedDisabled("param.mex.GenCodeOnly", true);
        this.fOriginalGenCodeOnlyValue = this.fConfiguration.getParamAsBoolean("param.mex.GenCodeOnly");
        this.fConfiguration.setParamAsBoolean("param.mex.GenCodeOnly", false);
        final String string = this.fConfiguration.getParamAsString("param.artifact");
        this.checkUpToDate(new ParameterRunnable<Boolean>(){

            public void run(Boolean bl) {
                if (!bl.booleanValue()) {
                    Object object = new BuildAction.DefaultProcessFactory();
                    if (!VerificationSection.this.isDirectMexBuild()) {
                        object = new WrappedLibraryBuildProcessFactory();
                    }
                    VerificationSection.this.fBuildAction.startBuildWithoutWorkflow(VerificationSection.this.fConfiguration.getProject(), (BuildAction.ProcessFactory)object, (DeploymentProcessMonitor)new DeploymentProcessAdapter(){

                        public void finished() {
                            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    VerificationSection.this.fClient.disposeBuildProgressDialog();
                                    VerificationSection.this.startRunning(testBenchConfig);
                                }
                            });
                        }

                        public void failed() {
                            this.canceled();
                        }

                        public void canceled() {
                            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    VerificationSection.this.runningStopped();
                                }
                            });
                        }
                    });
                } else {
                    if (!VerificationSection.this.fConfiguration.getParamAsBoolean("param.MergeInstrumentationResults") && string.equals("option.target.artifact.mex.instrumented")) {
                        VerificationSection.this.runClearInstrumentationResults();
                    }
                    VerificationSection.this.startRunning(testBenchConfig);
                }
            }
        });
    }

    private File determineLibraryWrapperMexFile() {
        String string = this.getEntryPointCount() == 1 ? new FileLocation((File)this.fConfiguration.getFileSet("fileset.entrypoints").getFiles().iterator().next()).getNameBeforeDot() : this.fConfiguration.getParamAsString("param.grt.outputfile");
        boolean bl = Utilities.isPilBuild((ReadableConfiguration)this.fConfiguration);
        String string2 = string + (bl ? "_pil" : "_sil") + Support.mexExtension();
        return new File(this.fConfiguration.getFile().getParentFile(), string2);
    }

    private boolean isDirectMexBuild() {
        String string = this.fConfiguration.getParamAsString("param.artifact");
        return string.equals("option.target.artifact.mex") || string.equals("option.target.artifact.mex.instrumented");
    }

    private static File resolveMatlabPwd(File file) {
        String string = file.getPath();
        if (string.contains("${MATLAB_PWD}")) {
            FileLocation fileLocation = MatlabPathModel.getInstance().getCurrentFolder();
            return new File(string.replace("${MATLAB_PWD}", fileLocation.toString()));
        }
        return file;
    }

    private void checkUpToDate(final ParameterRunnable<Boolean> parameterRunnable) {
        Object object;
        XmlReader xmlReader;
        boolean bl = false;
        if (this.fConfiguration.getBuildchecksum() == null || this.fConfiguration.isBuildChecksumOutdated()) {
            VerificationSection.log(this.fConfiguration.getBuildchecksum() == null ? "Project has no build checksum yet" : "Project build checksum is outdated");
            bl = true;
        }
        if (this.isAnnotationChecksumOutdated()) {
            VerificationSection.log("Annotation checksum outdated, rebuilding.");
            bl = true;
        }
        if (bl) {
            parameterRunnable.run((Object)false);
            return;
        }
        File file = null;
        if (!this.isDirectMexBuild()) {
            file = this.determineLibraryWrapperMexFile();
            xmlReader = (DynamicFileReference)this.fConfiguration.evaluateDynamicFileSubset(this.fConfiguration.getTarget().getBuildDeliverables()).iterator().next();
            object = VerificationSection.resolveMatlabPwd(xmlReader.getFile());
            if (((File)object).exists() && file.exists() && ((File)object).lastModified() > file.lastModified()) {
                VerificationSection.log("Library " + object + " is newer than wrapper " + file.getAbsolutePath());
                parameterRunnable.run((Object)false);
                return;
            }
        }
        xmlReader = this.fConfiguration.getProject().getXslInput();
        object = this.fConfiguration.getTarget().getBuildDeliverables().evaluate(this.fConfiguration, this.fConfiguration.getVariableGraph(), xmlReader);
        final Object[] objectArray = object.iterator();
        while (objectArray.hasNext()) {
            DynamicFileReference dynamicFileReference = (DynamicFileReference)objectArray.next();
            File file2 = VerificationSection.resolveMatlabPwd(dynamicFileReference.getFile());
            if (!file2.exists()) {
                VerificationSection.log("Artifact does not exist: " + file2.getAbsolutePath());
                parameterRunnable.run((Object)false);
                return;
            }
            if (file != null || !new FileLocation(file2).getExtension().startsWith("mex")) continue;
            file = file2;
        }
        if (file == null) {
            throw new IllegalStateException("MEX file not declared as a build deliverable");
        }
        if (!file.exists()) {
            VerificationSection.log("Artifact does not exist: " + file.getAbsolutePath());
            parameterRunnable.run((Object)false);
        } else {
            objectArray = new Object[]{"isMexFileUpToDate", file.getAbsolutePath()};
            new Matlab().feval("emlcprivate", objectArray, 1, new CompletionObserver(){

                public void completed(int n, final Object object) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VerificationSection.log("isMexFileUpToDate returned " + ((boolean[])object)[0] + " for " + objectArray[1]);
                            parameterRunnable.run((Object)((boolean[])object)[0]);
                        }
                    });
                }
            });
        }
    }

    private static void log(String string) {
        if (sLogWriter != null) {
            sLogWriter.println(string);
            sLogWriter.flush();
        }
    }

    private void startRunning(TestBenchConfig testBenchConfig) {
        this.configureRunButton();
        TestBenchUtils.runTestBench(testBenchConfig, new ParameterRunnable<TestBenchResult>(){

            public void run(TestBenchResult testBenchResult) {
                boolean bl;
                VerificationSection.this.runningStopped();
                if (testBenchResult == null || testBenchResult.getMessage() == null) {
                    return;
                }
                String string = VerificationSection.this.fConfiguration.getParamAsString("param.artifact");
                boolean bl2 = string.equals("option.target.artifact.mex.instrumented");
                boolean bl3 = bl = bl2 && VerificationSection.this.fConfiguration.getParamAsBoolean("param.LaunchInstrumentationReport");
                if (!VerificationSection.this.fCanceled && !testBenchResult.getMessage().isEmpty()) {
                    TestBenchUtils.showTestBenchError((Component)VerificationSection.this.fComponent, VerificationSection.getHeader(), testBenchResult);
                } else if (!VerificationSection.this.fCanceled && bl) {
                    InstrumentationUtils.showReport(VerificationSection.this.fConfiguration, VerificationSection.this.fBusyAffordance, new String[0]);
                }
                if (!VerificationSection.this.fCanceled && testBenchResult.getMessage().isEmpty()) {
                    if (InstrumentationUtils.isInstrumentedMex(VerificationSection.this.fConfiguration)) {
                        VerificationSection.this.fConfiguration.setParamAsBoolean("param.RanInstrumentedMex", true);
                    }
                    if (Utilities.isPilSilBuild(VerificationSection.this.fConfiguration)) {
                        VerificationSection.this.fConfiguration.setParamAsBoolean("param.RanPilSilVerification", true);
                    }
                }
            }
        });
    }

    private void runningStopped() {
        this.fRunning = false;
        this.fTestFileSelector.setEnabled(true);
        this.fRedirectToGeneratedCodeCheckBox.setEnabled(true);
        this.fClearInstrumentationResultsButton.setEnabled(true);
        this.fTerminateXILExecutionButton.setEnabled(true);
        this.requestClearButtonUpdate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VerificationSection.this.fBuildAction.setEnabled(true);
            }
        });
        this.configureRunButton();
        this.fBusyAffordance.stop();
        this.fBusyAffordance.getComponent().setVisible(false);
        this.fConfiguration.setParamAsBoolean("param.mex.GenCodeOnly", this.fOriginalGenCodeOnlyValue);
        this.fConfiguration.setForcedDisabled("param.artifact", false);
        this.fConfiguration.setForcedDisabled("param.mex.outputfile", false);
        this.fConfiguration.setForcedDisabled("param.mex.GenCodeOnly", false);
    }

    private String getProjectWorkingFolder() {
        String string;
        switch (string = this.fConfiguration.getParamAsString("param.WorkingFolder")) {
            case "option.WorkingFolder.Specified": {
                return this.fConfiguration.getParamAsString("param.SpecifiedWorkingFolder");
            }
            case "option.WorkingFolder.Project": {
                return this.fConfiguration.getFile().getParent();
            }
        }
        return "";
    }

    private File getAbsoluteWorkingFolder() {
        String string;
        switch (string = this.fConfiguration.getParamAsString("param.WorkingFolder")) {
            case "option.WorkingFolder.Specified": {
                String string2 = this.fConfiguration.getParamAsString("param.SpecifiedWorkingFolder");
                if (string2 == null) {
                    return null;
                }
                if (new File(string2).isAbsolute()) {
                    return new File(string2);
                }
                return new File(MatlabPathModel.getInstance().getCurrentFolder().toFile(), string2);
            }
            case "option.WorkingFolder.Project": {
                return new File(this.fConfiguration.getFile().getParent());
            }
        }
        return MatlabPathModel.getInstance().getCurrentFolder().toFile();
    }

    private static String getHeader() {
        return CoderResources.getString("verification.dialog.title");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getHeaderToolTipText() {
        return null;
    }

    private String getHeaderText() {
        return this.fHeaderText;
    }

    private void setHeaderText(String string) {
        this.fHeaderText = string;
    }

    private class WrappedLibraryBuildProcessFactory
    implements BuildAction.ProcessFactory {
        private WrappedLibraryBuildProcessFactory() {
        }

        public DeploymentProcess createProcess(Project project) throws InvalidProjectException {
            return DeploymentEngine.createProcess((Configuration)project.getConfiguration(), (boolean)true, (SubProcessType)SubProcessType.USER_REQUESTED_BUILD, (Command[])new Command[]{new CodeGenWrapper(VerificationSection.this.fConfiguration.getFile(), (WritableConfiguration)VerificationSection.this.fConfiguration, true)});
        }
    }
}

