/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.inputtypes;

import com.mathworks.project.impl.settingsui.validation.NumericRule;
import com.mathworks.project.impl.settingsui.validation.ValidationRule;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPAttributes;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPFimath;
import com.mathworks.toolbox.coder.plugin.inputtypes.PropertyBinder;
import com.mathworks.toolbox.coder.plugin.inputtypes.PropertyBinderFactory;
import com.mathworks.toolbox.fixedpoint.FimathPanel;
import com.mathworks.util.Converter;
import java.text.DecimalFormat;

public enum FiMathProperty {
    LOCAL_FIMATH(Boolean.class, "FimathIsLocal"),
    ROUNDING_METHOD(FimathPanel.RoundingMethod.class),
    OVERFLOW_ACTION(FimathPanel.OverflowAction.class),
    PRODUCT_MODE(FimathPanel.PrecisionMode.class, "ProductMode"),
    SUM_MODE(FimathPanel.PrecisionMode.class, "SumMode"),
    CAST_BEFORE_SUM(Boolean.class, "CastBeforeSum"),
    PRODUCT_WORD_LENGTH(Integer.class, "ProductWordLength", (ValidationRule)new NumericRule(1, Integer.MAX_VALUE, new DecimalFormat())),
    PRODUCT_FRACTION_LENGTH(Integer.class, "ProductFractionLength"),
    SUM_WORD_LENGTH(Integer.class, "SumWordLength", (ValidationRule)new NumericRule(1, Integer.MAX_VALUE, new DecimalFormat())),
    SUM_FRACTION_LENGTH(Integer.class, "SumFractionLength");

    private final PropertyBinder fBinder;
    private final String fName;

    private static Converter<IDPAttributes, Object> getBoundObjectAccessor() {
        return new Converter<IDPAttributes, Object>(){

            public Object convert(IDPAttributes iDPAttributes) {
                return iDPAttributes.getFimath();
            }
        };
    }

    private <E extends Enum<E>> FiMathProperty(Class<E> clazz) {
        this(clazz, FiMathProperty.chop(clazz.getName()));
    }

    private FiMathProperty(Class<?> clazz, String string2) {
        this(clazz, string2, null);
    }

    private FiMathProperty(Class<?> clazz, String string2, ValidationRule validationRule) {
        this.fName = string2;
        this.fBinder = PropertyBinderFactory.createBinder(string2, clazz, validationRule, IDPFimath.class, FiMathProperty.getBoundObjectAccessor());
    }

    private String getName() {
        return this.fName;
    }

    public static FiMathProperty getByName(String string) {
        for (FiMathProperty fiMathProperty : FiMathProperty.values()) {
            if (!fiMathProperty.getName().equals(string)) continue;
            return fiMathProperty;
        }
        return null;
    }

    public PropertyBinder getBinder() {
        return this.fBinder;
    }

    private static String chop(String string) {
        return string.substring(string.lastIndexOf(36) + 1);
    }
}

