/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.inputtypes;

import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.CellPredicate;
import com.mathworks.project.impl.table.ClickSensitiveCellEditor;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTableContextMenuCustomizer;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.EntryPoint;
import com.mathworks.toolbox.coder.plugin.inputtypes.ExampleConversionResult;
import com.mathworks.toolbox.coder.plugin.inputtypes.FormattedTypeField;
import com.mathworks.toolbox.coder.plugin.inputtypes.GlobalVariableList;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPChangeListener;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPClassEnum;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPUtils;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataProperty;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputTableActionMenu;
import com.mathworks.toolbox.coder.plugin.inputtypes.NameCellEditor;
import com.mathworks.toolbox.coder.plugin.inputtypes.TypeEntryMode;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public class InputTable {
    private final Root fRoot;
    private final Configuration fConfiguration;
    private final IDPChangeListener fChangeListener;
    private final PropertyTableModel<InputDataProperty> fModel;
    private final PropertyTable<InputDataProperty> fTable;
    private final Runnable fChangeNotifier;
    private final ReturnRunnable<String> fHelpMapPathProvider;
    private boolean fEvaluating;
    private static final DataFlavor IDP_DATA_FLAVOR;

    public InputTable(Configuration configuration, EntryPoint entryPoint, boolean bl, IDPChangeListener iDPChangeListener, Runnable runnable, ReturnRunnable<String> returnRunnable) {
        this(configuration, new EntryPointRoot(entryPoint, iDPChangeListener, runnable), bl, iDPChangeListener, runnable, returnRunnable);
    }

    public InputTable(Configuration configuration, GlobalVariableList globalVariableList, boolean bl, IDPChangeListener iDPChangeListener, Runnable runnable, ReturnRunnable<String> returnRunnable) {
        this(configuration, new GlobalsRoot(globalVariableList), bl, iDPChangeListener, runnable, returnRunnable);
    }

    private InputTable(Configuration configuration, Root root, boolean bl, IDPChangeListener iDPChangeListener, Runnable runnable, @Nullable ReturnRunnable<String> returnRunnable) {
        this.fConfiguration = configuration;
        this.fRoot = root;
        this.fChangeListener = iDPChangeListener;
        this.fChangeNotifier = runnable;
        this.fHelpMapPathProvider = returnRunnable != null ? returnRunnable : this.createDefaultHelpMapPathProvider();
        List<AbstractPropertyTableColumn> list = Arrays.asList(new AbstractPropertyTableColumn[]{new NameColumn(), new TypeColumn()});
        this.fModel = new PropertyTableModel(list, this.createRootLevelRows());
        this.fTable = new PropertyTable(this.fModel, (PropertyTableCellEditorFactory)new CellEditorFactory());
        this.fTable.setClipboardActions((ParameterRunnable)new ParameterRunnable<KeyEvent>(){

            public void run(KeyEvent keyEvent) {
                InputTable.this.doCopy();
            }
        }, (ParameterRunnable)new ParameterRunnable<KeyEvent>(){

            public void run(KeyEvent keyEvent) {
                InputTable.this.doPaste();
            }
        });
        this.fTable.getSelectionModel().setAllowMultiselect(true);
        this.fTable.setName("coder.input.table." + root.toString());
        this.fTable.setHeaderVisible(false);
        this.fTable.setColumnWeights(new double[]{0.35, 0.75});
        this.fTable.setAllowSelectingExpandableRows(true);
        this.fTable.setPreferToShowAllRows(true);
        if (bl) {
            this.fTable.setDefaultPredicate(new CellPredicate(){

                public boolean accept(int n, int n2) {
                    if (n2 != 1) {
                        return true;
                    }
                    InputDataProperty inputDataProperty = (InputDataProperty)InputTable.this.fTable.getModel().getValue(n, n2);
                    return inputDataProperty == null || inputDataProperty.isUndefined() || !inputDataProperty.isUserDefined();
                }
            });
        }
        InputTableActionMenu.bindKeyStrokes(this.fTable, this.fChangeNotifier, this.createRootLevelItemRemover());
        this.fTable.setContextMenuCustomizer(new PropertyTableContextMenuCustomizer(){

            public void customize(MJPopupMenu mJPopupMenu, int n, int n2) {
                if (n2 == 1) {
                    InputDataProperty inputDataProperty = (InputDataProperty)InputTable.this.fModel.getValue(n, n2);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    if (InputTable.this.fTable.getSelectionModel().getSelectedRowCount() == 1 && !inputDataProperty.isUndefined()) {
                        mJPopupMenu.add((Action)new MJAbstractAction(BuiltInResources.getString((String)"action.copy")){

                            public void actionPerformed(ActionEvent actionEvent) {
                                InputTable.this.doCopy();
                            }
                        });
                    }
                    if (Arrays.asList(clipboard.getAvailableDataFlavors()).contains(IDP_DATA_FLAVOR)) {
                        mJPopupMenu.add((Action)new MJAbstractAction(BuiltInResources.getString((String)"action.paste")){

                            public void actionPerformed(ActionEvent actionEvent) {
                                InputTable.this.doPaste();
                            }
                        });
                    }
                    mJPopupMenu.add((Action)new MJAbstractAction(CoderResources.getString("typedef.allScalarDouble")){

                        public void actionPerformed(ActionEvent actionEvent) {
                            for (int i = 0; i < InputTable.this.fTable.getModel().getRowCount(); ++i) {
                                InputDataProperty inputDataProperty = (InputDataProperty)InputTable.this.fTable.getModel().getValue(i, 0);
                                InputDataProperty inputDataProperty2 = InputTable.this.fRoot.create(inputDataProperty.getName());
                                inputDataProperty2.setClass("double", false);
                                inputDataProperty2.setSize("1 x 1", false);
                                inputDataProperty2.setComplex(false, false);
                                InputTable.this.commit(i, inputDataProperty, inputDataProperty2, false, false);
                            }
                            InputTable.this.fChangeNotifier.run();
                            InputTable.this.fModel.fireChange();
                            InputTable.this.fTable.getModel().fireChange();
                        }
                    });
                    mJPopupMenu.add((Action)new MJAbstractAction(CoderResources.getString("typedef.clear")){

                        public void actionPerformed(ActionEvent actionEvent) {
                            for (int i = 0; i < InputTable.this.fTable.getModel().getRowCount(); ++i) {
                                InputDataProperty inputDataProperty = (InputDataProperty)InputTable.this.fTable.getModel().getValue(i, 0);
                                InputTable.this.reset(i, inputDataProperty, false);
                            }
                            InputTable.this.fChangeNotifier.run();
                            InputTable.this.fModel.fireChange();
                        }
                    });
                }
            }
        });
    }

    private ReturnRunnable<String> createDefaultHelpMapPathProvider() {
        return new ReturnRunnable<String>(){

            public String run() {
                return PluginManager.resolveHelpMapPath((String)InputTable.this.fConfiguration.getTarget().getHelpMapPath());
            }
        };
    }

    public JComponent getComponent() {
        return this.fTable.getComponent();
    }

    public void clearSelection() {
        this.fTable.clearSelection();
    }

    public void reload() {
        this.fModel.setRootLevelRows(this.createRootLevelRows());
    }

    public void dispose() {
        this.fTable.dispose();
    }

    protected PropertyTable<InputDataProperty> getTable() {
        return this.fTable;
    }

    public void addRootLevelItem() {
        this.fTable.stopEditing(false);
        InputDataProperty inputDataProperty = new InputDataProperty(((RootWithAddRemoveSupport)this.fRoot).getNewItemName());
        ((RootWithAddRemoveSupport)this.fRoot).add(inputDataProperty);
        int n = this.fTable.getModel().addRootLevel((Object)inputDataProperty);
        this.fChangeNotifier.run();
        this.fTable.getSelectionModel().select(n);
        this.fTable.startEditing(n, 0, false);
        this.fTable.getComponent().revalidate();
        this.fTable.getComponent().repaint();
    }

    private void doCopy() {
        if (this.fTable.getSelectionModel().getSelectedRowCount() == 1) {
            InputDataProperty inputDataProperty = (InputDataProperty)this.fModel.getValue(this.fTable.getSelectionModel().getSelectedRow(), 0);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new IDPTransferable(inputDataProperty), null);
        }
    }

    private void doPaste() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Iterator iterator = this.fTable.getSelectionModel().getSelectedRows().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                InputDataProperty inputDataProperty = ((InputDataProperty)clipboard.getData(IDP_DATA_FLAVOR)).clone();
                InputDataProperty inputDataProperty2 = (InputDataProperty)this.fModel.getValue(n, 0);
                inputDataProperty.setName(inputDataProperty2.getName(), false);
                this.commit(n, inputDataProperty2, inputDataProperty, true, true);
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
    }

    private List<PropertyTableNode<InputDataProperty>> createRootLevelRows() {
        ArrayList<PropertyTableNode<InputDataProperty>> arrayList = new ArrayList<PropertyTableNode<InputDataProperty>>();
        for (InputDataProperty inputDataProperty : this.fRoot.getData()) {
            arrayList.add(this.createNode(null, inputDataProperty));
        }
        return arrayList;
    }

    private PropertyTableNode<InputDataProperty> createNode(PropertyTableNode<InputDataProperty> propertyTableNode, InputDataProperty inputDataProperty) {
        PropertyTableNode propertyTableNode2 = new PropertyTableNode(propertyTableNode, false, Arrays.asList(inputDataProperty));
        this.addChildrenRecursively((PropertyTableNode<InputDataProperty>)propertyTableNode2, inputDataProperty);
        return propertyTableNode2;
    }

    private ParameterRunnable<Integer> createRootLevelItemRemover() {
        if (this.fRoot instanceof RootWithAddRemoveSupport) {
            return new ParameterRunnable<Integer>(){

                public void run(Integer n) {
                    InputTable.this.fTable.stopEditing(false);
                    InputDataProperty inputDataProperty = (InputDataProperty)InputTable.this.fModel.getValue(n.intValue(), 0);
                    ((RootWithAddRemoveSupport)InputTable.this.fRoot).remove(inputDataProperty);
                    InputTable.this.fChangeNotifier.run();
                    InputTable.this.fTable.getModel().remove(n.intValue());
                    InputTable.this.fTable.getSelectionModel().select(n - 1);
                    InputTable.this.fTable.getComponent().revalidate();
                    InputTable.this.fTable.getComponent().repaint();
                }
            };
        }
        return null;
    }

    private void addChildrenRecursively(PropertyTableNode<InputDataProperty> propertyTableNode, InputDataProperty inputDataProperty) {
        for (InputDataProperty inputDataProperty2 : inputDataProperty.getChildren()) {
            PropertyTableNode propertyTableNode2 = new PropertyTableNode(propertyTableNode, false, Arrays.asList(inputDataProperty2));
            this.addChildrenRecursively((PropertyTableNode<InputDataProperty>)propertyTableNode2, inputDataProperty2);
        }
    }

    private void reset(int n, InputDataProperty inputDataProperty, boolean bl) {
        InputDataProperty inputDataProperty2 = this.fRoot.create(inputDataProperty.getName());
        this.commit(n, inputDataProperty, inputDataProperty2, true, bl);
    }

    void commit(int n, InputDataProperty inputDataProperty, InputDataProperty inputDataProperty2, boolean bl, boolean bl2) {
        inputDataProperty2.setUserDefined(true);
        inputDataProperty.setUserDefined(true);
        if (inputDataProperty2.getClassName().equals(inputDataProperty.getClassName()) && inputDataProperty2.getSizeString().equals(inputDataProperty.getSizeString()) && (inputDataProperty2.getValue() == null || inputDataProperty2.getValue().isEmpty()) && inputDataProperty2.isComplex() == inputDataProperty.isComplex()) {
            return;
        }
        if (!bl && inputDataProperty.getClassName().equals(inputDataProperty2.getClassName()) && (inputDataProperty2.getValue() == null || inputDataProperty2.getValue().isEmpty())) {
            inputDataProperty.setSize(inputDataProperty2.getSizeString(), true);
            inputDataProperty.setComplex(inputDataProperty2.isComplex(), true);
            inputDataProperty.setValue(null);
            inputDataProperty.setConstant(false, true);
        } else {
            if (inputDataProperty.getParent() != null) {
                inputDataProperty2.setParent(inputDataProperty.getParent());
                inputDataProperty.getParent().replaceField(inputDataProperty, inputDataProperty2);
            } else {
                this.fRoot.replace(inputDataProperty, inputDataProperty2, bl2);
            }
            PropertyTableNode propertyTableNode = new PropertyTableNode(null, false, Arrays.asList(inputDataProperty2));
            this.fModel.replaceRow(n, propertyTableNode);
            this.addChildrenRecursively((PropertyTableNode<InputDataProperty>)propertyTableNode, inputDataProperty2);
        }
        if (bl2) {
            this.fChangeNotifier.run();
            this.fModel.fireChange();
        }
    }

    private void evaluationStarted() {
        if (!this.fEvaluating) {
            this.fEvaluating = true;
            this.fConfiguration.addPendingComputation();
            this.fTable.setEnabled(false);
            this.fTable.repaint();
        }
    }

    private void evaluationFinished() {
        if (this.fEvaluating) {
            this.fEvaluating = false;
            this.fTable.setEnabled(true);
            this.fConfiguration.removePendingComputation();
            this.fTable.repaint();
        }
    }

    private MJPopupMenu createPopupMenu(InputDataProperty inputDataProperty, int n, Component component, FormattedTypeField formattedTypeField, JToggleButton jToggleButton) {
        return InputTableActionMenu.createAndShow(component, this.fConfiguration, this.fTable, n, inputDataProperty, formattedTypeField, jToggleButton, this.fChangeNotifier, this.createRootLevelItemRemover(), new Converter<String, InputDataProperty>(){

            public InputDataProperty convert(String string) {
                return InputTable.this.fRoot.create(string);
            }
        }, this.fHelpMapPathProvider);
    }

    static {
        try {
            IDP_DATA_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref;class=" + InputDataProperty.class.getName());
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private class IDPTransferable
    implements Transferable {
        private final InputDataProperty fProperty;

        public IDPTransferable(InputDataProperty inputDataProperty) {
            this.fProperty = inputDataProperty;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.stringFlavor, IDP_DATA_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return Arrays.asList(this.getTransferDataFlavors()).contains(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                return this.fProperty.getDefinition();
            }
            return this.fProperty;
        }
    }

    private static class GlobalsRoot
    implements RootWithAddRemoveSupport {
        private final GlobalVariableList fGlobals;

        GlobalsRoot(GlobalVariableList globalVariableList) {
            this.fGlobals = globalVariableList;
        }

        public String toString() {
            return "Globals";
        }

        @Override
        public List<InputDataProperty> getData() {
            return this.fGlobals.getVariables();
        }

        @Override
        public InputDataProperty createFromResult(ExampleConversionResult exampleConversionResult, IDPChangeListener iDPChangeListener) throws IOException {
            return InputDataProperty.createInputDataProperty(XmlApi.getInstance().read(exampleConversionResult.getXML()), iDPChangeListener, null);
        }

        @Override
        public InputDataProperty create(String string) {
            return new InputDataProperty(string);
        }

        @Override
        public void replace(InputDataProperty inputDataProperty, InputDataProperty inputDataProperty2, boolean bl) {
            this.fGlobals.replace(inputDataProperty, inputDataProperty2);
        }

        @Override
        public String getNewItemName() {
            return "g" + (this.getData().isEmpty() ? "" : Integer.valueOf(this.getData().size()));
        }

        @Override
        public void add(InputDataProperty inputDataProperty) {
            this.fGlobals.add(inputDataProperty);
        }

        @Override
        public void remove(InputDataProperty inputDataProperty) {
            this.fGlobals.remove(inputDataProperty);
        }
    }

    private static class EntryPointRoot
    implements Root {
        private final EntryPoint fEntryPoint;
        private final IDPChangeListener fChangeListener;
        private final Runnable fChangeNotifier;

        EntryPointRoot(EntryPoint entryPoint, IDPChangeListener iDPChangeListener, Runnable runnable) {
            this.fEntryPoint = entryPoint;
            this.fChangeListener = iDPChangeListener;
            this.fChangeNotifier = runnable;
        }

        public String toString() {
            return this.fEntryPoint.getFileName();
        }

        @Override
        public List<InputDataProperty> getData() {
            return this.fEntryPoint.getInputDataProperties();
        }

        @Override
        public InputDataProperty createFromResult(ExampleConversionResult exampleConversionResult, IDPChangeListener iDPChangeListener) throws IOException {
            return InputDataProperty.createInputDataProperty(XmlApi.getInstance().read(exampleConversionResult.getXML()), iDPChangeListener, this.fEntryPoint);
        }

        @Override
        public InputDataProperty create(String string) {
            InputDataProperty inputDataProperty = new InputDataProperty(this.fEntryPoint, string);
            inputDataProperty.setChangeListener(this.fChangeListener);
            return inputDataProperty;
        }

        @Override
        public void replace(InputDataProperty inputDataProperty, InputDataProperty inputDataProperty2, boolean bl) {
            this.fEntryPoint.replaceInput(inputDataProperty, inputDataProperty2);
            inputDataProperty2.setChangeListener(this.fChangeListener);
            if (bl) {
                this.fChangeNotifier.run();
            }
        }
    }

    private static interface RootWithAddRemoveSupport
    extends Root {
        public String getNewItemName();

        public void add(InputDataProperty var1);

        public void remove(InputDataProperty var1);
    }

    private static interface Root {
        public List<InputDataProperty> getData();

        public InputDataProperty createFromResult(ExampleConversionResult var1, IDPChangeListener var2) throws IOException;

        public InputDataProperty create(String var1);

        public void replace(InputDataProperty var1, InputDataProperty var2, boolean var3);
    }

    private class TypeCellEditor
    implements ClickSensitiveCellEditor<InputDataProperty> {
        private final InputDataProperty fProperty;
        private final int fRow;
        private final FormattedTypeField fTextField;
        private final MJToggleButton fPopupButton;
        private final MJPanel fPanel;
        private Point fInitialClickPoint;
        private String fDisplayedText;
        private MJPopupMenu fPopup;
        private boolean fActivating;

        TypeCellEditor(InputDataProperty inputDataProperty, int n) {
            this.fProperty = inputDataProperty;
            this.fTextField = new FormattedTypeField((PropertyTable<InputDataProperty>)InputTable.this.fTable, this.fProperty, InputTable.this.fRoot instanceof GlobalsRoot, new ParameterRunnable<Runnable>(){

                public void run(Runnable runnable) {
                    TypeCellEditor.this.fProperty.setClass(TypeCellEditor.this.fTextField.getTypeName(), true);
                    InputTableActionMenu.showProperties(InputTable.this.fConfiguration, (PropertyTable<InputDataProperty>)InputTable.this.fTable, TypeCellEditor.this.fProperty, (ReturnRunnable<String>)InputTable.this.fHelpMapPathProvider, runnable);
                }
            });
            this.fTextField.setName(InputTable.this.fTable.getName() + ".editor");
            if (inputDataProperty.isVarargin()) {
                this.fTextField.setEditable(false);
            }
            this.fTextField.lockFormatTip();
            this.fRow = n;
            this.fPopupButton = new MJToggleButton(DocumentIcon.ACTIONS.getIcon()){

                public Dimension getMinimumSize() {
                    return new Dimension(20, 0);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(20, (int)super.getPreferredSize().getHeight());
                }
            };
            this.fPopupButton.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (TypeCellEditor.this.fPopup == null) {
                        TypeCellEditor.this.fActivating = true;
                        InputTable.this.fTable.setKeepEditorAlive(true);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    TypeCellEditor.this.clearActivatingFlag();
                }
            });
            this.fPopupButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (TypeCellEditor.this.fActivating) {
                        TypeCellEditor.this.fTextField.closeFormatTip();
                        TypeCellEditor.this.fPopup = InputTable.this.createPopupMenu(TypeCellEditor.this.fProperty, TypeCellEditor.this.fRow, (Component)TypeCellEditor.this.fPanel, TypeCellEditor.this.fTextField, (JToggleButton)TypeCellEditor.this.fPopupButton);
                        TypeCellEditor.this.fPopup.show();
                    } else if (TypeCellEditor.this.fPopup != null) {
                        TypeCellEditor.this.fPopup.hide();
                        Timer timer = new Timer(20, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                if (FocusManager.getCurrentManager().getFocusedWindow() == SwingUtilities.windowForComponent(TypeCellEditor.this.fTextField.getComponent())) {
                                    TypeCellEditor.this.fTextField.requestFocus();
                                }
                                InputTable.this.fTable.setKeepEditorAlive(false);
                                TypeCellEditor.this.fPopup = null;
                                TypeCellEditor.this.fPopupButton.setSelected(false);
                            }
                        });
                        timer.setRepeats(false);
                        timer.start();
                    }
                }
            });
            this.fTextField.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    TypeCellEditor.this.fPopupButton.setVisible(TypeCellEditor.this.fProperty.isVarargin() || InputTable.this.fRoot instanceof GlobalsRoot || TypeCellEditor.this.fProperty.getParent() != null && TypeCellEditor.this.fProperty.getParent().isVarargin() || TypeCellEditor.this.fTextField.getTypeName() != null && TypeCellEditor.this.fTextField.getTypeName().equals("struct") || TypeCellEditor.this.fProperty.getParent() != null && TypeCellEditor.this.fProperty.getParent().isStruct());
                }
            });
            this.fPopupButton.setVisible(this.fProperty.isVarargin() || InputTable.this.fRoot instanceof GlobalsRoot || this.fProperty.getParent() != null && this.fProperty.getParent().isVarargin() || this.fProperty.isStruct() || this.fProperty.getParent() != null && this.fProperty.getParent().isStruct());
            this.fPanel = new MJPanel((LayoutManager)new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.fPanel.add((Component)this.fTextField.getComponent(), (Object)gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.fill = 3;
            gridBagConstraints.weightx = 0.0;
            this.fPanel.add((Component)this.fPopupButton, (Object)gridBagConstraints);
        }

        private void clearActivatingFlag() {
            Timer timer = new Timer(20, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TypeCellEditor.this.fActivating = false;
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        public void setInitialClickPoint(Point point) {
            this.fInitialClickPoint = point;
        }

        public void loadData(Object object, String string) {
            this.fDisplayedText = string;
            InputDataProperty inputDataProperty = (InputDataProperty)object;
            if (inputDataProperty.isConstant()) {
                this.fTextField.setMode(InputTable.this.fRoot instanceof GlobalsRoot ? TypeEntryMode.GLOBAL_CONSTANT : TypeEntryMode.CONSTANT);
            } else {
                this.fTextField.setText(inputDataProperty.getDefinition(false));
            }
        }

        public void commitData() {
            this.commitData(true);
        }

        public void commitData(boolean bl) {
            if (this.fProperty.isVarargin()) {
                return;
            }
            if (this.fTextField.getFullText().isEmpty()) {
                if (this.fTextField.getMode() == TypeEntryMode.INITIAL_VALUE) {
                    this.fProperty.setInitialValue(null);
                    InputTable.this.fChangeNotifier.run();
                } else {
                    InputTable.this.reset(this.fRow, this.fProperty, true);
                }
                InputTable.this.evaluationFinished();
                return;
            }
            if (bl && this.fTextField.getTypeName() == null) {
                InputTable.this.evaluationStarted();
                this.fTextField.afterEnumerationCheck(new Runnable(){

                    @Override
                    public void run() {
                        TypeCellEditor.this.commitData(false);
                    }
                });
                return;
            }
            String string = this.fTextField.getTypeName();
            if (!this.fTextField.getFullText().isEmpty() && string == null) {
                final String string2 = this.fTextField.getFullText();
                if (string2.trim().isEmpty()) {
                    InputTable.this.evaluationFinished();
                    return;
                }
                InputTable.this.evaluationStarted();
                IDPUtils.evaluateExampleExpression(this.fProperty, string2, new ParameterRunnable<ExampleConversionResult>(){

                    public void run(ExampleConversionResult exampleConversionResult) {
                        if (exampleConversionResult.getMessage().isEmpty()) {
                            try {
                                if (TypeCellEditor.this.fTextField.getMode().isSupportsInitialValue()) {
                                    if (TypeCellEditor.this.fTextField.getMode() == TypeEntryMode.GLOBAL_CONSTANT) {
                                        TypeCellEditor.this.fProperty.setValue(string2);
                                        TypeCellEditor.this.fProperty.setInitialValue("");
                                        TypeCellEditor.this.fProperty.setConstant(true, true);
                                    } else {
                                        TypeCellEditor.this.fProperty.setValue("");
                                        TypeCellEditor.this.fProperty.setInitialValue(string2);
                                        TypeCellEditor.this.fProperty.setConstant(false, true);
                                    }
                                    if (!TypeCellEditor.this.fProperty.getClassName().equals(IDPClassEnum.UNDEFINED.getClassName())) {
                                        InputTable.this.fChangeNotifier.run();
                                        InputTable.this.evaluationFinished();
                                        return;
                                    }
                                }
                                InputDataProperty inputDataProperty = InputTable.this.fRoot.createFromResult(exampleConversionResult, InputTable.this.fChangeListener);
                                if (!TypeCellEditor.this.fTextField.getMode().isSupportsInitialValue()) {
                                    inputDataProperty.setValue(string2);
                                    inputDataProperty.setConstant(TypeCellEditor.this.fTextField.getMode() == TypeEntryMode.CONSTANT, true);
                                } else if (TypeCellEditor.this.fTextField.getMode() == TypeEntryMode.GLOBAL_CONSTANT) {
                                    inputDataProperty.setValue(string2);
                                    inputDataProperty.setInitialValue("");
                                    inputDataProperty.setConstant(true, true);
                                } else {
                                    inputDataProperty.setValue("");
                                    inputDataProperty.setInitialValue(string2);
                                    inputDataProperty.setConstant(false, true);
                                }
                                InputTable.this.commit(TypeCellEditor.this.fRow, TypeCellEditor.this.fProperty, inputDataProperty, true, true);
                            }
                            catch (IOException iOException) {
                                throw new IllegalStateException(iOException);
                            }
                        } else {
                            HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(exampleConversionResult.getMessage(), new HyperlinkTextLabel.HyperlinkHandler(){

                                public void processHyperlink(String string) {
                                    if (string.startsWith("matlab:")) {
                                        new Matlab().evalConsoleOutput(string.substring("matlab:".length()));
                                    }
                                }
                            }, false, "link.badConversion.innerComponent", exampleConversionResult.getMessage());
                            MJOptionPane.showMessageDialog((Component)MJFrame.getFrame((Component)InputTable.this.fTable.getComponent()), (Object)hyperlinkTextLabel.getComponent(), (String)CoderResources.getString("typedef.error.example.title"), (int)0);
                        }
                        InputTable.this.evaluationFinished();
                    }
                });
            } else if (this.fTextField.getTypeName() != null) {
                InputDataProperty inputDataProperty = InputTable.this.fRoot.create(this.fProperty.getName());
                inputDataProperty.setClass(this.fTextField.getTypeName(), false);
                inputDataProperty.setSize(this.fTextField.getSize(), false);
                inputDataProperty.setComplex(this.fTextField.isComplex(), false);
                InputTable.this.commit(this.fRow, this.fProperty, inputDataProperty, false, true);
                InputTable.this.evaluationFinished();
            }
        }

        public JComponent getComponent() {
            return this.fPanel;
        }

        public void activate() {
            Serializable serializable;
            this.fTextField.requestFocus();
            boolean bl = false;
            if (this.fInitialClickPoint != null) {
                serializable = this.fPopupButton.getLocation();
                SwingUtilities.convertPointToScreen((Point)serializable, this.fPopupButton.getParent());
                bl = new Rectangle((Point)serializable, this.fPopupButton.getSize()).contains(this.fInitialClickPoint);
                if (bl) {
                    this.fActivating = true;
                    this.fTextField.closeFormatTip();
                    InputTable.this.fTable.setKeepEditorAlive(true);
                    this.fPopupButton.setSelected(true);
                    this.clearActivatingFlag();
                } else {
                    SwingUtilities.convertPointFromScreen(this.fInitialClickPoint, this.fTextField.getComponent());
                    this.fTextField.clickFromRendererIntoEditor(this.fDisplayedText, this.fInitialClickPoint);
                }
            }
            serializable = new Timer(bl ? 200 : 1, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TypeCellEditor.this.fTextField.unlockFormatTip();
                }
            });
            ((Timer)serializable).setRepeats(false);
            ((Timer)serializable).start();
        }

        public void dispose() {
            if (this.fPopup != null) {
                this.fPopup.hide();
                this.fPopup = null;
            }
            this.fTextField.dispose();
        }
    }

    private class CellEditorFactory
    implements PropertyTableCellEditorFactory<InputDataProperty> {
        private CellEditorFactory() {
        }

        public PropertyTableCellEditor<InputDataProperty> createWidget(PropertyTable<InputDataProperty> propertyTable, int n, int n2, InputDataProperty inputDataProperty) {
            if (n2 == 1 && !inputDataProperty.isDeferred()) {
                return new TypeCellEditor(inputDataProperty, n);
            }
            if (n2 == 0 && (inputDataProperty.getParent() != null && inputDataProperty.getParent().isStruct() || InputTable.this.fRoot instanceof RootWithAddRemoveSupport)) {
                return new NameCellEditor(propertyTable, inputDataProperty);
            }
            return null;
        }
    }

    private class TypeColumn
    extends AbstractPropertyTableColumn<InputDataProperty> {
        TypeColumn() {
            super("Type");
        }

        public String getText(InputDataProperty inputDataProperty) {
            if (InputTable.this.fEvaluating) {
                return CoderResources.getString("typedef.computing");
            }
            String string = inputDataProperty.getDefinition();
            if (string.equals("<Undefined>")) {
                string = CoderResources.getString("typedef.frozen.prompt" + (PlatformInfo.isMacintosh() ? ".mac" : ""));
            }
            return string;
        }

        public boolean isEditable() {
            return true;
        }
    }

    private class NameColumn
    extends AbstractPropertyTableColumn<InputDataProperty> {
        NameColumn() {
            super("Name");
        }

        public String getText(InputDataProperty inputDataProperty) {
            return inputDataProperty.getName();
        }

        public boolean isEditable() {
            return true;
        }
    }
}

