/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.workflow;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.settingsui.SettingComponentDefinition;
import com.mathworks.project.impl.settingsui.SettingsPanelBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public final class HDLPanelBuilder
implements SettingsPanelBuilder {
    private final Aligner fAligner = new Aligner();
    private final AlignedPanel fComponent;
    private AlignedPanel fCurrentComponent = this.fComponent = new AlignedPanel();
    private static final Insets INSETS = new Insets(4, 4, 4, 4);

    public void startCategory(String string) {
        this.fCurrentComponent = new AlignedPanel(string);
        this.fComponent.addComponent((Component)((Object)this.fCurrentComponent), false);
    }

    public String getCurrentCategoryName() {
        return this.fCurrentComponent.getCategoryName();
    }

    public void endCategory() {
        this.fCurrentComponent = this.fComponent;
    }

    public void addComponent(SettingComponentDefinition settingComponentDefinition) {
        this.fCurrentComponent.addComponent(settingComponentDefinition);
    }

    public void addComponent(Component component, boolean bl) {
        this.fCurrentComponent.addComponent(component, bl);
    }

    public void addPadding() {
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private class AlignedPanel
    extends MJPanel {
        private final Map<Component, MJLabel> fLabels;
        private final List<Component> fComponents;
        private final String fCategoryName;

        AlignedPanel() {
            this(null);
        }

        AlignedPanel(String string) {
            this.fCategoryName = string;
            if (string != null) {
                this.setBorder(new CompoundBorder(new EmptyBorder(3, 5, 3, 3), new TitledBorder(string)));
            } else {
                this.setBorder(new EmptyBorder(3, 5, 3, 3));
            }
            this.setOpaque(false);
            this.setLayout(null);
            this.fLabels = new HashMap<Component, MJLabel>();
            this.fComponents = new LinkedList<Component>();
            HDLPanelBuilder.this.fAligner.add(this);
        }

        public String getCategoryName() {
            return this.fCategoryName;
        }

        public void doLayout() {
            super.doLayout();
            int n = HDLPanelBuilder.this.fAligner.getLabelWidth();
            int n2 = HDLPanelBuilder.this.fAligner.getRowWidth();
            int n3 = HDLPanelBuilder.this.fAligner.getComponentWidth();
            int n4 = 0;
            Insets insets = new Insets(0, 0, 0, 0);
            if (this.getBorder() != null) {
                insets = this.getBorder().getBorderInsets((Component)((Object)this));
                n4 += insets.top;
            }
            for (Component component : this.fComponents) {
                n4 += INSETS.top;
                Dimension dimension = component.getPreferredSize();
                if (component instanceof AlignedPanel) {
                    component.setBounds(INSETS.left + insets.left, n4, this.getWidth() - INSETS.left - INSETS.right - insets.left - insets.right, (int)dimension.getHeight());
                    n4 = (int)((double)n4 + (dimension.getHeight() + (double)INSETS.bottom));
                    continue;
                }
                if (!this.fLabels.containsKey(component)) {
                    component.setBounds(INSETS.left + insets.left, n4, n2 - INSETS.left - INSETS.right, (int)dimension.getHeight());
                    n4 = (int)((double)n4 + (dimension.getHeight() + (double)INSETS.bottom));
                    continue;
                }
                MJLabel mJLabel = this.fLabels.get(component);
                Dimension dimension2 = mJLabel.getPreferredSize();
                mJLabel.setBounds(INSETS.left + insets.left, (int)((double)n4 + dimension.getHeight() / 2.0 - dimension2.getHeight() / 2.0), n, (int)mJLabel.getPreferredSize().getHeight());
                component.setBounds(INSETS.left * 2 + INSETS.right + n + insets.left, n4, n3, (int)dimension.getHeight());
                n4 = (int)((double)n4 + Math.max(dimension.getHeight(), dimension2.getHeight()));
                n4 += INSETS.bottom;
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension();
            dimension.width = HDLPanelBuilder.this.fAligner.getRowWidth();
            for (Component component : this.fComponents) {
                dimension.height = (int)((double)dimension.height + (component.getPreferredSize().getHeight() + (double)INSETS.top + (double)INSETS.bottom));
            }
            if (this.getBorder() != null) {
                Insets insets = this.getBorder().getBorderInsets((Component)((Object)this));
                dimension.height += insets.top + insets.bottom;
                dimension.width += insets.left + insets.right;
            }
            return dimension;
        }

        void addComponent(SettingComponentDefinition settingComponentDefinition) {
            if (settingComponentDefinition.getLabel() != null) {
                MJLabel mJLabel = new MJLabel(settingComponentDefinition.getLabel() + ":");
                mJLabel.setToolTipText(settingComponentDefinition.getTooltip());
                this.fLabels.put(settingComponentDefinition.getComponent(), mJLabel);
                this.add((Component)this.fLabels.get(settingComponentDefinition.getComponent()));
            }
            this.fComponents.add(settingComponentDefinition.getComponent());
            this.add(settingComponentDefinition.getComponent());
        }

        void addComponent(Component component, boolean bl) {
            if (bl) {
                throw new IllegalArgumentException("This panel builder does not support full-space components");
            }
            this.fComponents.add(component);
            this.add(component);
        }

        List<MJLabel> getLabels() {
            return new ArrayList<MJLabel>(this.fLabels.values());
        }

        List<Component> getActualComponents() {
            return new ArrayList<Component>(this.fComponents);
        }

        List<Component> getUnLabeledComponents() {
            ArrayList<Component> arrayList = new ArrayList<Component>();
            for (Component component : this.fComponents) {
                if (this.fLabels.containsKey(component)) continue;
                arrayList.add(component);
            }
            return arrayList;
        }
    }

    private class Aligner {
        private final List<AlignedPanel> fPanels = new LinkedList<AlignedPanel>();

        Aligner() {
        }

        void add(AlignedPanel alignedPanel) {
            this.fPanels.add(alignedPanel);
        }

        int getLabelWidth() {
            int n = 0;
            for (AlignedPanel alignedPanel : this.fPanels) {
                for (MJLabel mJLabel : alignedPanel.getLabels()) {
                    n = (int)Math.max((double)n, mJLabel.getPreferredSize().getWidth());
                }
            }
            return n;
        }

        int getComponentWidth() {
            int n = 0;
            for (AlignedPanel alignedPanel : this.fPanels) {
                for (Component component : alignedPanel.getActualComponents()) {
                    if (component instanceof AlignedPanel) continue;
                    n = (int)Math.max((double)n, component.getPreferredSize().getWidth());
                }
            }
            return n;
        }

        int getRowWidth() {
            int n = this.getLabelWidth() + this.getComponentWidth() + INSETS.left * 2 + INSETS.right * 2;
            for (AlignedPanel alignedPanel : this.fPanels) {
                for (Component component : alignedPanel.getUnLabeledComponents()) {
                    if (component instanceof AlignedPanel) continue;
                    n = (int)Math.max((double)n, component.getPreferredSize().getWidth() + (double)INSETS.left + (double)INSETS.right);
                }
            }
            return n;
        }
    }
}

