/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.workflow;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ParamWidget;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.FileSetFilter;
import com.mathworks.project.impl.model.FileSetRule;
import com.mathworks.project.impl.model.OptionListWithDefault;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamType;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.model.WorkflowStepResult;
import com.mathworks.project.impl.settingsui.AbstractListWidget;
import com.mathworks.project.impl.settingsui.ListTextFieldStyle;
import com.mathworks.project.impl.settingsui.ParamWidgetBinder;
import com.mathworks.project.impl.workflowui.WorkflowDialog;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.plugin.workflow.AbstractRequiredInputStep;
import com.mathworks.util.Holder;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.Pair;
import com.mathworks.widgets.BusyAffordance;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SelectTargetPanel
extends AbstractRequiredInputStep {
    private final Configuration fConfiguration;
    private final MJPanel fWrapper;
    private final MJPanel fComponent;
    private final Param fWorkflowParam;
    private final Param fPlatformParam;
    private final Param fToolParam;
    private final Param fFamilyParam;
    private final Param fDeviceParam;
    private final Param fPackageParam;
    private final Param fSpeedParam;
    private final Param fInputClockParam;
    private final Param fSystemClockParam;
    private final Param fExecutionModeParam;
    private final Param fReferenceDesign;
    private final Param fReferenceDesignPath;
    private final Param fAdditionalIPFiles;
    private final Param fIpCoreNameParam;
    private final Param fIpCoreVersionParam;
    private final Param fTargetLanguage;
    private final Set<String> fCascadingParamKeys;
    private final ParamWidgetBinder fBinder;
    private final PropertyChangeListener fConfigurationListener;
    private final HyperlinkTextLabel fBoardManagerLink;
    private final HyperlinkTextLabel fRefreshLink;
    private final MJPanel fRefreshWrapper;
    private final MJLabel fDescriptionLabel;
    private final MJLabel fIpCoreLabel;
    private final MJLabel fFrequencyLabel;
    private final Map<String, MJLabel> fLabels;
    private final Map<String, ComboBox> fComboBoxes;
    private IPFilesChooser fIPFilesChooser;
    private final BusyAffordance fBusyAffordance;
    private final JComponent fHelpButton;
    private boolean fSuppressUpdateOptions;
    private static final String GET_MORE_BOARDS_CALLBACK = "hwconnectinstaller.launchInstaller('StartAtStep', 'SelectPackage', 'BaseProduct', 'HDL Coder');";
    private static final String CREATE_CUSTOM_BOARD_CALLBACK = "DAStudio.Dialog(boardmanagergui.NewBoardWizard(''));";

    public SelectTargetPanel(MJFrame mJFrame, Configuration configuration) {
        super(configuration, "category.workflow.selecttarget");
        this.fConfiguration = configuration;
        this.fHelpButton = WorkflowDialog.createHelpButton();
        this.fComponent = new MJPanel(){

            public void doLayout() {
                super.doLayout();
                SelectTargetPanel.this.redoLayout();
            }

            public Dimension getPreferredSize() {
                return SelectTargetPanel.this.computePreferredSize();
            }
        };
        this.fComponent.setLayout(null);
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        this.fWrapper = new MJPanel(){

            public void doLayout() {
                Dimension dimension = this.getPreferredSize();
                SelectTargetPanel.this.fComponent.setBounds(0, 0, dimension.width, dimension.height);
            }

            public Dimension getPreferredSize() {
                Dimension dimension = SelectTargetPanel.this.fComponent.getPreferredSize();
                return new Dimension(Math.max(610, dimension.width), dimension.height);
            }
        };
        this.fWrapper.setLayout(null);
        this.fWrapper.add((Component)this.fComponent);
        Target target = this.fConfiguration.getTarget();
        this.fBinder = new ParamWidgetBinder(configuration.getProject(), false);
        this.fComboBoxes = new LinkedHashMap<String, ComboBox>();
        this.fWorkflowParam = target.getParam("param.hdl.Workflow");
        this.fPlatformParam = target.getParam("param.hdl.TargetPlatform");
        this.fToolParam = target.getParam("param.hdl.SynthesisTool");
        this.fBoardManagerLink = Utilities.createLink(CoderResources.getString("link.boardManager"), "link.boardManager", new Runnable(){

            @Override
            public void run() {
                new Matlab().evalConsoleOutput("fpgaBoardManager();");
            }
        });
        this.fRefreshLink = Utilities.createLink(CoderResources.getString("link.refreshList"), "link.refreshToolList", new Runnable(){

            @Override
            public void run() {
                SelectTargetPanel.this.fConfiguration.setForcedDisabled(SelectTargetPanel.this.fToolParam.getKey(), true);
                SelectTargetPanel.this.fRefreshLink.setEnabled(false);
                SelectTargetPanel.this.fBusyAffordance.getComponent().setVisible(true);
                SelectTargetPanel.this.fBusyAffordance.start();
                new Matlab().evalConsoleOutput("getHDLToolInfo('refresh');", new CompletionObserver(){

                    public void completed(int n, Object object) {
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                SelectTargetPanel.this.updateOptions(SelectTargetPanel.this.fWorkflowParam.getKey(), true);
                                SelectTargetPanel.this.fBusyAffordance.getComponent().setVisible(false);
                                SelectTargetPanel.this.fBusyAffordance.stop();
                                SelectTargetPanel.this.fConfiguration.setForcedDisabled(SelectTargetPanel.this.fToolParam.getKey(), false);
                                SelectTargetPanel.this.fRefreshLink.setEnabled(true);
                            }
                        });
                    }
                });
            }
        });
        this.fRefreshWrapper = new MJPanel((LayoutManager)new FormLayout("fill:d, 3dlu, fill:d", "0dlu:grow, fill:d, 0dlu:grow"));
        CellConstraints cellConstraints = new CellConstraints();
        this.fRefreshWrapper.add((Component)this.fRefreshLink.getComponent(), (Object)cellConstraints.xy(1, 2));
        this.fRefreshWrapper.add((Component)this.fBusyAffordance.getComponent(), (Object)cellConstraints.xy(3, 2));
        this.fLabels = new HashMap<String, MJLabel>();
        this.fFamilyParam = target.getParam("param.hdl.SynthesisToolChipFamily");
        this.fDeviceParam = target.getParam("param.hdl.SynthesisToolDeviceName");
        this.fPackageParam = target.getParam("param.hdl.SynthesisToolPackageName");
        this.fSpeedParam = target.getParam("param.hdl.SynthesisToolSpeedValue");
        this.fInputClockParam = target.getParam("param.hdl.InputFrequency");
        this.fSystemClockParam = target.getParam("param.hdl.TargetFrequency");
        this.fExecutionModeParam = target.getParam("param.hdl.ExecutionMode");
        this.fReferenceDesign = target.getParam("param.hdl.ReferenceDesign");
        this.fReferenceDesignPath = target.getParam("param.hdl.ReferenceDesignPath");
        this.fAdditionalIPFiles = target.getParam("param.hdl.AdditionalIPFiles");
        this.fIpCoreNameParam = target.getParam("param.hdl.IPCoreName");
        this.fIpCoreVersionParam = target.getParam("param.hdl.IPCoreVersion");
        this.fTargetLanguage = target.getParam("param.hdl.TargetLanguage");
        this.fDescriptionLabel = new MJLabel(target.getWorkflow().getStepByKey("category.workflow.selecttarget").getDescription());
        this.fDescriptionLabel.setFont(this.fDescriptionLabel.getFont().deriveFont(1));
        this.fFrequencyLabel = new MJLabel(CoderResources.getString("hdl.target.clockFrequency"));
        this.fIpCoreLabel = new MJLabel(CoderResources.getString("hdl.target.ipCoreSettings"));
        this.fCascadingParamKeys = new HashSet<String>();
        this.fCascadingParamKeys.addAll(Arrays.asList(this.fWorkflowParam.getKey(), this.fPlatformParam.getKey(), this.fToolParam.getKey(), this.fReferenceDesign.getKey(), this.fReferenceDesignPath.getKey(), this.fFamilyParam.getKey(), this.fDeviceParam.getKey(), this.fPackageParam.getKey()));
        this.fConfigurationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals(SelectTargetPanel.this.fWorkflowParam.getKey())) {
                    WorkflowDialog.getInstance().resetStep("category.workflow.targetinterface");
                    SelectTargetPanel.this.rebuild();
                }
                if (propertyChangeEvent.getPropertyName().equals(SelectTargetPanel.this.fToolParam.getKey()) || propertyChangeEvent.getPropertyName().equals(SelectTargetPanel.this.fPlatformParam.getKey()) || propertyChangeEvent.getPropertyName().equals(SelectTargetPanel.this.fWorkflowParam.getKey()) || propertyChangeEvent.getPropertyName().equals(SelectTargetPanel.this.fReferenceDesign.getKey())) {
                    SelectTargetPanel.this.updateStepState();
                }
                if (propertyChangeEvent.getPropertyName().equals(SelectTargetPanel.this.fTargetLanguage.getKey()) && SelectTargetPanel.this.fIPFilesChooser != null) {
                    if (SelectTargetPanel.this.fConfiguration.getParamAsString(SelectTargetPanel.this.fTargetLanguage.getKey()).equals("option.hdl.VHDL")) {
                        SelectTargetPanel.this.fIPFilesChooser.applyVHDLFilters();
                    } else {
                        SelectTargetPanel.this.fIPFilesChooser.applyVerilogFilters();
                    }
                }
                if (SelectTargetPanel.this.fCascadingParamKeys.contains(propertyChangeEvent.getPropertyName()) && !SelectTargetPanel.this.fSuppressUpdateOptions) {
                    SelectTargetPanel.this.updateOptions(propertyChangeEvent.getPropertyName(), false);
                }
            }
        };
        this.fConfiguration.addPropertyChangeListener(this.fConfigurationListener);
        this.rebuild();
        this.updateOptions(this.fWorkflowParam.getKey(), true);
    }

    private void rebuild() {
        this.fComponent.removeAll();
        this.fComponent.add((Component)this.fHelpButton);
        this.fComponent.add((Component)this.fDescriptionLabel);
        this.fComponent.add((Component)this.getLabel(this.fWorkflowParam));
        this.fComponent.add(this.fBinder.createOrGet(this.fWorkflowParam));
        ComboBox comboBox = this.createOrGetComboBox(this.fPlatformParam);
        if (!this.isGenericAsicFpga()) {
            this.fComponent.add((Component)this.getLabel(this.fPlatformParam));
            this.fComponent.add((Component)((Object)comboBox));
            this.fComponent.add((Component)this.fBoardManagerLink.getComponent());
        }
        this.fComponent.add((Component)this.getLabel(this.fToolParam));
        this.fComponent.add((Component)((Object)this.createOrGetComboBox(this.fToolParam)));
        this.fComponent.add((Component)this.fRefreshWrapper);
        this.fComponent.add((Component)this.getLabel(this.fFamilyParam));
        this.fComponent.add((Component)((Object)this.createOrGetComboBox(this.fFamilyParam)));
        this.fComponent.add((Component)this.getLabel(this.fDeviceParam));
        this.fComponent.add((Component)((Object)this.createOrGetComboBox(this.fDeviceParam)));
        this.fComponent.add((Component)this.getLabel(this.fPackageParam));
        this.fComponent.add((Component)((Object)this.createOrGetComboBox(this.fPackageParam)));
        this.fComponent.add((Component)this.getLabel(this.fSpeedParam));
        this.fComponent.add((Component)((Object)this.createOrGetComboBox(this.fSpeedParam)));
        if (this.isTurnkey()) {
            this.fComponent.add((Component)this.fFrequencyLabel);
            this.fComponent.add((Component)this.getLabel(this.fInputClockParam));
            this.fComponent.add(this.fBinder.createOrGet(this.fInputClockParam));
            this.fComponent.add((Component)this.getLabel(this.fSystemClockParam));
            this.fComponent.add(this.fBinder.createOrGet(this.fSystemClockParam));
        } else if (this.isIpCore()) {
            this.fComponent.add((Component)this.fIpCoreLabel);
            ComboBox comboBox2 = this.createOrGetComboBox(this.fReferenceDesign);
            this.fComponent.add((Component)this.getLabel(this.fReferenceDesign));
            this.fComponent.add((Component)((Object)comboBox2));
            this.fComponent.add(this.fBinder.createOrGet(this.fReferenceDesign));
            this.fComponent.add((Component)this.getLabel(this.fReferenceDesignPath));
            this.fComponent.add(this.fBinder.createOrGet(this.fReferenceDesignPath));
            this.fComponent.add((Component)this.getLabel(this.fIpCoreNameParam));
            this.fComponent.add(this.fBinder.createOrGet(this.fIpCoreNameParam));
            this.fComponent.add((Component)this.getLabel(this.fIpCoreVersionParam));
            this.fComponent.add(this.fBinder.createOrGet(this.fIpCoreVersionParam));
            this.fComponent.add((Component)this.getLabel(this.fIpCoreVersionParam));
            this.createOrGetIPFilesChooser(this.fAdditionalIPFiles);
            this.fComponent.add((Component)this.getLabel(this.fAdditionalIPFiles));
            this.fComponent.add(this.fBinder.createOrGet(this.fAdditionalIPFiles));
            this.fComponent.add((Component)this.getLabel(this.fExecutionModeParam));
            this.fComponent.add(this.fBinder.createOrGet(this.fExecutionModeParam));
        }
        this.fComponent.revalidate();
        this.fComponent.repaint();
        this.updateStepState();
    }

    private boolean isGenericAsicFpga() {
        return this.fConfiguration.getParamAsString(this.fWorkflowParam.getKey()).equals("option.workflow.GenericAsicFpga");
    }

    private boolean isTurnkey() {
        return this.fConfiguration.getParamAsString(this.fWorkflowParam.getKey()).equals("option.workflow.FpgaTurnkey");
    }

    private boolean isIpCore() {
        return this.fConfiguration.getParamAsString(this.fWorkflowParam.getKey()).equals("option.workflow.IpCore");
    }

    private Dimension computePreferredSize() {
        if (this.fComponent.getComponentCount() == 0) {
            return new Dimension(0, 0);
        }
        Object[] objectArray = new Object[]{this.fWorkflowParam, new Pair((Object)this.fPlatformParam, (Object)this.fBoardManagerLink.getComponent()), new Pair((Object)this.fToolParam, (Object)this.fRefreshWrapper), new Pair((Object)this.fFamilyParam, (Object)this.fDeviceParam), new Pair((Object)this.fPackageParam, (Object)this.fSpeedParam)};
        Dimension dimension = this.computePreferredSize(objectArray);
        if (this.isIpCore()) {
            dimension.height = (int)((double)dimension.height + (50.0 + this.fIpCoreLabel.getPreferredSize().getHeight() + this.fBinder.createOrGet(this.fReferenceDesign).getPreferredSize().getHeight() + this.fBinder.createOrGet(this.fReferenceDesignPath).getPreferredSize().getHeight() + this.fBinder.createOrGet(this.fIpCoreNameParam).getPreferredSize().getHeight() + this.fBinder.createOrGet(this.fAdditionalIPFiles).getPreferredSize().getHeight() + this.fBinder.createOrGet(this.fExecutionModeParam).getPreferredSize().getHeight()));
        } else if (this.isTurnkey()) {
            dimension.height = (int)((double)dimension.height + (24.0 + this.fFrequencyLabel.getPreferredSize().getHeight() + this.fBinder.createOrGet(this.fInputClockParam).getPreferredSize().getHeight()));
        }
        dimension.height = (int)((double)dimension.height + (this.fDescriptionLabel.getPreferredSize().getHeight() + 24.0));
        dimension.height = (int)((double)dimension.height + (this.fHelpButton.getPreferredSize().getHeight() + 3.0));
        return dimension;
    }

    private Dimension computePreferredSize(Object[] objectArray) {
        Dimension dimension = new Dimension();
        for (Object object : objectArray) {
            Dimension dimension2;
            Object object2;
            Dimension dimension3;
            if (object instanceof Param) {
                dimension3 = this.getLabel((Param)object).getPreferredSize();
                object2 = this.fBinder.createOrGet((Param)object).getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension3.width + 6 + ((Dimension)object2).width);
                dimension.height += Math.max(((Dimension)object2).height, dimension3.height) + 6;
                continue;
            }
            if (!(object instanceof Pair)) continue;
            dimension3 = (Param)((Pair)object).getFirst();
            object2 = ((Pair)object).getSecond();
            Dimension dimension4 = this.getLabel((Param)dimension3).getPreferredSize();
            Dimension dimension5 = this.fBinder.createOrGet((Param)dimension3).getPreferredSize();
            if (object2 instanceof Component) {
                dimension2 = ((Component)object2).getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension4.width + 12 + dimension5.width + dimension2.width);
            } else {
                dimension2 = this.getLabel((Param)object2).getPreferredSize();
                Dimension dimension6 = this.fBinder.createOrGet((Param)object2).getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension4.width + 16 + dimension5.width + dimension2.width + dimension6.width);
            }
            dimension.height += Math.max(dimension5.height, dimension4.height) + 6;
        }
        return dimension;
    }

    private void redoLayout() {
        Dimension dimension;
        if (this.fComponent.getComponentCount() == 0) {
            return;
        }
        Dimension dimension2 = this.fDescriptionLabel.getPreferredSize();
        this.fDescriptionLabel.setBounds(0, 0, dimension2.width, dimension2.height);
        int n = 3;
        int n2 = dimension2.height * 2;
        Holder holder = new Holder((Object)0);
        Holder holder2 = new Holder((Object)n2);
        Holder holder3 = new Holder((Object)3);
        Holder holder4 = new Holder((Object)0);
        int n3 = this.fRefreshWrapper.getPreferredSize().width;
        this.layoutLabel(this.fWorkflowParam, n, (Holder<Integer>)holder2, (Holder<Integer>)holder3, (Holder<Integer>)holder);
        if (!this.isGenericAsicFpga()) {
            this.layoutLabel(this.fPlatformParam, this.fBoardManagerLink.getComponent(), n, (Holder<Integer>)holder2, (Holder<Integer>)holder3, (Holder<Integer>)holder);
            n3 = Math.max(n3, this.fBoardManagerLink.getComponent().getPreferredSize().width);
        }
        this.layoutLabel(this.fToolParam, (Component)this.fRefreshWrapper, n, (Holder<Integer>)holder2, (Holder<Integer>)holder3, (Holder<Integer>)holder);
        this.layoutLabel(this.fFamilyParam, this.fDeviceParam, n, (Holder<Integer>)holder2, (Holder<Integer>)holder3, (Holder<Integer>)holder, (Holder<Integer>)holder4);
        this.layoutLabel(this.fPackageParam, this.fSpeedParam, n, (Holder<Integer>)holder2, (Holder<Integer>)holder3, (Holder<Integer>)holder, (Holder<Integer>)holder4);
        if (this.isTurnkey()) {
            holder2.set((Object)((Integer)holder2.get() + 24));
            dimension = this.fFrequencyLabel.getPreferredSize();
            this.fFrequencyLabel.setBounds(n, ((Integer)holder2.get()).intValue(), dimension.width, dimension.height);
            holder4.set((Object)Math.max((Integer)holder4.get(), this.getLabel((Param)this.fSystemClockParam).getPreferredSize().width));
        } else if (this.isIpCore()) {
            holder2.set((Object)((Integer)holder2.get() + 24));
            dimension = this.fIpCoreLabel.getPreferredSize();
            this.fIpCoreLabel.setBounds(n, ((Integer)holder2.get()).intValue(), dimension.width, dimension.height);
            holder4.set((Object)Math.max((Integer)holder4.get(), this.getLabel((Param)this.fIpCoreVersionParam).getPreferredSize().width));
        }
        n = (Integer)holder3.get() + 16;
        holder2.set((Object)n2);
        int n4 = (Integer)holder.get();
        n4 = Math.max(n4, this.fComponent.getWidth() - n - 40);
        n4 = Math.min(this.fComponent.getWidth() - n - 8, n4);
        this.layoutComponent(this.fWorkflowParam, n, (Holder<Integer>)holder2, n4);
        if (!this.isGenericAsicFpga()) {
            this.layoutComponent(this.fPlatformParam, this.fBoardManagerLink.getComponent(), n3, n, (Holder<Integer>)holder2, n4);
        }
        this.layoutComponent(this.fToolParam, (Component)this.fRefreshWrapper, n3, n, (Holder<Integer>)holder2, n4);
        this.layoutComponent(this.fFamilyParam, this.fDeviceParam, (int)((Integer)holder4.get()), n, (Holder<Integer>)holder2, n4);
        this.layoutComponent(this.fPackageParam, this.fSpeedParam, (int)((Integer)holder4.get()), n, (Holder<Integer>)holder2, n4);
        int n5 = (Integer)holder2.get();
        holder2.set((Object)0);
        if (this.isTurnkey()) {
            this.layoutIndentedComponent((Component)this.fFrequencyLabel, this.fInputClockParam, this.fSystemClockParam, (Integer)holder4.get(), n, (Holder<Integer>)holder2, n4);
            n5 = (Integer)holder2.get();
        } else if (this.isIpCore()) {
            this.layoutIndentedComponent((Component)this.fIpCoreLabel, this.fReferenceDesign, this.fIpCoreNameParam, n, (Holder<Integer>)holder2, n4);
            this.layoutIndentedComponent((Component)this.fIpCoreLabel, this.fReferenceDesignPath, this.fIpCoreNameParam, n, (Holder<Integer>)holder2, n4);
            this.layoutIndentedComponent((Component)this.fIpCoreLabel, this.fAdditionalIPFiles, this.fIpCoreNameParam, n, (Holder<Integer>)holder2, n4);
            this.layoutIndentedComponent((Component)this.fIpCoreLabel, this.fIpCoreNameParam, this.fIpCoreVersionParam, (Integer)holder4.get(), n, (Holder<Integer>)holder2, n4);
            this.layoutIndentedComponent((Component)this.fIpCoreLabel, this.fExecutionModeParam, this.fIpCoreNameParam, n, (Holder<Integer>)holder2, n4);
            n5 = (Integer)holder2.get();
        }
        Dimension dimension3 = this.fHelpButton.getPreferredSize();
        Rectangle rectangle = this.fBinder.createOrGet(this.fWorkflowParam).getBounds();
        this.fHelpButton.setBounds(rectangle.x + rectangle.width - dimension3.width, n5, dimension3.width, dimension3.height);
    }

    private void layoutComponent(Param param, int n, Holder<Integer> holder, int n2) {
        Component component = this.fBinder.createOrGet(param);
        Dimension dimension = component.getPreferredSize();
        component.setBounds(n, (Integer)holder.get(), n2, dimension.height);
        holder.set((Object)((Integer)holder.get() + dimension.height + 6));
    }

    private void layoutComponent(Param param, Component component, int n, int n2, Holder<Integer> holder, int n3) {
        Component component2 = this.fBinder.createOrGet(param);
        Dimension dimension = component2.getPreferredSize();
        Dimension dimension2 = component.getPreferredSize();
        component2.setBounds(n2, (Integer)holder.get(), n3 - n - 6, dimension.height);
        component.setBounds(n2 + n3 - n, (Integer)holder.get() + dimension.height / 2 - dimension2.height / 2, n, dimension2.height);
        holder.set((Object)((Integer)holder.get() + dimension.height + 6));
    }

    private void layoutComponent(Param param, Param param2, int n, int n2, Holder<Integer> holder, int n3) {
        Component component = this.fBinder.createOrGet(param);
        Dimension dimension = component.getPreferredSize();
        MJLabel mJLabel = this.getLabel(param2);
        Component component2 = this.fBinder.createOrGet(param2);
        Dimension dimension2 = mJLabel.getPreferredSize();
        Dimension dimension3 = component2.getPreferredSize();
        int n4 = this.getLabel((Param)param2).getPreferredSize().height;
        component.setBounds(n2, (Integer)holder.get(), n3 / 2 - n / 2 - 8, dimension.height);
        mJLabel.setBounds(component.getX() + component.getWidth() + 8 + n - dimension2.width, (Integer)holder.get() + dimension3.height / 2 - n4 / 2, dimension2.width, n4);
        component2.setBounds(mJLabel.getX() + mJLabel.getWidth() + 6, (Integer)holder.get() + dimension.height / 2 - dimension3.height / 2, n3 / 2 - n / 2 - 6, dimension3.height);
        holder.set((Object)((Integer)holder.get() + dimension.height + 6));
    }

    private void layoutIndentedComponent(Component component, Param param, Param param2, int n, Holder<Integer> holder, int n2) {
        Component component2 = this.fBinder.createOrGet(param);
        MJLabel mJLabel = this.getLabel(param);
        int n3 = component.getY() + component.getHeight() + 6;
        if ((Integer)holder.get() != 0) {
            n3 = (Integer)holder.get();
        }
        Dimension dimension = mJLabel.getPreferredSize();
        Dimension dimension2 = this.getLabel(param2).getPreferredSize();
        Dimension dimension3 = component2.getPreferredSize();
        mJLabel.setBounds(n - dimension2.width - 6, n3 + dimension3.height / 2 - dimension.height / 2, dimension.width, dimension.height);
        if (param.getType() == ParamType.INT) {
            dimension3.width = 75;
        }
        component2.setBounds(n + dimension.width - dimension2.width, n3, n2 - dimension.width + dimension2.width, dimension3.height);
        holder.set((Object)(n3 + component2.getHeight() + 6));
    }

    private void layoutIndentedComponent(Component component, Param param, Param param2, int n, int n2, Holder<Integer> holder, int n3) {
        Component component2 = this.fBinder.createOrGet(param);
        Component component3 = this.fBinder.createOrGet(param2);
        MJLabel mJLabel = this.getLabel(param);
        MJLabel mJLabel2 = this.getLabel(param2);
        if ((Integer)holder.get() == 0) {
            holder.set((Object)(component.getY() + component.getHeight() + 6));
        }
        Dimension dimension = mJLabel.getPreferredSize();
        Dimension dimension2 = component2.getPreferredSize();
        Dimension dimension3 = mJLabel2.getPreferredSize();
        Dimension dimension4 = component3.getPreferredSize();
        mJLabel.setBounds(n2 - 6 - dimension.width, (Integer)holder.get() + dimension2.height / 2 - dimension.height / 2, dimension.width, dimension.height);
        if (param.getType() == ParamType.INT) {
            dimension2.width = 75;
        }
        dimension2.width = Math.min(dimension2.width, n3 / 2 - n / 2 - 10);
        component2.setBounds(n2, (Integer)holder.get(), dimension2.width, dimension2.height);
        mJLabel2.setBounds(n2 + n3 / 2 - n / 2, (Integer)holder.get() + dimension4.height / 2 - dimension3.height / 2, n, dimension3.height);
        if (param2.getType() == ParamType.INT) {
            dimension4.width = 75;
        }
        dimension4.width = Math.min(dimension4.width, n3 / 2 - n / 2 - 10);
        component3.setBounds(mJLabel2.getX() + mJLabel2.getWidth() + 6, (Integer)holder.get(), dimension4.width + 3, dimension4.height);
        holder.set((Object)((Integer)holder.get() + dimension2.height + 6));
    }

    private void layoutLabel(Param param, int n, Holder<Integer> holder, Holder<Integer> holder2, Holder<Integer> holder3) {
        this.layoutLabel(param, null, null, n, holder, holder2, holder3, null);
    }

    private void layoutLabel(Param param, Param param2, int n, Holder<Integer> holder, Holder<Integer> holder2, Holder<Integer> holder3, Holder<Integer> holder4) {
        this.layoutLabel(param, param2, null, n, holder, holder2, holder3, holder4);
    }

    private void layoutLabel(Param param, Component component, int n, Holder<Integer> holder, Holder<Integer> holder2, Holder<Integer> holder3) {
        this.layoutLabel(param, null, component, n, holder, holder2, holder3, null);
    }

    private void layoutLabel(Param param, Param param2, Component component, int n, Holder<Integer> holder, Holder<Integer> holder2, Holder<Integer> holder3, Holder<Integer> holder4) {
        Dimension dimension = this.getLabel(param).getPreferredSize();
        Dimension dimension2 = this.fBinder.createOrGet(param).getPreferredSize();
        this.getLabel(param).setBounds(n, (Integer)holder.get() + dimension2.height / 2 - dimension.height / 2, dimension.width, dimension.height);
        holder2.set((Object)Math.max((Integer)holder2.get(), dimension.width));
        Dimension dimension3 = this.fBinder.createOrGet(param).getPreferredSize();
        int n2 = 0;
        if (param2 != null) {
            n2 = (int)((double)n2 + (this.getLabel(param2).getPreferredSize().getWidth() + 10.0 + this.fBinder.createOrGet(param2).getPreferredSize().getWidth()));
        } else if (component != null) {
            n2 = (int)((double)n2 + (10.0 + component.getPreferredSize().getWidth()));
        }
        holder3.set((Object)Math.max((Integer)holder3.get(), dimension3.width + n2));
        if (holder4 != null) {
            holder4.set((Object)Math.max((Integer)holder4.get(), this.getLabel((Param)param2).getPreferredSize().width));
        }
        holder.set((Object)((Integer)holder.get() + 6 + Math.max(dimension.height, dimension3.height)));
    }

    public void activate() {
    }

    public Component getComponent() {
        return this.fWrapper;
    }

    public void dispose() {
        this.fBinder.dispose();
        this.fConfiguration.removePropertyChangeListener(this.fConfigurationListener);
    }

    private MJLabel getLabel(Param param) {
        MJLabel mJLabel = this.fLabels.get(param.getKey());
        if (mJLabel == null) {
            mJLabel = new MJLabel(param.getName() + ":");
            this.fLabels.put(param.getKey(), mJLabel);
        }
        return mJLabel;
    }

    @Override
    protected WorkflowStepResult computeStepState() {
        String string = this.fConfiguration.getParamAsString(this.fToolParam.getKey());
        String string2 = this.fConfiguration.getParamAsString(this.fPlatformParam.getKey());
        if (!this.isGenericAsicFpga() && (string == null || string2 == null || string.contains("No synthesis tool") && !string2.equals("Generic Xilinx Platform") || string2.equals("Choose a platform"))) {
            return null;
        }
        return WorkflowStepResult.COMPLETED;
    }

    private ComboBox createOrGetComboBox(Param param) {
        ComboBox comboBox = this.fComboBoxes.get(param.getKey());
        if (comboBox == null) {
            comboBox = new ComboBox(param);
            this.fComboBoxes.put(param.getKey(), comboBox);
            this.fBinder.register(param, (ParamWidget)comboBox);
        }
        return comboBox;
    }

    private IPFilesChooser createOrGetIPFilesChooser(Param param) {
        IPFilesChooser iPFilesChooser = this.fIPFilesChooser;
        if (iPFilesChooser == null) {
            this.fIPFilesChooser = iPFilesChooser = new IPFilesChooser(param, this.fConfiguration.getProject());
            this.fBinder.register(param, (ParamWidget)iPFilesChooser);
        }
        return iPFilesChooser;
    }

    private boolean hasToolSelected() {
        String string = this.fConfiguration.getParamAsString(this.fToolParam.getKey());
        return string != null && !string.equals("No synthesis tool available on system path") && !string.equals("No synthesis tool specified");
    }

    private boolean hasXilinxToolSelected() {
        String string = this.fConfiguration.getParamAsString(this.fToolParam.getKey());
        return string != null && (string.equals("Xilinx ISE") || string.equals("Xilinx Vivado"));
    }

    private boolean hasNoBoardSelected() {
        String string = this.fConfiguration.getParamAsString(this.fPlatformParam.getKey());
        return string != null && string.equals("Choose a platform");
    }

    private void updateOptions(final String string, final boolean bl) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SelectTargetPanel.this.fComboBoxes.isEmpty()) {
                    return;
                }
                for (ComboBox comboBox : SelectTargetPanel.this.fComboBoxes.values()) {
                    comboBox.setEnabled(false);
                }
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Param param;
                        LinkedHashMap<Param, String> linkedHashMap = new LinkedHashMap<Param, String>();
                        linkedHashMap.put(SelectTargetPanel.this.fWorkflowParam, "Workflow");
                        linkedHashMap.put(SelectTargetPanel.this.fPlatformParam, "Board");
                        linkedHashMap.put(SelectTargetPanel.this.fToolParam, "Tool");
                        linkedHashMap.put(SelectTargetPanel.this.fReferenceDesign, "ReferenceDesign");
                        linkedHashMap.put(SelectTargetPanel.this.fFamilyParam, "Family");
                        linkedHashMap.put(SelectTargetPanel.this.fDeviceParam, "Device");
                        linkedHashMap.put(SelectTargetPanel.this.fPackageParam, "Package");
                        linkedHashMap.put(SelectTargetPanel.this.fSpeedParam, "Speed");
                        Iterator iterator = linkedHashMap.entrySet().iterator();
                        while (iterator.hasNext() && !(param = (Param)iterator.next().getKey()).getKey().equals(string)) {
                        }
                        param = new HashMap();
                        for (Param param2 : linkedHashMap.keySet()) {
                            param.put(param2.getKey(), SelectTargetPanel.this.fConfiguration.getParamAsString(param2.getKey()));
                        }
                        final LinkedHashMap linkedHashMap2 = new LinkedHashMap();
                        SelectTargetPanel.this.loadCascadingOptions(linkedHashMap, iterator, linkedHashMap2, (Map)param, bl);
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                SelectTargetPanel.this.fSuppressUpdateOptions = true;
                                for (Map.Entry entry : linkedHashMap2.entrySet()) {
                                    ComboBox comboBox = (ComboBox)((Object)SelectTargetPanel.this.fComboBoxes.get(entry.getKey()));
                                    if (comboBox == null) continue;
                                    comboBox.updateOptions((OptionListWithDefault)entry.getValue());
                                }
                                for (Map.Entry entry : SelectTargetPanel.this.fComboBoxes.entrySet()) {
                                    if (((String)entry.getKey()).equals(SelectTargetPanel.this.fToolParam.getKey())) {
                                        ((ComboBox)((Object)entry.getValue())).setEnabled(true);
                                    }
                                    if (((String)entry.getKey()).equals(SelectTargetPanel.this.fReferenceDesign.getKey())) {
                                        ((ComboBox)((Object)entry.getValue())).setEnabled(true);
                                        if (SelectTargetPanel.this.hasNoBoardSelected()) {
                                            ((ComboBox)((Object)entry.getValue())).removeAllItems();
                                            ((ComboBox)((Object)entry.getValue())).getComponent().setEnabled(false);
                                        } else {
                                            ((ComboBox)((Object)entry.getValue())).getComponent().setEnabled(true);
                                        }
                                    }
                                    if (((String)entry.getKey()).equals(SelectTargetPanel.this.fPlatformParam.getKey())) {
                                        ((ComboBox)((Object)entry.getValue())).setEnabled(!SelectTargetPanel.this.isGenericAsicFpga());
                                    }
                                    if (((String)entry.getKey()).equals(SelectTargetPanel.this.fFamilyParam.getKey()) || ((String)entry.getKey()).equals(SelectTargetPanel.this.fDeviceParam.getKey())) {
                                        ((ComboBox)((Object)entry.getValue())).setEnabled(SelectTargetPanel.this.hasToolSelected() && SelectTargetPanel.this.isGenericAsicFpga());
                                    }
                                    if (!((String)entry.getKey()).equals(SelectTargetPanel.this.fPackageParam.getKey()) && !((String)entry.getKey()).equals(SelectTargetPanel.this.fSpeedParam.getKey())) continue;
                                    ((ComboBox)((Object)entry.getValue())).setEnabled(SelectTargetPanel.this.hasXilinxToolSelected() && SelectTargetPanel.this.isGenericAsicFpga());
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        SelectTargetPanel.this.fSuppressUpdateOptions = false;
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadCascadingOptions(Map<Param, String> map, Iterator<Map.Entry<Param, String>> iterator, Map<String, OptionListWithDefault> map2, Map<String, String> map3, boolean bl) {
        if (iterator.hasNext()) {
            void var10_23;
            String string;
            Object object;
            Map.Entry<Param, String> entry = iterator.next();
            List<String> list = this.getArguments(map, map3, entry.getValue());
            try {
                object = Matlab.mtFevalConsoleOutput((String)"getHDLToolInfo", (Object[])list.toArray(), (int)2);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
            String[] stringArray = (String[])((Object[])object)[0];
            String string2 = (String)((Object[])object)[1];
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (String string3 : stringArray) {
                linkedHashMap.put(string3, string3);
            }
            if (bl && (string = map3.get(entry.getKey().getKey())) != null && linkedHashMap.containsKey(string)) {
                String string4 = string;
            }
            map3.put(entry.getKey().getKey(), (String)var10_23);
            map2.put(entry.getKey().getKey(), new OptionListWithDefault(linkedHashMap, (String)var10_23));
            this.loadCascadingOptions(map, iterator, map2, map3, bl);
            return;
        }
        if (this.isTurnkey()) {
            try {
                List<String> list = this.getArguments(map, map3, "targetFrequency");
                Object object = Matlab.mtFevalConsoleOutput((String)"getHDLToolInfo", (Object[])list.toArray(), (int)1);
                int n = Integer.parseInt((String)object);
                if (n <= 0) return;
                this.fConfiguration.setParamAsInt(this.fInputClockParam.getKey(), n);
                this.fConfiguration.setParamAsInt(this.fSystemClockParam.getKey(), n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        if (!this.isIpCore()) return;
        try {
            List<String> list = this.getArguments(map, map3, "referenceDesignPath");
            Object object = Matlab.mtFevalConsoleOutput((String)"getHDLToolInfo", (Object[])list.toArray(), (int)1);
            final int n = Integer.parseInt((String)object);
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (SelectTargetPanel.this.isIpCore()) {
                        SelectTargetPanel.this.fBinder.get(SelectTargetPanel.this.fReferenceDesignPath).setEnabled(!SelectTargetPanel.this.hasNoBoardSelected() && n > 0);
                    }
                }
            });
            return;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private List<String> getArguments(Map<Param, String> map, Map<String, String> map2, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        for (Map.Entry<Param, String> entry : map.entrySet()) {
            if (entry.getValue().equals(string)) break;
            arrayList.add(entry.getValue());
            String string2 = map2.get(entry.getKey().getKey());
            if (entry.getKey().getOptions() != null && !entry.getKey().getOptions().isEmpty()) {
                arrayList.add(entry.getKey().getResourceProvider().getResource(string2, false));
                continue;
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    public class IPFilesChooser
    extends AbstractListWidget<File> {
        private final List<FileSetFilter> fVerilogFilters;
        private final List<FileSetFilter> fVhdlFilters;
        private final List<FileSetFilter> fHdlLangAgnosticFilters;

        public IPFilesChooser(Param param, Project project) {
            super(project, param, ListTextFieldStyle.FILES);
            this.fVerilogFilters = new ArrayList<FileSetFilter>(0);
            this.fVhdlFilters = new ArrayList<FileSetFilter>(0);
            this.fHdlLangAgnosticFilters = new ArrayList<FileSetFilter>(0);
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("vhdl", "All HDL Files (*.vhd, *.vhdl)");
            linkedHashMap.put("verilog", "All HDL Files (*.v, *.vlg, *.verilog)");
            linkedHashMap.put("sdc_xdc", "SDC/XDC Files (*.sdc, *.xdc)");
            linkedHashMap.put("tcl", "Tcl Files (*.tcl)");
            Iterator iterator = linkedHashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next().getKey();
                String string2 = (String)linkedHashMap.get(string);
                String[] stringArray = string2.split("[(),]+");
                FileSetFilter fileSetFilter = new FileSetFilter(string2);
                for (int i = 1; i < stringArray.length; ++i) {
                    fileSetFilter.addRule(new FileSetRule(stringArray[i], false));
                }
                if (string.equals("vhdl")) {
                    this.fVhdlFilters.add(fileSetFilter);
                    continue;
                }
                if (string.equals("verilog")) {
                    this.fVerilogFilters.add(fileSetFilter);
                    continue;
                }
                this.fHdlLangAgnosticFilters.add(fileSetFilter);
            }
            this.applyVHDLFilters();
        }

        public void applyVHDLFilters() {
            ArrayList<FileSetFilter> arrayList = new ArrayList<FileSetFilter>(0);
            arrayList.addAll(this.fVhdlFilters);
            arrayList.addAll(this.fHdlLangAgnosticFilters);
            this.getField().replaceFilters(arrayList);
        }

        public void applyVerilogFilters() {
            ArrayList<FileSetFilter> arrayList = new ArrayList<FileSetFilter>(0);
            arrayList.addAll(this.fVerilogFilters);
            arrayList.addAll(this.fHdlLangAgnosticFilters);
            this.getField().replaceFilters(arrayList);
        }

        public void setData(List<File> list) {
            this.getField().setFileList(list);
        }

        public List<File> getData() {
            return this.getField().getFileList();
        }
    }

    private class ComboBox
    extends MJComboBox
    implements ParamWidget<String> {
        private final MulticastChangeListener fChangeListeners;

        ComboBox(Param param) {
            this.setName(param.getKey() + ".combobox");
            this.fChangeListeners = new MulticastChangeListener();
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    Object object = ComboBox.this.getSelectedItem();
                    Object object2 = itemEvent.getItem();
                    if (object2 == object && ComboBox.this.getSelectedIndex() >= 0) {
                        String string = null;
                        if (object != null && object.equals("Get more...")) {
                            ComboBox.this.setSelectedItem("Generic Xilinx Platform");
                            string = SelectTargetPanel.GET_MORE_BOARDS_CALLBACK;
                        } else if (object != null && object.equals("Get more boards...")) {
                            ComboBox.this.setSelectedItem("Choose a platform");
                            string = SelectTargetPanel.GET_MORE_BOARDS_CALLBACK;
                        } else if (object != null && object.equals("Create custom board...")) {
                            ComboBox.this.setSelectedItem("Choose a platform");
                            string = SelectTargetPanel.CREATE_CUSTOM_BOARD_CALLBACK;
                        } else {
                            ComboBox.this.fChangeListeners.stateChanged(new ChangeEvent((Object)ComboBox.this));
                        }
                        if (string != null) {
                            new Matlab().evalConsoleOutput(string);
                        }
                    }
                }
            });
        }

        public Component getComponent() {
            return this;
        }

        public void dispose() {
        }

        public void updateOptions(OptionListWithDefault optionListWithDefault) {
            this.removeAllItems();
            for (String string : optionListWithDefault.getOptions().keySet()) {
                this.addItem(string);
            }
            this.setSelectedItem(optionListWithDefault.getDefault());
        }

        public boolean isExternalLabelRequired() {
            return true;
        }

        public void setData(String string) {
            this.setSelectedItem(string);
        }

        public String getData() {
            return (String)this.getSelectedItem();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.fChangeListeners.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.fChangeListeners.removeChangeListener(changeListener);
        }

        public boolean showValidationMessage(ValidationMessage validationMessage) {
            return false;
        }

        public void clearValidationMessage() {
        }
    }
}

