/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.toolbox.coder.CoderAPI;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public final class GenerateFunctionInfo {
    private GenerateFunctionInfo() {
    }

    public static void run(String string) throws Exception {
        GenerateFunctionInfo.main(new String[]{string});
    }

    public static void printFiSupportedFunctions(String string) throws Exception {
        TreeSet<String> treeSet = new TreeSet<String>(GenerateFunctionInfo.findFunctionsWithFiSupport(new File(string)));
        for (String string2 : treeSet) {
            System.out.println(string2);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File(stringArray[0]);
        File file2 = new File(file, "java/src/com/mathworks/toolbox/coder/screener/FunctionInfo.java");
        file2.setWritable(true);
        PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
        printWriter.println("// Copyright 2012 The MathWorks. Inc.");
        printWriter.println();
        printWriter.println("package com.mathworks.toolbox.coder.screener;");
        printWriter.println();
        printWriter.println("import java.util.Set;");
        printWriter.println("import java.util.HashSet;");
        printWriter.println();
        printWriter.println("/** Generated by the GenerateFunctionInfo class */");
        printWriter.println("public final class FunctionInfo {");
        printWriter.println("    private static final Set<String> BUILTIN_NAMES = new HashSet<String>();");
        printWriter.println("    private static final Set<String> AUTO_EXTRINSIC_NAMES = new HashSet<String>();");
        printWriter.println("    private static final Set<String> FUNCTIONS_WITH_EML_IMPL = new HashSet<String>();");
        printWriter.println("    private static final Set<String> FUNCTIONS_WITH_FI_SUPPORT = new HashSet<String>();");
        printWriter.println("    private static final Set<String> SYSTEM_OBJECT_CLASSES = new HashSet<String>();");
        printWriter.println("    private static final Set<String> EXEMPT_METHOD_NAMES = new HashSet<String>();");
        printWriter.println();
        printWriter.println("    static {");
        for (String string : CoderAPI.getBuiltinNames().split(",")) {
            printWriter.println("        BUILTIN_NAMES.add(\"" + string + "\");");
        }
        printWriter.println();
        for (String string : CoderAPI.getAutoExtrinsicNames().split(",")) {
            printWriter.println("        AUTO_EXTRINSIC_NAMES.add(\"" + string + "\");");
        }
        printWriter.println();
        for (String string : GenerateFunctionInfo.findFunctionsWithEmlImpl()) {
            printWriter.println("        FUNCTIONS_WITH_EML_IMPL.add(\"" + string + "\");");
        }
        printWriter.println();
        for (String string : GenerateFunctionInfo.findFunctionsWithFiSupport(file)) {
            printWriter.println("        FUNCTIONS_WITH_FI_SUPPORT.add(\"" + string + "\");");
        }
        printWriter.println();
        for (String string : GenerateFunctionInfo.findSystemObjectClasses()) {
            printWriter.println("        SYSTEM_OBJECT_CLASSES.add(\"" + string + "\");");
        }
        printWriter.println();
        for (String string : GenerateFunctionInfo.findExemptMethodNames(file)) {
            printWriter.println("        EXEMPT_METHOD_NAMES.add(\"" + string + "\");");
        }
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public static boolean isBuiltin(String name) {");
        printWriter.println("        return BUILTIN_NAMES.contains(name);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public static boolean isAutoExtrinsic(String name) {");
        printWriter.println("        return AUTO_EXTRINSIC_NAMES.contains(name);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public static boolean hasEmlImpl(String name) {");
        printWriter.println("        return FUNCTIONS_WITH_EML_IMPL.contains(name);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public static boolean hasFixedPointSupport(String name) {");
        printWriter.println("        return FUNCTIONS_WITH_FI_SUPPORT.contains(name);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public static boolean isSystemObjectClass(String name) {");
        printWriter.println("        return SYSTEM_OBJECT_CLASSES.contains(name);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public static boolean isExemptMethodName(String name) {");
        printWriter.println("        return EXEMPT_METHOD_NAMES.contains(name);");
        printWriter.println("    }");
        printWriter.println("}");
        printWriter.println();
        printWriter.close();
    }

    private static Set<String> findFunctions(String ... stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        final TreeSet<String> treeSet = new TreeSet<String>();
        File file = PlatformInfo.isWindows() ? new File("\\\\mathworks\\devel\\jobarchive\\Aeml\\latest_pass\\matlab") : new File("/mathworks/devel/jobarchive/Aeml/latest_pass/matlab");
        for (String string : stringArray) {
            arrayList.add(new File(file, string));
        }
        for (File file2 : arrayList) {
            try {
                FileList fileList = RealFileSystem.getInstance().search(new FileLocation(file2), new SearchCriteria("*.m"), (Predicate)new Predicate<FileSystemEntry>(){

                    public boolean accept(FileSystemEntry fileSystemEntry) {
                        return !fileSystemEntry.getName().equals("CVS");
                    }
                });
                fileList.readFilesAndFolders((AsyncReceiver)new AsyncReceiver<FileSystemEntry>(){

                    public boolean receive(FileSystemEntry fileSystemEntry) {
                        if (fileSystemEntry.getName().startsWith("eml_")) {
                            treeSet.add(fileSystemEntry.getName().substring(4, fileSystemEntry.getName().length() - 2));
                        } else {
                            treeSet.add(fileSystemEntry.getLocation().getNameBeforeDot());
                        }
                        return true;
                    }
                });
            }
            catch (IOException iOException) {}
        }
        return treeSet;
    }

    private static Set<String> findFunctionsWithEmlImpl() {
        Set<String> set = GenerateFunctionInfo.findFunctions("toolbox/aeroblks/eml", "toolbox/comm/comm/eml", "toolbox/dsp/dsp/eml", "toolbox/eml/lib", "toolbox/images/images/eml", "toolbox/signal/eml", "toolbox/vision/vision/eml", "toolbox/stats/eml");
        set.add("setProperties");
        return set;
    }

    private static Set<String> findFunctionsWithFiSupport(File file) throws IOException {
        Set<String> set = GenerateFunctionInfo.findFunctions("toolbox/fixedpoint/fixedpoint/@embedded");
        set.addAll(GenerateFunctionInfo.findFunctions("toolbox/fixedpoint/fixedpoint/+embedded"));
        String string = CoderFileSupport.readMatlabSource(new FileLocation(new FileLocation(file), "java/src/com/mathworks/toolbox/coder/resources/fixedPointWhiteList.txt"));
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n,;");
        while (stringTokenizer.hasMoreTokens()) {
            set.add(stringTokenizer.nextToken());
        }
        return set;
    }

    private static Set<String> findExemptMethodNames(File file) throws IOException {
        String string = CoderFileSupport.readMatlabSource(new FileLocation(new FileLocation(file), "java/src/com/mathworks/toolbox/coder/resources/screenerExemptMethodNames.txt"));
        TreeSet<String> treeSet = new TreeSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n,;");
        while (stringTokenizer.hasMoreTokens()) {
            treeSet.add(stringTokenizer.nextToken());
        }
        return treeSet;
    }

    private static Set<String> findSystemObjectClasses() throws Exception {
        Object[] objectArray;
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Object object : objectArray = (Object[])Matlab.mtFeval((String)"emlcprivate", (Object[])new Object[]{"getAllSystemObjectClasses"}, (int)1)) {
            treeSet.add(object.toString());
        }
        return treeSet;
    }
}

