/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.Animator;
import com.mathworks.widgets.ComponentBuilder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.UIManager;

public final class ScoreGauge
implements ComponentBuilder {
    private final MJPanel fComponent;
    private final int fScore;
    private double fNeedlePhase;
    private double fNeedleDegree;
    private boolean fStarted;
    private static final Color[] COLORS = new Color[]{new Color(0xB22222), new Color(16729344), new Color(16766720), new Color(164, 213, 90), new Color(88, 151, 23)};
    private static final double[] NEEDLE_ANGLES = new double[]{30.0, 80.0, 140.0, 200.0, 270.0};

    public ScoreGauge(Animator animator, int n) {
        this.fScore = n;
        this.fComponent = new ScorePanel(animator);
        this.fComponent.putClientProperty((Object)"mwjavaguitest.instance", (Object)this);
        this.fComponent.setName("wfa.screener.gauge");
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public double getNeedleAngle() {
        return this.fNeedleDegree;
    }

    public boolean isAnimating() {
        return this.fNeedlePhase < 1.0;
    }

    private class ScorePanel
    extends MJPanel {
        private final Animator fAnimator;

        ScorePanel(Animator animator) {
            this.fAnimator = animator;
        }

        public void paintComponent(Graphics graphics) {
            if (!ScoreGauge.this.fStarted) {
                ScoreGauge.this.fStarted = true;
                this.fAnimator.animate(AnimationTrack.VERY_SLOW_LINEAR, new Animation(){

                    @Override
                    public void step(double d) {
                        ScoreGauge.this.fNeedlePhase = d;
                        ScorePanel.this.revalidate();
                        ScorePanel.this.repaint();
                    }
                });
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(UIManager.getColor("control"));
            graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
            double d = 230.0;
            double d2 = (d + (d - 180.0)) / 5.0;
            double d3 = 10.0;
            double d4 = 10.0;
            double d5 = (double)this.getWidth() - d3 * 2.0;
            double d6 = (double)this.getHeight() - d4 * 2.0;
            double d7 = (double)this.getWidth() - d3;
            double d8 = (double)this.getHeight() - d4;
            double d9 = 20.0;
            double d10 = 20.0;
            double d11 = (double)this.getWidth() - d9 * 2.0;
            double d12 = (double)this.getHeight() - d10 * 2.0;
            for (Color color : COLORS) {
                graphics2D.setColor(color);
                Area area = new Area(new Arc2D.Double(d3, d4, d5, d6, d, -d2, 2));
                area.subtract(new Area(new Arc2D.Double(d9, d10, d11, d12, 0.0, 360.0, 2)));
                graphics2D.fill(area);
                d -= d2;
            }
            double d13 = NEEDLE_ANGLES[ScoreGauge.this.fScore - 1] * ScoreGauge.this.fNeedlePhase;
            ScoreGauge.this.fNeedleDegree = d13;
            d13 = -4.014257274999999 + 0.0174532925 * d13;
            double d14 = Math.sqrt(1.0 / (Math.pow(Math.sin(d13) / (d8 / 2.0), 2.0) + Math.pow(Math.cos(d13) / (d7 / 2.0), 2.0)));
            graphics2D.setColor(new Color(75, 75, 75));
            graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
            graphics2D.fill(new RoundRectangle2D.Double(this.getWidth() / 2 - 8, this.getHeight() / 2 - 8, 16.0, 16.0, 16.0, 16.0));
            graphics2D.draw(new Line2D.Double(this.getWidth() / 2, this.getHeight() / 2, (double)(this.getWidth() / 2) + d14 * Math.cos(d13), (double)(this.getHeight() / 2) + d14 * Math.sin(d13)));
            graphics2D.setFont(graphics2D.getFont().deriveFont(1, 14.0f));
            for (int i = 0; i < 5; ++i) {
                d13 = NEEDLE_ANGLES[i];
                if (i != 2 && i != 3) {
                    d13 -= 8.0;
                } else if (i == 3 || ScoreGauge.this.fScore == 3) {
                    d13 += 8.0;
                }
                if (i == 4) {
                    d13 -= 4.0;
                }
                d13 = -4.014257274999999 + 0.0174532925 * d13;
                d14 = Math.sqrt(1.0 / (Math.pow(Math.sin(d13) / ((d8 - 40.0) / 2.0), 2.0) + Math.pow(Math.cos(d13) / ((d7 - 40.0) / 2.0), 2.0)));
                graphics2D.drawString(Integer.toString(i + 1), (float)((double)(this.getWidth() / 2) + d14 * Math.cos(d13)) - (float)(i > 2 ? 8 : 0), (float)((double)(this.getHeight() / 2) + d14 * Math.sin(d13)) + 8.0f);
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 185);
        }
    }
}

