/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.coder.fixedpoint.AbstractEditableCodePopupContentView;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupFrame;
import com.mathworks.toolbox.coder.fixedpoint.HDLExtendedModel;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.build.HDLTableUtils;
import com.mathworks.util.ParameterRunnable;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public final class HDLCodePopupContentView
extends AbstractEditableCodePopupContentView {
    private final HDLExtendedModel.HDLParameterObserver fParamUpdater;
    private final Map<HDLExtendedModel.HDLParameter, ParameterDelegate> fAllDelegates;
    private final HDLExtendedModel fModel;
    private CodePopupFrame fParent;
    private ParameterDelegate fCurrentDelegate;
    private FunctionScopedKey<?> fCurrentKey;
    private Component fLastWidget;

    public HDLCodePopupContentView(HDLExtendedModel hDLExtendedModel) {
        super(true, true);
        this.fModel = hDLExtendedModel;
        this.fAllDelegates = new HashMap<HDLExtendedModel.HDLParameter, ParameterDelegate>();
        this.fParamUpdater = new HDLExtendedModel.HDLParameterObserver(){

            @Override
            public void hdlParameterChanged(HDLExtendedModel.HDLParameter<?> hDLParameter, Object object) {
                if (HDLCodePopupContentView.this.fCurrentDelegate != null && HDLCodePopupContentView.this.fCurrentKey != null && HDLCodePopupContentView.this.fCurrentKey.equals(object)) {
                    HDLCodePopupContentView.this.fCurrentDelegate.updateComponent(hDLParameter.getValue(object));
                }
            }
        };
    }

    @Override
    protected JComponent doContentWidgetUpdate(FunctionScopedKey functionScopedKey, Function function) {
        Collection<HDLExtendedModel.HDLParameter<?>> collection = null;
        Object object = null;
        if (functionScopedKey != null) {
            collection = this.fModel.getHDLParameters(functionScopedKey);
            object = functionScopedKey;
        } else {
            collection = this.fModel.getHDLParameters(function);
            object = function;
        }
        if (collection.size() == 0) {
            return null;
        }
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setFocusable(true);
        this.fLastWidget = mJPanel;
        HDLTableUtils.GridBagFormBuilder gridBagFormBuilder = new HDLTableUtils.GridBagFormBuilder((JPanel)mJPanel).constrain("fill", 2).withColumnWeights(2.0, 1.0).constrain("ipadx", 2).constrain("ipady", 2).withInsets(new Insets(6, 6, 6, 6));
        this.fAllDelegates.clear();
        for (HDLExtendedModel.HDLParameter<?> hDLParameter : collection) {
            ParameterDelegate parameterDelegate = this.getDelegate(hDLParameter, object);
            if (parameterDelegate == null) continue;
            MJLabel mJLabel = new MJLabel(HDLExtendedModel.getDisplayString(hDLParameter), 2);
            mJLabel.setFont(mJLabel.getFont().deriveFont(1));
            gridBagFormBuilder.add((JComponent)mJLabel, "anchor 17").add(parameterDelegate.getComponent(), "anchor 13").nextRow();
            this.fAllDelegates.put(hDLParameter, parameterDelegate);
        }
        return mJPanel;
    }

    @Override
    public void setParentCodePopupFrame(CodePopupFrame codePopupFrame) {
        this.fParent = codePopupFrame;
    }

    @Override
    public boolean isContentViewFocused() {
        for (ParameterDelegate parameterDelegate : this.fAllDelegates.values()) {
            if (!parameterDelegate.isFocused()) continue;
            return true;
        }
        return this.fLastWidget != null && this.fLastWidget.hasFocus();
    }

    private ParameterDelegate getDelegate(HDLExtendedModel.HDLParameter<?> hDLParameter, Object object) {
        if (hDLParameter.getValueType().equals(Boolean.class)) {
            return this.createBooleanDelegate(hDLParameter, object);
        }
        if (hDLParameter.getValueType().equals(Integer.class)) {
            return new IntegerParameterDelegate(hDLParameter, object);
        }
        if (Enum.class.isAssignableFrom(hDLParameter.getValueType())) {
            return this.createEnumDelegate(hDLParameter, object);
        }
        return null;
    }

    private ParameterDelegate createBooleanDelegate(HDLExtendedModel.HDLParameter<?> hDLParameter, Object object) {
        return new ComboBoxDelegate<Boolean>(hDLParameter, object, (Boolean)hDLParameter.getDefaultValue(), Boolean.TRUE, Boolean.FALSE);
    }

    private ParameterDelegate createEnumDelegate(HDLExtendedModel.HDLParameter<?> hDLParameter, Object object) {
        Class<?> clazz = hDLParameter.getValueType();
        assert (clazz.isInstance(hDLParameter.getDefaultValue()));
        return new ComboBoxDelegate(hDLParameter, object, hDLParameter.getDefaultValue(), clazz.getEnumConstants());
    }

    private class ComboBoxDelegate<T>
    implements ParameterDelegate {
        private final T fDefaultValue;
        private final DefaultComboBoxModel<T> fComboModel;
        private final HDLExtendedModel.HDLParameter<?> fParameter;
        private final Object fKey;
        private JComboBox<T> fCombo;

        ComboBoxDelegate(HDLExtendedModel.HDLParameter<?> hDLParameter, Object object, T t, T ... TArray) {
            this.fDefaultValue = t;
            this.fParameter = hDLParameter;
            this.fKey = object;
            this.fComboModel = new DefaultComboBoxModel<T>(TArray);
        }

        @Override
        public JComponent getComponent() {
            if (this.fCombo == null) {
                this.fCombo = HDLCodePopupContentView.this.fParent.createTransparencySafeComboBox();
                this.fCombo.setModel(this.fComboModel);
                this.fCombo.setRenderer(new BasicComboBoxRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                        String string;
                        super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                        if (object != null && (string = ComboBoxDelegate.this.fParameter.getValueDisplayKey(object)) != null) {
                            try {
                                this.setText(CoderResources.getString(string));
                            }
                            catch (MissingResourceException missingResourceException) {
                                // empty catch block
                            }
                        }
                        return this;
                    }
                });
                this.fCombo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        HDLCodePopupContentView.this.pushCommitRequest(new AbstractEditableCodePopupContentView.CommitContext(){

                            @Override
                            public String getValue() {
                                return ComboBoxDelegate.this.fCombo.getSelectedItem().toString();
                            }

                            @Override
                            public Object getKey() {
                                return ComboBoxDelegate.this.fCombo;
                            }

                            @Override
                            public ParameterRunnable<String> getParameterRunnable() {
                                return new ParameterRunnable<String>(){

                                    public void run(String string) {
                                        ComboBoxDelegate.this.fParameter.performSetValue(ComboBoxDelegate.this.fKey, Boolean.parseBoolean(string));
                                    }
                                };
                            }
                        });
                    }
                });
                if (this.fDefaultValue != null) {
                    this.fCombo.setSelectedItem(this.fParameter.getValue(this.fKey));
                }
            }
            return this.fCombo;
        }

        @Override
        public void updateComponent(Object object) {
            if (this.fCombo != null) {
                this.fCombo.setSelectedItem(object);
            }
        }

        @Override
        public boolean isFocused() {
            return this.fCombo != null && (this.fCombo.hasFocus() || this.fCombo.isPopupVisible());
        }
    }

    private static interface ParameterDelegate {
        public JComponent getComponent();

        public void updateComponent(Object var1);

        public boolean isFocused();
    }

    private class IntegerParameterDelegate
    implements ParameterDelegate {
        private final HDLExtendedModel.HDLParameter<?> fParam;
        private final Object fKey;
        private MJTextField fTextField;
        private String fPreviousText;

        IntegerParameterDelegate(HDLExtendedModel.HDLParameter<?> hDLParameter, Object object) {
            this.fParam = hDLParameter;
            this.fKey = object;
        }

        @Override
        public JComponent getComponent() {
            if (this.fTextField != null) {
                return this.fTextField;
            }
            this.fTextField = new MJTextField(this.fParam.getValue(this.fKey).toString());
            if (this.fTextField.getDocument() instanceof AbstractDocument) {
                ((AbstractDocument)this.fTextField.getDocument()).setDocumentFilter(new DocumentFilter(){
                    private static final String DIGIT_REGEX = "^[\\d]*+$";

                    @Override
                    public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                        if (string.matches(DIGIT_REGEX)) {
                            super.insertString(filterBypass, n, string, attributeSet);
                        }
                    }

                    @Override
                    public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                        if (string.matches(DIGIT_REGEX)) {
                            super.replace(filterBypass, n, n2, string, attributeSet);
                        }
                    }
                });
            }
            this.fTextField.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    IntegerParameterDelegate.this.doEntering();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    IntegerParameterDelegate.this.doLeaving();
                }
            });
            this.fTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    IntegerParameterDelegate.this.doLeaving();
                }
            });
            this.fTextField.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getID() == 27 && IntegerParameterDelegate.this.fPreviousText != null) {
                        IntegerParameterDelegate.this.fTextField.setText(IntegerParameterDelegate.this.fPreviousText);
                    }
                }
            });
            return this.fTextField;
        }

        @Override
        public void updateComponent(Object object) {
            this.fPreviousText = this.fTextField.getText();
            this.fTextField.setText(object.toString());
        }

        private void doEntering() {
            this.fPreviousText = this.fTextField.getText();
            this.fTextField.setText("");
        }

        private void doLeaving() {
            if (this.fTextField.getText().trim().isEmpty()) {
                this.fTextField.setText(this.fPreviousText);
            } else {
                this.doFireCommit();
                this.fTextField.getParent().requestFocusInWindow();
            }
        }

        @Override
        public boolean isFocused() {
            return this.fTextField.hasFocus();
        }

        private void doFireCommit() {
            HDLCodePopupContentView.this.pushCommitRequest(new AbstractEditableCodePopupContentView.CommitContext(){

                @Override
                public String getValue() {
                    return IntegerParameterDelegate.this.fTextField.getText();
                }

                @Override
                public Object getKey() {
                    return IntegerParameterDelegate.this.fTextField;
                }

                @Override
                public ParameterRunnable<String> getParameterRunnable() {
                    return new ParameterRunnable<String>(){

                        public void run(String string) {
                            IntegerParameterDelegate.this.fParam.performSetValue(IntegerParameterDelegate.this.fKey, Integer.parseInt(string));
                        }
                    };
                }
            });
        }
    }
}

