/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.fixedpoint.HDLExtendedModel;
import com.mathworks.toolbox.coder.fixedpoint.HDLParameterScope;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.build.HDLDrillDownDelegates;
import com.mathworks.toolbox.coder.wfa.build.HDLDrillDownTable;
import com.mathworks.toolbox.coder.wfa.build.HDLParameterCellEditorFactory;
import com.mathworks.toolbox.coder.wfa.build.HDLPropertyGroupDecorator;
import com.mathworks.toolbox.coder.wfa.build.HDLTableUtils;
import com.mathworks.util.Converter;
import com.mathworks.util.RequestFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;

public final class HDLFunctionTable {
    private static final String RES_ENTRY_POINT_FUNCTION_LABEL = "wfa.hdl.entryPointFunctionLabel";
    private static final String RES_SUB_FUNCTION_LABEL = "wfa.hdl.subFunctionLabel";
    private static final String RES_FUNCTION_NAME_LABEL = "wfa.hdl.column.functionNameLabel";
    private final MJPanel fComponent;
    private final HDLExtendedModel fModel;
    private final HDLDrillDownDelegates.FunctionDrillDownSourceView fSourceView;
    private final HDLDrillDownTable<Function> fDownTable;
    private File fCurrentFile;

    public HDLFunctionTable(HDLExtendedModel hDLExtendedModel, CoderApp coderApp) {
        this.fModel = hDLExtendedModel;
        this.fSourceView = new HDLDrillDownDelegates.FunctionDrillDownSourceView();
        this.fDownTable = new HDLDrillDownTable<Function>(this.createParameterContext(), this.fSourceView, new HDLDrillDownDelegates.DefaultDrillDownView<Function>(coderApp, new Converter<Function, String>(){

            public String convert(Function function) {
                return function.getName();
            }
        }), true);
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout());
        this.fComponent.add((Component)this.fDownTable.getComponent(), (Object)"Center");
        final RequestFilter requestFilter = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                HDLFunctionTable.this.update();
            }
        });
        this.fModel.addHDLParameterObserver(new HDLExtendedModel.HDLParameterObserver(){

            @Override
            public void hdlParameterChanged(HDLExtendedModel.HDLParameter<?> hDLParameter, Object object) {
                requestFilter.request();
            }
        }, HDLParameterScope.FUNCTION, HDLParameterScope.ENTRY_POINT_FUNCTION, HDLParameterScope.SUB_FUNCTION);
    }

    public void init() {
        this.fDownTable.init();
    }

    private HDLDrillDownTable.HDLParameterContext<Function> createParameterContext() {
        return new HDLDrillDownTable.HDLParameterContext<Function>(){

            @Override
            public Set<HDLExtendedModel.HDLParameter<?>> getApplicableHDLParameters(Function function) {
                return new LinkedHashSet(HDLFunctionTable.this.fModel.getHDLParameters(function));
            }

            @Override
            public Set<HDLExtendedModel.HDLParameter<?>> getSharedHDLParameters(Collection<Function> collection) {
                return HDLTableUtils.intersectFunctionParameters(collection, HDLFunctionTable.this.fModel);
            }

            @Override
            public Set<HDLExtendedModel.HDLParameter<?>> getCommonViewHDLParameters(Collection<Function> collection) {
                return new LinkedHashSet(HDLFunctionTable.this.fModel.getHDLParameters(HDLParameterScope.FUNCTION));
            }
        };
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private void update() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                HDLExtendedModel.HDLParameter hDLParameter;
                Object object2;
                PropertyTableNode propertyTableNode;
                List<Object> list = null;
                if (HDLFunctionTable.this.fCurrentFile != null && CoderFileSupport.isMatlabSourceFile(HDLFunctionTable.this.fCurrentFile)) {
                    list = HDLFunctionTable.this.fModel.getCoreModel().getFunctionsByFile().get(HDLFunctionTable.this.fCurrentFile);
                }
                if (list == null) {
                    list = new LinkedList();
                }
                ArrayList<PropertyTableNode> arrayList = new ArrayList<PropertyTableNode>();
                Function function = null;
                if (HDLFunctionTable.this.fCurrentFile != null && (function = HDLFunctionTable.this.fModel.getCoreModel().getMainFunction(HDLFunctionTable.this.fCurrentFile)) != null) {
                    propertyTableNode = new PropertyTableNode(null, true, CoderResources.getString(HDLFunctionTable.RES_ENTRY_POINT_FUNCTION_LABEL));
                    arrayList.add(propertyTableNode);
                    new PropertyTableNode(propertyTableNode, false, Arrays.asList(function));
                }
                if (list.size() > 1) {
                    propertyTableNode = new PropertyTableNode(null, true, CoderResources.getString(HDLFunctionTable.RES_SUB_FUNCTION_LABEL));
                    arrayList.add(propertyTableNode);
                    for (Object object2 : list) {
                        if (((Function)object2).isEntryPointFunction()) continue;
                        new PropertyTableNode(propertyTableNode, false, Arrays.asList(object2));
                    }
                }
                propertyTableNode = new ArrayList();
                propertyTableNode.add(new FunctionNameColumn());
                ArrayList<HDLExtendedModel.HDLParameter<?>> arrayList2 = new ArrayList(HDLFunctionTable.this.fModel.getHDLParameters(HDLParameterScope.FUNCTION));
                object2 = arrayList2.iterator();
                while (object2.hasNext()) {
                    hDLParameter = (HDLExtendedModel.HDLParameter)object2.next();
                    propertyTableNode.add(new HDLTableUtils.HDLParameterColumn(hDLParameter));
                }
                if (function != null) {
                    object2 = new LinkedHashSet(HDLFunctionTable.this.fModel.getHDLParameters(HDLParameterScope.ENTRY_POINT_FUNCTION));
                    object2.addAll(HDLFunctionTable.this.fModel.getHDLParameters(HDLParameterScope.SUB_FUNCTION));
                    object2.removeAll(arrayList2);
                    propertyTableNode.add(new HDLTableUtils.LeftoverParameterColumn(HDLFunctionTable.this.fModel, (Set<HDLExtendedModel.HDLParameter<?>>)object2, new HDLPropertyGroupDecorator.GroupColumnResolver(){

                        @Override
                        public List<HDLExtendedModel.HDLParameter<?>> getLeftoverParametersForGroup(int n) {
                            ArrayList arrayList = new ArrayList();
                            if (n == 0) {
                                arrayList.addAll(HDLFunctionTable.this.fModel.getHDLParameters(HDLParameterScope.ENTRY_POINT_FUNCTION));
                            } else {
                                arrayList.addAll(HDLFunctionTable.this.fModel.getHDLParameters(HDLParameterScope.SUB_FUNCTION));
                            }
                            arrayList.removeAll(HDLFunctionTable.this.fModel.getHDLParameters(HDLParameterScope.FUNCTION));
                            return arrayList;
                        }
                    }, new Converter<Function, List<HDLExtendedModel.HDLParameter<?>>>(){

                        public List<HDLExtendedModel.HDLParameter<?>> convert(Function function) {
                            return new ArrayList(HDLFunctionTable.this.fModel.getHDLParameters(function));
                        }
                    }));
                }
                object2 = new PropertyTableModel((List)propertyTableNode, arrayList){

                    public boolean isEnabled(int n, int n2) {
                        if (n2 == 0) {
                            return true;
                        }
                        Function function = (Function)this.getValue(n, 0);
                        if (function == null) {
                            return true;
                        }
                        if (this.getColumn(n2) instanceof HDLTableUtils.HDLParameterColumn) {
                            HDLParameterScope hDLParameterScope = ((HDLTableUtils.HDLParameterColumn)this.getColumn(n2)).getParameter().getScope();
                            HDLParameterScope hDLParameterScope2 = function.isEntryPointFunction() ? HDLParameterScope.ENTRY_POINT_FUNCTION : HDLParameterScope.SUB_FUNCTION;
                            return hDLParameterScope.equals(hDLParameterScope2) || hDLParameterScope.containsScope(hDLParameterScope2);
                        }
                        return true;
                    }
                };
                object2.expandAll();
                hDLParameter = new PropertyTable(object2, HDLParameterCellEditorFactory.createEditorFactory(HDLFunctionTable.this.createEditorContext(arrayList2)));
                hDLParameter.setColumnWeights(HDLTableUtils.distributeColumns(propertyTableNode.size(), 0.2, 0.4, true));
                hDLParameter.getSelectionModel().setAllowMultiselect(true);
                HDLFunctionTable.this.fSourceView.setTable((PropertyTable<Function>)hDLParameter);
                HDLFunctionTable.this.fComponent.revalidate();
                HDLFunctionTable.this.fComponent.repaint();
            }
        });
    }

    private HDLParameterCellEditorFactory.CellEditorValueContext<Function> createEditorContext(final List<HDLExtendedModel.HDLParameter<?>> list) {
        final ArrayList arrayList = new ArrayList(this.fModel.getHDLParameters(HDLParameterScope.ENTRY_POINT_FUNCTION));
        final ArrayList arrayList2 = new ArrayList(this.fModel.getHDLParameters(HDLParameterScope.SUB_FUNCTION));
        arrayList.removeAll(list);
        arrayList2.removeAll(list);
        return new HDLParameterCellEditorFactory.CellEditorValueContext<Function>(){

            @Override
            public Collection<Function> getKeys() {
                return HDLFunctionTable.this.fSourceView.getSelectedEntries();
            }

            @Override
            public List<HDLExtendedModel.HDLParameter<?>> getHDLParameters(Function function, int n) {
                if (n < list.size()) {
                    LinkedList linkedList = new LinkedList();
                    linkedList.add((HDLExtendedModel.HDLParameter<?>)list.get(n));
                    return linkedList;
                }
                if (function.isEntryPointFunction()) {
                    return arrayList;
                }
                return arrayList2;
            }
        };
    }

    public void setCurrentFile(File file) {
        this.fCurrentFile = file;
        this.update();
    }

    private class FunctionNameColumn
    extends AbstractPropertyTableColumn<Function> {
        FunctionNameColumn() {
            super(CoderResources.getString(HDLFunctionTable.RES_FUNCTION_NAME_LABEL));
        }

        public String getText(Function function) {
            return function.getName();
        }
    }
}

