/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.project.impl.table.CellPaintContext;
import com.mathworks.project.impl.table.PropertyTableDecorator;
import com.mathworks.project.impl.table.PropertyTablePainter;
import com.mathworks.project.impl.table.PropertyTablePaintingUtils;
import com.mathworks.project.impl.table.VirtualComponentManager;
import com.mathworks.services.ColorPrefs;
import com.mathworks.toolbox.coder.fixedpoint.HDLExtendedModel;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import com.mathworks.toolbox.coder.wfa.build.HDLTableUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public final class HDLPropertyGroupDecorator<T>
implements PropertyTableDecorator<T> {
    private static final String FILLER_STRING = "...";
    private static final Color HEADER_GRID_LINE_COLOR = PlatformInfo.isMacintosh() ? new Color(237, 243, 254) : ColorPrefs.getBackgroundColor();
    private static final Color GRID_LINE_COLOR = PlatformInfo.isMacintosh() ? null : new Color(240, 240, 240);
    private final List<HDLExtendedModel.HDLParameter<?>> fParams;
    private final HDLExtendedModel fModel;
    private final GroupColumnResolver fRowResolver;
    private final PropertyTablePainter<T> fPainter;

    public HDLPropertyGroupDecorator(List<HDLExtendedModel.HDLParameter<?>> list, HDLExtendedModel hDLExtendedModel, GroupColumnResolver groupColumnResolver) {
        this.fModel = hDLExtendedModel;
        this.fRowResolver = groupColumnResolver;
        this.fParams = new ArrayList(list);
        this.fPainter = HDLTableUtils.createPropertyTablePainter();
    }

    public boolean shouldPaintText(T t) {
        return false;
    }

    public void paintDecoration(CellPaintContext<T> cellPaintContext, Graphics2D graphics2D, VirtualComponentManager virtualComponentManager, Color color, Color color2) {
        if (cellPaintContext.isLeaf()) {
            this.paintLeafDecorations(cellPaintContext, graphics2D, virtualComponentManager, color, color2);
        } else if (cellPaintContext.isExpanded()) {
            this.paintHeaderDecorations(cellPaintContext, graphics2D, virtualComponentManager, color, color2);
        }
    }

    private List<HDLExtendedModel.HDLParameter<?>> filterParameters(Object object) {
        HashSet hashSet = new HashSet();
        if (object instanceof FunctionScopedKey) {
            hashSet.addAll(this.fModel.getHDLParameters((FunctionScopedKey)object));
        } else if (object instanceof Function) {
            hashSet.addAll(this.fModel.getHDLParameters((Function)object));
        } else {
            return new LinkedList();
        }
        ArrayList arrayList = new ArrayList();
        for (HDLExtendedModel.HDLParameter<?> hDLParameter : this.fParams) {
            if (!hashSet.contains(hDLParameter)) continue;
            arrayList.add(hDLParameter);
        }
        return arrayList;
    }

    private void paintHeaderDecorations(final CellPaintContext<T> cellPaintContext, Graphics2D graphics2D, VirtualComponentManager virtualComponentManager, Color color, Color color2) {
        final Color color3 = ColorUtils.getContrastingForegroundVariant((Color)ColorPrefs.getBackgroundColor(), (Color)new Color(143, 158, 177));
        FauxCellPaintContext fauxCellPaintContext = new FauxCellPaintContext(){

            @Override
            public boolean paintGridlines() {
                return true;
            }

            @Override
            public Color getGridlineColor() {
                return HEADER_GRID_LINE_COLOR;
            }

            @Override
            public Color getTextColor() {
                return color3;
            }

            @Override
            public int getFontStyle() {
                return 2;
            }

            @Override
            public String getCellString(HDLExtendedModel.HDLParameter hDLParameter) {
                return HDLExtendedModel.getDisplayString(hDLParameter);
            }

            @Override
            public List<HDLExtendedModel.HDLParameter<?>> getColumnParams() {
                return HDLPropertyGroupDecorator.this.fRowResolver.getLeftoverParametersForGroup(cellPaintContext.getRowIndex());
            }
        };
        this.paintFauxCell(fauxCellPaintContext, cellPaintContext, graphics2D, virtualComponentManager, color);
    }

    private void paintLeafDecorations(final CellPaintContext<T> cellPaintContext, Graphics2D graphics2D, VirtualComponentManager virtualComponentManager, Color color, final Color color2) {
        FauxCellPaintContext fauxCellPaintContext = new FauxCellPaintContext(){

            @Override
            public boolean paintGridlines() {
                return GRID_LINE_COLOR != null;
            }

            @Override
            public Color getGridlineColor() {
                return GRID_LINE_COLOR;
            }

            @Override
            public Color getTextColor() {
                return color2;
            }

            @Override
            public int getFontStyle() {
                return 0;
            }

            @Override
            public String getCellString(HDLExtendedModel.HDLParameter hDLParameter) {
                return HDLTableUtils.getHDLParameterValueString(hDLParameter, cellPaintContext.getValue());
            }

            @Override
            public List<HDLExtendedModel.HDLParameter<?>> getColumnParams() {
                return HDLPropertyGroupDecorator.this.filterParameters(cellPaintContext.getValue());
            }
        };
        this.paintFauxCell(fauxCellPaintContext, cellPaintContext, graphics2D, virtualComponentManager, color);
    }

    private void paintFauxCell(FauxCellPaintContext fauxCellPaintContext, CellPaintContext<T> cellPaintContext, Graphics2D graphics2D, VirtualComponentManager virtualComponentManager, Color color) {
        List<HDLExtendedModel.HDLParameter<?>> list = fauxCellPaintContext.getColumnParams();
        if (list.isEmpty()) {
            return;
        }
        Rectangle2D rectangle2D = cellPaintContext.getCellRect();
        double d = this.getFakeCellWidth(rectangle2D, list.size());
        double[] dArray = this.getFakeCellXCoordinates(rectangle2D, list.size());
        Color color2 = PropertyTablePaintingUtils.adjustForegroundColorForHighlight(cellPaintContext, (Color)fauxCellPaintContext.getTextColor());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(graphics2D.getFont().deriveFont(fauxCellPaintContext.getFontStyle()));
        for (int i = 0; i < dArray.length; ++i) {
            if (fauxCellPaintContext.paintGridlines() && i > 0) {
                graphics2D.setColor(fauxCellPaintContext.getGridlineColor());
                graphics2D.fill(new Rectangle2D.Double(dArray[i], rectangle2D.getY(), this.fPainter.getGridLineWidth(), rectangle2D.getMaxY() - rectangle2D.getY()));
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(dArray[i], rectangle2D.getY(), d, rectangle2D.getHeight());
            graphics2D.setColor(color2);
            String string = HDLPropertyGroupDecorator.trimToLength(fauxCellPaintContext.getCellString(list.get(i)), (int)((RectangularShape)double_).getWidth(), graphics2D.getFontMetrics());
            HDLPropertyGroupDecorator.drawCenteredString(graphics2D, string, double_, cellPaintContext);
        }
    }

    private double getFakeCellWidth(Rectangle2D rectangle2D, int n) {
        return rectangle2D.getWidth() / (double)n;
    }

    private double[] getFakeCellXCoordinates(Rectangle2D rectangle2D, int n) {
        double[] dArray = new double[n];
        double d = this.getFakeCellWidth(rectangle2D, n);
        for (int i = 0; i < n; ++i) {
            dArray[i] = rectangle2D.getX() + (double)i * d;
        }
        return dArray;
    }

    private static void drawCenteredString(Graphics2D graphics2D, String string, Rectangle2D rectangle2D, CellPaintContext<?> cellPaintContext) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D2 = fontMetrics.getStringBounds(string, graphics2D);
        int n = cellPaintContext.getLineHeight() - (fontMetrics.getAscent() + fontMetrics.getDescent());
        int n2 = (int)(rectangle2D.getY() + (double)fontMetrics.getAscent() + (double)n / 2.0);
        graphics2D.drawString(string, (int)(rectangle2D.getX() + (rectangle2D.getWidth() - rectangle2D2.getWidth()) / 2.0), n2);
    }

    private static String trimToLength(String string, int n, FontMetrics fontMetrics) {
        int n2 = 0;
        int n3 = string.length();
        int n4 = n + 1;
        String string2 = string;
        while (n2 < n3) {
            int n5 = (n3 + n2) / 2;
            string2 = string.substring(0, n5 + 1) + (n5 + 1 < string.length() ? FILLER_STRING : "");
            n4 = fontMetrics.stringWidth(string2);
            if (n4 < n) {
                n2 = n5 + 1;
                continue;
            }
            if (n4 > n) {
                n3 = n5;
                continue;
            }
            return string2;
        }
        return n4 < n ? string2 : "";
    }

    public static interface GroupColumnResolver<T> {
        public List<HDLExtendedModel.HDLParameter<?>> getLeftoverParametersForGroup(int var1);
    }

    private static interface FauxCellPaintContext {
        public boolean paintGridlines();

        public Color getGridlineColor();

        public Color getTextColor();

        public int getFontStyle();

        public String getCellString(HDLExtendedModel.HDLParameter var1);

        public List<HDLExtendedModel.HDLParameter<?>> getColumnParams();
    }
}

