/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.table.AbstractPropertyTableColumn;
import com.mathworks.project.impl.table.DefaultPropertyTablePainter;
import com.mathworks.project.impl.table.MacPropertyTablePainter;
import com.mathworks.project.impl.table.PropertyTableDecorator;
import com.mathworks.project.impl.table.PropertyTablePainter;
import com.mathworks.toolbox.coder.fixedpoint.HDLExtendedModel;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.build.HDLDrillDownTable;
import com.mathworks.toolbox.coder.wfa.build.HDLPropertyGroupDecorator;
import com.mathworks.toolbox.coder.widgets.FauxColumnDataAdapter;
import com.mathworks.toolbox.coder.widgets.FauxColumnGroupDecorator;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class HDLTableUtils {
    private static final String RES_GENERIC_COLUMN_LABEL = "wfa.hdl.column.genericParamLabel";

    private HDLTableUtils() {
    }

    public static String getHDLParameterValueString(HDLExtendedModel.HDLParameter hDLParameter, Object object) {
        Object t = hDLParameter.getValue(object);
        String string = null;
        if (t != null) {
            String string2 = hDLParameter.getValueDisplayKey(t);
            string = string2 != null ? CoderResources.getString(string2) : t.toString();
        }
        return string;
    }

    public static Set<HDLExtendedModel.HDLParameter<?>> findUniqueParameters(Collection<Variable> collection, HDLExtendedModel hDLExtendedModel) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Variable variable : collection) {
            linkedHashSet.addAll(hDLExtendedModel.getHDLParameters(variable));
        }
        linkedHashSet.removeAll(HDLTableUtils.intersectParameters(collection, hDLExtendedModel));
        return linkedHashSet;
    }

    public static Set<HDLExtendedModel.HDLParameter<?>> findUniqueFunctionParameters(Collection<Function> collection, HDLExtendedModel hDLExtendedModel) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Function function : collection) {
            linkedHashSet.addAll(hDLExtendedModel.getHDLParameters(function));
        }
        linkedHashSet.removeAll(HDLTableUtils.intersectFunctionParameters(collection, hDLExtendedModel));
        return linkedHashSet;
    }

    public static Set<HDLExtendedModel.HDLParameter<?>> intersectParameters(Collection<Variable> collection, HDLExtendedModel hDLExtendedModel) {
        HashSet hashSet = null;
        for (Variable variable : collection) {
            Collection<HDLExtendedModel.HDLParameter<?>> collection2 = hDLExtendedModel.getHDLParameters(variable);
            if (hashSet == null) {
                hashSet = new LinkedHashSet(collection2);
                continue;
            }
            hashSet.retainAll(collection2);
        }
        return hashSet != null ? hashSet : new HashSet();
    }

    public static Set<HDLExtendedModel.HDLParameter<?>> intersectFunctionParameters(Collection<Function> collection, HDLExtendedModel hDLExtendedModel) {
        HashSet hashSet = null;
        for (Function function : collection) {
            Collection<HDLExtendedModel.HDLParameter<?>> collection2 = hDLExtendedModel.getHDLParameters(function);
            if (hashSet == null) {
                hashSet = new LinkedHashSet(collection2);
                continue;
            }
            hashSet.retainAll(collection2);
        }
        return hashSet != null ? hashSet : new HashSet();
    }

    static <T> PropertyTablePainter<T> createPropertyTablePainter() {
        return PlatformInfo.isMacintosh() ? new MacPropertyTablePainter() : new DefaultPropertyTablePainter();
    }

    static double[] distributeColumns(int n, double d, double d2, boolean bl) {
        double[] dArray = new double[n];
        dArray[0] = d;
        dArray[n - 1] = d2;
        double d3 = (1.0 - ((bl ? d2 : 0.0) + d)) / (double)(dArray.length - (bl ? 2 : 1));
        for (int i = 1; i < dArray.length - 1; ++i) {
            dArray[i] = d3;
        }
        return dArray;
    }

    static HDLDrillDownTable.HDLParameterContext<Variable> createParameterContext(final HDLExtendedModel hDLExtendedModel) {
        return new HDLDrillDownTable.HDLParameterContext<Variable>(){

            @Override
            public Set<HDLExtendedModel.HDLParameter<?>> getApplicableHDLParameters(Variable variable) {
                return new LinkedHashSet(hDLExtendedModel.getHDLParameters(variable));
            }

            @Override
            public Set<HDLExtendedModel.HDLParameter<?>> getSharedHDLParameters(Collection<Variable> collection) {
                return HDLTableUtils.intersectParameters(collection, hDLExtendedModel);
            }

            @Override
            public Set<HDLExtendedModel.HDLParameter<?>> getCommonViewHDLParameters(Collection<Variable> collection) {
                Set<HDLExtendedModel.HDLParameter<?>> set = HDLTableUtils.intersectParameters(collection, hDLExtendedModel);
                return set;
            }
        };
    }

    public static final class GridBagFormBuilder {
        private static final Set<String> GBC_IGNORE = new HashSet<String>(Arrays.asList("gridx", "gridy"));
        private static final Map<String, Field> FIELD_MAP;
        private static final GridBagConstraints DEFAULT_SOURCE;
        private final JPanel fPanel;
        private final GridBagConstraints fGbc;
        private final Stack<Map<Field, Number>> fStateStack;
        private final Map<Field, Number> fState;
        private double[] fColumnWeights;

        public GridBagFormBuilder(JPanel jPanel) {
            this.fPanel = jPanel;
            this.fStateStack = new Stack();
            this.fState = new HashMap<Field, Number>();
            this.fGbc = new GridBagConstraints();
            this.fGbc.gridy = 0;
            this.fGbc.gridx = 0;
            if (!GridBagLayout.class.isInstance(jPanel.getLayout())) {
                jPanel.setLayout(new GridBagLayout());
            }
        }

        public GridBagFormBuilder() {
            this((JPanel)new MJPanel());
        }

        public JComponent getComponent() {
            return this.fPanel;
        }

        public GridBagFormBuilder constrain(String string, Number number) {
            if (!GBC_IGNORE.contains(string) && FIELD_MAP.containsKey(string)) {
                Field field = FIELD_MAP.get(string);
                try {
                    if (number instanceof Integer) {
                        field.setInt(this.fGbc, number.intValue());
                    } else if (number instanceof Double) {
                        field.setDouble(this.fGbc, number.doubleValue());
                    }
                    this.fState.put(field, number);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return this;
        }

        public GridBagFormBuilder save() {
            this.fStateStack.push(new HashMap<Field, Number>(this.fState));
            this.fState.clear();
            return this;
        }

        public GridBagFormBuilder restore() {
            for (Field field : this.fState.keySet()) {
                try {
                    if (field.getType().equals(Integer.TYPE)) {
                        field.setInt(this.fGbc, this.getPreviousValue(field).intValue());
                        continue;
                    }
                    if (!field.getType().equals(Double.TYPE)) continue;
                    field.setDouble(this.fGbc, this.getPreviousValue(field).doubleValue());
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            this.fStateStack.pop();
            return this;
        }

        public GridBagFormBuilder withColumnWeights(double ... dArray) {
            this.fColumnWeights = dArray;
            return this;
        }

        private Number getPreviousValue(Field field) {
            for (int i = this.fStateStack.size() - 1; i >= 0; --i) {
                Map map = (Map)this.fStateStack.get(i);
                if (!map.containsKey(field)) continue;
                if (field.getType().equals(Integer.TYPE)) {
                    return ((Number)map.get(field)).intValue();
                }
                if (!field.getType().equals(Double.TYPE)) continue;
                return ((Number)map.get(field)).doubleValue();
            }
            try {
                if (field.getType().equals(Integer.TYPE)) {
                    return field.getInt(DEFAULT_SOURCE);
                }
                if (field.getType().equals(Double.TYPE)) {
                    return field.getDouble(DEFAULT_SOURCE);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return 0;
        }

        public GridBagFormBuilder nextRow() {
            ++this.fGbc.gridy;
            this.fGbc.gridx = 0;
            return this;
        }

        public GridBagFormBuilder withInsets(Insets insets) {
            this.fGbc.insets = insets;
            return this;
        }

        public GridBagFormBuilder add(JComponent jComponent, int n, String ... stringArray) {
            this.save();
            if (this.fColumnWeights != null & this.fColumnWeights.length > n) {
                this.fGbc.weightx = this.fColumnWeights[n];
            }
            for (String string : stringArray) {
                String[] stringArray2 = string.split(" ");
                if (stringArray2.length != 2 || !FIELD_MAP.containsKey(stringArray2[0])) continue;
                Field field = FIELD_MAP.get(stringArray2[0]);
                try {
                    if (field.getType().equals(Integer.TYPE)) {
                        field.setInt(this.fGbc, Integer.parseInt(stringArray2[1]));
                        continue;
                    }
                    if (!field.getType().equals(Double.TYPE)) continue;
                    field.setDouble(this.fGbc, Double.parseDouble(stringArray2[1]));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            this.fGbc.gridx = n;
            this.fPanel.add((Component)jComponent, this.fGbc);
            ++this.fGbc.gridx;
            this.restore();
            return this;
        }

        public GridBagFormBuilder add(JComponent jComponent, String ... stringArray) {
            this.add(jComponent, this.fGbc.gridx, new String[0]);
            return this;
        }

        static {
            DEFAULT_SOURCE = new GridBagConstraints();
            HashMap<String, Field> hashMap = new HashMap<String, Field>();
            for (Field field : GridBagConstraints.class.getFields()) {
                if (!field.getType().equals(Integer.TYPE) && !field.getType().equals(Double.TYPE)) continue;
                hashMap.put(field.getName(), field);
            }
            FIELD_MAP = Collections.unmodifiableMap(hashMap);
        }
    }

    static class ParameterNameColumn
    extends AbstractPropertyTableColumn<HDLExtendedModel.HDLParameter> {
        ParameterNameColumn() {
            super(CoderResources.getString("wfa.hdl.column.paramNameLabel"));
        }

        public String getText(HDLExtendedModel.HDLParameter hDLParameter) {
            return HDLExtendedModel.getDisplayString(hDLParameter);
        }
    }

    static final class LeftoverParameterColumn<T>
    extends AbstractPropertyTableColumn<T> {
        private final Set<HDLExtendedModel.HDLParameter<?>> fParamsToInclude;
        private final HDLExtendedModel fHdlModel;
        private final HDLPropertyGroupDecorator.GroupColumnResolver fRowResolver;
        private final Converter<T, List<HDLExtendedModel.HDLParameter<?>>> fConverter;

        LeftoverParameterColumn(HDLExtendedModel hDLExtendedModel, Set<HDLExtendedModel.HDLParameter<?>> set, HDLPropertyGroupDecorator.GroupColumnResolver groupColumnResolver, Converter<T, List<HDLExtendedModel.HDLParameter<?>>> converter) {
            super(CoderResources.getString(HDLTableUtils.RES_GENERIC_COLUMN_LABEL));
            this.fParamsToInclude = set;
            this.fHdlModel = hDLExtendedModel;
            this.fRowResolver = groupColumnResolver;
            this.fConverter = converter;
        }

        public boolean isEditable() {
            return true;
        }

        public String getText(T t) {
            LinkedList linkedList = new LinkedList((Collection)this.fConverter.convert(t));
            Object object = linkedList.iterator();
            while (object.hasNext()) {
                if (this.fParamsToInclude.contains(object.next())) continue;
                object.remove();
            }
            object = new StringBuilder();
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                HDLExtendedModel.HDLParameter hDLParameter = (HDLExtendedModel.HDLParameter)iterator.next();
                String string = HDLTableUtils.getHDLParameterValueString(hDLParameter, t);
                if (string == null) continue;
                ((StringBuilder)object).append('[').append(HDLExtendedModel.getDisplayString(hDLParameter)).append(" = ").append(string).append(']');
                if (!iterator.hasNext()) continue;
                ((StringBuilder)object).append(',');
            }
            return ((StringBuilder)object).toString();
        }

        public PropertyTableDecorator<T> getDecorator() {
            return new FauxColumnGroupDecorator(new FauxColumnDataAdapter<T>(){

                @Override
                public List<Object> getDisplayObjects(int n, final T t) {
                    final ArrayList<Object> arrayList = new ArrayList<Object>();
                    LeftoverParameterColumn.this.runOnParams(n, new ParameterRunnable<HDLExtendedModel.HDLParameter<?>>(){

                        public void run(HDLExtendedModel.HDLParameter<?> hDLParameter) {
                            arrayList.add(hDLParameter.getValue(t));
                        }
                    });
                    return arrayList;
                }

                @Override
                public List<String> getFauxFieldsForRow(int n) {
                    final ArrayList<String> arrayList = new ArrayList<String>();
                    LeftoverParameterColumn.this.runOnParams(n, new ParameterRunnable<HDLExtendedModel.HDLParameter<?>>(){

                        public void run(HDLExtendedModel.HDLParameter<?> hDLParameter) {
                            arrayList.add(HDLExtendedModel.getDisplayString(hDLParameter));
                        }
                    });
                    return arrayList;
                }
            });
        }

        private void runOnParams(int n, ParameterRunnable<HDLExtendedModel.HDLParameter<?>> parameterRunnable) {
            List<HDLExtendedModel.HDLParameter<?>> list = this.fRowResolver.getLeftoverParametersForGroup(n);
            for (HDLExtendedModel.HDLParameter<?> hDLParameter : list) {
                parameterRunnable.run(hDLParameter);
            }
        }
    }

    static final class HDLParameterColumn<T>
    extends AbstractPropertyTableColumn<T> {
        private final HDLExtendedModel.HDLParameter fParameter;

        HDLParameterColumn(HDLExtendedModel.HDLParameter hDLParameter) {
            super(HDLExtendedModel.getDisplayString(hDLParameter));
            this.fParameter = hDLParameter;
        }

        public String getText(T t) {
            Object t2 = this.fParameter.getValue(t);
            if (t2 == null) {
                return "";
            }
            String string = this.fParameter.getValueDisplayKey(t2);
            return string != null ? CoderResources.getString(string) : t2.toString();
        }

        public boolean isEditable() {
            return true;
        }

        public HDLExtendedModel.HDLParameter getParameter() {
            return this.fParameter;
        }
    }
}

