/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupFrame;
import com.mathworks.toolbox.coder.model.Expression;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionScopedKey;
import com.mathworks.toolbox.coder.model.InferenceModel;
import com.mathworks.toolbox.coder.model.MatlabType;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;

public final class InferenceCodePopupContentView
implements CodePopupFrame.CodePopupContentView {
    private static final String RES_VAR_HEADER = "wfa.build.infcontent.varheader";
    private static final String RES_EXPR_HEADER = "wfa.build.infcontent.exprheader";
    private static final String RES_NAME = "wfa.build.infcontent.name";
    private static final String RES_SIZE = "wfa.build.infcontent.size";
    private static final String RES_CLASS = "wfa.build.infcontent.class";
    private static final String RES_COMPLEX = "wfa.build.infcontent.complex";
    private static final String RES_COMPLEX_YES = "wfa.build.infcontent.yes";
    private static final String RES_COMPLEX_NO = "wfa.build.infcontent.no";
    private final InferenceModel fModel;
    private CodePopupFrame fParent;
    private JComponent fComponent;

    public InferenceCodePopupContentView(InferenceModel inferenceModel) {
        this.fModel = inferenceModel;
    }

    @Override
    public void setParentCodePopupFrame(CodePopupFrame codePopupFrame) {
        this.fParent = codePopupFrame;
    }

    public JComponent updateContentView(FunctionScopedKey functionScopedKey) {
        if (!(functionScopedKey instanceof Variable) && !(functionScopedKey instanceof Expression)) {
            return null;
        }
        MatlabType matlabType = this.fModel.getMatlabType(functionScopedKey);
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        String string = RES_VAR_HEADER;
        if (functionScopedKey instanceof Expression) {
            string = RES_EXPR_HEADER;
        }
        mJPanel.add((Component)InferenceCodePopupContentView.createHeadingLabel(this.getResourceString(string)), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        if (functionScopedKey instanceof Variable) {
            mJPanel.add((Component)InferenceCodePopupContentView.createLabel(this.getResourceString(RES_NAME)), gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        mJPanel.add((Component)InferenceCodePopupContentView.createLabel(this.getResourceString(RES_CLASS)), gridBagConstraints);
        ++gridBagConstraints.gridy;
        mJPanel.add((Component)InferenceCodePopupContentView.createLabel(this.getResourceString(RES_SIZE)), gridBagConstraints);
        ++gridBagConstraints.gridy;
        mJPanel.add((Component)InferenceCodePopupContentView.createLabel(this.getResourceString(RES_COMPLEX)), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        if (functionScopedKey instanceof Variable) {
            mJPanel.add((Component)InferenceCodePopupContentView.createValueLabel(((Variable)functionScopedKey).getName()), gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        mJPanel.add((Component)InferenceCodePopupContentView.createValueLabel(matlabType.getClassName()), gridBagConstraints);
        ++gridBagConstraints.gridy;
        mJPanel.add((Component)InferenceCodePopupContentView.createValueLabel(matlabType.toDimensionString()), gridBagConstraints);
        ++gridBagConstraints.gridy;
        mJPanel.add((Component)InferenceCodePopupContentView.createValueLabel(this.getResourceString(matlabType.isComplex() ? RES_COMPLEX_YES : RES_COMPLEX_NO)), gridBagConstraints);
        return mJPanel;
    }

    @Override
    public JComponent updateContentView(Function function) {
        return null;
    }

    private String getResourceString(String string) {
        return CoderResources.getString(string);
    }

    @Override
    public boolean isContentViewFocused() {
        return false;
    }

    private static MJLabel createLabel(String string) {
        MJLabel mJLabel = new MJLabel(string);
        mJLabel.setFont(mJLabel.getFont().deriveFont(1));
        mJLabel.setHorizontalAlignment(4);
        return mJLabel;
    }

    private static JComponent createValueLabel(String string) {
        MJLabel mJLabel = InferenceCodePopupContentView.createLabel(string);
        mJLabel.setHorizontalAlignment(0);
        mJLabel.setFont(mJLabel.getFont().deriveFont(0));
        return mJLabel;
    }

    private static MJLabel createHeadingLabel(String string) {
        MJLabel mJLabel = InferenceCodePopupContentView.createLabel(string);
        return mJLabel;
    }
}

